set session authorization planmonitor;


drop view volledig_overzicht_view;
drop view volledig_overzicht_shape_view;
drop view bouwplan_view;
drop view info_view;
drop view volledig_totaal_uitgebreid_view;
drop view eenvoudig_overzicht_shape_view;
DROP VIEW volledig_overzicht_additional_variables_view;



CREATE OR REPLACE VIEW volledig_overzicht_shape_view AS 
  SELECT b.the_geom,
   b.id,
   b.plan_identificatie AS planidentificatie,
   b.naam,
   gem.naam as gemeente,r.naam as regio,b.referentienummer,
   b.masterplan,
   b.bestemmingsplannaam,

b.huur1,b.huur2,b.huur3,b.huur4,b.huurprijsonbekend,b.huurtotaal,b.koop1,b.koop2,b.koop3,b.koop4,b.kooptotaal,b.koopprijsonbekend,
 b.imronummer,
 b.jaar_eerste_oplevering,
 b.jaar_laatste_oplevering,
b.restcapaciteit,
b.totaalcapaciteit,
b.gerealiseerdecapaciteit as "gereal_cap",
 b.resterendesloop as "rest_sloop",
 b.sloop,
ot.type AS opdrachtgever,
 b.ontwikkelaar_namelijk AS opdrachtgever_namelijk,
   p.type AS plantype,
    w.type AS woonmilieu,
   b.woonmilieu_namelijk as woonm_nml,
   b.woonmilieu_rosetta as rosetta, 
   g.naam AS gebruikgegevens, 
   stp.type as status_plan, 
   sp.type as status_proj
   FROM bouwplan b
   LEFT JOIN ontwikkelaartype ot ON b.ontwikkelaartypeid = ot.id
   LEFT JOIN plantype p ON b.plantypeid = p.id
   LEFT JOIN woonmilieu w ON b.woonmilieuid = w.id
   LEFT JOIN gebruikgegevens g ON b.gebruikgegevensid = g.id
   LEFT JOIN gemeente gem on b.gemeenteid = gem.id
   LEFT JOIN regio r on r.id = gem.regioid
   join statusplanologisch sp on b.statusplanologischid = sp.id
   join statusproject stp on stp.id = b.statusprojectid;



CREATE OR REPLACE VIEW volledig_overzicht_view AS 
 SELECT 
volledig_overzicht_shape_view.id,volledig_overzicht_shape_view.planidentificatie,volledig_overzicht_shape_view.naam,volledig_overzicht_shape_view.gemeente,volledig_overzicht_shape_view.regio,volledig_overzicht_shape_view.referentienummer,volledig_overzicht_shape_view.masterplan,volledig_overzicht_shape_view.bestemmingsplannaam,volledig_overzicht_shape_view.huur1,volledig_overzicht_shape_view.huur2,volledig_overzicht_shape_view.huur3,volledig_overzicht_shape_view.huur4,volledig_overzicht_shape_view.huurprijsonbekend,volledig_overzicht_shape_view.huurtotaal,volledig_overzicht_shape_view.koop1,volledig_overzicht_shape_view.koop2,volledig_overzicht_shape_view.koop3,volledig_overzicht_shape_view.koop4,volledig_overzicht_shape_view.kooptotaal,volledig_overzicht_shape_view.koopprijsonbekend,volledig_overzicht_shape_view.imronummer,volledig_overzicht_shape_view.jaar_eerste_oplevering,volledig_overzicht_shape_view.jaar_laatste_oplevering,volledig_overzicht_shape_view.restcapaciteit,volledig_overzicht_shape_view.totaalcapaciteit,volledig_overzicht_shape_view.gereal_cap,volledig_overzicht_shape_view.rest_sloop,volledig_overzicht_shape_view.opdrachtgever,volledig_overzicht_shape_view.opdrachtgever_namelijk,volledig_overzicht_shape_view.plantype,volledig_overzicht_shape_view.woonmilieu,volledig_overzicht_shape_view.woonm_nml,volledig_overzicht_shape_view.rosetta,volledig_overzicht_shape_view.gebruikgegevens,volledig_overzicht_shape_view.status_plan,volledig_overzicht_shape_view.status_proj   FROM volledig_overzicht_shape_view;

CREATE OR REPLACE VIEW bouwplan_view AS 
 SELECT b.id,
    b.the_geom,
    b.naam,
    b.gebruikgegevensid,
        CASE plantypeid
            WHEN 1 THEN '#048500'::text
            WHEN 2 THEN '#09FF00'::text
            WHEN 3 THEN '#FFE100'::text
            WHEN 6 THEN '#FF8800'::text
            WHEN 7 THEN '#AA00FF'::text
            WHEN 99 THEN '#C0C0C0'::text
            ELSE '#000000'::text
        END AS plantype,
    b.gemeenteid,
    g.regioid,
    g.provincie AS provincieid,
    b.statusprojectid
   FROM bouwplan b
     LEFT JOIN gemeente g ON b.gemeenteid = g.id
  WHERE b.statusprojectid <> 11 AND b.the_geom IS NOT NULL
  ORDER BY b.id;



CREATE OR REPLACE VIEW volledig_totaal_uitgebreid_view AS 
 SELECT bp.id as bvid,
    bp.bouwplan as id,
    bp.year,
    bp.gepland,
    bp.sloop,
    bp.gerealiseerd,
    bp.eengezinshuur1,
    bp.eengezinshuur2,
    bp.eengezinshuur3,
    bp.eengezinshuur4,
    bp.eengezinshuuronb,
    bp.eengezinskoop1,
    bp.eengezinskoop2,
    bp.eengezinskoop3,
    bp.eengezinskoop4,
    bp.eengezinskooponb,
    bp.meergezinshuur1,
    bp.meergezinshuur2,
    bp.meergezinshuur3,
    bp.meergezinshuur4,
    bp.meergezinshuuronb,
    bp.meergezinskoop1,
    bp.meergezinskoop2,
    bp.meergezinskoop3,
    bp.meergezinskoop4,
    bp.meergezinskooponb,
    bp.onbekendhuur1,
    bp.onbekendhuur2,
    bp.onbekendhuur3,
    bp.onbekendhuur4,
    bp.onbekendhuuronb,
    bp.onbekendkoop1,
    bp.onbekendkoop2,
    bp.onbekendkoop3,
    bp.onbekendkoop4,
    bp.onbekendkooponb,
    bp.onbekendgerealiseerd,
    bp.eengezinsgerealiseerd,
    bp.meergezinsgerealiseerd
   FROM bouwplan_variable bp;

ALTER TABLE volledig_totaal_uitgebreid_view
  OWNER TO planmonitor;





CREATE OR REPLACE VIEW eenvoudig_overzicht_shape_view AS 
 SELECT b.the_geom,
b.id,b.naam as plannaam,g.naam as gemeente,b.plaatsnaam,b.referentienummer,b.bestemmingsplannaam as "best-plan",b.imronummer,b.masterplan,o.type as opdr_type,b.ontwikkelaar_namelijk as opdr_naam,p.type AS plantype,s.type AS status_plan,sp.type AS status_proj,b.knelpunten,b.jaar_eerste_oplevering as jaar_begin,b.jaar_laatste_oplevering as jaar_eind,b.restcapaciteit as restcapaciteit,b.totaalcapaciteit as totaalcap,b.gerealiseerdecapaciteit as gereal_cap,b.sloop,b.resterendesloop as "rest_sloop",gepland.gepland2013 AS gep2013,gepland.gepland2014 AS gep2014,gepland.gepland2015 AS gep2015,gepland.gepland2016 AS gep2016,gepland.gepland2017 AS gep2017,gepland.gepland2018 AS gep2018,gepland.gepland2019 AS gep2019,gepland.gepland2020 AS gep2020,gepland.gepland2021 AS gep2021,gepland.gepland2022 AS gep2022,gepland.gepland2023 AS gep2023,gepland.gepland2024 AS gep2024,gepland.gepland2025 AS gep2025,gepland.gepland2026 AS gep2026,gepland.gepland2027 AS gep2027,gepland.gepland2028 AS gep2028,gepland.gepland2029 AS gep2029,gepland.gepland2030 AS gep2030,gepland.gepland2031 AS gep2031,gepland.gepland2032 AS gep2032,gepland.gepland2033 AS gep2033,gepland.gepland2034 AS gep2034,gepland.gepland2035 AS gep2035,gepland.gepland2036 AS gep2036,gepland.gepland2037 AS gep2037,gepland.gepland2038 AS gep2038,gepland.gepland2039 AS gep2039,gepland.gepland2040 AS gep2040   FROM bouwplan b
     JOIN bouwplan_data_gepland() gepland(bouwplan,
      gepland2013,      gepland2014,      gepland2015,      gepland2016,      gepland2017,      gepland2018,      gepland2019,      gepland2020,      gepland2021,      gepland2022,      gepland2023,      gepland2024,      gepland2025,      gepland2026,      gepland2027,      gepland2028,      gepland2029,      gepland2030,      gepland2031,      gepland2032,      gepland2033,      gepland2034,      gepland2035,      gepland2036,      gepland2037,      gepland2038,      gepland2039,      gepland2040) ON b.id = gepland.bouwplan
     JOIN gemeente g ON b.gemeenteid = g.id
     JOIN ontwikkelaartype o ON b.ontwikkelaartypeid = o.id
     JOIN plantype p ON b.plantypeid = p.id
     JOIN statusplanologisch s ON b.statusplanologischid = s.id
     JOIN statusproject sp ON b.statusprojectid = sp.id
;
-- View: volledig_overzicht_additional_variables_view

 -- View: volledig_overzicht_additional_variables_view

-- DROP VIEW volledig_overzicht_additional_variables_view;

CREATE OR REPLACE VIEW volledig_overzicht_additional_variables_view AS 
 SELECT bp.id,
    pav.additional_variable AS "Variabele",
    COALESCE(pavv.value, bav.variable_value) AS "Waarde"
   FROM bouwplan bp
     JOIN gemeente gm ON bp.gemeenteid = gm.id
     JOIN regio r ON r.id = gm.regioid
     LEFT JOIN bouwplan_additional_variable bav ON bav.bouwplan = bp.id
     LEFT JOIN provincie_additional_variable pav ON bav.config_variable = pav.id
     LEFT JOIN provincie_additional_variable_value pavv ON pavv.id = bav.variable_value::integer
  WHERE bav.variable_value IS NOT NULL AND bav.variable_value::text <> ''::text AND bav.variable_value::text ~ '^[0-9]+$'::text AND bp.id = 10225
UNION
 SELECT bp.id,
    pav.additional_variable AS "Variabele",
    bav.variable_value AS "Waarde"
   FROM bouwplan bp
     JOIN gemeente gm ON bp.gemeenteid = gm.id
     JOIN regio r ON r.id = gm.regioid
     LEFT JOIN bouwplan_additional_variable bav ON bav.bouwplan = bp.id
     LEFT JOIN provincie_additional_variable pav ON bav.config_variable = pav.id
  WHERE bav.variable_value IS NOT NULL AND bav.variable_value::text <> ''::text AND bav.variable_value::text !~ '^[0-9]+$'::text AND bp.id = 10225;

ALTER TABLE volledig_overzicht_additional_variables_view
  OWNER TO planmonitor;
