CREATE OR REPLACE VIEW bouwplan_view AS
select b.id, b.the_geom, b.naam, b.gebruikgegevensid, b.aanduidingid, 
CASE (select v.voortgangstatusid 
from bouwplanvoortgang v 
where v.bouwplanid = b.id and v.voortgangsoortid = 1)
         WHEN '1' THEN '#009900'
         WHEN '2' THEN '#ff6600'
         WHEN '3' THEN '#ff0000'
         ELSE '#C0C0C0'
      END as voortgang,
b.gemeenteid, g.regioid, r.provincieid
from bouwplan b
left join gemeente g
on b.gemeenteid = g.id
left join regio r
on g.regioid = r.id
where statusprojectid != 11
and b.the_geom IS NOT NULL
  ORDER BY b.id;

ALTER TABLE bouwplan_view OWNER TO rwbp;
