package nl.b3p.pzh.rwbp.entity;

import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import nl.woningbouwplannen.WoonmilieuRosetta;
import nl.woningbouwplannen.WoonmilieuRosetta.WoonmilieuRosettaType;

/**
 *
 * @author Jytte
 */

@Entity
public class Bouwplan{

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;

    @Temporal(TemporalType.TIMESTAMP)
    private Date aanmaakdatum;

    private String naam;
    
    private String planIdentificatie;

    @Temporal(TemporalType.TIMESTAMP)
    private Date gebruikeractiontijd;

    @Temporal(TemporalType.TIMESTAMP)
    private Date prognose_start;

    @Temporal(TemporalType.TIMESTAMP)
    private Date prognose_oplevering;

    private String referentienummer;

    private String bestemmingsplannaam;
    private String masterplan;

    private Integer voortgang_algemeen;

    @org.hibernate.annotations.Type(type="org.hibernatespatial.GeometryUserType")
    private Polygon the_geom;

    @ManyToOne (fetch= FetchType.LAZY)
    @JoinColumn(name="gemeenteid")
    private Gemeente gemeente;

    @ManyToOne (fetch= FetchType.LAZY)
    @JoinColumn(name="statusplanologischid")
    private Statusplanologisch statusplanologisch;

    @ManyToOne (fetch= FetchType.LAZY)
    @JoinColumn(name="statusprojectid")
    private Statusproject statusproject;

    private String status_namelijk;

    @ManyToOne (fetch= FetchType.LAZY)
    @JoinColumn(name="gebruikerid")
    private Gebruiker gebruiker;
     
    @ManyToOne (fetch= FetchType.LAZY)
    @JoinColumn(name="gebruikgegevensid")
    private Gebruikgegevens gebruikgegevens;

    @ManyToOne (fetch= FetchType.LAZY)
    @JoinColumn(name="woonmilieuid")
    private Woonmilieu woonmilieu;

    private String woonmilieu_namelijk;

    @ManyToOne (fetch= FetchType.LAZY)
    @JoinColumn(name="ontwikkelaartypeid")
    private Ontwikkelaartype ontwikkelaartype;

    private String ontwikkelaar_namelijk;

    @ManyToOne (fetch= FetchType.LAZY)
    @JoinColumn(name="plantypeid")
    private Plantype plantype;

    @OneToMany(fetch= FetchType.LAZY)
    @JoinColumn(name = "bouwplanid")
    private Set<Extraveld> extraveld = new HashSet<Extraveld>();

    @OneToMany(fetch= FetchType.LAZY)
    @JoinColumn(name = "bouwplanid")
    private Set<Bouwplanopmerking> bouwplanOpmerkingen = new HashSet<Bouwplanopmerking>();

    @OneToMany(fetch= FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name = "bouwplanid")
    private Set<Bouwplanvoortgang> bouwplanvoortgang = new HashSet<Bouwplanvoortgang>();

    @OneToMany(fetch= FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name = "bouwplanid")
    private Set<Factmetperiode> factsmetperiode = new HashSet<Factmetperiode>();
    
    @Enumerated(EnumType.STRING)
    private WoonmilieuRosetta.WoonmilieuRosettaType woonmilieu_rosetta;

    private Integer jaar_eerste_oplevering;
    private Integer jaar_laatste_oplevering;
    private Integer restcapaciteit;
    private Integer gerealiseerdecapaciteit;
    private Integer totaalcapaciteit;
    private Integer resterendesloop;
    private Integer sloop;

    private Integer koop1;
    private Integer koop2;
    private Integer koop3;
    private Integer koop4;
    private Integer koopprijsonbekend;
    private Integer kooptotaal;

    private Integer huur1;
    private Integer huur2;
    private Integer huur3;
    private Integer huur4;
    private Integer huurprijsonbekend;
    private Integer huurtotaal;
    
    private Integer eensgezins;
    private Integer meergezins;
    private Integer woningtypeonbekend;

    @Temporal(TemporalType.TIMESTAMP)
    private Date datumlaatstewijziging;

    private String plaatsnaam;

    private String imronummer;

    private String woonmilieuabf14;

    @Lob
    @org.hibernate.annotations.Type(type="org.hibernate.type.StringClobType")
    private String knelpunten;
    
    private String opmerkingen;
    
    private String opmerkingenprovincie;
    
    private boolean opmerkingenprive = false;

    private String detailType;


    @OneToMany(orphanRemoval=true, cascade=CascadeType.ALL, mappedBy="bouwplan", fetch = FetchType.LAZY)
    private List<BouwplanAdditionalVariable> bouwplanAdditionalVariables = new ArrayList<BouwplanAdditionalVariable>();

    @OneToMany(orphanRemoval=true, cascade=CascadeType.ALL, mappedBy="bouwplan", fetch = FetchType.LAZY)
    private List<BouwplanVariable> bouwplanVariables = new ArrayList<BouwplanVariable>();

    // <editor-fold defaultstate="collapsed" desc="getters en setters">
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getVoortgang_algemeen() {
        return voortgang_algemeen;
    }

    public void setVoortgang_algemeen(Integer voortgang_algemeen) {
        this.voortgang_algemeen = voortgang_algemeen;
    }

    public String getNaam() {
        return naam;
    }

    public void setNaam(String naam) {
        this.naam = naam;
    }

    public Date getGebruikeractiontijd() {
        return gebruikeractiontijd;
    }

    public void setGebruikeractiontijd(Date gebruikeractiontijd) {
        this.gebruikeractiontijd = gebruikeractiontijd;
    }

    public Date getAanmaakdatum() {
        return aanmaakdatum;
    }

    public void setAanmaakdatum(Date aanmaakdatum) {
        this.aanmaakdatum = aanmaakdatum;
    }

    public String getMasterplan() {
        return masterplan;
    }

    public void setMasterplan(String masterplan) {
        this.masterplan = masterplan;
    }

    public Date getPrognose_oplevering() {
        return prognose_oplevering;
    }

    public void setPrognose_oplevering(Date prognose_oplevering) {
        this.prognose_oplevering = prognose_oplevering;
    }

    public Date getPrognose_start() {
        return prognose_start;
    }

    public void setPrognose_start(Date prognose_start) {
        this.prognose_start = prognose_start;
    }

    public String getWoonmilieu_namelijk() {
        return woonmilieu_namelijk;
    }

    public void setWoonmilieu_namelijk(String woonmilieu_namelijk) {
        this.woonmilieu_namelijk = woonmilieu_namelijk;
    }

    public String getBestemmingsplannaam() {
        return bestemmingsplannaam;
    }

    public void setBestemmingsplannaam(String bestemmingsplannaam) {
        this.bestemmingsplannaam = bestemmingsplannaam;
    }

    public String getOntwikkelaar_namelijk() {
        return ontwikkelaar_namelijk;
    }

    public void setOntwikkelaar_namelijk(String ontwikkelaar_namelijk) {
        this.ontwikkelaar_namelijk = ontwikkelaar_namelijk;
    }

    public String getReferentienummer() {
        return referentienummer;
    }

    public void setReferentienummer(String referentienummer) {
        this.referentienummer = referentienummer;
    }

    public Polygon getThe_geom() {
        return the_geom;
    }

    public void setThe_geom(Polygon the_geom) {
        this.the_geom = the_geom;
    }

    public Set<Bouwplanopmerking> getBouwplanOpmerkingen() {
        return bouwplanOpmerkingen;
    }

    public void setBouwplanOpmerkingen(Set<Bouwplanopmerking> bouwplanOpmerkingen) {
        this.bouwplanOpmerkingen = bouwplanOpmerkingen;
    }

    public void addBouwplanOpmerking(Bouwplanopmerking bouwplanOpmerking) {
        this.bouwplanOpmerkingen.add(bouwplanOpmerking);
    }

    public Gemeente getGemeente() {
        return gemeente;
    }

    public void setGemeente(Gemeente gemeente) {
        this.gemeente = gemeente;
    }

    public Set<Factmetperiode> getFactsmetperiode() {
        return factsmetperiode;
    }

    public void setFactsmetperiode(Set<Factmetperiode> factsmetperiode) {
        this.factsmetperiode = factsmetperiode;
    }

    public void addFactsmetperiode(Factmetperiode factmetperiode) {
        if (this.factsmetperiode==null){
            this.factsmetperiode=new HashSet<Factmetperiode>();
        }
        this.factsmetperiode.add(factmetperiode);
    }

    public Plantype getPlantype() {
        return plantype;
    }

    public void setPlantype(Plantype plantype) {
        this.plantype = plantype;
    }

    public Ontwikkelaartype getOntwikkelaartype() {
        return ontwikkelaartype;
    }

    public void setOntwikkelaartype(Ontwikkelaartype ontwikkelaartype) {
        this.ontwikkelaartype = ontwikkelaartype;
    }

    public Woonmilieu getWoonmilieu() {
        return woonmilieu;
    }

    public void setWoonmilieu(Woonmilieu woonmilieu) {
        this.woonmilieu = woonmilieu;
    }

    public Gebruikgegevens getGebruikgegevens() {
        return gebruikgegevens;
    }

    public void setGebruikgegevens(Gebruikgegevens gebruikgegevens) {
        this.gebruikgegevens = gebruikgegevens;
    }

    public Gebruiker getGebruiker() {
        return gebruiker;
    }

    public void setGebruiker(Gebruiker gebruiker) {
        this.gebruiker = gebruiker;
    }

    public Statusplanologisch getStatusplanologisch() {
        return statusplanologisch;
    }

    public void setStatusplanologisch(Statusplanologisch statusplanologisch) {
        this.statusplanologisch = statusplanologisch;
    }

    public Statusproject getStatusproject() {
        return statusproject;
    }

    public void setStatusproject(Statusproject statusproject) {
        this.statusproject = statusproject;
    }

    public String getStatus_namelijk() {
        return status_namelijk;
    }

    public void setStatus_namelijk(String status_namelijk) {
        this.status_namelijk = status_namelijk;
    }

    public Set<Bouwplanvoortgang> getBouwplanvoortgang() {
        return bouwplanvoortgang;
    }

    public void setBouwplanvoortgang(Set<Bouwplanvoortgang> bouwplanvoortgang) {
        this.bouwplanvoortgang = bouwplanvoortgang;
    }

    public void addBouwplanvoortgang(Bouwplanvoortgang bouwplanvoortgang) {
        if (this.bouwplanvoortgang ==null){
            this.bouwplanvoortgang = new HashSet<Bouwplanvoortgang>();
        }
        this.bouwplanvoortgang.add(bouwplanvoortgang);
    }

    public Set<Extraveld> getExtraveld() {
        return extraveld;
    }

    public void setExtraveld(Set<Extraveld> extraveld) {
        this.extraveld = extraveld;
    }
    
    public WoonmilieuRosettaType getWoonmilieu_rosetta() {
        return woonmilieu_rosetta;
    }

    public void setWoonmilieu_rosetta(WoonmilieuRosettaType woonmilieu_rosetta) {
        this.woonmilieu_rosetta = woonmilieu_rosetta;
    }

    public String getPlanIdentificatie() {
        return planIdentificatie;
    }

    public void setPlanIdentificatie(String planIdentificatie) {
        this.planIdentificatie = planIdentificatie;
    }

    public Integer getJaar_eerste_oplevering() {
        return jaar_eerste_oplevering;
    }

    public void setJaar_eerste_oplevering(Integer jaar_eerste_oplevering) {
        this.jaar_eerste_oplevering = jaar_eerste_oplevering;
    }

    public Integer getJaar_laatste_oplevering() {
        return jaar_laatste_oplevering;
    }

    public void setJaar_laatste_oplevering(Integer jaar_laatste_oplevering) {
        this.jaar_laatste_oplevering = jaar_laatste_oplevering;
    }

    public Integer getRestcapaciteit() {
        return restcapaciteit;
    }

    public void setRestcapaciteit(Integer restcapaciteit) {
        this.restcapaciteit = restcapaciteit;
    }

    public Integer getResterendesloop() {
        return resterendesloop;
    }

    public void setResterendesloop(Integer resterendesloop) {
        this.resterendesloop = resterendesloop;
    }

    public Integer getKoop1() {
        return koop1;
    }

    public void setKoop1(Integer koop1) {
        this.koop1 = koop1;
    }

    public Integer getKoop2() {
        return koop2;
    }

    public void setKoop2(Integer koop2) {
        this.koop2 = koop2;
    }

    public Integer getKoop3() {
        return koop3;
    }

    public void setKoop3(Integer koop3) {
        this.koop3 = koop3;
    }

    public Integer getKoop4() {
        return koop4;
    }

    public void setKoop4(Integer koop4) {
        this.koop4 = koop4;
    }

    public Integer getKoopprijsonbekend() {
        return koopprijsonbekend;
    }

    public void setKoopprijsonbekend(Integer koopprijsonbekend) {
        this.koopprijsonbekend = koopprijsonbekend;
    }

    public Integer getKooptotaal() {
        return kooptotaal;
    }

    public void setKooptotaal(Integer kooptotaal) {
        this.kooptotaal = kooptotaal;
    }

    public Integer getHuur1() {
        return huur1;
    }

    public void setHuur1(Integer huur1) {
        this.huur1 = huur1;
    }

    public Integer getHuur2() {
        return huur2;
    }

    public void setHuur2(Integer huur2) {
        this.huur2 = huur2;
    }

    public Integer getHuur3() {
        return huur3;
    }

    public void setHuur3(Integer huur3) {
        this.huur3 = huur3;
    }

    public Integer getHuur4() {
        return huur4;
    }

    public void setHuur4(Integer huur4) {
        this.huur4 = huur4;
    }

    public Integer getHuurprijsonbekend() {
        return huurprijsonbekend;
    }

    public void setHuurprijsonbekend(Integer huurprijsonbekend) {
        this.huurprijsonbekend = huurprijsonbekend;
    }

    public Integer getHuurtotaal() {
        return huurtotaal;
    }

    public void setHuurtotaal(Integer huurtotaal) {
        this.huurtotaal = huurtotaal;
    }

    public Date getDatumlaatstewijziging() {
        return datumlaatstewijziging;
    }

    public void setDatumlaatstewijziging(Date datumlaatstewijziging) {
        this.datumlaatstewijziging = datumlaatstewijziging;
    }

    public String getPlaatsnaam() {
        return plaatsnaam;
    }

    public void setPlaatsnaam(String plaatsnaam) {
        this.plaatsnaam = plaatsnaam;
    }

    public String getImronummer() {
        return imronummer;
    }

    public void setImronummer(String imronummer) {
        this.imronummer = imronummer;
    }

    public String getKnelpunten() {
        return knelpunten;
    }

    public void setKnelpunten(String knelpunten) {
        this.knelpunten = knelpunten;
    }

    public String getWoonmilieuabf14() {
        return woonmilieuabf14;
    }

    public void setWoonmilieuabf14(String woonmilieuabf14) {
        this.woonmilieuabf14 = woonmilieuabf14;
    }
    
    public Integer getEensgezins() {
        return eensgezins;
    }

    public void setEensgezins(Integer eensgezins) {
        this.eensgezins = eensgezins;
    }

    public Integer getMeergezins() {
        return meergezins;
    }

    public void setMeergezins(Integer meergezins) {
        this.meergezins = meergezins;
    }

    public Integer getWoningtypeonbekend() {
        return woningtypeonbekend;
    }

    public void setWoningtypeonbekend(Integer woningtypeonbekend) {
        this.woningtypeonbekend = woningtypeonbekend;
    }

    public String getOpmerkingenprovincie() {
        return opmerkingenprovincie;
    }

    public void setOpmerkingenprovincie(String opmerkingenprovincie) {
        this.opmerkingenprovincie = opmerkingenprovincie;
    }
    
    public String getOpmerkingen() {
        return opmerkingen;
    }

    public void setOpmerkingen(String opmerkingen) {
        this.opmerkingen = opmerkingen;
    }

    public boolean isOpmerkingenprive() {
        return opmerkingenprive;
    }

    public void setOpmerkingenprive(boolean opmerkingenprive) {
        this.opmerkingenprive = opmerkingenprive;
    }

    public List<BouwplanAdditionalVariable> getBouwplanAdditionalVariables() {
        return bouwplanAdditionalVariables;
    }

    public void setBouwplanAdditionalVariables(List<BouwplanAdditionalVariable> bouwplanAdditionalVariables) {
        this.bouwplanAdditionalVariables = bouwplanAdditionalVariables;
    }

    public List<BouwplanVariable> getBouwplanVariables() {
        return bouwplanVariables;
    }

    public void setBouwplanVariables(List<BouwplanVariable> bouwplanVariables) {
        this.bouwplanVariables = bouwplanVariables;
    }

    public String getDetailType() {
        return detailType;
    }

    public void setDetailType(String detailType) {
        this.detailType = detailType;
    }

    public Integer getSloop() {
        return sloop;
    }

    public void setSloop(Integer sloop) {
        this.sloop = sloop;
    }

    public Integer getGerealiseerdecapaciteit() {
        return gerealiseerdecapaciteit;
    }

    public void setGerealiseerdecapaciteit(Integer gerealiseerdecapaciteit) {
        this.gerealiseerdecapaciteit = gerealiseerdecapaciteit;
    }

    public Integer getTotaalcapaciteit() {
        return totaalcapaciteit;
    }

    public void setTotaalcapaciteit(Integer totaalcapaciteit) {
        this.totaalcapaciteit = totaalcapaciteit;
    }
    // </editor-fold>

}

