package nl.b3p.pzh.rwbp.stripes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.tag.BeanFirstPopulationStrategy;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.commons.stripes.CustomPopulationStrategy;
import nl.b3p.pzh.rwbp.entity.ConfigurableVariable;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieVariable;
import nl.b3p.pzh.rwbp.entity.VariableType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author Meine Toonen meinetoonen@b3partners.nl
 */
@StrictBinding
@CustomPopulationStrategy(BeanFirstPopulationStrategy.class)
public class AdminSearchActionBean extends ViewerActionBean {

    private static final Log log = LogFactory.getLog(AdminSearchActionBean.class);
    private final String JSP = "/WEB-INF/jsp/admin/search.jsp";
    private List<ConfigurableVariable> vars = new ArrayList<ConfigurableVariable>();

    @Validate
    private Integer[] savedFacetFields = new Integer[0];

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution save() {
        Provincie p = gebruiker.resolveProvincie();
        EntityManager em = Stripersist.getEntityManager();

        List<ConfigurableVariable> varsToBeRemoved = em.createQuery("FROM ConfigurableVariable WHERE type = :search")
                .setParameter("search", VariableType.SEARCH).getResultList();
        if(! varsToBeRemoved.isEmpty()){
            List<ProvincieVariable> optionalProvincieVars = em.createQuery("FROM ProvincieVariable WHERE provincie = :provincie and variable in :vars").setParameter("provincie", p).setParameter("vars", varsToBeRemoved).getResultList();
            for (Iterator<ProvincieVariable> it = optionalProvincieVars.iterator(); it.hasNext();) {
                ProvincieVariable provVar = it.next();
                em.remove(provVar);
            }
        }

        // Somehow, when checking no values, it keeps on remembering the previous value (even with BeanFirstPopulationStrategy), but the actual request.parameterValues is correct.
        if (this.getContext().getRequest().getParameterValues("savedFacetFields") != null) {
            for (int i = 0; i < savedFacetFields.length; i++) {
                Integer facetVar = savedFacetFields[i];
                ConfigurableVariable var = em.find(ConfigurableVariable.class, facetVar);
                ProvincieVariable provVar = new ProvincieVariable();
                provVar.setProvincie(p);
                provVar.setVariable(var);
                em.persist(provVar);
            }
        }
        em.getTransaction().commit();
        createList();
        return new ForwardResolution(JSP);
    }
    
    @Before(stages = LifecycleStage.BindingAndValidation)
    private void createList() {
        EntityManager em = Stripersist.getEntityManager();
        Provincie p = gebruiker.getProvincie();
        vars = em.createQuery("FROM ConfigurableVariable WHERE type = :type").setParameter("type", VariableType.SEARCH).getResultList();

        List<Integer> numVars = em.createQuery("select variable.id FROM ProvincieVariable WHERE variable in :vars and provincie = :provincie")
                .setParameter("vars", vars).setParameter("provincie", p).getResultList();
        savedFacetFields = numVars.toArray(new Integer[numVars.size()]);
    }

    // <editor-fold defaultstate="collapsed" desc="getters en setters">
    public List<ConfigurableVariable> getVars() {
        return vars;
    }

    public void setVars(List<ConfigurableVariable> vars) {
        this.vars = vars;
    }

    public Integer[] getSavedFacetFields() {
        return savedFacetFields;
    }

    public void setSavedFacetFields(Integer[] savedFacetFields) {
        this.savedFacetFields = savedFacetFields;
    }
    // </editor-fold>
}
