package nl.b3p.pzh.rwbp.stripes;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author Jytte
 * @author Meine Toonen meinetoonen@b3partners.nl
 */
@StrictBinding
public class BeheerActionBean extends ViewerActionBean {

    private static final Log log = LogFactory.getLog(BeheerActionBean.class);

    @Validate
    private String gemeente;

    @DefaultHandler
    public Resolution beheerdefault() {
        return new ForwardResolution("/WEB-INF/jsp/beheer.jsp");
    }

    public Resolution deletePlannenFromGemeente() {
           StringBuilder message = new StringBuilder();
        if (getIsBeheerder()) {
            EntityManager em = Stripersist.getEntityManager();
            List<Gemeente> gems = em.createQuery("FROM Gemeente where naam = :naam", Gemeente.class).setParameter("naam", gemeente).getResultList();
 
            if (gems.size() > 1) {
                message.append("Meer dan 1 gemeente gevonden. Geef de hele naam op. Afgebroken.");
            } else if (gems.isEmpty()) {
                message.append("Geen gemeente gevonden. Afgebroken.");
            } else {

                Gemeente gem = gems.get(0);
                Set<Bouwplan> bps = gem.getBouwplannen();
                message.append("Gemeente gevonden. Er zijn ");
                message.append(bps.size());
                message.append(" bouwplannen die worden verwijderd.");
                EditActionBean eb = new EditActionBean();
                List<String> ids = new ArrayList<String>();
                for (Bouwplan bp : bps) {
                    if(!em.getTransaction().isActive()){
                        em.getTransaction().begin();
                    }
                    ids.add(bp.getId().toString());
                    eb.removeBouwplan(bp, em);
                }
                SolrActionBean.removeMultipleBouwplans(ids);

            }
        } else {
            return new ErrorResolution(401, "Alleen beheerders mogen gemeentes weggooien.");
        }
        return new StreamingResolution("plain/text", message.toString()).setAttachment(false);
    }

    public String getGemeente() {
        return gemeente;
    }

    public void setGemeente(String gemeente) {
        this.gemeente = gemeente;
    }

}
