package nl.b3p.pzh.rwbp.stripes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.pzh.rwbp.SearchQuery;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.export.ExportBouwplannenThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServerException;
import org.stripesstuff.plugin.session.Session;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author Jytte
 */
@StrictBinding
public class ExportActionBean extends ViewerActionBean  {
    private static final Log log = LogFactory.getLog(ExportActionBean.class);

    @Session
    private Set<Integer> plannenToExport = new HashSet<Integer>();
    
    private List<Bouwplan> bouwplannen = new ArrayList<Bouwplan>();
    private Long resultCount;

    @Session
    private Long exportAantal;
    private boolean geenEmail = false;
    private boolean emailMelding = false;
    private String email;
    @Validate
    private boolean rapportpertype;
    @Validate
    private boolean rapportperperiode;
    @Validate
    private boolean rapporthov;
    @Validate
    private boolean exportperperiode;
    @Validate
    private boolean exportpertype;
    @Validate
    private boolean exportvolledig=true;
    @Validate
    private boolean exporteenvoudig=false;

    @DefaultHandler
    public Resolution export() {
        getExportplannen();
        return new ForwardResolution("/WEB-INF/jsp/export.jsp");
    }

    @Before(stages = LifecycleStage.BindingAndValidation)
    public void checkMail() {
        /* Als een gbruiker zijn email veranderd heeft zit deze niet in het gebruiker object wat
         wat via de userPrincipal word opgehaald. Dus moet de gebruiker opgehaald worden uit de
         database*/
        
        if (getGebruiker().getEmail() == null || getGebruiker().getEmail().length() <= 0) {
            getContext().getMessages().add(new SimpleMessage("Er is geen e-mail adres opgegeven voor deze gebruiker. <br>"
                    + "Het is daarom niet mogelijk om een export te doen. <br>Ga naar profiel om uw e-mail adres in te voeren."));

            geenEmail = true;
        } else {
            email = getGebruiker().getEmail();
        }
    }

    public Resolution delete() {
       
        Integer id = new Integer(context.getRequest().getParameter("id").toString());

        plannenToExport.remove(id);

        getExportplannen();

        return new ForwardResolution("/WEB-INF/jsp/export.jsp");
    }

    public Resolution deleteAll() {
        plannenToExport = new HashSet<Integer>();
        exportAantal = null;

        return new ForwardResolution("/WEB-INF/jsp/export.jsp");
    }

    public Resolution makeExport() {
        EntityManager em = Stripersist.getEntityManager();
        List<Integer> bpsToExport = new ArrayList<Integer>(plannenToExport);
     
        Integer[] geselecteerdePlannen = bpsToExport.toArray(new Integer[0]);

        if (bpsToExport.isEmpty()) {
            getContext().getMessages().add(new SimpleMessage("Er zijn geen bouwplannen geselecteerd op te exporteren. <br>"
                    + "Voeg bouwplannen toe via de zoekfunctie."));
            return new ForwardResolution("/WEB-INF/jsp/export.jsp");
        }
        // eventueel controleren of gebruiker lees rechten heeft op alle geselecteerde plannen.

        /* Als een gbruiker zijn email veranderd heeft zit deze niet in het gebruiker object wat
         wat via de userPrincipal word opgehaald. Dus moet de gebruiker opgehaald worden uit de
         database*/
        Gebruiker dbGebruiker = em.find(Gebruiker.class, gebruiker.getId());

        String servletPath = context.getRequest().getServletPath();
        String totaalPath = context.getRequest().getRequestURL().toString();
        String path = totaalPath.substring(0, totaalPath.length() - servletPath.length());

        try {
            ExportBouwplannenThread ebpt = new ExportBouwplannenThread(geselecteerdePlannen, dbGebruiker, path, exporteenvoudig,exportvolledig, exportperperiode, exportpertype, rapportpertype, rapportperperiode, rapporthov);
            ebpt.start();
            getContext().getMessages().add(new SimpleMessage("De export wordt voor u gemaakt. Zodra dit klaar is ontvangt u een email bericht op \'"+gebruiker.getEmail()+"\' met daarin een link waarmee u de export kunt downloaden."));
            emailMelding = true;
        } catch (Exception e) {
            context.getValidationErrors().add("exportMode", new SimpleError("Exporttype niet herkent: " + e));
            return export();
        }
        getExportplannen();

        return updateSelection();
    }

    public Resolution print() throws Exception{
        PrintActionBean print = new PrintActionBean();
        print.setContext(context);
        List<Integer> bps = new ArrayList<Integer>(plannenToExport);
        print.setBouwplans(bps);
        print.setMapserverUrl(this.getMapserverUrl());
        print.setLayers(this.getLayers());
        print.setHttpRequestParams(this.getHttpRequestParams());

        return print.print();
    }

    public Resolution updateSelection() {
        bouwplannen= getFilteredList();

        resultCount = new Long(bouwplannen.size());
        return new ForwardResolution("/WEB-INF/jsp/export.jsp");
    }

    private List<Bouwplan> getFilteredList() {
        EntityManager em = Stripersist.getEntityManager();
        
        List<Bouwplan> currentList = em.createQuery("from Bouwplan as bp where id in (:ids) order by naam asc").setParameter("ids", plannenToExport).getResultList();
        
        return currentList;
    }
    
    public Resolution addToExport() throws SolrServerException {
        List<Integer> add = new ArrayList<Integer>();
        Object searchProperties = context.getRequest().getSession().getAttribute(SolrActionBean.SEARCH_PROPERTIES);
        if (searchProperties != null) {
            SearchQuery query = (SearchQuery)searchProperties;
            add = BouwplanUtils.getAllIdsFromQuery(query);
            if(plannenToExport == null){
                plannenToExport = new HashSet<Integer>();
            }
            plannenToExport.addAll(add);
        }

        getExportplannen();
        return new ForwardResolution("/WEB-INF/jsp/export.jsp");
    }

    public void getExportplannen() {
        if (plannenToExport != null && !plannenToExport.isEmpty()) {
            bouwplannen = getFilteredList();
            resultCount = new Long(bouwplannen.size());
            exportAantal = new Long(bouwplannen.size());
        }
    }

    // <editor-fold defaultstate="collapsed" desc="getters en setters">
    public List<Bouwplan> getBouwplannen() {
        return bouwplannen;
    }

    public void setBouwplannen(List<Bouwplan> bouwplannen) {
        this.bouwplannen = bouwplannen;
    }

    public Long getResultCount() {
        return resultCount;
    }

    public void setResultCount(Long resultCount) {
        this.resultCount = resultCount;
    }

    public Long getExportAantal() {
        return exportAantal;
    }

    public void setExportAantal(Long exportAantal) {
        this.exportAantal = exportAantal;
    }

    public boolean isGeenEmail() {
        return geenEmail;
    }

    public void setGeenEmail(boolean geenEmail) {
        this.geenEmail = geenEmail;
    }

    public boolean isEmailMelding() {
        return emailMelding;
    }

    public void setEmailMelding(boolean emailMelding) {
        this.emailMelding = emailMelding;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isRapportpertype() {
        return rapportpertype;
    }

    public void setRapportpertype(boolean rapportpertype) {
        this.rapportpertype = rapportpertype;
    }

    public boolean isRapportperperiode() {
        return rapportperperiode;
    }

    public void setRapportperperiode(boolean rapportperperiode) {
        this.rapportperperiode = rapportperperiode;
    }

    public boolean isExportperperiode() {
        return exportperperiode;
    }

    public void setExportperperiode(boolean exportperperiode) {
        this.exportperperiode = exportperperiode;
    }

    public boolean isExportpertype() {
        return exportpertype;
    }

    public void setExportpertype(boolean exportpertype) {
        this.exportpertype = exportpertype;
    }

    public boolean isExportvolledig() {
        return exportvolledig;
    }

    public void setExportvolledig(boolean exportvolledig) {
        this.exportvolledig = exportvolledig;
    }

    public boolean isRapporthov() {
        return rapporthov;
    }

    public void setRapporthov(boolean rapporthov) {
        this.rapporthov = rapporthov;
    }

    public boolean isExporteenvoudig() {
        return exporteenvoudig;
    }

    public void setExporteenvoudig(boolean exporteenvoudig) {
        this.exporteenvoudig = exporteenvoudig;
    }
    // </editor-fold>

}
