/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import nl.b3p.pzh.rwbp.export.ExportConfigServlet;
import nl.b3p.pzh.rwbp.stripes.ViewerActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadsActionBean
extends ViewerActionBean {
    private static final Log log = LogFactory.getLog(DownloadsActionBean.class);
    private final String JSP = "/WEB-INF/jsp/downloads.jsp";
    private List<String> reports = new ArrayList();
    @Validate
    private String reportName;

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public List<String> getReports() {
        return this.reports;
    }

    public void setReports(List<String> reports) {
        this.reports = reports;
    }

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution("/WEB-INF/jsp/downloads.jsp");
    }

    public Resolution download() throws IOException {
        String location = ExportConfigServlet.getDownloadLocation();
        String government = this.getGovernmentType();
        String governmentname = this.getGovernmentName();
        String reportType = this.reportName.substring(0, this.reportName.indexOf("."));
        String extensie = this.reportName.substring(this.reportName.indexOf("."));
        File parentLocation = new File(location, government);
        File typeLocation = new File(parentLocation, reportType);
        String fileName = governmentname + "_" + reportType + extensie;
        File report = new File(typeLocation, fileName);
        if (report.exists()) {
            String contenttype = Files.probeContentType(report.toPath());
            return new /* Unavailable Anonymous Inner Class!! */.setAttachment(true).setFilename(this.reportName);
        }
        this.context.getValidationErrors().add("Bestand", (ValidationError)new SimpleError("Bestand niet gevonden.", new Object[0]));
        log.error((Object)("Bestand geprobeerd te downloaden, wat niet bestaat. Bestand: " + report.getAbsolutePath() + " - " + governmentname + " for user: " + (this.gebruiker != null ? this.gebruiker.getUsername() : " niet ingelogd ") + "uit " + governmentname));
        return new ForwardResolution("/WEB-INF/jsp/downloads.jsp");
    }

    @Before
    private void generateReportList() {
        if (this.gebruiker != null) {
            String location = ExportConfigServlet.getDownloadLocation();
            String government = this.getGovernmentType();
            String governmentname = this.getGovernmentName();
            File dir = new File(location, government);
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isDirectory()) continue;
                    this.addReportsForGovernmentName(file, governmentname, this.reports);
                }
            }
        }
    }

    private String getGovernmentType() {
        String government = null;
        if (this.gebruiker.getGemeente() != null) {
            government = "Gemeenten";
        } else if (this.gebruiker.getRegio() != null) {
            government = "Regios";
        } else if (this.gebruiker.getProvincie() != null) {
            government = "Provincies";
        } else if (this.gebruiker.isRijk()) {
            government = "Rijk";
        }
        return government;
    }

    private String getGovernmentName() {
        String governmentname = null;
        if (this.gebruiker == null) {
            return null;
        }
        if (this.gebruiker.getGemeente() != null) {
            governmentname = this.gebruiker.getGemeente().getNaam();
        } else if (this.gebruiker.getRegio() != null) {
            governmentname = this.gebruiker.getRegio().getNaam();
        } else if (this.gebruiker.getProvincie() != null) {
            governmentname = this.gebruiker.getProvincie().getNaam();
        } else if (this.gebruiker.isRijk()) {
            governmentname = "Rijk";
        }
        return governmentname;
    }

    private void addReportsForGovernmentName(File dir, String governmentName, List<String> reports) {
        if (governmentName != null) {
            String[] files;
            for (String file : files = dir.list()) {
                if (!file.substring(0, file.indexOf("_")).equals(governmentName)) continue;
                reports.add(dir.getName() + file.substring(file.indexOf(".")));
            }
        }
    }
}

