<%@include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@page contentType="text/html" session="false" pageEncoding="UTF-8"%>

<stripes:layout-render name="/WEB-INF/jsp/templates/viewerTemplate.jsp" pageTitle="Zoeken">
    <stripes:layout-component name="head">
        <script type="text/javascript" src="./js/dropdown.js"></script>
        <script type="text/javascript" src="./js/searchNG.js"></script>
    </stripes:layout-component>
    <stripes:layout-component name="content">
        <div id="search">
            <div class="search-container">
                <div class="advanced-search default-hidden">
                    <div class="row">
                        <label>Regio</label>
                        <div class="select">
                            <select id="regio" multiple data-emptytext="Selecteer 1 of meerdere regio’s">
                                <c:forEach var="regio" items="${actionBean.regios}">
                                    <option value="${regio.naam}"><c:out value="${regio.naam}"/></option>
                                </c:forEach>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <label>Gemeente</label>
                        <div class="select">
                            <select id="gemeente" multiple data-emptytext="Selecteer 1 of meerdere gemeentes">
                                <c:forEach var="gemeente" items="${actionBean.gemeentes}">
                                    <option value="${gemeente.naam}"><c:out value="${gemeente.naam}"/></option>
                                </c:forEach>
                            </select>
                        </div>
                    </div>
                </div>
                <input type="search" placeholder="Zoek op trefwoord, plaats, regio, ..." name="searchField" id="searchField" />
                <button class="btn" id="searchButton">Zoeken</button>
                <button class="btn" id="resetButton">Reset</button>
                <a href="#" class="toggle" data-target=".advanced-search" data-toggle-text="eenvoudig zoeken">uitgebreid zoeken</a>
            </div>
            <div class="search-result">
                <div class="result-title">
                    <a href="#" class="result-export">exporteer plannen</a>
                    <span id="result-status"></span>
                </div>
                <div class="search-sort">
                    <a href="#" id="search-sort-toggle">Sorteer op</a>
                </div>
                <div id="facets" class="search-facets"></div>
                <div class="result-links">
                    <ol id="searchResults"></ol>
                    <div id="pagination" class="pagination"></div>
                </div>
            </div>
        </div>
        <div id="map"></div>
        <stripes:form id="selectBouwplanForm" beanclass="nl.b3p.pzh.rwbp.stripes.EditActionBean" name="selectBouwplanForm">
            <stripes:hidden name="planid" id="planid"/>
        </stripes:form>
    </stripes:layout-component>
</stripes:layout-render>
                        
<script type="text/javascript">

    Ext.onReady(function() {
        var b3pviewer = Ext.create('B3p.planmonitor.Viewer', {
            kaartlagen: '${actionBean.layers}',
            mapserverUrl: '${actionBean.mapserverUrl}',
            host: '${actionBean.absoluteUrlPrefix}${contextPath}/sld',
            querylagen: '${actionBean.querylayers}',
            sldkey_eenvoudig: '${actionBean.sldkey_eenvoudig}',
            httpRequestParams: '${actionBean.httpRequestParams}',
            bouwplanByCoordAjaxurl: "<stripes:url beanclass="nl.b3p.pzh.rwbp.stripes.SearchActionBean" event="getBouwplanIdsByCoord"></stripes:url>",
        });
        var facets = "${actionBean.facets}";
        
        if( ${empty actionBean.gebruiker}){
            facets = "provincie_facet,regio_facet,gemeente_facet,plaatsnaam_facet";
        }
        var search = Ext.create(B3p.planmonitor.SearchNG, {
            searchURL: "<stripes:url beanclass="nl.b3p.pzh.rwbp.stripes.SolrActionBean" event="search"></stripes:url>",
            searchButton: "searchButton",
            sortToggle: 'search-sort-toggle',
            facetDiv :'facets',
            resultStatus: 'result-status',
            resultDiv: 'searchResults',
            paginationDiv: 'pagination',
            termField:"searchField",
            facettingFields: facets,
            sortField: "naam_facet",
            sortOrder: "asc",
            resultsPerPage: 10,
            viewer: b3pviewer,
            reloadPrevious: "${actionBean.context.eventName}" === "close",
            searchFields:"naam,gemeente,id",
            defaultExtraQueries:"-statusproject_facet:Verwijderd",
            resetButton: "resetButton"
        });
        // Added timeout to make sure selects are converted to Ext ComboBoxes
        setTimeout(function() {
                var isGemeente = ${actionBean.isGemeente};
                var isProvincie = ${not empty actionBean.provincie};
                var isRegio= ${not empty actionBean.regio};
                var initialExtent= '${actionBean.initialExtent}';
                var field, value;
                if(isGemeente){
                    var gemeente = "${actionBean.gebruiker.gemeente.naam}";
                    field = "gemeente_facet";
                    value ="\"" + gemeente+"\"";
                }else if(isProvincie){
                    field = "provincie_facet";
                    value = "\"${actionBean.provincie}\"";
                }else if(isRegio){
                    field = "regio_facet";
                    value = "\"${actionBean.regio}\"";
                }
                
                search.start(field, value,initialExtent);
        }, 0);
    });
</script>
