Ext.define('B3p.planmonitor.DetailPlanner', {
    cols: ["Jaar", "Gepland", "Gerealiseerd"],
    bouwplan: null,
    initCompleted: false,
    tableBody: null,
    totalsCounter: null,
    // Keeps a reference to which fields is updated last, the restcapaciteit field
    // or the detailfields which make up a total.
    capacityCountLastUpdate: '',
    capacityTotal: 0,
    config: {
        div: null,
        beginYear: null,
        endYear: null,
        canEdit:null,
        retrieveDetailData: '',
        saveDetailData: ''
    },
    constructor: function(config) {
        this.initConfig(config);
        this.bouwplan = document.getElementById("bouwplanid").value;
        this.initForm();
        this.capacityTotal = +(document.getElementById('totaalcapaciteit').value);
        document.getElementById("cancelDetailPlanning").addEventListener("click", this.closeDialog);
        if(this.config.canEdit){
            document.getElementById("saveDetailPlanning").addEventListener("click", this.save.bind(this));
        }
        document.getElementById("detailPopupLink").addEventListener("click", this.popupOpen.bind(this));
        document.getElementById('totaalcapaciteit').addEventListener('input', this.totalCapaciteitChange.bind(this));
    },
    totalCapaciteitChange: function(e) {
        var val = +(e.target.value);
        if(val !== this.capacityTotal) {
            this.capacityCountLastUpdate = 'restcapaciteit';
            this.capacityTotal = val;
            if(this.initCompleted) {
                this.divideCapacityTotal();
            }
        }
    },
    popupOpen: function() {
        var begin = parseInt(Ext.get( "jaar_eerste_oplevering").getValue(), 10);
        var end = parseInt(Ext.get( "jaar_laatste_oplevering").getValue(), 10);
        if(!this.initCompleted || this.config.beginYear !== begin || this.config.endYear !== end) {
            this.config.beginYear = begin;
            this.config.endYear = end;
            this.init();
        }
    },
    init: function(){
        Ext.Ajax.request({
            url: this.config.retrieveDetailData,
            scope: this,
            params: {
                bouwplan: this.bouwplan
            },
            success: function (result) {
                var response = Ext.JSON.decode(result.responseText);
                if (response.success) {
                    var d = response.bouwplanvariables;
                    // Process data for easier lookup
                    var data = {};
                    for ( var i = 0 ; i < d.length ;i++){
                        data[d[i].year] = d[i];
                    }
                    this.createForm(data);
                } else {
                    console.log("Error", response);
                }
            },
            failure: function (error) {
                console.log("Error", error);
            }
        });
    },
    save: function(){
        var bvs = [];
        for(var i = this.config.beginYear ; i <= this.config.endYear ; i ++ ){
            var bv = this.getBouwplanVariable(i);
            bvs.push(bv);
        }
        var onbekend = this.getBouwplanVariable(-1); // Retrieve onbekend jaar
        bvs.push(onbekend);

        if(this.bouwplan){
            Ext.Ajax.request({
                url: this.config.saveDetailData,
                scope: this,
                params: {
                    bouwplan: this.bouwplan,
                    detailData: Ext.JSON.encode(bvs)
                },
                success: function (result) {
                    var response = Ext.JSON.decode(result.responseText);
                    if (response.success) {
                        this.updateMainScreen();
                    } else {
                        console.log("Error", response);
                    }
                    this.closeDialog();
                },
                failure: function (error) {
                    console.log("Error", error);
                }
            });
        }else{
            document.getElementById("detailData").value = Ext.JSON.encode(bvs);
            this.updateMainScreen();
            this.closeDialog();
        }
    },
    updateMainScreen : function (){
        var total = this.totalsCounter.getTotalForField('gepland');
        var gerealiseerdTotaal = this.gerealiseerdCounter.getTotal();

        this.capacityCountLastUpdate = 'details';
        this.capacityTotal = total;

        var totalElement = document.getElementById('totaalcapaciteit');
        totalElement.value = total;
        totalElement.readonly = true;

        var gerealiseerdeElement = document.getElementById('gerealiseerdecapaciteit');
        gerealiseerdeElement.value = gerealiseerdTotaal;
        gerealiseerdeElement.readonly = true;

        $(totalElement).change();
    },
    getBouwplanVariable: function (year){
        var bouwplanVariable = {
            "gerealiseerd": document.getElementById("gerealiseerd"+year).checked,
            "gepland" : +(document.getElementById("gepland"+year).value),
            "year": year
        };
        return bouwplanVariable;
    },
    initForm: function() {
        var table = document.createElement ("table");
        table.className = "planning-counter";
        table.id = "detailstable";
        table.appendChild(this.createHeader());
        this.tableBody = document.createElement("tbody");
        table.appendChild(this.tableBody);
        var tfoot = document.createElement('tfoot');
        tfoot.appendChild(this.createTotal());
        table.appendChild(tfoot);
        var div = document.getElementById(this.config.div);
        div.appendChild(table);
        this.totalsCounter = Ext.create('B3p.planmonitor.TotalCounter', {
            parent: '.planning-counter',
            fields: [
                'gepland'
            ]
        });
        this.gerealiseerdCounter = Ext.create('B3p.planmonitor.ConditionalCounter', {
            parent: '.planning-counter',
            rowSelector: '.inputrow',
            conditionSelector: '.gerealiseerd_checkbox'
        });
    },
    createForm: function(data){
        this.initCompleted = true;
        this.clearChildren(this.tableBody);
        for (var i = this.config.beginYear; i <= this.config.endYear; i++) {
            var yearData = data.hasOwnProperty(i) ? data[i] : {};
            var row = this.createRow(i, yearData);
            this.tableBody.appendChild(row);
        }
        var unknownData = Ext.isDefined(data[-1]) ? data[-1] : {};
        var unknownRow = this.createRow(-1, unknownData);
        this.tableBody.appendChild(unknownRow);
        if(this.totalsCounter) {
            this.totalsCounter.resetTotals();
        }
        if(this.capacityCountLastUpdate === 'restcapaciteit') {
            this.divideCapacityTotal();
        }
    },
    createHeader: function(){
        var thead = document.createElement('thead');
        var tr = document.createElement("tr");
        for( var i = 0 ; i < this.cols.length ;i++){
            var th = document.createElement("th");
            th.innerHTML = this.cols[i];
            tr.appendChild(th);
        }
        thead.appendChild(tr);
        return thead;
    },
    createTotal: function(){
        var tr = document.createElement ("tr");
        var td = document.createElement("td");
        td.innerHTML = "Totaal";
        tr.appendChild(td);
        tr.appendChild(this.createTotalTD("gepland"));
        tr.appendChild(document.createElement("td"));
        return tr;
    },
    createTotalTD: function(type){
        var td = document.createElement("td");
        var spangepland = document.createElement("span");
        spangepland.className = "total "+ type + "-total";
        td.appendChild(spangepland);
        return td;
    },
    createRow: function (year, yearData){
        var tr = document.createElement ("tr");
        tr.className = 'inputrow';
        for (var i = 0 ; i < this.cols.length ; i ++){
            var col = this.createColumn(year, this.cols[i],yearData);
            tr.appendChild(col);
        }
        return tr;
    },
    createColumn: function(year, colName, yearData){
        var lowerCaseName = colName.toLowerCase();
        var td = document.createElement("td");
        td.className = "detail-div";
        if(colName !== "Jaar") {
            var inputField = document.createElement("input");
            inputField.id = lowerCaseName + year;
            inputField.name = lowerCaseName + year;
            if(colName === "Gerealiseerd") {
                inputField.className = 'gerealiseerd_checkbox'
                inputField.type = "checkbox";
                inputField.value = true;
                inputField.checked = yearData.hasOwnProperty(lowerCaseName) && yearData[lowerCaseName];
            } else {
                inputField.type = "text";
                inputField.value = yearData.hasOwnProperty(lowerCaseName) ? yearData[lowerCaseName] : "";
                inputField.className = "numeric " + lowerCaseName;
            }
            td.appendChild(inputField);
        } else {
            year = year === -1 ? "Onbekend" : year;
            td.innerHTML = year;
        }
        return td;
    },
    divideCapacityTotal: function() {
        var totaalcapaciteit = +(document.getElementById('totaalcapaciteit').value);
        var rows = (this.config.endYear - this.config.beginYear) + 1;
        var average = Math.floor(totaalcapaciteit / rows);
        var rest = totaalcapaciteit - (rows * average);
        for (var i = this.config.beginYear; i <= this.config.endYear; i++) {
            document.getElementById("gepland" + i).value = (i === this.config.beginYear ? average + rest : average);
        }
        if(this.totalsCounter) {
            this.totalsCounter.resetTotals();
        }
        this.capacityCountLastUpdate = '';
    },
    clearChildren: function(container) {
        if(!container) {
            return;
        }
        while (container.firstChild) {
            container.removeChild(container.firstChild);
        }
    },
    closeDialog : function(){
        $("#detailplanning").dialog("close");
    }
});