// Input 0
Ext.define("viewer.viewercontroller.openlayers.OpenLayersLayer", {config:{name:null}, enabledEvents:null, events:null, type:null, alpha:100, constructor:function(a) {
  this.initConfig(a);
  this.enabledEvents = {};
  this.events = {};
  return this
}, getOption:function(a) {
  var a = a.toLowerCase(), b;
  for(b in this.getFrameworkLayer().options) {
    if(b.toLowerCase() == a) {
      return this.getFrameworkLayer().options[b]
    }
  }
  for(b in this.getFrameworkLayer().params) {
    if(b.toLowerCase() == a) {
      return this.getFrameworkLayer().params[b]
    }
  }
  return null
}, setOption:function(a, b) {
  var c = {};
  c[a] = b;
  this.getFrameworkLayer().setOptions(c)
}, setAlpha:function(a) {
  this.alpha = a;
  this.frameworkLayer && this.frameworkLayer.setOpacity(a / 100)
}, getAlpha:function() {
  return this.alpha
}, reload:function() {
  this.getFrameworkLayer().redraw(true)
}, addListener:function(a, b, c) {
  var d = this.viewerController.mapComponent.getSpecificEventName(a);
  d && (c || (c = this), !d == "featureadded" && (this.enabledEvents[d] ? this.enabledEvents[d]++ : (this.enabledEvents[d] = 1, this.frameworkLayer.events.register(d, this, this.handleEvent))));
  viewer.viewercontroller.controller.Layer.superclass.addListener.call(this, a, b, c)
}, removeListener:function(a, b, c) {
  var d = this.viewerController.mapComponent.getSpecificEventName(a);
  d && (c || (c = this), this.enabledEvents[d] && (this.enabledEvents[d]--, this.enabledEvents[d] <= 0 && (this.enabledEvents[d] = 0, this.frameworkLayer.events.unregister(d, this, this.handleEvent))));
  viewer.viewercontroller.controller.Layer.superclass.removeListener.call(this, a, b, c)
}, getType:function() {
  return this.type
}, handleEvent:function(a) {
  var b = {};
  b.layer = this.map.getLayerByOpenLayersId(a.element.id);
  b.feature = this.fromOpenLayersFeature(a.feature);
  var c = this.viewerController.mapComponent.getGenericEventName(a.type);
  c || (c = a);
  this.fireEvent(c, b)
}, setVisible:function(a) {
  this.visible = a;
  this.frameworkLayer != null && this.frameworkLayer.setVisibility(a)
}, getVisible:function() {
  return this.frameworkLayer != null ? this.frameworkLayer.getVisibility() : null
}, destroy:function() {
  this.frameworkLayer != null && this.frameworkLayer.destroy();
  this.superclass.$className == "viewer.viewercontroller.openlayers.OpenLayersArcLayer" ? this.superclass.superclass.destroy.call(this) : this.superclass.destroy.call(this)
}});
// Input 1
Ext.define("viewer.viewercontroller.openlayers.OpenLayersArcLayer", {extend:"viewer.viewercontroller.controller.ArcLayer", mixins:{openLayersLayer:"viewer.viewercontroller.openlayers.OpenLayersLayer"}, constructor:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersArcLayer.superclass.constructor.call(this, a);
  this.mixins.openLayersLayer.constructor.call(this, a);
  this.initConfig(a);
  return this
}, getId:function() {
  return this.id
}, getName:function() {
  return this.options.name
}, getServer:function() {
  return this.options.server
}, getService:function() {
  return this.options.service
}, getServlet:function() {
  return this.options.servlet
}, getMapservice:function() {
  return this.options.mapservice
}, getLayers:function() {
  return this.options.layers
}, getLegendGraphic:function() {
  return null
}, setBuffer:function() {
  console.log("OpenLayersArcLayer.setBuffer: .setBuffer() must be made!")
}, removeBuffer:function() {
  console.log("OpenLayersArcLayer.removeBuffer: .removeBuffer() must be made!")
}, getType:function() {
  return this.mixins.openLayersLayer.getType.call(this)
}, setVisible:function(a) {
  this.mixins.openLayersLayer.setVisible.call(this, a)
}, getVisible:function() {
  return this.mixins.openLayersLayer.getVisible.call(this)
}, setAlpha:function(a) {
  this.mixins.openLayersLayer.setAlpha.call(this, a)
}, reload:function() {
  this.mixins.openLayersLayer.reload.call(this)
}, addListener:function(a, b, c) {
  this.mixins.openLayersLayer.addListener.call(this, a, b, c)
}, removeListener:function(a, b, c) {
  this.mixins.openLayersLayer.removeListener.call(this, a, b, c)
}, destroy:function() {
  this.mixins.openLayersLayer.destroy.call(this)
}});
// Input 2
Ext.define("viewer.viewercontroller.openlayers.OpenLayersArcIMSLayer", {extend:"viewer.viewercontroller.openlayers.OpenLayersArcLayer", constructor:function(a) {
  this.id = a.id;
  viewer.viewercontroller.openlayers.OpenLayersArcIMSLayer.superclass.constructor.call(this, a);
  this.initConfig(a);
  this.type = viewer.viewercontroller.controller.Layer.ARCIMS_TYPE;
  a = {async:true, singleTile:false, tileSize:new OpenLayers.Size(1024, 1024), transparent:true, format:"image/png", opacity:this.config.opacity != void 0 ? this.config.opacity : 1};
  a.serviceName = this.serviceName;
  a.filterCoordSys = "28992";
  a.featureCoordSys = "28992";
  a.layers = [{id:this.layers, visible:true, query:{where:""}}];
  this.frameworkLayer = new OpenLayers.Layer.ArcIMS(this.name, this.url, a);
  return this
}, setBuffer:function() {
  this.viewerController.logger.error("OpenLayersArcIMSLayer: setBuffer() not supported!")
}, removeBuffer:function() {
}, setQuery:function(a) {
  if(a) {
    var b = this;
    Ext.create("viewer.ArcQueryUtil").cqlToArcXMLWhere(a.getCQL(), function(a) {
      b.frameworkLayer.layers[0].query.where = a;
      b.reload()
    }, this.viewerController.logger.error)
  }else {
    this.frameworkLayer.layers[0].query.where = "", this.reload()
  }
}});
// Input 3
Ext.define("viewer.viewercontroller.openlayers.OpenLayersArcServerLayer", {extend:"viewer.viewercontroller.openlayers.OpenLayersArcLayer", constructor:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersArcServerLayer.superclass.constructor.call(this, a);
  this.frameworkLayer = new OpenLayers.Layer.ArcGIS93Rest(this.name, this.url + "/export", {layers:"show:" + a.layers, transparent:"true"}, {visibility:this.visible, singleTile:true, transitionEffect:"resize", opacity:this.config.opacity != void 0 ? this.config.opacity : 1});
  this.type = viewer.viewercontroller.controller.Layer.ARCSERVERREST_TYPE
}, getLastMapRequest:function() {
  var a = this.getFrameworkLayer().map.getExtent(), a = this.getFrameworkLayer().getURL(a), b = "SIZE=" + this.getMap().getWidth() + "%2C" + this.getMap().getHeight(), a = a.replace("SIZE=256%2C256", b);
  return[{url:a}]
}, setQuery:function(a) {
  var b = this, a = a != null ? a.getCQL() : "";
  a != "" ? Ext.create("viewer.ArcQueryUtil").cqlToArcFIDS(a, this.appLayerId, function(a, d) {
    var e = "-1";
    a.length != 0 && (e = d + " IN(" + a.join(",") + ")");
    b.getFrameworkLayer().setLayerFilter(b.layers, e);
    setTimeout(function() {
      b.reload()
    }, 500)
  }, function(a) {
    b.getViewerController().logger.error(a)
  }) : (b.getFrameworkLayer().setLayerFilter(b.layers, null), setTimeout(function() {
    b.reload()
  }, 500))
}});
// Input 4
Ext.define("viewer.viewercontroller.openlayers.OpenLayersWMSLayer", {extend:"viewer.viewercontroller.controller.WMSLayer", mixins:{openLayersLayer:"viewer.viewercontroller.openlayers.OpenLayersLayer"}, constructor:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersWMSLayer.superclass.constructor.call(this, a);
  this.mixins.openLayersLayer.constructor.call(this, a);
  this.options.visibility = this.visible;
  this.options.singleTile = true;
  this.options.transitionEffect = "resize";
  this.frameworkLayer = new OpenLayers.Layer.WMS(this.options.name, this.url, this.ogcParams, this.options);
  this.type = viewer.viewercontroller.controller.Layer.WMS_TYPE;
  this.mapTipControl = this.getFeatureInfoControl = null
}, getLastMapRequest:function() {
  return[{url:this.getFrameworkLayer().getURL(this.getFrameworkLayer().map.getExtent())}]
}, getLayers:function() {
  return this.getFrameworkLayer().options.layers
}, setUrl:function(a) {
  this.url = a
}, setOGCParams:function(a) {
  this.getFrameworkLayer().mergeNewParams(a)
}, setGetFeatureInfoControl:function(a) {
  this.getFeatureInfoControl = a
}, getGetFeatureInfoControl:function() {
  return this.getFeatureInfoControl
}, setMapTipControl:function(a) {
  this.mapTipControl = a
}, getMapTipControl:function() {
  return this.mapTipControl
}, setQuery:function(a) {
  if(a) {
    var b = this.viewerController.app.services[this.serviceId].layers[this.options.name];
    if(b.details != void 0 && (b = b.details.filterable, b != void 0 && b != null && (b = Ext.JSON.decode(b)))) {
      var c = this;
      Ext.create("viewer.SLD", {}).create([this.options.layers], ["default"], a.getCQL(), function(a) {
        c.setOGCParams({SLD_BODY:a});
        c.reload()
      }, console.log)
    }
  }else {
    this.setOGCParams({SLD_BODY:null})
  }
}, setVisible:function(a) {
  this.mixins.openLayersLayer.setVisible.call(this, a)
}, getVisible:function() {
  return this.mixins.openLayersLayer.getVisible.call(this)
}, setAlpha:function(a) {
  this.mixins.openLayersLayer.setAlpha.call(this, a)
}, reload:function() {
  this.mixins.openLayersLayer.reload.call(this)
}, addListener:function(a, b, c) {
  this.mixins.openLayersLayer.addListener.call(this, a, b, c)
}, removeListener:function(a, b, c) {
  this.mixins.openLayersLayer.removeListener.call(this, a, b, c)
}, getType:function() {
  return this.mixins.openLayersLayer.getType.call(this)
}, destroy:function() {
  this.mixins.openLayersLayer.destroy.call(this)
}});
// Input 5
Ext.define("viewer.viewercontroller.openlayers.OpenLayersVectorLayer", {extend:"viewer.viewercontroller.controller.VectorLayer", mixins:{openLayersLayer:"viewer.viewercontroller.openlayers.OpenLayersLayer"}, point:null, line:null, polygon:null, circle:null, drawFeatureControls:null, modifyFeature:null, constructor:function(a) {
  a.colorPrefix = "#";
  viewer.viewercontroller.openlayers.OpenLayersVectorLayer.superclass.constructor.call(this, a);
  this.mixins.openLayersLayer.constructor.call(this, a);
  var b = new OpenLayers.StyleMap({"default":this.getCurrentStyleHash(), select:{strokeColor:"#FF0000", strokeWidth:2, fillColor:this.colorPrefix + a.style.fillcolor, fillOpacity:0.4, strokeOpacity:0.8, pointRadius:6}}, {extendDefault:false});
  a.styleMap = b;
  delete a.style;
  this.frameworkLayer = new OpenLayers.Layer.Vector(a.id, a);
  this.type = viewer.viewercontroller.controller.Layer.VECTOR_TYPE;
  this.point = new OpenLayers.Control.DrawFeature(this.frameworkLayer, OpenLayers.Handler.Point, {displayClass:"olControlDrawFeaturePoint"});
  this.line = new OpenLayers.Control.DrawFeature(this.frameworkLayer, OpenLayers.Handler.Path, {displayClass:"olControlDrawFeaturePath"});
  this.polygon = new OpenLayers.Control.DrawFeature(this.frameworkLayer, OpenLayers.Handler.Polygon, {displayClass:"olControlDrawFeaturePolygon"});
  this.circle = new OpenLayers.Control.DrawFeature(this.frameworkLayer, OpenLayers.Handler.RegularPolygon, {handlerOptions:{sides:40}});
  this.drawFeatureControls = [];
  this.drawFeatureControls.push(this.circle);
  this.drawFeatureControls.push(this.polygon);
  this.drawFeatureControls.push(this.line);
  this.drawFeatureControls.push(this.point);
  this.modifyFeature = new OpenLayers.Control.ModifyFeature(this.frameworkLayer, {createVertices:false, vertexRenderIntent:"select"});
  a = this.viewerController.mapComponent.getMap().getFrameworkMap();
  a.addControl(this.point);
  a.addControl(this.line);
  a.addControl(this.polygon);
  a.addControl(this.circle);
  a.addControl(this.modifyFeature);
  this.modifyFeature.selectControl.events.register("featurehighlighted", this, this.activeFeatureChanged);
  this.frameworkLayer.events.register("afterfeaturemodified", this, this.featureModified);
  this.frameworkLayer.events.register("featuremodified", this, this.featureModified);
  this.frameworkLayer.events.register("featureadded", this, this.featureAdded);
  this.modifyFeature.activate()
}, getCurrentStyleHash:function() {
  return{strokeColor:this.colorPrefix + this.style.strokecolor, strokeWidth:3, pointRadius:6, fillColor:this.colorPrefix + this.style.fillcolor, fillOpacity:this.style.fillopacity / 100}
}, adjustStyle:function() {
}, removeAllFeatures:function() {
  this.getFrameworkLayer().removeAllFeatures();
  this.stopDrawing()
}, getActiveFeature:function() {
  return this.fromOpenLayersFeature(this.getFrameworkLayer().features[0])
}, getFeature:function(a) {
  return this.getFrameworkLayer().features[a]
}, getFeatureById:function(a) {
  return this.fromOpenLayersFeature(this.getFrameworkLayer().getFeatureById(a))
}, getAllFeatures:function() {
  for(var a = this.getFrameworkLayer().features, b = [], c = 0;c < a.length;c++) {
    var d = this.fromOpenLayersFeature(a[c]);
    b.push(d)
  }
  return b
}, addFeature:function(a) {
  var b = [];
  b.push(a);
  this.addFeatures(b)
}, removeFeature:function(a) {
  a = this.getFrameworkLayer().getFeatureById(a.getId());
  this.getFrameworkLayer().removeFeatures([a])
}, addFeatures:function(a) {
  for(var b = [], c = 0;c < a.length;c++) {
    var d = a[c], e = this.toOpenLayersFeature(d);
    b.push(e);
    e.style = this.getCurrentStyleHash();
    if(d.label) {
      e.style.label = d.label
    }
  }
  return this.getFrameworkLayer().addFeatures(b)
}, drawFeature:function(a) {
  a == "Point" ? this.point.activate() : a == "LineString" ? this.line.activate() : a == "Polygon" ? this.polygon.activate() : a == "Circle" ? this.circle.activate() : this.viewerController.logger.warning("Feature type >" + a + "< not implemented!")
}, stopDrawing:function() {
  this.point.active && this.point.cancel();
  this.line.active && this.point.cancel();
  this.polygon.active && this.polygon.cancel();
  this.circle.active && this.circle.cancel()
}, activeFeatureChanged:function(a) {
  a = this.fromOpenLayersFeature(a.feature);
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_ACTIVE_FEATURE_CHANGED, this, a)
}, featureModified:function(a) {
  a = this.fromOpenLayersFeature(a.feature);
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_FEATURE_ADDED, this, a)
}, featureAdded:function(a) {
  for(var b = this.fromOpenLayersFeature(a.feature), c = 0;c < this.drawFeatureControls.length;c++) {
    this.drawFeatureControls[c].deactivate()
  }
  if(!a.feature.style) {
    a.feature.style = this.getCurrentStyleHash()
  }
  this.editFeature(a.feature);
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_FEATURE_ADDED, this, b)
}, editFeature:function(a) {
  this.modifyFeature.selectControl.unselectAll();
  this.modifyFeature.selectControl.select(a);
  a = this.fromOpenLayersFeature(a);
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_ACTIVE_FEATURE_CHANGED, this, a)
}, toOpenLayersFeature:function(a) {
  var b = OpenLayers.Geometry.fromWKT(a.wktgeom), c = this.frameworkLayer.styleMap.styles["default"];
  c.label = a.label;
  return new OpenLayers.Feature.Vector(b, {id:a.id}, {style:c})
}, fromOpenLayersFeature:function(a) {
  var b = new viewer.viewercontroller.controller.Feature({id:a.id, wktgeom:a.geometry.toString()});
  if(a.style) {
    b.label = a.style.label
  }
  return b
}, setLabel:function(a, b) {
  var c = this.getFrameworkLayer().getFeatureById(a);
  if(c) {
    c.style.label = b, this.reload()
  }
}, setVisible:function(a) {
  this.mixins.openLayersLayer.setVisible.call(this, a)
}, getVisible:function() {
  return this.mixins.openLayersLayer.getVisible.call(this)
}, setAlpha:function(a) {
  this.mixins.openLayersLayer.setAlpha.call(this, a)
}, reload:function() {
  this.mixins.openLayersLayer.reload.call(this)
}, addListener:function(a, b, c) {
  this.mixins.openLayersLayer.addListener.call(this, a, b, c)
}, removeListener:function(a, b, c) {
  this.mixins.openLayersLayer.removeListener.call(this, a, b, c)
}, getType:function() {
  return this.mixins.openLayersLayer.getType.call(this)
}, destroy:function() {
  this.mixins.openLayersLayer.destroy.call(this)
}});
// Input 6
Ext.define("viewer.viewercontroller.openlayers.OpenLayersImageLayer", {extend:"viewer.viewercontroller.controller.ImageLayer", mixins:{openLayersLayer:"viewer.viewercontroller.openlayers.OpenLayersLayer"}, constructor:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersImageLayer.superclass.constructor.call(this, a);
  this.mixins.openLayersLayer.constructor.call(this, a);
  this.utils = Ext.create("viewer.viewercontroller.openlayers.Utils");
  this.type = viewer.viewercontroller.controller.Layer.IMAGE_TYPE;
  var a = this.viewerController.mapComponent.getMap().getWidth(), b = this.viewerController.mapComponent.getMap().getHeight();
  if(this.options == null) {
    this.options = {}
  }
  if(this.options.maxExtent == void 0) {
    this.options.displayOutsideMaxExtent = true, this.options.alwaysInRange = true
  }
  this.options.visibility = this.visible;
  this.frameworkLayer = new OpenLayers.Layer.Image(this.name, this.url, this.utils.createBounds(this.extent), new OpenLayers.Size(a, b), this.options)
}, setExtent:function(a) {
  this.extent = a;
  if(this.frameworkLayer) {
    this.frameworkLayer.extent = this.utils.createBounds(a)
  }
}, setUrl:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersImageLayer.superclass.setUrl.call(this, a);
  this.frameworkLayer && this.frameworkLayer.setUrl(a)
}, getLastMapRequest:function() {
  return[{url:this.url, extent:this.extent}]
}, getType:function() {
  return this.mixins.openLayersLayer.getType.call(this)
}, setVisible:function(a) {
  this.mixins.openLayersLayer.setVisible.call(this, a)
}, getVisible:function() {
  return this.mixins.openLayersLayer.getVisible.call(this)
}, setAlpha:function(a) {
  this.mixins.openLayersLayer.setAlpha.call(this, a)
}, reload:function() {
  this.mixins.openLayersLayer.reload.call(this)
}, addListener:function(a, b, c) {
  this.mixins.openLayersLayer.addListener.call(this, a, b, c)
}, removeListener:function(a, b, c) {
  this.mixins.openLayersLayer.removeListener.call(this, a, b, c)
}, destroy:function() {
  this.mixins.openLayersLayer.destroy.call(this)
}});
// Input 7
Ext.define("viewer.viewercontroller.openlayers.OpenLayersTilingLayer", {extend:"viewer.viewercontroller.controller.TilingLayer", mixins:{openLayersLayer:"viewer.viewercontroller.openlayers.OpenLayersLayer"}, utils:null, constructor:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersTilingLayer.superclass.constructor.call(this, a);
  if(!Ext.Array.contains(["TMS", "ArcGisRest"], this.getProtocol())) {
    throw Error("OpenLayersTilingLayer currently does not support tiling protocol " + this.getProtocol());
  }
  this.mixins.openLayersLayer.constructor.call(this, a);
  this.type = viewer.viewercontroller.controller.Layer.TILING_TYPE;
  this.utils = Ext.create("viewer.viewercontroller.openlayers.Utils");
  var b = this.serviceEnvelope.split(","), a = {tileOrigin:new OpenLayers.LonLat(Number(b[0]), Number(b[1])), serverResolutions:this.resolutions, tileSize:new OpenLayers.Size(this.getTileWidth(), this.getTileHeight()), type:this.extension, transitionEffect:"resize", maxExtent:new OpenLayers.Bounds(Number(b[0]), Number(b[1]), Number(b[2]), Number(b[3])), maxResolution:this.resolutions[0], visibility:this.visible == void 0 ? true : this.visible, opacity:this.config.opacity != void 0 ? this.config.opacity : 
  1};
  if(this.getProtocol() == "TMS") {
    var c = b = null;
    if(this.url.lastIndexOf("/") == this.url.length - 1) {
      this.url = this.url.substring(0, this.url.length - 1)
    }
    var d = this.url.split("/"), c = d[d.length - 1], b = d[d.length - 2];
    d.splice(d.length - 2, 2);
    this.url = d.join("/") + "/";
    a.serviceVersion = b;
    a.layername = c;
    this.frameworkLayer = new OpenLayers.Layer.TMS(c, this.url, a)
  }else {
    if(this.getProtocol() == "ArcGisRest") {
      a = {opacity:a.opacity}, a.layerInfo = {spatialReference:{wkid:28992}, tileInfo:{height:this.getTileHeight(), width:this.getTileWidth(), origin:{x:Number(b[0]), y:Number(b[3])}, lods:Ext.Array.map(this.resolutions, function(a) {
        return{resolution:a}
      })}, fullExtent:{xmin:Number(b[0]), ymin:Number(b[1]), xmax:Number(b[2]), ymax:Number(b[3])}}, this.frameworkLayer = new OpenLayers.Layer.ArcGISCache(this.name, this.url, a)
    }
  }
}, setUrl:function(a) {
  this.url = a
}, getLayers:function() {
  return this.frameworkLayer.options.layername
}, getLegendGraphic:function() {
  return null
}, getLastMapRequest:function() {
  for(var a = [], b = this.getFrameworkLayer().grid, c = 0;c < b.length;c++) {
    for(var d = 0;d < b[c].length;d++) {
      var e = b[c][d], f = e.url;
      a.push({extent:this.utils.createExtent(e.bounds), url:f})
    }
  }
  return a
}, setVisible:function(a) {
  this.mixins.openLayersLayer.setVisible.call(this, a)
}, getVisible:function() {
  return this.mixins.openLayersLayer.getVisible.call(this)
}, setAlpha:function(a) {
  this.mixins.openLayersLayer.setAlpha.call(this, a)
}, reload:function() {
  this.mixins.openLayersLayer.reload.call(this)
}, addListener:function(a, b, c) {
  this.mixins.openLayersLayer.addListener.call(this, a, b, c)
}, removeListener:function(a, b, c) {
  this.mixins.openLayersLayer.removeListener.call(this, a, b, c)
}, getType:function() {
  return this.mixins.openLayersLayer.getType.call(this)
}, destroy:function() {
  this.mixins.openLayersLayer.destroy.call(this)
}});
// Input 8
Ext.define("viewer.viewercontroller.openlayers.OpenLayersTool", {extend:"viewer.viewercontroller.controller.Tool", controls:null, enabledEvents:null, constructor:function(a, b) {
  viewer.viewercontroller.openlayers.OpenLayersTool.superclass.constructor.call(this, a);
  this.frameworkObject = b;
  this.controls = [];
  this.enabledEvents = {};
  this.overwriteStyle();
  if(this.type == viewer.viewercontroller.controller.Tool.BUTTON) {
    var c = this;
    b.trigger = function() {
      c.fire(viewer.viewercontroller.controller.Event.ON_EVENT_DOWN)
    }
  }
  return this
}, overwriteStyle:function() {
  if(this.iconUrl_up != null || this.iconUrl_sel != null) {
    var a = document.createElement("style");
    a.type = "text/css";
    var b = "";
    this.iconUrl_up != null && (b += ".olControlPanel ." + this.frameworkObject.displayClass + "ItemInactive", b += '{ background-image: url("' + this.iconUrl_up + '")}');
    this.iconUrl_sel != null && (b += ".olControlPanel ." + this.frameworkObject.displayClass + "ItemActive", b += '{ background-image: url("' + this.iconUrl_sel + '")}');
    a.innerHTML = b;
    document.getElementsByTagName("head")[0].appendChild(a)
  }
}, setVisible:function(a) {
  this.visible = a;
  if(this.getFrameworkTool()) {
    a ? this.getFrameworkTool().panel_div.style.display = "block" : this.getFrameworkTool().panel_div.style.display = "none"
  }
}, isActive:function() {
  return this.getFrameworkTool().active
}, activate:function() {
  this.getFrameworkTool().activate()
}, deactivate:function() {
  this.getFrameworkTool().deactivate()
}, addListener:function(a, b, c) {
  var d = this.viewerController.mapComponent.getSpecificEventName(a);
  d && (c || (c = this), this.enabledEvents[d] ? this.enabledEvents[d]++ : (this.enabledEvents[d] = 1, this.frameworkObject.events.register(d, this, this.handleEvent)));
  viewer.viewercontroller.openlayers.OpenLayersTool.superclass.addListener.call(this, a, b, c)
}, removeListener:function(a, b, c) {
  var d = this.viewerController.mapComponent.getSpecificEventName(a);
  d && (c || (c = this), this.enabledEvents[d] && (this.enabledEvents[d]--, this.enabledEvents[d] <= 0 && (this.enabledEvents[d] = 0, this.frameworkObject.events.unregister(d, this, this.handleEvent))));
  viewer.viewercontroller.openlayers.OpenLayersTool.superclass.removeListener.call(this, a, b, c)
}, handleEvent:function(a) {
  var b = this.viewerController.mapComponent.getGenericEventName(a.type);
  b || (b = a);
  this.fire(b, {})
}});
// Input 9
Ext.define("viewer.viewercontroller.openlayers.OpenLayersMap", {extend:"viewer.viewercontroller.controller.Map", layersLoading:null, utils:null, constructor:function(a) {
  viewer.viewercontroller.openlayers.OpenLayersMap.superclass.constructor.call(this, a);
  this.initConfig(a);
  this.utils = Ext.create("viewer.viewercontroller.openlayers.Utils");
  var b = null;
  a.options.maxExtent && (b = this.utils.createBounds(a.options.maxExtent));
  var c;
  a.options.startExtent && (c = this.utils.createBounds(a.options.startExtent));
  c ? a.center = c.getCenterLonLat() : b ? a.center = b.getCenterLonLat() : this.viewerController.logger.error("No bounds found, can't center viewport");
  a.restrictedExtent = b;
  var d = this, b = new OpenLayers.Control.Click({handlerOptions:{single:true, "double":false}, autoActivate:true, click:function(a) {
    var b = this.map.getLonLatFromPixel(a.xy);
    d.fire(viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO, {x:a.xy.x, y:a.xy.y, coord:{x:b.lon, y:b.lat}})
  }});
  a.controls = [new OpenLayers.Control.Attribution, new OpenLayers.Control.MouseWheelZoom({autoActivate:true}), b, new OpenLayers.Control.Navigation];
  this.frameworkMap = new OpenLayers.Map(a.domId, a);
  this.frameworkMap.centerLayerContainer();
  if(a.options.startExtent) {
    var d = this, e = function() {
      d.zoomToExtent(a.options.startExtent);
      d.removeListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, e, e)
    };
    this.addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, e, e)
  }
  this.layersLoading = 0;
  this.defaultIcon = this.markerLayer = null;
  this.markers = {};
  this.getFeatureInfoControl = null;
  this.addListener(viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED, this.layerRemoved, this);
  return this
}, getAllWMSLayers:function() {
  for(var a = [], b = 0;b < this.layers.length;b++) {
    this.layers[b] instanceof OpenLayersWMSLayer && a.push(this.layers[b])
  }
  return a
}, getAllVectorLayers:function() {
  for(var a = [], b = 0;b < this.layers.length;b++) {
    this.layers[b] instanceof OpenLayersVectorLayer && a.push(this.layers[b])
  }
  return a
}, remove:function() {
  this.getFrameworkMap().destroy()
}, addLayer:function(a) {
  this.superclass.addLayer.call(this, a);
  this.getFrameworkMap().addLayer(a.getFrameworkLayer())
}, removeLayer:function(a) {
  this.getFrameworkMap().removeLayer(a.getFrameworkLayer())
}, layerRemoved:function(a, b) {
  for(var c = b.layer.getFrameworkLayer(), d = 0;d < this.layers.length;d++) {
    if(this.layers[d].getFrameworkLayer().id == c.id) {
      this.layers.splice(d, 1);
      break
    }
  }
}, setLayerVisible:function(a, b) {
  this.superclass.setLayerVisible.call(this, a, b);
  a.setVisible(b)
}, setLayerIndex:function(a, b) {
  if(!(a instanceof OpenLayersLayer)) {
    throw"OpenLayersMap.setLayerIndex(): Given layer not of type OpenLayersLayer.";
  }
  this.getFrameworkMap().setLayerIndex(a.getFrameworkLayer(), b);
  return Map.prototype.setLayerIndex(a, b)
}, setGetFeatureInfoControl:function(a) {
  if(a.type != Tool.GET_FEATURE_INFO) {
    throw"Type of given control not of type GET_FEATURE_INFO, but: " + a.type;
  }
  this.getFeatureInfoControl = a
}, zoomToMaxExtent:function() {
  this.getFrameworkMap().zoomToExtent(this.getFrameworkMap().getMaxExtent())
}, zoomToExtent:function(a) {
  a = this.utils.createBounds(a);
  this.getFrameworkMap().zoomToExtent(a)
}, zoomToScale:function(a) {
  this.getFrameworkMap().zoomToResolution(a)
}, zoomToResolution:function(a) {
  this.getFrameworkMap().zoomTo(this.getFrameworkMap().getZoomForResolution(a))
}, moveTo:function(a, b) {
  this.getFrameworkMap().panTo(new OpenLayers.LonLat(a, b))
}, setMaxExtent:function(a) {
  this.getFrameworkMap() != null && this.getFrameworkMap().setOptions({maxExtent:Utils.createBounds(a)})
}, getMaxExtent:function() {
  return Utils.createExtent(this.getFrameworkMap().getMaxExtent())
}, getExtent:function() {
  return this.utils.createExtent(this.getFrameworkMap().getExtent())
}, setMarker:function(a, b, c) {
  if(this.markerLayer == null) {
    this.markerLayer = new OpenLayers.Layer.Markers("Markers");
    this.frameworkMap.addLayer(this.markerLayer);
    var d = new OpenLayers.Size(17, 17), e = new OpenLayers.Pixel(-(d.w / 2), -d.h);
    this.defaultIcon = new OpenLayers.Icon(contextPath + "/viewer-html/common/openlayers/img/marker.png", d, e)
  }
  d = this.defaultIcon.clone();
  this.markers[a] == void 0 ? (this.markers[a] = new OpenLayers.Marker(new OpenLayers.LonLat(b, c), d), this.markerLayer.addMarker(this.markers[a])) : this.markers[a].moveTo(this.frameworkMap.getLayerPxFromLonLat(new OpenLayers.LonLat(b, c)))
}, removeMarker:function(a) {
  this.markers[a] && this.markerLayer != null && (this.markerLayer.removeMarker(this.markers[a]), this.markers[a].destroy(), delete this.markers[a])
}, addListener:function(a, b, c) {
  var d = this.viewerController.mapComponent.getSpecificEventName(a);
  d && (c || (c = this), this.enabledEvents[d] ? this.enabledEvents[d]++ : (this.enabledEvents[d] = 1, this.frameworkMap.events.register(d, this, this.handleEvent)));
  viewer.viewercontroller.openlayers.OpenLayersMap.superclass.addListener.call(this, a, b, c)
}, removeListener:function(a, b, c) {
  var d = this.viewerController.mapComponent.getSpecificEventName(a);
  d ? (c || (c = this), this.enabledEvents[d] && (this.enabledEvents[d]--, this.enabledEvents[d] <= 0 && (this.enabledEvents[d] = 0, this.frameworkMap.events.unregister(d, this, this.handleEvent))), viewer.viewercontroller.openlayers.OpenLayersMap.superclass.removeListener.call(this, a, b, c)) : this.viewerController.logger.warning("Event not listed in OpenLayersMapComponent >" + a + "<. The application  might not work correctly.")
}, handleEvent:function(a) {
  var b = {}, c = this.viewerController.mapComponent.getGenericEventName(a.type);
  if(c == viewer.viewercontroller.controller.Event.ON_LAYER_ADDED) {
    if(b.layer = this.getLayerByOpenLayersId(a.layer.id), b.layer == void 0) {
      return
    }
  }else {
    if(c == viewer.viewercontroller.controller.Event.ON_LAYER_VISIBILITY_CHANGED) {
      b.layer = this.getLayerByOpenLayersId(a.layer.id);
      if(b.layer == void 0) {
        return
      }
      b.visible = a.layer.visibility
    }else {
      if(c == viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED) {
        if(b.layer = this.getLayerByOpenLayersId(a.layer.id), b.layer == void 0) {
          return
        }
      }else {
        c == viewer.viewercontroller.controller.Event.ON_FINISHED_CHANGE_EXTENT || c == viewer.viewercontroller.controller.Event.ON_CHANGE_EXTENT ? b.extent = this.getExtent() : this.viewerController.logger.error("The event " + c + " is not implemented in the OpenLayersMap.handleEvent()")
      }
    }
  }
  this.fireEvent(c, this, b)
}, getScale:function() {
  return this.getResolution()
}, getResolution:function() {
  return this.getFrameworkMap().getResolution()
}, coordinateToPixel:function(a, b) {
  return this.getFrameworkMap().getPixelFromLonLat(new OpenLayers.LonLat(a, b))
}, getCenter:function() {
  var a = this.getFrameworkMap().getCenter();
  a.x = a.lon;
  a.y = a.lat;
  return a
}, getWidth:function() {
  return this.frameworkMap.getSize().w
}, getHeight:function() {
  return this.frameworkMap.getSize().h
}, layerFinishedLoading:function() {
  this.layersLoading--;
  if(this.layersLoading == 0) {
    webMapController.handleEvent(webMapController.eventList[viewer.viewercontroller.controller.Event.ON_ALL_LAYERS_LOADING_COMPLETE])
  }else {
    if(this.layersLoading < 0) {
      this.layersLoading = 0
    }
  }
}, layerBeginLoading:function() {
  this.layersLoading++
}, getLayerByOpenLayersId:function(a) {
  for(var b = 0;b < this.layers.length;b++) {
    if(this.layers[b].frameworkLayer && this.layers[b].frameworkLayer.id == a) {
      return this.layers[b]
    }
  }
}});
// Input 10
Ext.define("viewer.viewercontroller.openlayers.Utils", {createBounds:function(a) {
  return new OpenLayers.Bounds(a.minx, a.miny, a.maxx, a.maxy)
}, createExtent:function(a) {
  return new viewer.viewercontroller.controller.Extent(a.left, a.bottom, a.right, a.top)
}});
OpenLayers.Control.MouseWheelZoom = OpenLayers.Class(OpenLayers.Control, {button:null, initialize:function(a) {
  OpenLayers.Control.prototype.initialize.apply(this, arguments);
  this.handler = new OpenLayers.Handler.MouseWheel(this, {up:function(a, c) {
    this.wheelUp(a, c)
  }, down:function(a, c) {
    this.wheelDown(a, c)
  }})
}, wheelChange:function(a, b) {
  var c = this.map.getZoom(), d = this.map.getZoom() + Math.round(b), d = Math.max(d, 0), d = Math.min(d, this.map.getNumZoomLevels());
  if(d !== c) {
    var e = this.map.getSize(), c = e.w / 2 - a.xy.x, e = a.xy.y - e.h / 2, f = this.map.baseLayer.getResolutionForZoom(d), h = this.map.getLonLatFromPixel(a.xy);
    this.map.setCenter(new OpenLayers.LonLat(h.lon + c * f, h.lat + e * f), d)
  }
}, wheelUp:function(a, b) {
  this.wheelChange(a, b || 1)
}, wheelDown:function(a, b) {
  this.wheelChange(a, b || -1)
}});
OpenLayers.Control.LoadingPanel = OpenLayers.Class(OpenLayers.Control, {counter:0, maximized:false, visible:true, initialize:function(a) {
  OpenLayers.Control.prototype.initialize.apply(this, [a])
}, setVisible:function(a) {
  (this.visible = a) ? OpenLayers.Element.show(this.div) : OpenLayers.Element.hide(this.div)
}, getVisible:function() {
  return this.visible
}, hide:function() {
  this.setVisible(false)
}, show:function() {
  this.setVisible(true)
}, toggle:function() {
  this.setVisible(!this.getVisible())
}, addLayer:function(a) {
  a.layer && (a.layer.events.register("loadstart", this, this.increaseCounter), a.layer.events.register("loadend", this, this.decreaseCounter))
}, setMap:function(a) {
  OpenLayers.Control.prototype.setMap.apply(this, arguments);
  this.map.events.register("preaddlayer", this, this.addLayer);
  for(var b = 0;b < this.map.layers.length;b++) {
    var c = this.map.layers[b];
    c.events.register("loadstart", this, this.increaseCounter);
    c.events.register("loadend", this, this.decreaseCounter)
  }
}, increaseCounter:function() {
  this.counter++;
  this.counter > 0 && !this.maximized && this.visible && this.maximizeControl()
}, decreaseCounter:function() {
  this.counter > 0 && this.counter--;
  this.counter == 0 && this.maximized && this.visible && this.minimizeControl()
}, draw:function() {
  OpenLayers.Control.prototype.draw.apply(this, arguments);
  return this.div
}, minimizeControl:function(a) {
  this.div.style.display = "none";
  this.maximized = false;
  a != null && OpenLayers.Event.stop(a)
}, maximizeControl:function(a) {
  this.div.style.display = "block";
  this.maximized = true;
  a != null && OpenLayers.Event.stop(a)
}, destroy:function() {
  if(this.map && (this.map.events.unregister("preaddlayer", this, this.addLayer), this.map.layers)) {
    for(var a = 0;a < this.map.layers.length;a++) {
      var b = this.map.layers[a];
      b.events.unregister("loadstart", this, this.increaseCounter);
      b.events.unregister("loadend", this, this.decreaseCounter)
    }
  }
  OpenLayers.Control.prototype.destroy.apply(this, arguments)
}, CLASS_NAME:"OpenLayers.Control.LoadingPanel"});
OpenLayers.Control.Click = OpenLayers.Class(OpenLayers.Control, {defaultHandlerOptions:{single:true, "double":false, stopSingle:false, stopDouble:false}, initialize:function(a) {
  this.handlerOptions = OpenLayers.Util.extend({}, this.defaultHandlerOptions);
  Ext.apply(this.handlerOptions, a.handlerOptions);
  OpenLayers.Control.prototype.initialize.apply(this, arguments);
  if(a.click) {
    this.onClick = a.click
  }
  if(a.dblclick) {
    this.onDblclick = a.dblclick
  }
  this.handler = new OpenLayers.Handler.Click(this, {click:this.onClick, dblclick:this.onDblclick}, this.handlerOptions)
}, onClick:function() {
}, onDblclick:function() {
}});
// Input 11
Ext.define("viewer.viewercontroller.openlayers.ToolMapClick", {extend:"viewer.viewercontroller.controller.ToolMapClick", handler:null, scope:null, config:{id:null, name:null, handlerOptions:null}, constructor:function(a) {
  viewer.viewercontroller.openlayers.ToolMapClick.superclass.constructor.call(this, a);
  this.initConfig(a);
  var b = this;
  this.type = viewer.viewercontroller.controller.Tool.MAP_CLICK;
  this.initConfig(a);
  this.handler = a.handler.fn;
  this.scope = a.handler.scope;
  this.olMap = this.viewerController.mapComponent.getMap().getFrameworkMap();
  this.clickControl = new OpenLayers.Control.Click({handlerOptions:b.handlerOptions, click:function(a) {
    b.handleClick(a)
  }});
  this.olMap.addControl(this.clickControl);
  return this
}, handleClick:function(a) {
  var b = this.olMap.getLonLatFromPixel(a.xy);
  this.handler.call(this.scope, this, {x:a.xy.x, y:a.xy.y, coord:{x:b.lon, y:b.lat}})
}, activateTool:function() {
  this.clickControl.activate()
}, deactivateTool:function() {
  this.clickControl.deactivate()
}});
// Input 12
Ext.define("viewer.viewercontroller.openlayers.OpenLayersComponent", {extend:"viewer.viewercontroller.controller.Component", constructor:function(a, b) {
  viewer.viewercontroller.openlayers.OpenLayersComponent.superclass.constructor.call(this, a);
  this.frameworkObject = b;
  if(a.regionName == "content_bottom" && this.viewerController.mapComponent.contentBottom) {
    var c = document.createElement("div");
    c.id = a.id + "content_bottom";
    b.div.appendChild(c);
    b.div = c;
    a.cssClass && c.setAttribute("class", a.cssClass)
  }
}, doAfterAdd:function() {
}});
// Input 13
Ext.define("viewer.viewercontroller.OpenLayersMapComponent", {extend:"viewer.viewercontroller.MapComponent", mapOptions:null, contentTop:null, contentBottom:null, config:{theme:"flamingo"}, constructor:function(a, b, c) {
  this.domId = Ext.id();
  var d = document.createElement("div");
  d.id = this.domId;
  d.style.height = "100%";
  d.style.width = "100%";
  document.getElementById(b).appendChild(d);
  viewer.viewercontroller.OpenLayersMapComponent.superclass.constructor.call(this, a, this.domId, c);
  this.polygonButton = this.lineButton = this.pointButton = null;
  if(c && c.resolutions) {
    b = c.resolutions.split(",");
    a = [];
    for(c = 0;c < b.length;c++) {
      d = Number(b[c]), isNaN(d) || a.push(d)
    }
  }else {
    a = [512, 256, 128, 64, 32, 16, 8, 4, 2, 1, 0.5, 0.25, 0.125]
  }
  Proj4js.defs["EPSG:28992"] = "+proj=sterea +lat_0=52.15616055555555 +lon_0=5.38763888888889 +k=0.9999079 +x_0=155000 +y_0=463000 +ellps=bessel +towgs84=565.237,50.0087,465.658,-0.406857,0.350733,-1.87035,4.0812 +units=m +no_defs";
  this.mapOptions = {projection:new OpenLayers.Projection("EPSG:28992"), maxExtent:new OpenLayers.Bounds(12E4, 304E3, 28E4, 62E4), allOverlays:true, units:"m", resolutions:a, resolution:512};
  var e = this;
  this.viewerController.addListener(viewer.viewercontroller.controller.Event.ON_COMPONENTS_FINISHED_LOADING, function() {
    setTimeout(function() {
      e.checkTools()
    }, 10)
  }, this);
  return this
}, checkTools:function() {
  if(this.getTools().length == 0) {
    var a = new viewer.viewercontroller.openlayers.tools.OpenLayersDefaultTool({viewerController:this.viewerController, id:"defaultTool"});
    this.addTool(a);
    a.setVisible(false);
    a.activate()
  }
}, initEvents:function() {
  this.eventList[viewer.viewercontroller.controller.Event.ON_EVENT_DOWN] = "activate";
  this.eventList[viewer.viewercontroller.controller.Event.ON_EVENT_UP] = "deactivate";
  this.eventList[viewer.viewercontroller.controller.Event.ON_GET_CAPABILITIES] = "onGetCapabilities";
  this.eventList[viewer.viewercontroller.controller.Event.ON_CONFIG_COMPLETE] = "onConfigComplete";
  this.eventList[viewer.viewercontroller.controller.Event.ON_FEATURE_ADDED] = "featureadded";
  this.eventList[viewer.viewercontroller.controller.Event.ON_CLICK] = "click";
  this.eventList[viewer.viewercontroller.controller.Event.ON_SET_TOOL] = "activate";
  this.eventList[viewer.viewercontroller.controller.Event.ON_ALL_LAYERS_LOADING_COMPLETE] = "onUpdateComplete";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LOADING_START] = "loadstart";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LOADING_END] = "loadend";
  this.eventList[viewer.viewercontroller.controller.Event.ON_MEASURE] = "measure";
  this.eventList[viewer.viewercontroller.controller.Event.ON_FINISHED_CHANGE_EXTENT] = "moveend";
  this.eventList[viewer.viewercontroller.controller.Event.ON_CHANGE_EXTENT] = "move";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED] = "removelayer";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LAYER_ADDED] = "addlayer";
  this.eventList[viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO] = "getfeatureinfo";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LAYER_VISIBILITY_CHANGED] = "changelayer";
  this.eventList[viewer.viewercontroller.controller.Event.ON_ACTIVATE] = "activate";
  this.eventList[viewer.viewercontroller.controller.Event.ON_DEACTIVATE] = "deactivate"
}, getPanel:function() {
  this.panel == null && this.createPanel();
  return this.panel
}, createPanel:function() {
  this.panel = new OpenLayers.Control.Panel({saveState:true, div:this.contentTop});
  this.maps[0].getFrameworkMap().addControl(this.panel)
}, createMap:function(a, b) {
  b = Ext.merge(this.mapOptions, b);
  b.theme = OpenLayers._getScriptLocation() + "theme/" + this.getTheme() + "/style.css";
  b.mapComponent = this;
  b.viewerController = this.viewerController;
  b.domId = this.domId;
  return Ext.create("viewer.viewercontroller.openlayers.OpenLayersMap", b)
}, createMenus:function(a, b) {
  var c = document.getElementById(this.domId);
  c.style.position = "absolute";
  var d = Ext.get(this.getMap().frameworkMap.viewPortDiv.id), e = d.getHeight();
  d.dom.style.position = "absolute";
  var f;
  if(a.indexOf("%") == -1) {
    e -= a, f = a
  }else {
    var h = a.substring(0, a.indexOf("%")), g = e / 100 * h;
    e -= g;
    f = g
  }
  c.style.top = f + "px";
  b.indexOf("%") == -1 ? (h = b, e -= b) : (h = b.substring(0, b.indexOf("%")), h = g = e / 100 * h, e -= g);
  c.style.height = e + "px";
  this.contentTop = document.createElement("div");
  this.contentTop.id = "content_top";
  var g = this.contentTop.style, i = this.viewerController.getLayout("top_menu");
  if(i.height) {
    g.background = i.bgcolor, g.height = i.height + i.heightmeasure
  }
  d.dom.style.zIndex = 100;
  g.zIndex = d.dom.style.zIndex + 1;
  this.contentTop.setAttribute("class", "olControlPanel");
  c.parentNode.insertBefore(this.contentTop, c);
  if(h && parseInt(h) > 0) {
    this.contentBottom = document.createElement("div"), this.contentBottom.id = "content_bottom", d = this.contentBottom.style, g = this.viewerController.getLayout("content_bottom"), d.height = h + "px", d.background = g.bgcolor, d.top = e + parseInt(f) + "px", d.position = "relative", c.parentNode.appendChild(this.contentBottom)
  }
}, doResize:function() {
  var a = Ext.get(document.getElementById(this.domId).parentNode).getHeight(), b = Ext.get(this.contentTop);
  if(this.contentBottom !== null) {
    var c = Ext.get(this.contentBottom);
    c.setTop(a - c.getHeight() + "px")
  }
  Ext.get(this.domId).setHeight(a - b.getHeight() - c.getHeight() + "px")
}, createWMSLayer:function(a, b, c, d) {
  d.options = {};
  d.options.id = null;
  d.options.isBaseLayer = true;
  d.options.transitionEffect = "resize";
  d.options.events = {};
  d.options.visibility = c.visible;
  d.options.name = a;
  d.options.url = b;
  for(var e in c) {
    d.options[e] = c[e]
  }
  d.ogcParams = c;
  d.viewerController = this.viewerController;
  d.options.url = b;
  if(d.alpha != void 0) {
    d.options.opacity = d.alpha / 100
  }
  a = Ext.create("viewer.viewercontroller.openlayers.OpenLayersWMSLayer", d);
  if(c.query_layers != null && c.query_layers != "") {
    c = new OpenLayers.Control.WMSGetFeatureInfo({url:b, title:"Identify features by clicking", queryVisible:true, layers:[a.getFrameworkLayer()], queryLayers:c.query_layers, infoFormat:"text/xml"}), c.request = doGetFeatureRequest, a.setGetFeatureInfoControl(c)
  }
  if(d.maptip_layers != null && d.maptip_layers != "") {
    b = new OpenLayers.Control.WMSGetFeatureInfo({url:b, title:"Identify features by clicking", queryVisible:true, layers:[a.getFrameworkLayer()], queryLayers:d.maptip_layers, infoFormat:"application/vnd.ogc.gml", hover:true}), b.request = doGetFeatureRequest, a.setMapTipControl(b)
  }
  return a
}, createTilingLayer:function(a, b, c) {
  c.name = a;
  c.url = b;
  c.viewerController = this.viewerController;
  if(c.alpha != void 0) {
    c.opacity = c.alpha / 100
  }
  return new viewer.viewercontroller.openlayers.OpenLayersTilingLayer(c)
}, createArcIMSLayer:function(a, b, c) {
  c.name = a;
  c.url = Ext.urlAppend(actionBeans.proxy, Ext.Object.toQueryString({url:b, mode:"arcims"}));
  if(c.alpha != void 0) {
    c.opacity = c.alpha / 100
  }
  c.serviceName = c.mapservice;
  c.viewerController = this.viewerController;
  return Ext.create("viewer.viewercontroller.openlayers.OpenLayersArcIMSLayer", c)
}, createArcServerLayer:function(a, b, c, d) {
  c.name = a;
  c.url = b;
  c.viewerController = d;
  if(c.alpha != void 0) {
    c.opacity = c.alpha / 100
  }
  return Ext.create("viewer.viewercontroller.openlayers.OpenLayersArcServerLayer", c)
}, createImageLayer:function(a, b, c) {
  return Ext.create("viewer.viewercontroller.openlayers.OpenLayersImageLayer", {id:a, url:b, extent:c, frameworkLayer:this.viewerObject, viewerController:this.viewerController})
}, createVectorLayer:function(a) {
  a == void 0 ? a = {isBaseLayer:false} : a.isBaseLayer == void 0 && (a.isBaseLayer = false);
  return Ext.create("viewer.viewercontroller.openlayers.OpenLayersVectorLayer", a)
}, createComponent:function(a) {
  var b = a.type, c = null;
  if(b == viewer.viewercontroller.controller.Component.LOADMONITOR) {
    c = Ext.create("viewer.viewercontroller.openlayers.components.OpenLayersLoadMonitor", a)
  }else {
    if(b == viewer.viewercontroller.controller.Component.OVERVIEW) {
      c = Ext.create("viewer.viewercontroller.openlayers.components.OpenLayersOverview", a)
    }else {
      if(b == viewer.viewercontroller.controller.Component.MAPTIP) {
        c = Ext.create("viewer.viewercontroller.openlayers.components.OpenLayersMaptip", a, this.getMap())
      }else {
        if(b == viewer.viewercontroller.controller.Component.NAVIGATIONPANEL) {
          b = Ext.fly(this.contentTop).getHeight(), c = Ext.create("viewer.viewercontroller.openlayers.OpenLayersComponent", a, new OpenLayers.Control.PanZoomBar({position:new OpenLayers.Pixel(6, b > 40 ? 4 : (40 - b) / 2 + 2), zoomWorldIcon:true}))
        }else {
          if(b == viewer.viewercontroller.controller.Component.BORDER_NAVIGATION) {
            c = Ext.create("viewer.viewercontroller.openlayers.components.OpenLayersBorderNavigation", a)
          }else {
            if(b == viewer.viewercontroller.controller.Component.COORDINATES) {
              b = {numDigits:a.decimals};
              if(this.contentBottom) {
                b.div = this.contentBottom, a.cssClass = "olControlMousePosition"
              }
              c = Ext.create("viewer.viewercontroller.openlayers.OpenLayersComponent", a, new OpenLayers.Control.MousePosition(b))
            }else {
              if(b == viewer.viewercontroller.controller.Component.SCALEBAR) {
                b = {bottomOutUnits:"", bottomInUnits:""};
                if(!Ext.isEmpty(a.units)) {
                  b.topOutUnits = a.units
                }
                if(this.contentBottom) {
                  b.div = this.contentBottom, a.cssClass = "olControlScale"
                }
                c = Ext.create("viewer.viewercontroller.openlayers.OpenLayersComponent", a, new OpenLayers.Control.ScaleLine(b))
              }else {
                this.viewerController.logger.warning("Framework specific component with type " + b + " not yet implemented!")
              }
            }
          }
        }
      }
    }
  }
  return c
}, createTool:function(a) {
  var b = a.type;
  a.viewerController = this.viewerController;
  var c = {};
  if(a.tooltip) {
    c.title = a.tooltip
  }
  if(b == viewer.viewercontroller.controller.Tool.NAVIGATION_HISTORY) {
    return new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.NavigationHistory(options))
  }else {
    if(b == viewer.viewercontroller.controller.Tool.ZOOMIN_BOX) {
      return new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.ZoomBox(c))
    }else {
      if(b == viewer.viewercontroller.controller.Tool.ZOOMOUT_BOX) {
        return new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.ZoomOut(c))
      }else {
        if(b == viewer.viewercontroller.controller.Tool.PAN) {
          return new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.DragPan(c))
        }else {
          if(b == viewer.viewercontroller.controller.Tool.SUPERPAN) {
            return c.enableKinetic = true, new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.DragPan(c))
          }else {
            if(b == viewer.viewercontroller.controller.Tool.GET_FEATURE_INFO) {
              return new viewer.viewercontroller.openlayers.tools.OpenLayersIdentifyTool(a)
            }else {
              if(b == viewer.viewercontroller.controller.Tool.MEASURE) {
                return c.persist = true, c.callbacks = {modify:function(a) {
                  if(a.parent) {
                    var b = document.getElementById("olControlMeasureValue");
                    if(b == void 0) {
                      b = document.createElement("div");
                      b.id = "olControlMeasureValue";
                      b.style.position = "absolute";
                      this.map.div.appendChild(b);
                      b.style.zIndex = "10000";
                      b.className = "olControlMaptip";
                      var c = document.createElement("div");
                      c.id = "olControlMeasureValueText";
                      b.appendChild(c)
                    }
                    c = this.map.getViewPortPxFromLonLat(new OpenLayers.LonLat(a.x, a.y));
                    b.style.top = c.y + "px";
                    b.style.left = c.x + 10 + "px";
                    b.style.display = "block";
                    c = document.getElementById("olControlMeasureValueText");
                    a = this.getBestLength(a.parent);
                    c.innerHTML = a[0].toFixed(3) + " " + a[1]
                  }
                }}, a = new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.Measure(OpenLayers.Handler.Path, c)), a.getFrameworkTool().events.register("measure", a.getFrameworkTool(), function() {
                  var a = document.getElementById("olControlMeasureValue");
                  if(a) {
                    a.style.display = "none"
                  }
                  this.cancel()
                }), a.getFrameworkTool().events.register("deactivate", a.getFrameworkTool(), function() {
                  var a = document.getElementById("olControlMeasureValue");
                  if(a) {
                    a.style.display = "none"
                  }
                }), a
              }else {
                if(b == viewer.viewercontroller.controller.Tool.ZOOM_BAR) {
                  return new OpenLayersTool(a, new OpenLayers.Control.PanZoomBar(c))
                }else {
                  if(b == viewer.viewercontroller.controller.Tool.DEFAULT) {
                    return new viewer.viewercontroller.openlayers.tools.OpenLayersDefaultTool(a)
                  }else {
                    if(b == viewer.viewercontroller.controller.Tool.PREVIOUS_EXTENT || b == viewer.viewercontroller.controller.Tool.NEXT_EXTENT) {
                      var c = {}, d;
                      for(d in this.viewerController.app.components) {
                        if(b = this.viewerController.app.components[d], b.className == "viewer.components.tools.NextExtent") {
                          c.nextOptions = {title:b.config.tooltip}
                        }else {
                          if(b.className == "viewer.components.tools.PreviousExtent") {
                            c.previousOptions = {title:b.config.tooltip}
                          }
                        }
                      }
                      return new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.NavigationHistory(c))
                    }else {
                      if(b == viewer.viewercontroller.controller.Tool.FULL_EXTENT) {
                        return new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control.ZoomToMaxExtent(c))
                      }else {
                        if(b == viewer.viewercontroller.controller.Tool.MAP_CLICK) {
                          return Ext.create("viewer.viewercontroller.openlayers.ToolMapClick", a)
                        }else {
                          if(a.type == viewer.viewercontroller.controller.Tool.TOGGLE) {
                            return c.type = OpenLayers.Control.TYPE_TOGGLE, c.displayClass = "olToggle_" + a.id, new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control(c))
                          }else {
                            if(a.type == viewer.viewercontroller.controller.Tool.MAP_TOOL) {
                              return c.type = OpenLayers.Control.TYPE_TOOL, c.displayClass = "olTool_" + a.id, new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control(c))
                            }else {
                              if(a.type == viewer.viewercontroller.controller.Tool.BUTTON) {
                                return c.type = OpenLayers.Control.TYPE_BUTTON, c.displayClass = "olButton_" + a.id, new viewer.viewercontroller.openlayers.OpenLayersTool(a, new OpenLayers.Control(c))
                              }else {
                                this.viewerController.logger.warning("Tool Type >" + b + "< not recognized. Please use existing type.")
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
}, activateGetFeatureControls:function() {
  for(var a = this.getMap().getAllWMSLayers(), b = 0;b < a.length;b++) {
    var c = a[b].getGetFeatureInfoControl();
    c != null && c.activate()
  }
}, deactivateGetFeatureControls:function() {
  for(var a = this.getMap().getAllWMSLayers(), b = 0;b < a.length;b++) {
    var c = a[b].getGetFeatureInfoControl();
    c != null && c.deactivate()
  }
}, addTool:function(a) {
  this.maps.length == 0 && Ext.Error.raise({msg:"No map in MapComponent!"});
  if(a instanceof Array) {
    for(var b = 0;b < a.length;b++) {
      this.getMap().getFrameworkMap().addControl(a[b].getFrameworkTool()), this.addTool(a[b]), MapComponent.prototype.addTool.call(this, a[b])
    }
  }else {
    if(a.getType() == viewer.viewercontroller.controller.Tool.NAVIGATION_HISTORY) {
      var c = this, d = function() {
        c.maps[0].getFrameworkMap().addControl(a.getFrameworkTool());
        c.getPanel().addControls([a.getFrameworkTool().previous, a.getFrameworkTool().next]);
        c.getMap().removeListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, d, d)
      };
      this.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, d, d)
    }else {
      a.getType() == viewer.viewercontroller.controller.Tool.CLICK ? (this.maps[0].getFrameworkMap().addControl(a.getFrameworkTool()), this.getPanel().addControls([a.getFrameworkTool().button])) : a.getType() == viewer.viewercontroller.controller.Tool.GET_FEATURE_INFO ? (this.getPanel().addControls([a.getFrameworkTool()]), this.maps[0].getFrameworkMap().addControl(a.getFrameworkTool())) : a.getType() == viewer.viewercontroller.controller.Tool.ZOOM_BAR ? this.maps[0].getFrameworkMap().addControl(a.getFrameworkTool()) : 
      a.getType() == viewer.viewercontroller.controller.Tool.PREVIOUS_EXTENT ? (c = this, d = function() {
        var b = a.getFrameworkTool(), f = c.maps[0].getFrameworkMap().getControlsByClass("OpenLayers.Control.NavigationHistory");
        f.length > 0 ? b = f[0] : c.maps[0].getFrameworkMap().addControl(a.getFrameworkTool());
        c.getPanel().addControls([b.previous]);
        c.getMap().removeListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, d, d)
      }, this.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, d, d)) : a.getType() == viewer.viewercontroller.controller.Tool.NEXT_EXTENT ? (c = this, d = function() {
        var b = a.getFrameworkTool(), f = c.maps[0].getFrameworkMap().getControlsByClass("OpenLayers.Control.NavigationHistory");
        f.length > 0 ? b = f[0] : c.maps[0].getFrameworkMap().addControl(a.getFrameworkTool());
        c.getPanel().addControls([b.next]);
        c.getMap().removeListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, d, d)
      }, this.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, d, d)) : (a.getFrameworkTool(), this.getPanel().addControls([a.getFrameworkTool()]))
    }
  }
  a instanceof Array || this.superclass.addTool.call(this, a)
}, removeToolById:function(a) {
  this.removeTool(this.getTool(a))
}, removeTool:function(a) {
  a instanceof OpenLayersTool || Ext.Error.raise({msg:"The given tool is not of type 'OpenLayersTool'"});
  a.type == Tool.NAVIGATION_HISTORY ? (OpenLayers.Util.removeItem(this.getPanel().controls, a.getFrameworkTool().next), OpenLayers.Util.removeItem(this.getPanel().controls, a.getFrameworkTool().previous), a.getFrameworkTool().destroy()) : OpenLayers.Util.removeItem(this.getPanel().controls, a.getFrameworkTool());
  this.maps[0].getFrameworkMap().removeControl(a.getFrameworkTool());
  this.getPanel().controls.length == 0 ? (this.getPanel().destroy(), this.panel = null) : this.getPanel().redraw();
  MapComponent.prototype.removeTool.call(this, a)
}, addComponent:function(a) {
  Ext.isEmpty(a) ? this.viewerController.logger.warning("Empty component added to OpenLayersMapComponent. \n                Properly not yet implemented") : (this.getMap().getFrameworkMap().addControl(a.getFrameworkObject()), a.getFrameworkObject().activate(), a.doAfterAdd())
}, addMap:function(a) {
  a instanceof viewer.viewercontroller.openlayers.OpenLayersMap || Ext.Error.raise({msg:"The given map is not of the type 'OpenLayersMap'"});
  this.maps.length >= 1 && Ext.Error.raise({msg:"Multiple maps not supported yet"});
  this.maps.push(a);
  this.createMenus(this.mapOptions.options.top, this.mapOptions.options.bottom);
  a.getFrameworkMap().events.register("mousemove", this, this.removeMaptip)
}, getMap:function() {
  return this.maps[0]
}, removeMap:function(a) {
  a.remove();
  this.maps = []
}, activateTool:function(a) {
  for(var b = this.tools, c = 0;c < b.length;c++) {
    b[c].getFrameworkTool().deactivate()
  }
  this.getTool(a).getFrameworkTool().activate()
}, getWidth:function() {
  var a = this.getMap();
  return a ? a.getWidth() : null
}, getHeight:function() {
  var a = this.getMap();
  return a ? a.getHeight() : null
}});
function doGetFeatureRequest(a, b) {
  var c = this.findLayers();
  if(c.length == 0) {
    this.events.triggerEvent("nogetfeatureinfo"), OpenLayers.Element.removeClass(this.map.viewPortDiv, "olCursorWait")
  }else {
    if(b = b || {}, this.drillDown === false) {
      c = this.buildWMSOptions(this.url, c, a, c[0].params.FORMAT);
      c.params.STYLES = "";
      c.params.QUERY_LAYERS = this.queryLayers.split(",");
      var d = OpenLayers.Request.GET(c);
      if(b.hover === true) {
        this.hoverRequest = d
      }
    }else {
      this._numRequests = this._requestCount = 0;
      this.features = [];
      for(var d = {}, e, f = 0, h = c.length;f < h;f++) {
        var g = c[f];
        e = g.url instanceof Array ? g.url[0] : g.url;
        e in d ? d[e].push(g) : (this._numRequests++, d[e] = [g])
      }
      for(e in d) {
        c = d[e], c = this.buildWMSOptions(e, c, a, c[0].params.FORMAT), OpenLayers.Request.GET(c)
      }
    }
  }
}
;
// Input 14
OpenLayers.Control.LoadingPanel = OpenLayers.Class(OpenLayers.Control, {counter:0, minimizeTimeout:null, minimizeTimeoutDelay:null, maximized:false, visible:true, initialize:function(a) {
  OpenLayers.Control.prototype.initialize.apply(this, [a])
}, setVisible:function(a) {
  (this.visible = a) ? OpenLayers.Element.show(this.div) : OpenLayers.Element.hide(this.div)
}, getVisible:function() {
  return this.visible
}, hide:function() {
  this.setVisible(false)
}, show:function() {
  this.setVisible(true)
}, toggle:function() {
  this.setVisible(!this.getVisible())
}, addLayer:function(a) {
  a.layer && (a.layer.events.register("loadstart", this, this.increaseCounter), a.layer.events.register("loadend", this, this.decreaseCounter))
}, setMap:function(a) {
  OpenLayers.Control.prototype.setMap.apply(this, arguments);
  this.map.events.register("preaddlayer", this, this.addLayer);
  for(var b = 0;b < this.map.layers.length;b++) {
    var c = this.map.layers[b];
    c.events.register("loadstart", this, this.increaseCounter);
    c.events.register("loadend", this, this.decreaseCounter)
  }
}, increaseCounter:function() {
  var a = this, b = a.minimizeTimeoutDelay || 5E3;
  if(this.counter > 0) {
    this.minimizeTimeout != null && window.clearTimeout(this.minimizeTimeout), this.minimizeTimeout = window.setTimeout(function() {
      if(a.maximized) {
        for(;a.counter > 0;) {
          a.decreaseCounter()
        }
      }
    }, b)
  }
  this.counter++;
  this.counter > 0 && !this.maximized && this.visible && this.maximizeControl()
}, decreaseCounter:function() {
  this.counter > 0 && this.counter--;
  this.counter == 0 && this.maximized && this.visible && this.minimizeControl()
}, draw:function() {
  OpenLayers.Control.prototype.draw.apply(this, arguments);
  return this.div
}, minimizeControl:function(a) {
  this.div.style.display = "none";
  this.maximized = false;
  a != null && OpenLayers.Event.stop(a)
}, maximizeControl:function(a) {
  this.div.style.display = "block";
  this.maximized = true;
  a != null && OpenLayers.Event.stop(a)
}, destroy:function() {
  if(this.map && (this.map.events.unregister("preaddlayer", this, this.addLayer), this.map.layers)) {
    for(var a = 0;a < this.map.layers.length;a++) {
      var b = this.map.layers[a];
      b.events.unregister("loadstart", this, this.increaseCounter);
      b.events.unregister("loadend", this, this.decreaseCounter)
    }
  }
  OpenLayers.Control.prototype.destroy.apply(this, arguments)
}, CLASS_NAME:"OpenLayers.Control.LoadingPanel"});
// Input 15
Ext.define("viewer.viewercontroller.openlayers.components.OpenLayersBorderNavigation", {extend:"viewer.viewercontroller.openlayers.OpenLayersComponent", north:null, south:null, east:null, west:null, buttonSize:0, timer:null, constructor:function(a) {
  this.callParent(arguments);
  this.frameworkObject = new OpenLayers.Control.PanPanel;
  return this
}, doAfterAdd:function() {
  this.north = Ext.select(".olControlPanNorthItemInactive");
  this.south = Ext.select(".olControlPanSouthItemInactive");
  this.east = Ext.select(".olControlPanEastItemInactive");
  this.west = Ext.select(".olControlPanWestItemInactive");
  Ext.select(".olControlPanPanel").setStyle("left", "0px");
  Ext.select(".olControlPanPanel").setStyle("top", "0px");
  var a = this;
  Ext.EventManager.onWindowResize(function() {
    a.resizeOnceAfter(100)
  });
  this.resize()
}, resizeOnceAfter:function(a) {
  var b = this;
  this.timer && clearTimeout(this.timer);
  this.timer = setTimeout(function() {
    b.resize()
  }, a)
}, resize:function() {
  if(this.buttonSize == 0) {
    this.buttonSize = this.north.item(0).getHeight();
    var a = this;
    setTimeout(function() {
      a.resize()
    }, 50)
  }else {
    var b = Ext.select(".olMap").item(0).getHeight(), c = Ext.select(".olMap").item(0).getWidth(), d = Number((b - this.buttonSize) / 2), e = Number((c - this.buttonSize) / 2);
    this.north.setStyle("top", "0px");
    this.north.setStyle("left", e + "px");
    this.south.setStyle("top", b - this.buttonSize + "px");
    this.south.setStyle("left", e + "px");
    this.west.setStyle("top", d + "px");
    this.west.setStyle("left", "0px");
    this.east.setStyle("top", d + "px");
    this.east.setStyle("left", c - this.buttonSize + "px")
  }
}});
// Input 16
Ext.define("viewer.viewercontroller.openlayers.components.OpenLayersLoadMonitor", {extend:"viewer.viewercontroller.openlayers.OpenLayersComponent", config:{top:null, left:null, timeout:null}, constructor:function(a) {
  viewer.viewercontroller.openlayers.components.OpenLayersLoadMonitor.superclass.constructor.call(this, a);
  a = this.viewerController.mapComponent.getMap().getFrameworkMap();
  this.frameworkObject = new OpenLayers.Control.LoadingPanel({minimizeTimeoutDelay:this.timeout});
  a.addControl(this.frameworkObject);
  this.left && this.top && this.setPosition(this.top, this.left);
  return this
}, setPosition:function(a, b) {
  var c = this.frameworkObject.div;
  c.style.top = a + "px";
  c.style.left = b + "px"
}, getExtComponents:function() {
  return[]
}});
// Input 17
Ext.define("viewer.viewercontroller.openlayers.components.OpenLayersOverview", {extend:"viewer.viewercontroller.openlayers.OpenLayersComponent", config:{top:null, left:null, url:null, layers:null, position:null, height:null, width:null, lox:null, loy:null, rbx:null, rby:null}, constructor:function(a) {
  this.width = this.height = 300;
  viewer.viewercontroller.openlayers.components.OpenLayersOverview.superclass.constructor.call(this, a);
  if(Ext.isEmpty(this.url)) {
    throw Error("No URL set for Overview component, unable to load component");
  }
  var a = this.viewerController.mapComponent.getMap().frameworkMap.maxExtent, b;
  b = this.getLox() != null && this.getLoy() != null && this.getRbx() != null && this.getRby() != null && this.getLox() != this.getRbx() && this.getLoy() != this.getRby() ? new OpenLayers.Bounds(this.getLox(), this.getLoy(), this.getRbx(), this.getRby()) : a;
  var c = new OpenLayers.Size("" + this.width, "" + this.height);
  b = new OpenLayers.Layer.Image("OverviewLaag", this.url, b, c);
  this.frameworkObject = new OpenLayers.Control.OverviewMap({maximized:true, mapOptions:{maxExtent:a, projection:"EPSG:28992"}, size:c, layers:[b]});
  return this
}, getExtComponents:function() {
  return[]
}, setLox:function(a) {
  this.lox = isNaN(a) ? null : Number(a)
}, setLoy:function(a) {
  this.loy = isNaN(a) ? null : Number(a)
}, setRbx:function(a) {
  this.rbx = isNaN(a) ? null : Number(a)
}, setRby:function(a) {
  this.rby = isNaN(a) ? null : Number(a)
}, setHeight:function(a) {
  if(isNaN(a)) {
    this.height = null
  }else {
    if(!Ext.isEmpty(a) && a > 0) {
      this.height = Number(a)
    }
  }
}, setWidth:function(a) {
  if(isNaN(a)) {
    this.width = null
  }else {
    if(!Ext.isEmpty(a) && a > 0) {
      this.width = Number(a)
    }
  }
}});
// Input 18
Ext.define("viewer.viewercontroller.openlayers.components.OpenLayersMaptip", {extend:"viewer.viewercontroller.openlayers.OpenLayersComponent", map:null, constructor:function(a, b) {
  viewer.viewercontroller.openlayers.components.OpenLayersMaptip.superclass.constructor.call(this, a);
  this.map = b;
  this.frameworkObject = new OpenLayers.Control;
  var c = this;
  this.frameworkObject.handler = new OpenLayers.Handler.Hover(this.frameworkObject, {pause:function(a) {
    c.onPause(a)
  }, move:this.onMove}, {delay:a.maptipdelay, pixelTolerance:null, stopMove:false})
}, onPause:function(a) {
  var b = this.map.getFrameworkMap().getLonLatFromViewPortPx(a.xy);
  this.map.fire(viewer.viewercontroller.controller.Event.ON_MAPTIP, {x:a.xy.x, y:a.xy.y, coord:{x:b.lon, y:b.lat}})
}, setVisible:function(a) {
  a ? this.frameworkObject.activate() : this.frameworkObject.deactivate()
}});
// Input 19
Ext.define("viewer.viewercontroller.openlayers.tools.OpenLayersIdentifyTool", {extend:"viewer.viewercontroller.openlayers.OpenLayersTool", map:null, deactivatedControls:null, constructor:function(a) {
  var b = new OpenLayers.Control({displayClass:"olControlIdentify", type:OpenLayers.Control.TYPE_TOOL, title:a.tooltip});
  viewer.viewercontroller.openlayers.tools.OpenLayersIdentifyTool.superclass.constructor.call(this, a, b);
  this.map = this.viewerController.mapComponent.getMap();
  this.mapClick = new viewer.viewercontroller.openlayers.ToolMapClick({id:"mapclick_" + this.id, viewerController:this.viewerController, handler:{fn:this.handleClick, scope:this}, handlerOptions:{stopSingle:true}});
  this.getFrameworkTool().events.register("activate", this, this.activate);
  this.getFrameworkTool().events.register("deactivate", this, this.deactivate);
  return this
}, activate:function() {
  if(MobileManager.isMobile()) {
    if(this.deactivatedControls == null) {
      this.deactivatedControls = []
    }
    for(var a = this.map.getFrameworkMap().getControlsByClass("OpenLayers.Control.Navigation"), b = 0;b < a.length;b++) {
      a[b].active && (this.deactivatedControls.push(a[b]), a[b].deactivate())
    }
  }
  this.mapClick.activateTool()
}, deactivate:function() {
  if(MobileManager.isMobile()) {
    for(;!Ext.isEmpty(this.deactivatedControls);) {
      this.deactivatedControls.pop().activate()
    }
  }
  this.mapClick.deactivateTool()
}, handleClick:function(a, b) {
  this.map.fire(viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO, b)
}});
// Input 20
Ext.define("viewer.viewercontroller.openlayers.tools.OpenLayersDefaultTool", {extend:"viewer.viewercontroller.openlayers.OpenLayersTool", map:null, navigationControl:null, mapClick:null, constructor:function(a) {
  var b = new OpenLayers.Control({displayClass:"olControlDefault", type:OpenLayers.Control.TYPE_TOOL, title:a.tooltip});
  viewer.viewercontroller.openlayers.tools.OpenLayersDefaultTool.superclass.constructor.call(this, a, b);
  this.setType(viewer.viewercontroller.controller.Tool.DEFAULT);
  this.map = this.viewerController.mapComponent.getMap();
  this.navigationControl = new OpenLayers.Control.Navigation({autoActivate:false});
  this.map.getFrameworkMap().addControls([this.navigationControl]);
  this.mapClick = new viewer.viewercontroller.openlayers.ToolMapClick({id:"mapclick_" + this.id, viewerController:this.viewerController, handler:{fn:this.mapClicked, scope:this}});
  this.getFrameworkTool().events.register("activate", this, this.activate);
  this.getFrameworkTool().events.register("deactivate", this, this.deactivate);
  return this
}, mapClicked:function(a, b) {
  this.map.fire(viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO, b)
}, activate:function() {
  this.navigationControl.activate();
  this.mapClick.activateTool();
  this.getFrameworkObject().activate()
}, deactivate:function() {
  this.navigationControl.deactivate();
  this.mapClick.deactivateTool();
  this.getFrameworkObject().deactivate()
}});
