/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp;

import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Random;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.securityfilter.realm.SecurityRealmInterface;
import org.stripesstuff.stripersist.Stripersist;

public class RWBPSecurityRealm
implements SecurityRealmInterface {
    private static final Log auditLog = LogFactory.getLog((String)"audit");
    private static final String ROLE_GEMEENTE = "gemeente";
    private static final String ROLE_REGIO = "regio";
    private static final String ROLE_PROVINCIE = "provincie";
    private static final String ROLE_BEHEERDER = "beheerder";
    private static final String ROLE_RIJK = "rijk";
    private static final int SALT_SIZE = 4;

    public static String generateHexSalt(HttpServletRequest request) {
        long seed = System.currentTimeMillis();
        long ip = 1L;
        try {
            InetAddress addr = InetAddress.getByName(request.getRemoteAddr());
            if (addr instanceof Inet4Address) {
                byte[] raw = ((Inet4Address)addr).getAddress();
                ip = raw[0] << 24 | raw[1] << 16 | raw[2] << 8 | raw[3];
            }
        }
        catch (UnknownHostException addr) {
            // empty catch block
        }
        seed *= ip;
        if (request.getRemotePort() != 0) {
            seed *= (long)request.getRemotePort();
        }
        Random random = new Random(seed);
        StringBuffer salt = new StringBuffer(8);
        for (int i = 0; i < 4; ++i) {
            int b = random.nextInt(16);
            salt.append(Integer.toHexString(b));
            b = random.nextInt(16);
            salt.append(Integer.toHexString(b));
        }
        return salt.toString();
    }

    public static String getHexSha1(String saltHex, String phrase) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if ((saltHex = saltHex.trim()).length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid salt hex length (must be divisible by 2): " + saltHex.length());
        }
        byte[] salt = new byte[saltHex.length() / 2];
        try {
            for (int i = 0; i < saltHex.length() / 2; ++i) {
                int hexIdx = i * 2;
                int highNibble = Integer.parseInt(saltHex.substring(hexIdx, hexIdx + 1), 16);
                int lowNibble = Integer.parseInt(saltHex.substring(hexIdx + 1, hexIdx + 2), 16);
                salt[i] = (byte)(highNibble << 4 | lowNibble);
            }
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid hex characters in salt parameter: " + saltHex);
        }
        return RWBPSecurityRealm.getHexSha1(salt, phrase);
    }

    public static String getHexSha1(byte[] salt, String phrase) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] phraseUTF8 = phrase.getBytes("UTF8");
        byte[] saltedPhrase = new byte[salt.length + phraseUTF8.length];
        System.arraycopy(salt, 0, saltedPhrase, 0, salt.length);
        System.arraycopy(phraseUTF8, 0, saltedPhrase, salt.length, phraseUTF8.length);
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] digest = md.digest(saltedPhrase);
        StringBuffer sb = new StringBuffer(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            sb.append(Integer.toHexString(digest[i] >> 4 & 0xF));
            sb.append(Integer.toHexString(digest[i] & 0xF));
        }
        return sb.toString();
    }

    public Principal authenticate(String username, String password) {
        String auditAllow = "LOGIN ALLOW: username=\"" + username + "\": ";
        String auditDeny = "LOGIN DENY:  username=\"" + username + "\": ";
        Stripersist.requestInit();
        EntityManager em = Stripersist.getEntityManager();
        try {
            Gebruiker g = (Gebruiker)em.createQuery("from Gebruiker g where lower(g.username) = lower(:username) ").setParameter("username", (Object)username).getSingleResult();
            String hash = RWBPSecurityRealm.getHexSha1(g.getPasswordsalt(), password);
            if (hash.equals(g.getPasswordhash())) {
                String info = "authenticatie check ok; ";
                if (g.isBeheerder()) {
                    info = info + "beheerder; ";
                } else if (g.getGemeente() != null) {
                    info = info + "gemeente \"" + g.getGemeente().getNaam() + "\"";
                } else if (g.getRegio() != null) {
                    info = info + "regio \"" + g.getRegio().getNaam() + "\"";
                } else if (g.getProvincie() != null) {
                    info = info + "provincie \"" + g.getProvincie().getNaam() + "\"";
                } else if (g.isRijk()) {
                    info = info + "rijk; ";
                } else {
                    throw new IllegalStateException();
                }
                auditLog.info((Object)(auditAllow + info));
                Gebruiker gebruiker = g;
                return gebruiker;
            }
            auditLog.info((Object)(auditDeny + "password hash komt niet overeen (ongeldig wachtwoord)"));
            Principal principal = null;
            return principal;
        }
        catch (NoResultException nre) {
            auditLog.info((Object)(auditDeny + "geen gebruiker gevonden voor gebruikersnaam"));
            Principal principal = null;
            return principal;
        }
        catch (Exception e) {
            auditLog.error((Object)("LOGIN ERROR: username=\"" + username + "\": exception"), (Throwable)e);
            throw new RuntimeException("Exception checking authentication database", e);
        }
        finally {
            Stripersist.requestComplete();
        }
    }

    public boolean isUserInRole(Principal principal, String role) {
        if (principal == null) {
            return false;
        }
        Gebruiker g = (Gebruiker)principal;
        if (role.equals(ROLE_GEMEENTE) && g.getGemeente() != null) {
            return true;
        }
        if (role.equals(ROLE_REGIO) && g.getRegio() != null) {
            return true;
        }
        if (role.equals(ROLE_PROVINCIE) && g.getProvincie() != null) {
            return true;
        }
        if (role.equals(ROLE_BEHEERDER) && g.isBeheerder()) {
            return true;
        }
        return role.equals(ROLE_RIJK) && g.isRijk();
    }
}

