/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.export;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.servlet.ServletException;
import nl.b3p.commons.csv.CsvOutputStream;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.pzh.rwbp.entity.Bouwplanopmerking;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.export.ExportConfigServlet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.stripesstuff.stripersist.Stripersist;

public class ExportBouwplannenThread
extends Thread {
    private static final Log log = LogFactory.getLog(ExportBouwplannenThread.class);
    private String host = "localhost";
    private String port = "5432";
    private String db = "rwbp";
    private String schema = "public";
    private String username = "rwbp";
    private String pass = "rwbp";
    private String featureTypeIdProperty = "id";
    private String outputExtension = ".shp";
    private Integer[] geselecteerdePlannen;
    private Gebruiker user;
    private String downloadservlet;
    private String mailhost;
    private String sendfrom;
    private String path;
    private boolean toelichting;
    private List<String> csvViews = new ArrayList<String>();
    private boolean rapportpertype;
    private boolean rapportperperiode;
    private boolean rapporthov;
    private boolean exportperperiode;
    private boolean exportpertype;
    private boolean exportvolledig;
    private boolean exporteenvoudig;
    private String explanationPath;

    public ExportBouwplannenThread(Integer[] geselecteerdePlannen, Gebruiker user, String path, boolean exporteenvoudig, boolean exportvolledig, boolean exportperperiode, boolean exportpertype, boolean rapportpertype, boolean rapportperperiode, boolean rapporthov) throws Exception {
        this.geselecteerdePlannen = geselecteerdePlannen;
        this.user = user;
        this.path = path;
        this.host = ExportConfigServlet.getHost();
        this.port = ExportConfigServlet.getPort();
        this.db = ExportConfigServlet.getDb();
        this.schema = ExportConfigServlet.getSchema();
        this.username = ExportConfigServlet.getUsername();
        this.pass = ExportConfigServlet.getPass();
        this.featureTypeIdProperty = ExportConfigServlet.getFeatureTypeIdProperty();
        this.outputExtension = ExportConfigServlet.getOutputExtension();
        this.downloadservlet = ExportConfigServlet.getDownloadservlet();
        this.mailhost = ExportConfigServlet.getMailhost();
        this.sendfrom = ExportConfigServlet.getSendfrom();
        this.explanationPath = ExportConfigServlet.getExplanationPath();
        this.exportvolledig = exportvolledig;
        this.exporteenvoudig = exporteenvoudig;
        this.exportperperiode = exportperperiode;
        this.exportpertype = exportpertype;
        this.rapporthov = rapporthov;
        this.rapportperperiode = rapportperperiode;
        this.rapportpertype = rapportpertype;
        this.initExportTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Stripersist.requestInit();
        EntityManager em = Stripersist.getEntityManager();
        DataStore sds = null;
        Exception e = null;
        String workingName = null;
        try {
            workingName = ExportConfigServlet.uniqueName(File.separator, "", true);
            File workingDir = new File(workingName);
            workingDir.mkdir();
            sds = this.getSourceDatastore();
            if (sds == null) {
                throw new ServletException("Kan geen verbinding maken met bron.");
            }
            if (this.exportperperiode) {
                this.createShape(sds, "planningperperiode", workingName);
            }
            if (this.exportpertype) {
                this.createShape(sds, "pertype", workingName);
            }
            if (this.exportvolledig) {
                this.createShape(sds, "volledig", workingName);
            }
            if (this.exporteenvoudig) {
                this.createShape(sds, "eenvoudig", workingName);
            }
            for (String view : this.csvViews) {
                int begin = view.indexOf("_");
                int eind = view.indexOf("_view");
                String type = view.substring(begin + 1, eind);
                String exportType = view.substring(0, begin);
                if (type.equals("opmerking")) {
                    type = "opmerkingen";
                } else if (type.equals("extravelden")) {
                    type = "extravelden";
                } else if (type.equals("aantal")) {
                    type = "aantallen";
                }
                String filename = exportType + "_" + type;
                if (view.indexOf("rapportage") != -1) {
                    filename = type + "_rapportage";
                    exportType = type;
                }
                List priveOpmerkingen = null;
                if (view.equals("volledig_opmerking_view")) {
                    priveOpmerkingen = em.createQuery("from Bouwplanopmerking where gebruiker = :gebruiker and accesslevel.id = :accesslevel").setParameter("gebruiker", (Object)this.user).setParameter("accesslevel", (Object)new Integer(1)).getResultList();
                }
                SimpleFeatureSource sfsCSV = sds.getFeatureSource(view);
                SimpleFeatureType sftCSV = (SimpleFeatureType)sfsCSV.getSchema();
                FeatureCollection sourceFcCSV = this.getFeatureCollection((FeatureSource)sfsCSV, this.geselecteerdePlannen);
                CsvOutputStream csvWriter = null;
                FeatureIterator fit = null;
                try {
                    fit = sourceFcCSV.features();
                    File typeDir = new File(workingName + File.separator + exportType + File.separator);
                    typeDir.mkdir();
                    File f = new File(typeDir, filename + ".csv");
                    FileWriter fw = new FileWriter(f);
                    csvWriter = new CsvOutputStream((OutputStreamWriter)fw, ';', false);
                    String[] kolommen = null;
                    if (view.equals("volledig_opmerking_view") && priveOpmerkingen != null && priveOpmerkingen.size() > 0) {
                        kolommen = new String[sftCSV.getAttributeCount() + 1];
                        kolommen[kolommen.length - 1] = "prive";
                    } else {
                        kolommen = new String[sftCSV.getAttributeCount()];
                    }
                    for (int i = 0; i < sftCSV.getAttributeCount(); ++i) {
                        AttributeDescriptor ad = sftCSV.getDescriptor(i);
                        kolommen[i] = ad.getLocalName();
                    }
                    if (view.indexOf("pertype") == 0) {
                        String[] head = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "Tot 2015", "", "", "", "", "", "", "", "", "", "2015 - 2019", "", "", "", "", "", "", "", "", "", "2020 - 2024", "", "", "", "", "", "", "", "", "", "2025 - 2029", "", "", "", "", "", "", "", "", "", "2030 en verder"};
                        csvWriter.writeRecord(head);
                    }
                    csvWriter.writeRecord(kolommen);
                    while (fit.hasNext()) {
                        Feature feature = fit.next();
                        String[] values = new String[kolommen.length];
                        boolean emptyOpmerking = true;
                        for (int i = 0; i < kolommen.length; ++i) {
                            Property prop;
                            if (kolommen[i].equals("prive")) {
                                String waarde = "";
                                int bouwplanid = Integer.parseInt(values[0]);
                                for (Bouwplanopmerking opmerking : priveOpmerkingen) {
                                    if (opmerking.getBouwplan().getId() != bouwplanid) continue;
                                    waarde = opmerking.getOpmerking();
                                    emptyOpmerking = false;
                                }
                                if (waarde != null) {
                                    values[i] = waarde;
                                    if (waarde.contains("\r")) {
                                        waarde = waarde.replaceAll("\r", " ");
                                    }
                                    if (!waarde.contains("\n")) continue;
                                    waarde = waarde.replaceAll("\n", " ");
                                    continue;
                                }
                                values[i] = "";
                                continue;
                            }
                            if (kolommen[i].equals("oplevering")) {
                                prop = feature.getProperty(kolommen[i]);
                                if (prop != null && prop.getValue() != null) {
                                    Date datum = (Date)prop.getValue();
                                    SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
                                    sdf.applyPattern("dd-MM-yyyy");
                                    String date = sdf.format(datum);
                                    values[i] = date.toString();
                                    if (i <= 0) continue;
                                    emptyOpmerking = false;
                                    continue;
                                }
                                values[i] = "";
                                continue;
                            }
                            prop = feature.getProperty(kolommen[i]);
                            if (prop != null && prop.getValue() != null) {
                                String waarde = prop.getValue().toString();
                                if (waarde.contains("\r")) {
                                    waarde = waarde.replaceAll("\r", " ");
                                }
                                if (waarde.contains("\n")) {
                                    waarde = waarde.replaceAll("\n", " ");
                                }
                                values[i] = waarde;
                                if (i <= 0) continue;
                                emptyOpmerking = false;
                                continue;
                            }
                            values[i] = "";
                        }
                        if (emptyOpmerking && view.equals("volledig_opmerking_view")) continue;
                        csvWriter.writeRecord(values);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)"Fout bij maken van csv", (Throwable)ex);
                }
                finally {
                    if (csvWriter != null) {
                        csvWriter.close();
                    }
                    if (fit == null) continue;
                    fit.close();
                }
            }
            if (this.rapporthov) {
                this.createReport("planninghov", workingName);
            }
            if (this.rapportperperiode) {
                this.createReport("planningperperiode", workingName);
            }
            if (this.rapportpertype) {
                this.createReport("pertype", workingName);
            }
            this.addToelichtingen(workingName);
        }
        catch (Exception ex) {
            log.error((Object)"Fout bij exporteren", (Throwable)ex);
        }
        finally {
            this.sendEmail(workingName, e);
            if (sds != null) {
                sds.dispose();
            }
            Stripersist.requestComplete();
            log.debug((Object)"Done with making export files!");
        }
    }

    private void addToelichtingen(String workingname) {
        if (this.rapporthov) {
            this.copyFile(workingname, "planninghov", "planninghov_rapportage.xls");
        }
        if (this.rapportperperiode) {
            this.copyFile(workingname, "planningperperiode", "perperiode_rapportage.xls");
        }
        if (this.rapportpertype) {
            this.copyFile(workingname, "pertype", "pertype_rapportage.xls");
        }
        if (this.exportperperiode) {
            this.copyFile(workingname, "planningperperiode", "perperiode_overzicht.xls");
        }
        if (this.exportpertype) {
            this.copyFile(workingname, "pertype", "pertype_overzicht.xls");
        }
    }

    private void copyFile(String workingname, String type, String srcName) {
        try {
            File src = new File(this.explanationPath + File.separator + srcName);
            File dest = new File(workingname + File.separator + type);
            if (!dest.exists()) {
                dest.mkdir();
            }
            FileUtils.copyFileToDirectory((File)src, (File)dest);
        }
        catch (IOException e) {
            log.error((Object)("File copy failed: " + srcName), (Throwable)e);
        }
    }

    private void createShape(DataStore sds, String type, String workingName) throws IOException, Exception {
        String featureType = type + "_overzicht_shape_view";
        String filename = type + "_overzicht_shape";
        SimpleFeatureSource sfs = sds.getFeatureSource(featureType);
        SimpleFeatureType sft = (SimpleFeatureType)sfs.getSchema();
        FeatureCollection sourceFc = this.getFeatureCollection((FeatureSource)sfs, this.geselecteerdePlannen);
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:28992");
        SimpleFeatureType newFt = this.fixFeatureType(sft);
        File newShapeFile = new File(workingName + File.separator + type + File.separator + filename + this.outputExtension);
        File typeDir = new File(workingName + File.separator + type);
        typeDir.mkdir();
        ShapefileDataStore dds = this.createDestinationDatastore(newShapeFile);
        dds.createSchema(newFt);
        dds.forceSchemaCRS(crs);
        DefaultTransaction transaction = new DefaultTransaction("create");
        FeatureStore destFs = (FeatureStore)dds.getFeatureSource(filename);
        destFs.setTransaction((Transaction)transaction);
        try {
            destFs.addFeatures(sourceFc);
            transaction.commit();
        }
        catch (Exception exc) {
            log.error((Object)"Fout bij schrijven van features naar datastore... Doe rollback", (Throwable)exc);
            transaction.rollback();
            throw exc;
        }
        finally {
            transaction.close();
            dds.dispose();
        }
    }

    private void createReport(String rapportType, String workingName) throws ServletException {
        Date today = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
        sdf.applyPattern("dd-MM-yyyy");
        String now = sdf.format(today);
        Document document = null;
        try {
            PdfPTable table = this.createTable(rapportType);
            if (table != null) {
                Rectangle ps = PageSize.A4;
                document = new Document(ps.rotate());
                String filename = workingName + File.separator + rapportType + File.separator + rapportType + "_rapport.pdf";
                File typeDir = new File(workingName + File.separator + rapportType);
                typeDir.mkdir();
                PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filename));
                document.open();
                Paragraph titleParagraph = new Paragraph("Rapportage\n\n", new Font(1, 14.0f));
                titleParagraph.setAlignment(0);
                Chunk bron = new Chunk("Bron: Planmonitor Wonen", new Font(1, 10.0f));
                titleParagraph.add((Object)bron);
                Chunk datum = new Chunk("\nPeildatum: " + now + "\n\n", new Font(1, 10.0f));
                titleParagraph.add((Object)datum);
                document.add((Element)titleParagraph);
                document.add((Element)table);
            }
        }
        catch (Exception de) {
            log.error((Object)"Fout bij het maken van een document. Reden: ", (Throwable)de);
            throw new ServletException((Throwable)de);
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    private PdfPTable createTable(String rapportType) throws DocumentException {
        EntityManager em = Stripersist.getEntityManager();
        List<Integer> ids = Arrays.asList(this.geselecteerdePlannen);
        String view = "rapportage_" + rapportType + "_view";
        List rows = em.createNativeQuery("select * from " + view + " where id in(:ids)").setParameter("ids", ids).getResultList();
        String[] kolommen = null;
        float[] widths = null;
        int nonNumberOffset = 4;
        if (rapportType.equals("pertype")) {
            kolommen = new String[]{"Gemeentenaam", "Plannaam", "Status planologisch", "Status project", "Voortgang algemeen", "Nieuwbouw totaal", "Huur", "Koop", "Eigendom onbekend", "Eengezins", "Meergezins", "Type onbekend"};
            widths = new float[]{14.0f, 14.0f, 18.0f, 18.0f, 18.0f, 7.0f, 6.0f, 9.0f, 7.0f, 6.0f, 7.0f, 7.0f};
        } else if (rapportType.equals("planningperperiode")) {
            kolommen = new String[]{"Gemeentenaam", "Plannaam", "Status planologisch", "Status project", "Voortgang algemeen", "Totaal tot 2015", "Totaal 2015-2019", "Totaal 2020-2024", "Totaal 2025-2029", "Totaal 2030 en verder"};
            widths = new float[]{14.0f, 14.0f, 18.0f, 18.0f, 18.0f, 9.0f, 9.0f, 9.0f, 9.0f, 9.0f};
        } else if (rapportType.equals("planninghov")) {
            kolommen = new String[]{"Regio", "Gemeente", "Plannaam", "Invloedsgebied HOV", "Naam invloedsgebied HOV", "Status planologisch", "Status percentage", "Periode", "Nieuwbouw", "Sloop", "ont cap nieuwbouw", "ont cap sloop"};
            widths = new float[]{10.0f, 10.0f, 16.0f, 18.0f, 18.0f, 18.0f, 9.0f, 9.0f, 9.0f, 9.0f, 9.0f, 9.0f};
            nonNumberOffset = 12;
        } else {
            return null;
        }
        PdfPTable table = new PdfPTable(kolommen.length);
        int[] totals = new int[kolommen.length - nonNumberOffset];
        for (int b = 0; b < kolommen.length; ++b) {
            PdfPCell cel = new PdfPCell(new Phrase(kolommen[b], FontFactory.getFont((String)"Helvetica-Bold", (float)10.0f)));
            cel.setBackgroundColor(Color.LIGHT_GRAY);
            cel.setBorderWidth(0.0f);
            table.addCell(cel);
        }
        for (Object[] row : rows) {
            for (int x = 0; x < kolommen.length; ++x) {
                PdfPCell cel;
                Object waarde = row[x];
                if (waarde == null) {
                    cel = new PdfPCell(new Phrase("", FontFactory.getFont((String)"Helvetica", (float)10.0f)));
                    cel.setBorderWidth(0.0f);
                    table.addCell(cel);
                } else if (waarde instanceof Date) {
                    Date date = (Date)waarde;
                    SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
                    sdf.applyPattern("MM-yyyy");
                    String now = sdf.format(date);
                    PdfPCell cel2 = new PdfPCell(new Phrase(now, FontFactory.getFont((String)"Helvetica", (float)10.0f)));
                    cel2.setBorderWidth(0.0f);
                    if (x > nonNumberOffset) {
                        cel2.setHorizontalAlignment(1);
                    }
                    table.addCell(cel2);
                } else {
                    cel = new PdfPCell(new Phrase(waarde.toString(), FontFactory.getFont((String)"Helvetica", (float)10.0f)));
                    cel.setBorderWidth(0.0f);
                    if (x > nonNumberOffset) {
                        cel.setHorizontalAlignment(1);
                    }
                    table.addCell(cel);
                }
                if (waarde == null || x <= nonNumberOffset) continue;
                BigInteger bigaantal = (BigInteger)waarde;
                int aantal = bigaantal.intValue();
                int n = x - nonNumberOffset - 1;
                totals[n] = totals[n] + aantal;
            }
        }
        PdfPCell lastcel = new PdfPCell(new Phrase("Totaal", FontFactory.getFont((String)"Helvetica-Bold", (float)10.0f)));
        lastcel.setColspan(5);
        lastcel.setBorderWidth(0.0f);
        lastcel.setBackgroundColor(Color.LIGHT_GRAY);
        table.addCell(lastcel);
        for (int i = 0; i < totals.length; ++i) {
            int total = totals[i];
            PdfPCell totaalGeplandNieuwCel = new PdfPCell(new Phrase("" + total, FontFactory.getFont((String)"Helvetica-Bold", (float)10.0f)));
            totaalGeplandNieuwCel.setBorderWidth(0.0f);
            totaalGeplandNieuwCel.setBackgroundColor(Color.LIGHT_GRAY);
            totaalGeplandNieuwCel.setHorizontalAlignment(1);
            table.addCell(totaalGeplandNieuwCel);
        }
        table.setWidths(widths);
        table.setHorizontalAlignment(0);
        table.setWidthPercentage(100.0f);
        return table;
    }

    private void sendEmail(String workingName, Exception e) {
        String prefix = "\\" + File.separator;
        String[] splitWorkingName = workingName.split(prefix);
        String filename = splitWorkingName[splitWorkingName.length - 1];
        String downloadLink = this.path + this.downloadservlet + "?filename=" + filename + "&toelichting=" + this.toelichting;
        String to = this.user.getEmail();
        Date today = new Date(System.currentTimeMillis());
        String subject = "Export bouwplannen " + FormUtils.DateToString((Date)today, null);
        String body = null;
        body = e != null ? "De export is mislukt. \nFoutmelding: \n" + e : "<html><body><p>U kunt nu met de onder staande link de export downloaden.<br>Let op! De bestanden worden na het downloaden van de server verwijderd.<br>Deze link is dus slechts 1 maal te gebruiken. Tevens dient u ingelogd te zijn. </p><a href=\"" + downloadLink + "\">Downloaden</a>" + "</body></html>";
        HtmlEmail email = new HtmlEmail();
        try {
            email.setHtmlMsg(body);
            email.addTo(to);
            email.setFrom(this.sendfrom);
            email.setSubject(subject);
            email.setHostName(this.mailhost);
            email.send();
        }
        catch (EmailException ex) {
            log.error((Object)("Error bij senden email " + (Object)((Object)ex)));
        }
    }

    private ShapefileDataStore createDestinationDatastore(File file) throws MalformedURLException, IOException {
        String path = file.getAbsolutePath();
        if (!path.toLowerCase().endsWith(".shp")) {
            String newPath = !file.isDirectory() ? path.substring(0, path.length() - 4) + ".shp" : (path = path + "shapefile.shp");
            file = new File(newPath);
        }
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", file.toURI().toURL());
        params.put("create spatial index", Boolean.FALSE);
        ShapefileDataStore newDataStore = (ShapefileDataStore)factory.createNewDataStore(params);
        return newDataStore;
    }

    private DataStore getSourceDatastore() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PostgisNGDataStoreFactory.DBTYPE.key, "postgis");
        params.put(PostgisNGDataStoreFactory.HOST.key, this.host);
        params.put(PostgisNGDataStoreFactory.PORT.key, this.port);
        params.put(PostgisNGDataStoreFactory.DATABASE.key, this.db);
        params.put(PostgisNGDataStoreFactory.USER.key, this.username);
        params.put(PostgisNGDataStoreFactory.PASSWD.key, this.pass);
        params.put(PostgisNGDataStoreFactory.SCHEMA.key, this.schema);
        return DataStoreFinder.getDataStore(params);
    }

    private FeatureCollection getFeatureCollection(FeatureSource fs, Integer[] geselecteerdePlannen) throws IOException {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        ArrayList<PropertyIsEqualTo> orFilters = new ArrayList<PropertyIsEqualTo>();
        for (int i = 0; i < geselecteerdePlannen.length; ++i) {
            try {
                orFilters.add(ff.equals((Expression)ff.property(this.featureTypeIdProperty), (Expression)ff.literal((Object)geselecteerdePlannen[i])));
                continue;
            }
            catch (NumberFormatException nfe) {
                log.error((Object)("Kan filter niet toevoegen. Plan: " + geselecteerdePlannen[i] + "is geen int"), (Throwable)nfe);
            }
        }
        Or combinedFilter = ff.or(orFilters);
        return fs.getFeatures((Filter)combinedFilter);
    }

    private void initExportTypes() throws Exception {
        String view;
        if (this.exportvolledig) {
            this.csvViews.add("volledig_totaal_uitgebreid_view");
            this.csvViews.add("volledig_overzicht_additional_variables_view");
        }
        if (this.exportperperiode) {
            this.csvViews.add("planningperperiode_overzicht_view");
        }
        if (this.exportpertype) {
            this.csvViews.add("pertype_overzicht_view");
        }
        if (this.rapportpertype) {
            view = "rapportage_pertype_view";
            this.csvViews.add(view);
        }
        if (this.rapportperperiode) {
            view = "rapportage_planningperperiode_view";
            this.csvViews.add(view);
        }
        if (this.rapporthov) {
            view = "rapportage_planninghov_view";
            this.csvViews.add(view);
        }
    }

    private SimpleFeatureType fixFeatureType(SimpleFeatureType sft) {
        SimpleFeatureTypeBuilder schemaBuilder = new SimpleFeatureTypeBuilder();
        schemaBuilder.init(sft);
        ArrayList<AttributeDescriptor> attributeDescriptors = new ArrayList<AttributeDescriptor>(sft.getAttributeDescriptors());
        ArrayList<String> addedNames = new ArrayList<String>();
        for (int i = 0; i < attributeDescriptors.size(); ++i) {
            AttributeTypeBuilder attributeTypeBuilder;
            AttributeDescriptor desc = (AttributeDescriptor)attributeDescriptors.get(i);
            if (desc.getLocalName().length() > 10) {
                attributeTypeBuilder = new AttributeTypeBuilder();
                attributeTypeBuilder.init(desc);
                String newName = desc.getLocalName().substring(0, 10);
                int counter = 0;
                while (addedNames.contains(newName) && ++counter != 100) {
                    newName = newName.substring(0, 10 - ("" + counter).length());
                    newName = newName + counter;
                }
                addedNames.add(newName);
                desc = attributeTypeBuilder.buildDescriptor(newName);
                attributeDescriptors.set(i, desc);
                continue;
            }
            if (desc instanceof GeometryDescriptor) {
                attributeTypeBuilder = new AttributeTypeBuilder();
                attributeTypeBuilder.init(desc);
                attributeTypeBuilder.setBinding(Polygon.class);
                GeometryType geometryType = attributeTypeBuilder.buildGeometryType();
                desc = attributeTypeBuilder.buildDescriptor("the_geom", geometryType);
                attributeDescriptors.set(i, desc);
                addedNames.add(desc.getLocalName());
                continue;
            }
            addedNames.add(desc.getLocalName());
        }
        Object gdi = null;
        schemaBuilder.setAttributes(attributeDescriptors);
        schemaBuilder.setCRS(sft.getCoordinateReferenceSystem());
        schemaBuilder.setDefaultGeometry(sft.getGeometryDescriptor().getLocalName());
        return schemaBuilder.buildFeatureType();
    }
}

