/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.printen;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import nl.b3p.pzh.rwbp.printen.PrintInfo;
import nl.b3p.pzh.rwbp.printen.PrintInfoList;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;

public class PrintGenerator {
    private static final Log log = LogFactory.getLog(PrintGenerator.class);
    private final PrintInfo info;
    private final String mimeType;
    private final File xsl;
    private final String filename;
    private final String fromName;
    private final String fromMail;
    private final String toMail;

    public PrintGenerator(PrintInfo info, String mimeType, File xsl, String filename, String fromName, String fromMail, String toMail) {
        this.info = info;
        this.mimeType = mimeType;
        this.xsl = xsl;
        this.filename = filename;
        this.fromName = fromName;
        this.fromMail = fromMail;
        this.toMail = toMail;
    }

    public static void createOutput(PrintInfoList info, String mimeType, File xslFile, boolean addJavascript, HttpServletResponse response, String filename) throws MalformedURLException, IOException {
        String path = new File(xslFile.getParent()).toURI().toString();
        PrintGenerator.createOutput(info, mimeType, new FileInputStream(xslFile), path, addJavascript, response, filename);
    }

    public static void createOutput(PrintInfoList info, String mimeType, URL xslUrl, boolean addJavascript, HttpServletResponse response, String filename) throws MalformedURLException, IOException {
        String path = xslUrl.toString().substring(0, xslUrl.toString().lastIndexOf("/") + 1);
        PrintGenerator.createOutput(info, mimeType, xslUrl.openStream(), path, addJavascript, response, filename);
    }

    public static void createOutput(PrintInfoList info, String mimeType, InputStream xslIs, String basePath, boolean addJavascript, HttpServletResponse response, String filename) throws MalformedURLException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintGenerator.createOutput(info, mimeType, xslIs, basePath, (OutputStream)out, filename);
        response.setContentType(mimeType);
        response.setContentLength(out.size());
        response.setHeader("Content-Disposition", "attachment; filename=" + filename);
        response.getOutputStream().write(out.toByteArray());
        response.getOutputStream().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createOutput(PrintInfoList info, String mimeType, InputStream xslIs, String basePath, OutputStream out, String filename) throws MalformedURLException, IOException {
        FopFactory fopFactory = FopFactory.newInstance();
        fopFactory.setBaseURL(basePath);
        try {
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            foUserAgent.setCreator("Flamingo");
            foUserAgent.setProducer("Flamingo");
            Date now = new Date();
            foUserAgent.setCreationDate(now);
            foUserAgent.setTitle("Kaart");
            Fop fop = fopFactory.newFop(mimeType, foUserAgent, out);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{PrintInfoList.class, PrintInfo.class});
            JAXBSource src = new JAXBSource(jc, (Object)info);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PrintInfoList.class, PrintInfo.class});
            if (log.isDebugEnabled()) {
                StringWriter sw = new StringWriter();
                jaxbContext.createMarshaller().marshal((Object)info, (Writer)sw);
                log.debug((Object)("Print XML: " + sw.toString()));
            }
            StreamSource xsltSrc = new StreamSource(xslIs);
            xsltSrc.setSystemId(basePath);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xsltSrc);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform((Source)src, res);
        }
        catch (Exception ex) {
            log.error((Object)"Fout tijdens print output: ", (Throwable)ex);
        }
        finally {
            out.close();
        }
    }
}

