CREATE TABLE voortgangstatus
(
   id serial NOT NULL, 
   "type" character varying(255), 
    PRIMARY KEY (id)
) 
WITHOUT OIDS;
ALTER TABLE voortgangstatus OWNER TO rwbp;

INSERT INTO voortgangstatus (type) VALUES ('Groen - er worden geen knelpunten voorzien');
INSERT INTO voortgangstatus (type) VALUES ('Oranje - er worden knelpunten voorzien');
INSERT INTO voortgangstatus (type) VALUES ('Rood - er zijn knelpunten');
INSERT INTO voortgangstatus (type) VALUES ('Niet van toepassing');
INSERT INTO voortgangstatus (type) VALUES ('Onbekend');


CREATE TABLE voortgangsoort
(
   id serial NOT NULL, 
   "type" character varying(255), 
    PRIMARY KEY (id)
) 
WITHOUT OIDS;
ALTER TABLE voortgangsoort OWNER TO rwbp;

INSERT INTO voortgangsoort (type) VALUES ('Algemeen');
INSERT INTO voortgangsoort (type) VALUES ('Planologische');
INSERT INTO voortgangsoort (type) VALUES ('Start bouw');
INSERT INTO voortgangsoort (type) VALUES ('Bouwrijp maken');
INSERT INTO voortgangsoort (type) VALUES ('Bouwvergunningen');
INSERT INTO voortgangsoort (type) VALUES ('Overig');



CREATE TABLE bouwplanvoortgang
(
   id serial NOT NULL, 
   voortgangsoortid integer NOT NULL, 
   bouwplanid integer NOT NULL, 
   voortgangstatusid integer NOT NULL, 
   toelichting character varying(1000), 
    PRIMARY KEY (id), 
    FOREIGN KEY (bouwplanid) REFERENCES bouwplan (id)    ON UPDATE NO ACTION ON DELETE NO ACTION, 
    FOREIGN KEY (voortgangsoortid) REFERENCES voortgangsoort (id)    ON UPDATE NO ACTION ON DELETE NO ACTION, 
    FOREIGN KEY (voortgangstatusid) REFERENCES voortgangstatus (id)    ON UPDATE NO ACTION ON DELETE NO ACTION
) 
WITHOUT OIDS;
ALTER TABLE bouwplanvoortgang OWNER TO rwbp;