CREATE OR REPLACE VIEW info_view AS
select b.id, b.the_geom, b.naam as plannaam, b.aanduidingid, 
(SELECT v.voortgangstatusid
	FROM bouwplanvoortgang v
	WHERE v.bouwplanid = b.id 
	AND v.voortgangsoortid = 1) AS voortgangid,
g.naam as gemeente, 
to_char(b.prognose_start, 'DD-MM-YYYY') as prognose_start,
to_char(b.prognose_oplevering, 'DD-MM-YYYY') as prognose_oplevering,
(SELECT vs.type
	FROM bouwplanvoortgang v
	left join voortgangstatus vs
	on v.voortgangstatusid = vs.id
	WHERE v.bouwplanid = b.id 
	AND v.voortgangsoortid = 1) AS voortgang,
(select sum(f.planningaantal) 
	from factmetperiode f
	where bouwplanid = b.id 
	and f.factsoortid != 1 
	and f.factsoortid != 2
	and f.factsoortid != 19
	and periodeid = 2) as tweeduizendnegen,
(select sum(f.planningaantal) 
	from factmetperiode f
	where bouwplanid = b.id 
	and f.factsoortid != 1 
	and f.factsoortid != 2
	and f.factsoortid != 19
	and periodeid >= 3
	and periodeid <= 7) as tweeduizendtien_veertien,
(select sum(f.planningaantal) 
	from factmetperiode f
	where bouwplanid = b.id 
	and f.factsoortid != 1 
	and f.factsoortid != 2
	and f.factsoortid != 19
	and periodeid >= 8
	and periodeid <= 12) as tweeduizendveertien_negentien,
(select sum(f.planningaantal) 
	from factmetperiode f
	where bouwplanid = b.id 
	and f.factsoortid != 1 
	and f.factsoortid != 2
	and f.factsoortid != 19
	and periodeid = 13) as tweeduizendtwintig,
(select sum(f.planningaantal) 
	from factmetperiode f
	where bouwplanid = b.id 
	and f.factsoortid != 1 
	and f.factsoortid != 2
	and f.factsoortid != 19
	and periodeid = 15) as onbekend,
(select sum(f.planningaantal) 
	from factmetperiode f
	where bouwplanid = b.id 
	and f.factsoortid != 1 
	and f.factsoortid != 2
	and f.factsoortid != 19) as totaal
FROM bouwplan b
left join gemeente g
on b.gemeenteid = g.id
WHERE b.statusprojectid <> 11 
AND b.the_geom IS NOT NULL
AND b.gebruikgegevensid = 1
ORDER BY b.id;

ALTER TABLE info_view OWNER TO rwbp;