/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.pzh.rwbp.MD5Hasher;
import nl.b3p.pzh.rwbp.SearchQuery;
import nl.b3p.pzh.rwbp.SldMapEntry;
import nl.b3p.pzh.rwbp.SolrInitializer;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.stripes.BouwplanUtils;
import nl.b3p.pzh.rwbp.stripes.ViewerActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@StrictBinding
public class SolrActionBean
extends ViewerActionBean {
    private static final Log log = LogFactory.getLog(SolrActionBean.class);
    public static final String SEARCH_PROPERTIES = "searchProperties";
    @Validate
    private String naam;
    @Validate
    private String term;
    @Validate
    private String extraFilter;
    @Validate
    private String facetQuery;
    @Validate
    private String facet;
    @Validate
    private String sortField;
    @Validate
    private String sortOrder;
    @Validate
    private boolean reloadPrevious;
    @Validate
    private int start = 0;
    @Validate
    private int numResults = 10;
    @Validate
    private String searchFields;
    private String layers;
    private String sldKey = "";
    private SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");

    @DefaultHandler
    public Resolution search() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("success", false);
        try {
            String authQuery = this.getAuthorizedQuery();
            SearchQuery sq = null;
            if (this.reloadPrevious) {
                sq = (SearchQuery)this.context.getRequest().getSession().getAttribute("searchProperties");
            }
            if (sq == null) {
                sq = new SearchQuery(this.naam, this.term, this.extraFilter, this.facetQuery, this.facet, this.sortField, this.sortOrder, this.searchFields, authQuery, this.start, this.numResults);
                this.context.getRequest().getSession().setAttribute("searchProperties", (Object)sq);
            }
            QueryResponse rsp = BouwplanUtils.getResponse((SolrQuery)sq.toQuery());
            SolrDocumentList list = rsp.getResults();
            JSONArray respDocs = new JSONArray();
            int total = new Long(list.getNumFound()).intValue();
            obj.put("total", total);
            obj.put("results", (Object)respDocs);
            JSONObject extent = null;
            ArrayList<Integer> zichtbaarIds = new ArrayList<Integer>();
            for (SolrDocument solrDocument : list) {
                JSONObject doc = this.solrDocumentToResult(solrDocument);
                if (doc == null) continue;
                respDocs.put((Object)doc);
                zichtbaarIds.add(doc.getInt("id"));
                extent = this.processExtent(doc, extent);
            }
            JSONArray facets = this.getFacetInformation(rsp);
            obj.put("facets", (Object)facets);
            obj.put("numResults", this.numResults);
            obj.put("start", this.start);
            obj.put("success", true);
            obj.put("extent", (Object)extent);
            obj.put("searchQuery", (Object)sq.toJSON());
            obj.put("mapVariables", (Object)this.doKaartlijstRequests(sq, total, zichtbaarIds));
        }
        catch (SolrServerException ex) {
            log.error((Object)"Error searchign solr:", (Throwable)ex);
        }
        catch (JSONException ex) {
            log.error((Object)"Error searchign solr:", (Throwable)ex);
        }
        return new StreamingResolution("application/json", obj.toString(4));
    }

    private JSONObject processExtent(JSONObject doc, JSONObject extent) throws JSONException {
        if (!doc.getBoolean("heeft_geometrie")) {
            return extent;
        }
        double minX = doc.getDouble("minx");
        double minY = doc.getDouble("miny");
        double maxX = doc.getDouble("maxx");
        double maxY = doc.getDouble("maxy");
        if (extent == null) {
            extent = new JSONObject();
            extent.put("minx", minX);
            extent.put("miny", minY);
            extent.put("maxx", maxX);
            extent.put("maxy", maxY);
            return extent;
        }
        double curMinX = extent.getDouble("minx");
        double curMinY = extent.getDouble("miny");
        double curMaxX = extent.getDouble("maxx");
        double curMaxY = extent.getDouble("maxy");
        if (curMinX > minX) {
            extent.put("minx", minX);
        }
        if (curMinY > minY) {
            extent.put("miny", minY);
        }
        if (curMaxX < maxX) {
            extent.put("maxx", maxX);
        }
        if (curMaxY < maxY) {
            extent.put("maxy", maxY);
        }
        return extent;
    }

    private String getAuthorizedQuery() {
        String rechtenQuery = "";
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker ingelogd = (Gebruiker)this.context.getRequest().getUserPrincipal();
        boolean prov = this.context.getRequest().isUserInRole("provincie");
        boolean regio = this.context.getRequest().isUserInRole("regio");
        boolean gemeente = this.context.getRequest().isUserInRole("gemeente");
        boolean rijk = this.context.getRequest().isUserInRole("rijk");
        boolean admin = false;
        boolean openbaar = false;
        String resultField = "";
        if (ingelogd != null) {
            this.gebruiker = (Gebruiker)em.find(Gebruiker.class, (Object)ingelogd.getId());
            admin = ingelogd.isBeheerder();
            if (this.gebruiker.getGemeente() != null) {
                resultField = "\"" + this.gebruiker.getGemeente().getNaam() + "\"";
            } else if (this.gebruiker.getRegio() != null) {
                resultField = "\"" + this.gebruiker.getRegio().getNaam() + "\"";
            } else if (this.gebruiker.getProvincie() != null) {
                resultField = this.gebruiker.getProvincie().getNaam();
            } else if (this.gebruiker.isRijk()) {
                resultField = "Nederland";
            }
        } else {
            openbaar = true;
        }
        String OPENBAAR = "Openbaar";
        String EIGEN_NIVEAU = "\"Gemeente, eigen regio, eigen provincie\"";
        String INGELOGD = "\"Alle ingelogde gebruikers\"";
        String GEMEENTE = "\"Alleen gemeente\"";
        String GEMEENTE_EIGENREGIO = "\"Gemeente, eigen regio\"";
        if (prov) {
            rechtenQuery = " (gebruikgegevens_facet:Openbaar or (provincie_facet:" + resultField + " and gebruikgegevens_facet:" + "\"Gemeente, eigen regio, eigen provincie\"" + ")" + " or (gebruikgegevens_facet:" + "\"Alle ingelogde gebruikers\"" + "))";
        } else if (regio) {
            rechtenQuery = " (gebruikgegevens_facet:Openbaar or (regio_facet:" + resultField + " and (gebruikgegevens_facet:" + "\"Gemeente, eigen regio, eigen provincie\"" + " or gebruikgegevens_facet:" + "\"Gemeente, eigen regio\"" + ")) or (gebruikgegevens_facet:" + "\"Alle ingelogde gebruikers\"" + "))";
        } else if (gemeente) {
            Provincie p = this.gebruiker.resolveProvincie();
            String provincie = p != null ? p.getNaam() : null;
            rechtenQuery = " (gebruikgegevens_facet:Openbaar or (gemeente_facet:" + resultField + " and (gebruikgegevens_facet:" + "\"Alleen gemeente\"" + " or gebruikgegevens_facet:" + "\"Gemeente, eigen regio\"" + " or gebruikgegevens_facet:" + "\"Gemeente, eigen regio, eigen provincie\"" + " )) or (gebruikgegevens_facet:" + "\"Alle ingelogde gebruikers\"" + ")";
            rechtenQuery = rechtenQuery + " or( provincie_facet:" + provincie + " and (gebruikgegevens_facet:" + "\"Gemeente, eigen regio, eigen provincie\"" + " or gebruikgegevens_facet:" + "\"Gemeente, eigen regio\"" + ")) )";
        } else if (rijk || admin) {
            rechtenQuery = " gebruikgegevens_facet:Openbaar or gebruikgegevens_facet:\"Alle ingelogde gebruikers\"";
        } else if (openbaar) {
            rechtenQuery = " (gebruikgegevens_facet:Openbaar)";
        }
        return rechtenQuery;
    }

    public Resolution add() throws SolrServerException, IOException {
        SolrServer server = SolrInitializer.getServerInstance();
        EntityManager em = Stripersist.getEntityManager();
        UpdateResponse ur = server.deleteByQuery("*:*");
        TypedQuery q = em.createQuery("FROM Bouwplan", Bouwplan.class);
        List lijst = q.getResultList();
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
        int counter = 0;
        for (Bouwplan bp : lijst) {
            SolrInputDocument doc = SolrActionBean.createDocument((Bouwplan)bp);
            docs.add(doc);
            if (++counter <= 100) continue;
            UpdateResponse resp = server.add(docs);
            server.commit();
            counter = 0;
            docs = new ArrayList();
        }
        if (!docs.isEmpty()) {
            UpdateResponse updateResponse = server.add(docs);
        }
        server.commit();
        return new StreamingResolution("plain/text", "");
    }

    public static void removeSingleBouwplan(Bouwplan bp) {
        try {
            SolrServer server = SolrInitializer.getServerInstance();
            server.deleteById(bp.getId().toString());
            server.commit();
        }
        catch (SolrServerException ex) {
            log.error((Object)"Error removing bouwplan:", (Throwable)ex);
        }
        catch (IOException ex) {
            log.error((Object)"Error removing bouwplan:", (Throwable)ex);
        }
    }

    public static void removeMultipleBouwplans(List<String> ids) {
        try {
            SolrServer server = SolrInitializer.getServerInstance();
            server.deleteById(ids);
            server.commit();
        }
        catch (SolrServerException ex) {
            log.error((Object)"Error removing bouwplan:", (Throwable)ex);
        }
        catch (IOException ex) {
            log.error((Object)"Error removing bouwplan:", (Throwable)ex);
        }
    }

    public static void addSingleBouwplan(Bouwplan bp) {
        try {
            SolrServer server = SolrInitializer.getServerInstance();
            SolrInputDocument doc = SolrActionBean.createDocument((Bouwplan)bp);
            server.add(doc);
            server.commit();
        }
        catch (SolrServerException ex) {
            log.error((Object)"Error adding bouwplan:", (Throwable)ex);
        }
        catch (IOException ex) {
            log.error((Object)"Error adding bouwplan:", (Throwable)ex);
        }
    }

    private static SolrInputDocument createDocument(Bouwplan plan) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("id", (Object)plan.getId());
        doc.addField("aanmaakdatum", (Object)plan.getAanmaakdatum());
        doc.addField("naam", (Object)plan.getNaam());
        doc.addField("bestemmingsplannaam", (Object)plan.getBestemmingsplannaam());
        doc.addField("gemeente", (Object)plan.getGemeente().getNaam());
        doc.addField("plaatsnaam", (Object)plan.getPlaatsnaam());
        doc.addField("regio", (Object)plan.getGemeente().getRegio().getNaam());
        doc.addField("provincie", (Object)plan.getGemeente().getProvincie().getNaam());
        doc.addField("statusplanologisch", plan.getStatusplanologisch() != null ? plan.getStatusplanologisch().getType() : null);
        doc.addField("statusproject", plan.getStatusproject() != null ? plan.getStatusproject().getType() : null);
        doc.addField("gebruikgegevens", plan.getGebruikgegevens() != null ? plan.getGebruikgegevens().getNaam() : null);
        doc.addField("woonmilieu", plan.getWoonmilieu() != null ? plan.getWoonmilieu().getType() : null);
        doc.addField("ontwikkelaartype", plan.getOntwikkelaartype() != null ? plan.getOntwikkelaartype().getType() : null);
        doc.addField("plantype", plan.getPlantype() != null ? plan.getPlantype().getType() : null);
        doc.addField("woonmilieurosetta", plan.getWoonmilieu_rosetta() != null ? plan.getWoonmilieu_rosetta().getValue() : null);
        Polygon p = plan.getThe_geom();
        if (p != null) {
            Envelope e = p.getEnvelopeInternal();
            doc.addField("minx", (Object)e.getMinX());
            doc.addField("miny", (Object)e.getMinY());
            doc.addField("maxx", (Object)e.getMaxX());
            doc.addField("maxy", (Object)e.getMaxY());
        }
        doc.addField("aantal_woningen", (Object)plan.getTotaalcapaciteit());
        doc.addField("jaareersteoplevering", (Object)plan.getJaar_eerste_oplevering());
        doc.addField("datumlaatstewijziging", (Object)plan.getDatumlaatstewijziging());
        doc.addField("heeft_geometrie", (Object)(plan.getThe_geom() != null ? 1 : 0));
        return doc;
    }

    private JSONObject solrDocumentToResult(SolrDocument doc) throws JSONException {
        JSONObject result = new JSONObject();
        Collection fields = doc.getFieldNames();
        for (String field : fields) {
            if (field.equals("datumlaatstewijziging")) {
                Date d = (Date)doc.get((Object)field);
                result.put(field, (Object)this.sdf.format(d));
                continue;
            }
            result.put(field, doc.get((Object)field));
        }
        return result;
    }

    private JSONArray getFacetInformation(QueryResponse resp) throws JSONException {
        JSONArray facets = new JSONArray();
        List fields = resp.getFacetFields();
        for (FacetField field : fields) {
            JSONObject jsonField = new JSONObject();
            jsonField.put("count", field.getValueCount());
            jsonField.put("name", (Object)field.getName());
            String name = field.getName();
            String label = name.replace("_facet", "");
            label = label.substring(0, 1).toUpperCase() + label.substring(1);
            jsonField.put("label", (Object)label);
            List values = field.getValues();
            JSONArray jsonValues = new JSONArray();
            for (FacetField.Count value : values) {
                JSONObject jsonValue = new JSONObject();
                jsonValue.put("name", (Object)value.getName());
                jsonValue.put("count", value.getCount());
                jsonValues.put((Object)jsonValue);
            }
            jsonField.put("values", (Object)jsonValues);
            facets.put((Object)jsonField);
        }
        return facets;
    }

    private JSONObject doKaartlijstRequests(SearchQuery sq, int max, List<Integer> zichtbaarIds) {
        JSONObject mapVariables = new JSONObject();
        try {
            int offset = sq.getStart();
            List allIds = BouwplanUtils.getAllIdsFromQuery((SearchQuery)sq, (int)max);
            this.makeKaartLijsten(allIds, zichtbaarIds, offset);
            mapVariables.put("sldKey", (Object)this.sldKey);
        }
        catch (SolrServerException ex) {
            log.error((Object)"Cannot find all ids:", (Throwable)ex);
        }
        catch (JSONException ex) {
            log.error((Object)"Cannot add mapvariables to response json: ", (Throwable)ex);
        }
        return mapVariables;
    }

    private void makeKaartLijsten(List<Integer> ids, List<Integer> zichtbaarIds, int offset) {
        int beginnummering = 1;
        ids.removeAll(zichtbaarIds);
        String zichtbaar = "";
        String nummering = "";
        String gevonden = "";
        beginnummering = offset + 1;
        int aantal = zichtbaarIds.size();
        int i = 1;
        for (Integer id : zichtbaarIds) {
            if (i == aantal) {
                zichtbaar = zichtbaar + id;
                nummering = nummering + beginnummering;
            } else {
                zichtbaar = zichtbaar + id + ",";
                nummering = nummering + beginnummering + ",";
            }
            ++i;
            ++beginnummering;
        }
        if (ids.size() > 0) {
            aantal = ids.size();
            i = 1;
            for (Integer bouwplanid : ids) {
                gevonden = i == aantal ? gevonden + bouwplanid : gevonden + bouwplanid + ",";
                ++i;
            }
        }
        String[] extraLagen = new String[]{};
        String extraLaagId = "";
        if (this.gebruiker != null) {
            extraLagen = new String[1];
            if (this.gebruiker.getGemeente() != null) {
                extraLaagId = extraLaagId + this.gebruiker.getGemeente().getId();
                extraLagen[0] = "bouwplan_gemeente";
            } else if (this.gebruiker.getRegio() != null) {
                extraLaagId = extraLaagId + this.gebruiker.getRegio().getId();
                extraLagen[0] = "bouwplan_regio";
            } else if (this.gebruiker.getProvincie() != null) {
                extraLaagId = extraLaagId + this.gebruiker.getProvincie().getId();
                extraLagen[0] = "bouwplan_provincie";
            } else if (this.gebruiker.isRijk()) {
                extraLagen[0] = "bouwplan_rijk";
            }
        }
        this.initLayers();
        this.createHashMapEntry(this.layers, zichtbaar, gevonden, nummering, extraLagen, extraLaagId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHashMapEntry(String layers, String cbpids, String obpids, String cbpnrs, String[] extraLagen, String extraLaagId) {
        ServletContext sc;
        ServletContext servletContext = sc = this.context.getServletContext();
        synchronized (servletContext) {
            Map sldMap = SolrActionBean.getSldMap((ServletContext)sc);
            String parameterString = this.createParameterString(layers, cbpids, obpids, cbpnrs, extraLagen, extraLaagId);
            if (!sldMap.containsKey(parameterString)) {
                this.sldKey = SolrActionBean.createHash((String)parameterString);
                sldMap.put(this.sldKey, new SldMapEntry(cbpids, obpids, cbpnrs, layers, extraLagen, extraLaagId));
            }
        }
    }

    public void initLayers() {
        this.layers = "bouwplan_openbaar,bouwplan_openbaar_afgerond,bouwplan_openbaar_vervallen";
        if (this.gebruiker != null) {
            if (this.getGebruiker().getGemeente() != null) {
                this.layers = this.layers + ",bouwplan_gemeente,bouwplan_gemeente_afgerond,bouwplan_gemeente_vervallen";
            } else if (this.getGebruiker().getRegio() != null) {
                this.layers = this.layers + ",bouwplan_regio,bouwplan_regio_afgerond,bouwplan_regio_vervallen";
            } else if (this.getGebruiker().getProvincie() != null) {
                this.layers = this.layers + ",bouwplan_provincie,bouwplan_provincie_afgerond,bouwplan_provincie_vervallen";
            } else if (this.gebruiker.isRijk()) {
                this.layers = this.layers + ",bouwplan_rijk,bouwplan_rijk_afgerond,bouwplan_rijk_vervallen";
            }
        }
    }

    private String createParameterString(String layers, String cbpids, String obpids, String cbpnrs, String[] extraLagen, String extraLaagid) {
        String parameterString = cbpids + obpids + cbpnrs + layers;
        for (String extraLaag : extraLagen) {
            parameterString = parameterString + extraLaag;
        }
        parameterString = parameterString + extraLaagid;
        return parameterString;
    }

    private static String createHash(String parameterString) {
        try {
            return MD5Hasher.MD5((String)parameterString);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage());
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)ex.getMessage());
        }
        return null;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public String getExtraFilter() {
        return this.extraFilter;
    }

    public void setExtraFilter(String extraFilter) {
        this.extraFilter = extraFilter;
    }

    public String getFacet() {
        return this.facet;
    }

    public void setFacet(String facet) {
        this.facet = facet;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public String getNaam() {
        return this.naam;
    }

    public void setNaam(String naam) {
        this.naam = naam;
    }

    public int getNumResults() {
        return this.numResults;
    }

    public void setNumResults(int numResults) {
        this.numResults = numResults;
    }

    public String getSearchFields() {
        return this.searchFields;
    }

    public void setSearchFields(String searchFields) {
        this.searchFields = searchFields;
    }

    public boolean isReloadPrevious() {
        return this.reloadPrevious;
    }

    public void setReloadPrevious(boolean reloadPrevious) {
        this.reloadPrevious = reloadPrevious;
    }

    public String getFacetQuery() {
        return this.facetQuery;
    }

    public void setFacetQuery(String facetQuery) {
        this.facetQuery = facetQuery;
    }
}

