<%@include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@page contentType="text/html" session="false" pageEncoding="UTF-8"%>

<stripes:layout-render name="/WEB-INF/jsp/templates/tabTemplate.jsp" pageTitle="Beheer">
    <stripes:layout-component name="head">
        <script type="text/javascript" src="./js/config.js"></script>
        <script type="text/javascript" src="./js/fields.js"></script>
        <script type="text/javascript" src="./js/variablecreator.js"></script>
    </stripes:layout-component>
    <stripes:layout-component name="content">
        <div style="width:100%;"> 
            <div class="optional_fields editform">
                <stripes:form id="beheerForm" beanclass="nl.b3p.pzh.rwbp.stripes.AdminFieldsActionBean">
                    <p style="color:red">
                        <stripes:errors/>
                    </p>
                    <p style="color:green">
                        <stripes:messages/>
                    </p>
                    <h2>Optionele velden</h2>
                    <div class="block">
                        <table>
                            <c:forEach items="${actionBean.optionalVars}" var="opVar">
                                <tr>
                                    <c:set var="checked" value="" />
                                    <c:forEach items="${actionBean.savedOptVars}" var="pOptVar">
                                        <c:if test="${pOptVar == opVar.id}">
                                            <c:set var="checked" value=" checked=\"true\"" />
                                        </c:if>
                                    </c:forEach>
                                    <td><input type="hidden" id="savedOptVars${opVar.id}" name="savedOptVars" value="${checked == ''?'':opVar.id}"/>
                                        <input type="checkbox" class="savedOptCheckbox" name="savedOptVars_checkbox" value="${opVar.id}"${checked} />${opVar.label}</td>
                                </tr>
                            </c:forEach>
                        </table>
                    </div>
                    <div style="clear: both;"></div>
                    <stripes:submit name="save" class="inputbutton menubutton" style="width: auto;">Opslaan</stripes:submit>
                </stripes:form>
            </div>
            <div class="optional_fields editform edit-labels">
                <h2>Labels aanpassen</h2>
                <div class="block">
                    <c:forEach items="${actionBean.optionalLabelVars}" var="opVar">
                        <div class="row">
                            <label>${opVar.label}</label>
                            <a href="#" class="label${ opVar.id }" data-varid="${ opVar.id }" data-varlabel="${opVar.label}" data-regios="1,2,3">
                                <c:choose>
                                    <c:when test="${not empty actionBean.labelMap[opVar.id]}">
                                        ${actionBean.labelMap[opVar.id]}
                                    </c:when>
                                    <c:otherwise>
                                        aanpassen
                                    </c:otherwise>
                                </c:choose>
                            </a>
                        </div>
                    </c:forEach>
                </div>
            </div>
            <div class="optional_fields editform variables-table">
                <h2>Additionele velden</h2>
                <div class="table-container"></div>
                <div class="add-var-container">
                    <a href="#" class="add-var">Variabele toevoegen</a>
                </div>
            </div>
            <div id="addedit-variable" class="modal-dialog">
                <div class="block large-block create-variable"></div>
                <div class="buttons">
                    <a href="#" class="cancel-var pull-left">Annuleren</a>
                    <a href="#" class="save-var pull-right">Opslaan</a>
                </div>
            </div>
        </div>
        <script>
            Ext.onReady(function() {
                Ext.create('B3p.planmonitor.Fields', {
                    regios: ${actionBean.regios},
                    variables: ${actionBean.variables},
                    labels:  ${actionBean.labels},
                    saveurl: '<stripes:url beanclass="nl.b3p.pzh.rwbp.stripes.AdminFieldsActionBean" event="saveVariable"/>',
                    saveLabelUrl: '<stripes:url beanclass="nl.b3p.pzh.rwbp.stripes.AdminFieldsActionBean" event="saveLabel"/>',
                    removeurl: '<stripes:url beanclass="nl.b3p.pzh.rwbp.stripes.AdminFieldsActionBean" event="removeVariable"/>'
                });
            });
        </script>
    </stripes:layout-component>
</stripes:layout-render>
