<%-- 
    Document   : planinformatie
    Created on : Feb 24, 2015, 8:21:05 PM
    Author     : geertplaisier
--%>

<%@include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@page contentType="text/html" pageEncoding="UTF-8"%>

<section class="planinformatie">
    <h1>Planinformatie</h1>
    <div class="blocks">
        <div id="basisgegevens" class="block">
            <h2>Basisgegevens</h2>
            <stripes:hidden id="bouwplanid" name="bouwplan.id" value="${actionBean.bouwplan.id}"/>
            <stripes:hidden id="add" name="add" value="${actionBean.add}"/>
            <div class="row">
                <label>Plan ID</label>
                <div class="input">
                    ${actionBean.bouwplan.id}
                </div>
            </div>
            <div class="row">
                <label>Datum laatste wijziging</label>
                <div class="input">
                    <fmt:formatDate value="${actionBean.bouwplan.datumlaatstewijziging}" pattern="dd-MM-yyyy"/>
                </div>
            </div>
            <div class="row">
                <label>Plannaam *</label>
                <div class="input">
                    <stripes:text name="bouwplan.naam" class="gemeentefield" />
                </div>
            </div>
            <div class="row">
                <label>Gemeente</label>
                <div class="input">
                    <c:choose>
                    <c:when test="${not empty actionBean.bouwplan && !actionBean.add}">
                    ${actionBean.bouwplan.gemeente.naam}
                    </c:when>
                        <c:when test="${not empty actionBean.gebruiker}">
                            ${actionBean.gebruiker.gemeente.naam}
                        </c:when>
                    </c:choose>
                </div>
            </div>
            <div class="row">
                <label>Plaatsnaam</label>
                <div class="input">
                    <stripes:text name="bouwplan.plaatsnaam" class="gemeentefield"/>
                </div>
            </div>
            <div class="row">
                <label>Referentienummer</label>
                <div class="input">
                    <stripes:text name="bouwplan.referentienummer" class="gemeentefield" />
                </div>
            </div>
            <div class="row">
                <label>Bestemmingsplan</label>
                <div class="input">
                    <stripes:text name="bouwplan.bestemmingsplannaam" class="gemeentefield"/>
                </div>
            </div>
            <div class="row">
                <label>IMRO-nummer</label>
                <div class="input">
                    <stripes:text name="bouwplan.imronummer" class="gemeentefield"/>
                </div>
            </div>
            <div class="row">
                <label>Masterplan</label>
                <div class="input">
                    <stripes:text name="bouwplan.masterplan" class="gemeentefield" />
                </div>
            </div>
            <div class="row">
                <label>Opdrachtgever type</label>
                <div class="input">
                    <stripes:select name="bouwplan.ontwikkelaartype" class="gemeentefield">
                        <stripes:option value="">-- Kies opdracht --</stripes:option>
                        <stripes:options-collection collection="${actionBean.ontwikkelaartypes}" value="id" label="type"/>
                    </stripes:select>
                </div>
            </div>
            <div class="row">
                <label>Opdrachtgever</label>
                <div class="input">
                    <stripes:text name="bouwplan.ontwikkelaar_namelijk" class="gemeentefield" />
                </div>
            </div>
            <div class="row">
                <label for="vertrouwelijk">Vertrouwelijk *</label>
                <div class="input">
                    <stripes:select name="bouwplan.gebruikgegevens" class="gemeentefield">
                        <stripes:option value="">-- Kies gebruikgegevens --</stripes:option>
                        <stripes:options-collection collection="${actionBean.gebruikgegevens}" label="naam" value="id"/>
                    </stripes:select>
                </div>
            </div>
        </div>
        <div id="soortplan" class="block">
            <h2>Soort plan</h2>
            <div class="row">
                <label>Plantype *</label>
                <div class="input">
                    <stripes:select name="bouwplan.plantype" class="gemeentefield">
                        <stripes:option value="">-- Kies plantype --</stripes:option>
                        <stripes:options-collection collection="${actionBean.plantypes}" value="id" label="type"/>
                    </stripes:select>
                </div>
            </div>
            <c:if test="${actionBean.bpOptionalVariables['woonmilieu_abf']}">
            <div class="row">
                <label>Woonmilieu ABF-6</label>
                <div class="input">
                    <stripes:select name="bouwplan.woonmilieu" class="gemeentefield">
                        <stripes:option value="">-- Kies een woonmileu -- </stripes:option>
                        <stripes:options-collection collection="${actionBean.woonmilieus}" value="id" label="type"/>
                    </stripes:select>
                </div>
            </div>
            </c:if>
            <c:if test="${actionBean.bpOptionalVariables['woonmilieu_abf-14']}">
            <div class="row">
                <label>Woonmilieu ABF-14</label>
                <div class="input">
                    <stripes:select name="bouwplan.woonmilieuabf14" class="gemeentefield">
                        <stripes:option>-- Kies een woonmilieu --</stripes:option>
                        <stripes:option>1 Centrum Stedelijk Plus</stripes:option>
                        <stripes:option>2 Centrum Stedelijk</stripes:option>
                        <stripes:option>3 Stedelijk Vooroorlogs</stripes:option>
                        <stripes:option>4 Stedelijk Naoorlogs Compact</stripes:option>
                        <stripes:option>5 Stedelijk Naoorlogs Grondgebonden</stripes:option>
                        <stripes:option>6 Groen Stedelijk</stripes:option>
                        <stripes:option>7 Centrum Klein Stedelijk</stripes:option>
                        <stripes:option>8 Klein Stedelijk</stripes:option>
                        <stripes:option>9 Groen Klein Stedelijk</stripes:option>
                        <stripes:option>10 Centrum Dorps</stripes:option>
                        <stripes:option>11 Dorps</stripes:option>
                        <stripes:option>12 Landelijk Bereikbaar</stripes:option>
                        <stripes:option>13 Landelijk Perifeer</stripes:option>
                        <stripes:option>14 Werkmilieu</stripes:option>
                        <stripes:option>Onbekend</stripes:option>
                    </stripes:select>
                </div>
            </div>
            </c:if>
        </div>
        <div class="block">
            <h2>Locatie</h2>
            <div id="map_thumb"><img src="?bouwplanImage=true&bouwplan=${actionBean.bouwplan.id}" width="370" height="285"/></div>
            <a href="#" id="open-map-button" class="modal-dialog-toggle gemeentefield" data-target="#bewerk-plan">Plan op de kaart bewerken</a>
            <div id="locatie"></div>
        </div>
    </div>
</section>