Ext.define('B3p.planmonitor.DetailPlannerUitgebreid', {
    types: ["Meergezins", "Eengezins", "Onbekend"],
    cols: ["Koop1", "Koop2", "Koop3", "Koop4", "Koop Onb.", "Huur1", "Huur2", "Huur3", "Huur4", "Huur Onb.", "Gerealiseerd"],
    bouwplan: null,
    initCompleted: false,
    tableBody: null,
    totalsCounter: null,
    config: {
        div: null,
        beginYear: null,
        labels:null,
        canEdit:null,
        endYear: null,
        retrieveDetailData: '',
        saveDetailData: ''
    },
    constructor: function(config) {
        this.initConfig(config);
        this.config.labels["Gerealiseerd"] = "Gereal.";
        this.bouwplan = document.getElementById("bouwplanid").value;
        this.initForm();
        if(this.config.canEdit){
            document.getElementById("saveDetailPlanningUitgebreid").addEventListener("click", this.save.bind(this));
        }
        document.getElementById("cancelDetailPlanningUitgebreid").addEventListener("click", this.closeDialog);
        document.getElementById("detailUitgebreidPopupLink").addEventListener("click", this.popupOpen.bind(this));
    },
    popupOpen: function() {
        var begin = parseInt(Ext.get( "jaar_eerste_oplevering").getValue(), 10);
        var end = parseInt(Ext.get( "jaar_laatste_oplevering").getValue(), 10);
        if(!this.initCompleted || this.config.beginYear !== begin || this.config.endYear !== end) {
            this.config.beginYear = begin;
            this.config.endYear = end;
            this.init();
        }
    },
    init: function(){
        Ext.Ajax.request({
            url: this.config.retrieveDetailData,
            scope: this,
            params: {
                bouwplan: this.bouwplan
            },
            success: function (result) {
                var response = Ext.JSON.decode(result.responseText);
                if (response.success) {
                    var d = response.bouwplanvariables;
                    // Process data for easier lookup
                    var data = {};
                    for ( var i = 0 ; i < d.length ;i++){
                        data[d[i].year] = d[i];
                    }
                    this.createForm(data);
                } else {
                }
            },
            failure: function (error) {
            }
        });
    },
    save: function(){
        var bvs = [];
        for(var i = this.config.beginYear ; i <= this.config.endYear ; i ++ ){
            var bv = this.getBouwplanVariable(i);
            bvs.push(bv);
        }
        if(this.bouwplan){
            Ext.Ajax.request({
                url: this.config.saveDetailData,
                scope: this,
                params: {
                    bouwplan: this.bouwplan,
                    detailData: Ext.JSON.encode(bvs)
                },
                success: function (result) {
                    var response = Ext.JSON.decode(result.responseText);
                    if (response.success) {
                        this.updateMainscreen()
                    }
                    this.closeDialog();
                },
                failure: function (error) {
                }
            });
        }else{
            document.getElementById("detailData").value = Ext.JSON.encode(bvs);
            this.updateMainscreen()
            this.closeDialog();
        }
    },
    updateMainscreen : function(){
        var total = this.totalsCounter.getTotal();
        var gerealiseerdTotaal = this.gerealiseerdCounter.getTotal();
        var totalElement = document.getElementById('totaalcapaciteit');
        totalElement.value = total;
        totalElement.readonly = true;

        var gerealiseerdeElement = document.getElementById('gerealiseerdecapaciteit');
        gerealiseerdeElement.value = gerealiseerdTotaal;
        gerealiseerdeElement.readonly = true;

        $(totalElement).change();
    },
    getBouwplanVariable: function (year){
        var lowerCaseName;
        var element;
        var varKey;
        var bouwplanVariable = {
            "year": year
        };
        for(var i = 0; i < this.cols.length; i++) {
            for(var j = 0; j < this.types.length; j++) {
                lowerCaseName = this.classForCol(this.cols[i]);
                element = document.getElementById(lowerCaseName + year + this.types[j].toLowerCase());
                varKey = this.types[j].toLowerCase() + lowerCaseName;
                bouwplanVariable[varKey] = lowerCaseName === 'gerealiseerd' ? element.checked : +(element.value);
            }
        }
        return bouwplanVariable;
    },
    initForm: function() {
        var table = document.createElement ("table");
        table.className = "planning-counter-uitgebreid";
        table.id = "detailsuitgebreidtable";
        this.tableBody = document.createElement("tbody");
        table.appendChild(this.tableBody);
        var tfoot = document.createElement('tfoot');
        tfoot.appendChild(this.createTotal());
        table.appendChild(tfoot);
        var div = document.getElementById(this.config.div);
        div.appendChild(table);
    },
    createForm: function(data) {
        this.initCompleted = true;
        this.clearChildren(this.tableBody);
        var type;
        for (var t = 0; t < this.types.length; t++) {
            this.tableBody.appendChild(this.createSectionHeader(t));
            var colHeaders = this.createHeader();
            colHeaders.className = 'rowcontent row-' + this.types[t].toLowerCase();
            this.tableBody.appendChild(colHeaders);
            for (var i = this.config.beginYear; i <= this.config.endYear; i++) {
                var yearData = data.hasOwnProperty(i) ? data[i] : {};
                var row = this.createRow(i, this.types[t], yearData);
                if(i === this.config.endYear) {
                    row.className += ' last-rowcontent';
                }
                this.tableBody.appendChild(row);
            }
            this.tableBody.appendChild(this.createSectionFooter(t));
            this.tableBody.appendChild(this.createSpacer(t));
        }
        
        var totalClasses = [];
        for (var i = 0; i < this.cols.length; i++) {
            totalClasses.push(this.classForCol(this.cols[i]));
        }
        var type = '';
        for (var t = 0; t < this.types.length; t++) {
            type = this.classForCol(this.types[t]);
            totalClasses.push('type-' + type);
            for (var j = this.config.beginYear; j <= this.config.endYear; j++) {
                totalClasses.push(type + '-year-' + j);
            }
            for (var i = 0; i < this.cols.length; i++) {
                totalClasses.push('type-' + type + '-' + this.classForCol(this.cols[i]));
            }
        }
        this.totalsCounter = Ext.create('B3p.planmonitor.TotalCounter', {
            parent: '.planning-counter-uitgebreid',
            fields: totalClasses,
            total: '.table-total',
            repeatingFields: 4
        });
        this.gerealiseerdCounter = Ext.create('B3p.planmonitor.ConditionalCounter', {
            parent: '.planning-counter-uitgebreid',
            rowSelector: '.inputrow',
            conditionSelector: '.gerealiseerd_checkbox'
        });
    },
    createSectionHeader: function(type) {
        var rowHeader = document.createElement('tr');
        var rowHeaderTd = document.createElement('th');
        var baseClassname = 'rowheader header-' + this.types[type].toLowerCase();
        rowHeaderTd.setAttribute('colspan', this.cols.length + 2); // 2 = Jaar + Subtotal column
        rowHeaderTd.innerHTML = this.types[type];
        rowHeaderTd.setAttribute('data-collapsed', '0');
        rowHeader.className = baseClassname;
        rowHeaderTd.addEventListener('click', (function() {
            var expand = rowHeaderTd.getAttribute('data-collapsed') === '1';
            rowHeader.className = baseClassname + (expand ? '' : ' collapsed');
            rowHeaderTd.setAttribute('data-collapsed', (expand ? '0' : '1'));
        }).bind(this));
        rowHeader.appendChild(rowHeaderTd);
        return rowHeader;
    },
    createSectionFooter: function(type) {
        var rowFooter = document.createElement('tr');
        rowFooter.className = 'rowfooter' + ' footer-' + this.types[type].toLowerCase();
        var rowFooterTd = document.createElement('th');
        rowFooterTd.innerHTML = 'Subtot.';
        rowFooter.appendChild(rowFooterTd);
        for( var i = 0 ; i < this.cols.length ;i++){
            if(this.cols[i] === "Gerealiseerd") {
                rowFooter.appendChild(document.createElement('td'));
            } else {
                rowFooter.appendChild(this.createTotalTD('type-' + this.classForCol(this.types[type]) + '-' + this.classForCol(this.cols[i])));
            }
        }
        rowFooter.appendChild(this.createTotalTD('type-' + this.classForCol(this.types[type])));
        return rowFooter;
    },
    createSpacer: function(type) {
        var rowSpacer = document.createElement('tr');
        rowSpacer.className = 'spacer spacer-' + this.types[type].toLowerCase();
        var rowSpacerTd = document.createElement('td');
        rowSpacerTd.setAttribute('colspan', this.cols.length + 2);
        rowSpacerTd.innerHTML = '&nbsp;';
        rowSpacer.appendChild(rowSpacerTd);
        return rowSpacer;
    },
    createHeader: function(){
        var tr = document.createElement("tr");
        var th = document.createElement("th");
        var label;
        th.innerHTML = "Jaar";
        tr.appendChild(th);
        for( var i = 0 ; i < this.cols.length ;i++){
            th = document.createElement("th");
            label = this.cols[i];
            if(this.config.labels.hasOwnProperty(label)) {
                label = this.config.labels[label];
            }
            th.innerHTML = label;
            th.title = label;
            tr.appendChild(th);
        }
        th = document.createElement("th");
        th.innerHTML = 'Subtot.';
        tr.appendChild(th);
        return tr;
    },
    createTotal: function(){
        var tr = document.createElement ("tr");
        var th = document.createElement("th");
        th.innerHTML = "Totaal";
        tr.appendChild(th);
        for( var i = 0 ; i < this.cols.length ;i++){
            if(this.cols[i] === "Gerealiseerd") {
                tr.appendChild(document.createElement('td'));
            } else {
                tr.appendChild(this.createTotalTD(this.classForCol(this.cols[i])));
            }
        }
        tr.appendChild(this.createTotalTD('table'));
        return tr;
    },
    createTotalTD: function(type){
        var td = document.createElement("td");
        var subtotal = document.createElement("span");
        subtotal.className = "total "+ type + "-total";
        td.appendChild(subtotal);
        return td;
    },
    createRow: function (year, type, yearData){
        var tr = document.createElement ("tr");
        tr.className = 'rowcontent inputrow row-' + type.toLowerCase();
        var td = document.createElement("td");
        td.innerHTML = year === -1 ? "Onbekend" : year;
        tr.appendChild(td);
        for (var i = 0 ; i < this.cols.length ; i ++){
            var col = this.createColumn(year, type, this.cols[i], yearData);
            tr.appendChild(col);
        }
        tr.appendChild(this.createTotalTD(this.classForCol(type) + '-year-' + year));
        return tr;
    },
    createColumn: function(year, type, colName, yearData){
        var lowerCaseName = this.classForCol(colName);
        var typeClass = this.classForCol(type);
        var dataKey = typeClass + lowerCaseName;
        var td = document.createElement("td");
        var inputField = document.createElement("input");
        inputField.id = lowerCaseName + year + type.toLowerCase();
        inputField.name = lowerCaseName + year + type.toLowerCase();
        if(colName === "Gerealiseerd") {
            inputField.className = 'gerealiseerd_checkbox'
            inputField.type = "checkbox";
            inputField.value = '1';
            inputField.checked = yearData.hasOwnProperty(dataKey) && yearData[dataKey];
        } else {
            inputField.type = "text";
            // multiple classes for each 'totals' situation
            inputField.className = "numeric " +
                lowerCaseName + ' '+ // col total
                typeClass + '-year-' + year + ' ' + // row total
                'type-' + typeClass + ' ' +// type total
                'type-' + typeClass + '-' + lowerCaseName; // type col total
            inputField.value = yearData.hasOwnProperty(dataKey) ? yearData[dataKey] : "";
        }
        td.appendChild(inputField);
        return td;
    },
    clearChildren: function(container) {
        if(!container) {
            return;
        }
        while (container.firstChild) {
            container.removeChild(container.firstChild);
        }
    },
    classForCol: function(col) {
        return col.toLowerCase().replace(/[ \.]/ig, '');
    },
    closeDialog : function(){
        $("#detailplanninguitgebreid").dialog("close");
    }
});