Ext.define('B3p.planmonitor.Dropdown', {
    extend: 'Ext.util.Observable',
    toggle: null,
    target: null,
    items: $([]),
    currentValue: '',
    visible: false,
    config: {
        listeners: {},
        toggle: '',
        value: '',
        values: []
    },
    constructor: function(config) {
        this.listeners = config.listeners;
        this.initConfig(config);
        this.callParent(arguments);
        this.initDropDown();
    },
    initDropDown: function() {
        var me = this;
        this.toggle = $(this.config.toggle);
        this.target = $('<ul></ul>').addClass('drop-down');
        for(var i = 0; i < this.config.values.length; i++) {
            this.items = this.items.add(this.createItem(i));
        }
        this.target.append(this.items);
        this.target.insertAfter(this.toggle);
        $('window').on('resize orientationchange', function() {
            me.hideDropDown();
        });
        $(document).on('click touchstart', function() {
            me.hideDropDown();
        });
        this.toggle.on('click touchstart', function(e) {
            e.preventDefault();
            e.stopPropagation();
            me.toggleDropDown();
        });
    },
    createItem: function(i) {
        var me = this;
        return $('<li></li>')
            .html(this.config.values[i].label)
            .attr('title', this.config.values[i].label)
            .addClass(this.config.value === this.config.values[i].value ? 'active' : '')
            .on('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                me.changeValue(me.config.values[i].value, $(this));
            });
    },
    toggleDropDown: function() {
        if(this.visible) {
            this.hideDropDown();
        } else {
            this.showDropDown();
        }
    },
    hideDropDown: function() {
        this.target.hide();
        this.visible = false;
    },
    showDropDown: function() {
        var boundingRect = this.toggle[0].getBoundingClientRect();
        this.target.css({
            'left': (boundingRect.left - 10) + 'px',
            'margin-top': '10px',
            'display': 'block'
        });
        this.visible = true;
    },
    changeValue: function(value, item) {
        this.items.removeClass('active');
        if(this.config.value === value){
            this.config.value = null;
        }else{
            item.addClass('active');
            this.config.value = value;
        }
        this.fireEvent('change', { value: this.config.value });
        this.hideDropDown();
    }
});