/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.tag.BeanFirstPopulationStrategy;
import net.sourceforge.stripes.validation.OneToManyTypeConverter;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import nl.b3p.commons.stripes.CustomPopulationStrategy;
import nl.b3p.pzh.rwbp.entity.BouwplanAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.ConfigurableVariable;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Periode;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariableValue;
import nl.b3p.pzh.rwbp.entity.ProvincieVariable;
import nl.b3p.pzh.rwbp.entity.Regio;
import nl.b3p.pzh.rwbp.entity.VariableType;
import nl.b3p.pzh.rwbp.stripes.ViewerActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StrictBinding
@CustomPopulationStrategy(value=BeanFirstPopulationStrategy.class)
public class AdminFieldsActionBean
extends ViewerActionBean {
    private static final Log log = LogFactory.getLog(AdminFieldsActionBean.class);
    private List<ConfigurableVariable> optionalVars = new ArrayList<ConfigurableVariable>();
    private List<ConfigurableVariable> optionalLabelVars = new ArrayList<ConfigurableVariable>();
    private List<ProvincieVariable> optionalProvincieVars = new ArrayList<ProvincieVariable>();
    private List<ProvincieAdditionalVariable> additionalVars = new ArrayList<ProvincieAdditionalVariable>();
    private List<ProvincieAdditionalVariable> additionalLabels = new ArrayList<ProvincieAdditionalVariable>();
    private final String JSP = "/WEB-INF/jsp/admin/fields.jsp";
    @Validate(converter=OneToManyTypeConverter.class)
    private List<Integer> additionalVarsIndices = new ArrayList<Integer>();
    @Validate
    private Integer[] savedOptVars = new Integer[0];
    @Validate
    private Integer[] savedOptNumVars = new Integer[0];
    private List<Periode> periodes;
    @ValidateNestedProperties(value={@Validate(field="value"), @Validate(field="id")})
    private Map<String, ProvincieVariable> optionalPeriodes = new HashMap<String, ProvincieVariable>();
    @Validate
    private Map<String, String> labelMap = new HashMap<String, String>();
    @Validate
    private String variableJSON;
    private String variables;
    private String labels;
    private String regios;
    @Validate
    private ProvincieAdditionalVariable variable;

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution("/WEB-INF/jsp/admin/fields.jsp");
    }

    public Resolution removeVariable() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", false);
        try {
            EntityManager em = Stripersist.getEntityManager();
            List bpvars = em.createQuery("from BouwplanAdditionalVariable where variable = :variable").setParameter("variable", (Object)this.variable).getResultList();
            for (BouwplanAdditionalVariable bpvar : bpvars) {
                em.remove((Object)bpvar);
            }
            em.remove((Object)this.variable);
            em.getTransaction().commit();
            json.put("success", true);
        }
        catch (Exception e) {
            json.put("message", (Object)"Variable niet verwijderd");
            log.error((Object)"Fout bij verwijderen: ", (Throwable)e);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    public Resolution saveLabel() {
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker ingelogd = (Gebruiker)this.context.getRequest().getUserPrincipal();
        this.gebruiker = (Gebruiker)em.find(Gebruiker.class, (Object)ingelogd.getId());
        Provincie p = this.gebruiker.getProvincie();
        try {
            JSONObject json = new JSONObject(this.variableJSON);
            ProvincieAdditionalVariable pav = null;
            boolean hasId = json.has("id");
            if (hasId) {
                int id = json.getInt("id");
                pav = (ProvincieAdditionalVariable)em.find(ProvincieAdditionalVariable.class, (Object)id);
                List<ProvincieAdditionalVariableValue> oldValues = pav.getValues();
                for (ProvincieAdditionalVariableValue value : oldValues) {
                    em.remove((Object)value);
                }
                pav.setValues(new ArrayList<ProvincieAdditionalVariableValue>());
                em.remove((Object)pav);
            }
            pav = new ProvincieAdditionalVariable();
            this.populatePAV(json, pav, p);
            JSONArray values = json.optJSONArray("values");
            HashSet<Regio> regiosSet = new HashSet<Regio>();
            ArrayList<ProvincieAdditionalVariableValue> newValues = new ArrayList<ProvincieAdditionalVariableValue>();
            for (int i = 0; i < values.length(); ++i) {
                JSONObject valueObject = values.getJSONObject(i);
                ProvincieAdditionalVariableValue pavv = new ProvincieAdditionalVariableValue();
                JSONArray regiosJSON = valueObject.getJSONArray("regios");
                List<Regio> regioListTemp = this.getRegio(regiosJSON);
                regiosSet.addAll(regioListTemp);
                pavv.setRegios(regioListTemp);
                String value = valueObject.getString("value");
                boolean isUseByMunicipalities = this.isUsedByMunicipalities(regiosJSON);
                pavv.setProvincieadditionalvariable(pav);
                pavv.setValue(value);
                pavv.setUsedByMunicipalities(isUseByMunicipalities);
                em.persist((Object)pavv);
                newValues.add(pavv);
            }
            ArrayList<Regio> regioList = new ArrayList<Regio>(regiosSet);
            pav.setRegios(regioList);
            pav.setValues(newValues);
            em.persist((Object)pav);
            em.getTransaction().commit();
            return new StreamingResolution("application/json", (Reader)new StringReader(pav.toJSON(null).toString()));
        }
        catch (JSONException e) {
            log.error((Object)("Cannot save provincieadditionalfield: " + this.variableJSON), (Throwable)e);
            return new ErrorResolution(500);
        }
    }

    public Resolution saveVariable() {
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker ingelogd = (Gebruiker)this.context.getRequest().getUserPrincipal();
        this.gebruiker = (Gebruiker)em.find(Gebruiker.class, (Object)ingelogd.getId());
        Provincie p = this.gebruiker.getProvincie();
        try {
            JSONObject json = new JSONObject(this.variableJSON);
            ProvincieAdditionalVariable pav = null;
            boolean hasId = json.has("id");
            if (hasId) {
                int id = json.getInt("id");
                pav = (ProvincieAdditionalVariable)em.find(ProvincieAdditionalVariable.class, (Object)id);
            } else {
                pav = new ProvincieAdditionalVariable();
            }
            this.populatePAV(json, pav, p);
            JSONArray values = json.optJSONArray("values");
            em.persist((Object)pav);
            List<Regio> regioList = null;
            String type = json.getString("type");
            if (type.equalsIgnoreCase("dropdown")) {
                HashSet<Regio> regiosSet = new HashSet<Regio>();
                ArrayList<ProvincieAdditionalVariableValue> newValues = new ArrayList<ProvincieAdditionalVariableValue>();
                for (int i = 0; i < values.length(); ++i) {
                    JSONObject valueObject = values.getJSONObject(i);
                    ProvincieAdditionalVariableValue pavv = valueObject.has("id") ? (ProvincieAdditionalVariableValue)em.find(ProvincieAdditionalVariableValue.class, (Object)valueObject.getInt("id")) : new ProvincieAdditionalVariableValue();
                    JSONArray regios = valueObject.getJSONArray("regios");
                    List<Regio> regioListTemp = this.getRegio(regios);
                    regiosSet.addAll(regioListTemp);
                    pavv.setRegios(regioListTemp);
                    String value = valueObject.getString("value");
                    boolean isUseByMunicipalities = this.isUsedByMunicipalities(regios);
                    pavv.setProvincieadditionalvariable(pav);
                    pavv.setValue(value);
                    pavv.setUsedByMunicipalities(isUseByMunicipalities);
                    em.persist((Object)pavv);
                    newValues.add(pavv);
                }
                List<ProvincieAdditionalVariableValue> valuesToRemove = pav.getValues();
                valuesToRemove.removeAll(newValues);
                if (!valuesToRemove.isEmpty()) {
                    ArrayList<String> ids = new ArrayList<String>();
                    for (ProvincieAdditionalVariableValue valueToRemove : valuesToRemove) {
                        ids.add("" + valueToRemove.getId());
                    }
                    em.createQuery("DELETE BouwplanAdditionalVariable WHERE variable = :var and variableValue in :list").setParameter("var", (Object)pav).setParameter("list", ids).executeUpdate();
                }
                pav.setValues(newValues);
                for (ProvincieAdditionalVariableValue valueToRemove : valuesToRemove) {
                    em.remove((Object)valueToRemove);
                }
                em.persist((Object)pav);
                regioList = new ArrayList<Regio>(regiosSet);
            } else {
                JSONArray regios = json.getJSONArray("regios");
                regioList = this.getRegio(regios);
                boolean isUseByMunicipalities = this.isUsedByMunicipalities(regios);
                pav.setUsedByMunicipalities(isUseByMunicipalities);
            }
            pav.setRegios(regioList);
            em.persist((Object)pav);
            em.getTransaction().commit();
            return new StreamingResolution("application/json", (Reader)new StringReader(pav.toJSON(null).toString()));
        }
        catch (JSONException ex) {
            log.error((Object)("Cannot save provincieadditionalfield: " + this.variableJSON), (Throwable)ex);
            return new ErrorResolution(500);
        }
    }

    private void populatePAV(JSONObject json, ProvincieAdditionalVariable pav, Provincie p) throws JSONException {
        String naam = json.getString("name");
        String type = json.getString("type");
        String location = json.getString("location");
        boolean additionField = json.optBoolean("addupField", true);
        boolean provinceField = json.optString("provinceField", "nee").equals("ja");
        boolean label = json.optBoolean("label", false);
        pav.setAdditionField(additionField);
        pav.setLocation(location);
        pav.setType(type);
        pav.setProvincie(p);
        pav.setAdditional_variable(naam);
        pav.setProvinceField(provinceField);
        pav.setLabel(label);
    }

    public Resolution save() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker ingelogd = (Gebruiker)this.context.getRequest().getUserPrincipal();
        this.gebruiker = (Gebruiker)em.find(Gebruiker.class, (Object)ingelogd.getId());
        Provincie p = this.gebruiker.getProvincie();
        List varsToBeRemoved = em.createQuery("FROM ConfigurableVariable WHERE type = :optional").setParameter("optional", (Object)VariableType.OPTIONAL).getResultList();
        if (!varsToBeRemoved.isEmpty()) {
            this.optionalProvincieVars = em.createQuery("FROM ProvincieVariable WHERE provincie = :provincie and variable in :vars").setParameter("provincie", (Object)p).setParameter("vars", (Object)varsToBeRemoved).getResultList();
            for (ProvincieVariable provVar : this.optionalProvincieVars) {
                em.remove((Object)provVar);
            }
        }
        if (this.savedOptVars != null) {
            for (int i = 0; i < this.savedOptVars.length; ++i) {
                Integer optVarId = this.savedOptVars[i];
                ConfigurableVariable var = (ConfigurableVariable)em.find(ConfigurableVariable.class, (Object)optVarId);
                ProvincieVariable provVar = new ProvincieVariable();
                provVar.setProvincie(p);
                provVar.setVariable(var);
                em.persist((Object)provVar);
            }
        }
        for (String key : this.labelMap.keySet()) {
            Integer id = Integer.parseInt(key);
            ConfigurableVariable var = (ConfigurableVariable)em.find(ConfigurableVariable.class, (Object)id);
            String value = this.labelMap.get(key);
            ProvincieVariable provVar = new ProvincieVariable();
            provVar.setProvincie(p);
            provVar.setVariable(var);
            provVar.setValue(value);
            em.persist((Object)provVar);
        }
        em.getTransaction().commit();
        SimpleMessage sm = new SimpleMessage("Opslaan gelukt", new Object[0]);
        this.context.getMessages().add(sm);
        this.createLists();
        return new ForwardResolution("/WEB-INF/jsp/admin/fields.jsp");
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    private void createLists() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker ingelogd = (Gebruiker)this.context.getRequest().getUserPrincipal();
        this.gebruiker = (Gebruiker)em.find(Gebruiker.class, (Object)ingelogd.getId());
        Provincie p = this.gebruiker.getProvincie();
        VariableType optional = VariableType.OPTIONAL;
        this.optionalVars = em.createQuery("FROM ConfigurableVariable WHERE type = :type", ConfigurableVariable.class).setParameter("type", (Object)optional).getResultList();
        List vars = em.createQuery("select variable.id FROM ProvincieVariable WHERE variable in :vars and provincie = :provincie").setParameter("vars", this.optionalVars).setParameter("provincie", (Object)p).getResultList();
        this.savedOptVars = vars.toArray(new Integer[vars.size()]);
        this.optionalLabelVars = em.createQuery("FROM ConfigurableVariable WHERE type = :type", ConfigurableVariable.class).setParameter("type", (Object)VariableType.LABEL).getResultList();
        List labelVars = em.createQuery("FROM ProvincieVariable WHERE variable in :vars and provincie = :provincie").setParameter("vars", this.optionalLabelVars).setParameter("provincie", (Object)p).getResultList();
        this.labelMap = new HashMap<String, String>();
        for (Object labelVar : labelVars) {
            this.labelMap.put("" + ((ProvincieVariable)labelVar).getVariable().getId(), ((ProvincieVariable)labelVar).getValue());
        }
        this.additionalVars = em.createQuery("FROM ProvincieAdditionalVariable WHERE provincie = :provincie and label = false order by id").setParameter("provincie", (Object)p).getResultList();
        JSONArray variablesJSON = new JSONArray();
        for (ProvincieAdditionalVariable provincieAdditionalVariable : this.additionalVars) {
            JSONObject var = provincieAdditionalVariable.toJSON(null);
            variablesJSON.put((Object)var);
        }
        this.variables = variablesJSON.toString();
        this.additionalLabels = em.createQuery("FROM ProvincieAdditionalVariable WHERE provincie = :provincie and label = true order by id").setParameter("provincie", (Object)p).getResultList();
        JSONArray labelsJSON = new JSONArray();
        for (ProvincieAdditionalVariable label : this.additionalLabels) {
            JSONObject var = label.toJSON(null);
            labelsJSON.put((Object)var);
        }
        this.labels = labelsJSON.toString();
        List list = em.createQuery("select r from Regio r join r.provincie p where p = :provincie order by r.naam").setParameter("provincie", (Object)p).getResultList();
        JSONArray regioArray = new JSONArray();
        JSONObject rest = new JSONObject();
        rest.put("id", -1);
        rest.put("label", (Object)"Gemeentes");
        regioArray.put((Object)rest);
        for (Regio regio : list) {
            regioArray.put((Object)regio.toJSON());
        }
        this.regios = regioArray.toString();
    }

    private boolean isUsedByMunicipalities(JSONArray regios) throws JSONException {
        for (int j = 0; j < regios.length(); ++j) {
            int regioId = regios.getInt(j);
            if (regioId != -1) continue;
            return true;
        }
        return false;
    }

    private List<Regio> getRegio(JSONArray regios) throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        ArrayList<Regio> regioList = new ArrayList<Regio>();
        for (int j = 0; j < regios.length(); ++j) {
            int regioId = regios.getInt(j);
            if (regioId == -1) continue;
            Regio r = (Regio)em.find(Regio.class, (Object)regioId);
            regioList.add(r);
        }
        return regioList;
    }

    public List<ConfigurableVariable> getOptionalVars() {
        return this.optionalVars;
    }

    public void setOptionalVars(List<ConfigurableVariable> optionalVars) {
        this.optionalVars = optionalVars;
    }

    public List<ProvincieAdditionalVariable> getAdditionalVars() {
        return this.additionalVars;
    }

    public void setAdditionalVars(List<ProvincieAdditionalVariable> additionalVars) {
        this.additionalVars = additionalVars;
    }

    public Integer[] getSavedOptVars() {
        return this.savedOptVars;
    }

    public void setSavedOptVars(Integer[] savedOptVars) {
        this.savedOptVars = savedOptVars;
    }

    public List<Integer> getAdditionalVarsIndices() {
        return this.additionalVarsIndices;
    }

    public void setAdditionalVarsIndices(List<Integer> additionalVarsIndices) {
        this.additionalVarsIndices = additionalVarsIndices;
    }

    public Integer[] getSavedOptNumVars() {
        return this.savedOptNumVars;
    }

    public void setSavedOptNumVars(Integer[] savedOptNumVars) {
        this.savedOptNumVars = savedOptNumVars;
    }

    public List<ProvincieVariable> getOptionalProvincieVars() {
        return this.optionalProvincieVars;
    }

    public void setOptionalProvincieVars(List<ProvincieVariable> optionalProvincieVars) {
        this.optionalProvincieVars = optionalProvincieVars;
    }

    public List<Periode> getPeriodes() {
        return this.periodes;
    }

    public void setPeriodes(List<Periode> periodes) {
        this.periodes = periodes;
    }

    public Map<String, ProvincieVariable> getOptionalPeriodes() {
        return this.optionalPeriodes;
    }

    public void setOptionalPeriodes(Map<String, ProvincieVariable> optionalPeriodes) {
        this.optionalPeriodes = optionalPeriodes;
    }

    public String getVariableJSON() {
        return this.variableJSON;
    }

    public void setVariableJSON(String variableJSON) {
        this.variableJSON = variableJSON;
    }

    public String getVariables() {
        return this.variables;
    }

    public void setVariables(String variables) {
        this.variables = variables;
    }

    public String getRegios() {
        return this.regios;
    }

    public void setRegios(String regios) {
        this.regios = regios;
    }

    public ProvincieAdditionalVariable getVariable() {
        return this.variable;
    }

    public void setVariable(ProvincieAdditionalVariable variable) {
        this.variable = variable;
    }

    public Map<String, String> getLabelMap() {
        return this.labelMap;
    }

    public void setLabelMap(Map<String, String> labelMap) {
        this.labelMap = labelMap;
    }

    public List<ConfigurableVariable> getOptionalLabelVars() {
        return this.optionalLabelVars;
    }

    public void setOptionalLabelVars(List<ConfigurableVariable> optionalLabelVars) {
        this.optionalLabelVars = optionalLabelVars;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }
}

