package nl.b3p.pzh.rwbp.entity;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.pzh.rwbp.RWBPSecurityRealm;

/**
 *
 * @author Jytte
 */

@Entity
public class Gebruiker implements Principal{

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;

    private String username;
    private String passwordsalt;
    private String passwordhash;
    private String fullname;
    private String email;
    private String phone;
    private String position;
    private boolean beheerder;
    private boolean rijk;
    @ManyToOne (fetch= FetchType.LAZY)
    @JoinColumn(name="gemeenteid")
    private Gemeente gemeente;

    @ManyToOne (fetch= FetchType.LAZY)
    @JoinColumn(name="regioid")
    private Regio regio;

    @ManyToOne (fetch= FetchType.LAZY)
    @JoinColumn(name="provincieid")
    private Provincie provincie;

    public void changePassword(HttpServletRequest request, String pw) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String salt = RWBPSecurityRealm.generateHexSalt(request);
        String hash = RWBPSecurityRealm.getHexSha1(salt, pw);
        setPasswordsalt(salt);
        setPasswordhash(hash);
    }

    public boolean isBeheerder() {
        return beheerder;
    }

    public void setBeheerder(boolean beheerder) {
        this.beheerder = beheerder;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFullname() {
        return fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public Gemeente getGemeente() {
        return gemeente;
    }

    public void setGemeente(Gemeente gemeente) {
        this.gemeente = gemeente;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getPasswordhash() {
        return passwordhash;
    }

    public void setPasswordhash(String passwordhash) {
        this.passwordhash = passwordhash;
    }

    public String getPasswordsalt() {
        return passwordsalt;
    }

    public void setPasswordsalt(String passwordsalt) {
        this.passwordsalt = passwordsalt;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public Regio getRegio() {
        return regio;
    }

    public void setRegio(Regio regio) {
        this.regio = regio;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Provincie getProvincie() {
        return provincie;
    }

    public void setProvincie(Provincie provincie) {
        this.provincie = provincie;
    }

    public boolean isRijk() {
        return rijk;
    }

    public void setRijk(boolean rijk) {
        this.rijk = rijk;
    }
    
    public String getName() {
        return getUsername();
    }
    
    @Override
    public String toString(){
        return getUsername();
    }
    /**
     * Resolve the provincie of this user.
     * @return the provincie or null if no provincie.
     */
    public Provincie resolveProvincie(){
        Provincie p=null;
        if (this.getProvincie()!=null){
            p = this.getProvincie();
        }else if (this.getGemeente()!=null){
            p = this.getGemeente().getProvincie();
        }else if (this.getRegio()!=null && this.getRegio().getProvincie()!=null &&this.getRegio().getProvincie().size()>0 ){
            p= (Provincie) this.getRegio().getProvincie().toArray()[0];            
        }
        return p;
    }
}
