package nl.b3p.pzh.rwbp.export;

import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.servlet.ServletException;
import nl.b3p.commons.csv.CsvOutputStream;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.pzh.rwbp.entity.Bouwplanopmerking;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.referencing.CRS;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author Jytte
 * @author Meine Toonen meinetoonen@b3partners.nl
 */
public class ExportBouwplannenThread extends Thread {

    private static final Log log = LogFactory.getLog(ExportBouwplannenThread.class);
    private String host = "localhost";
    private String port = "5432";
    private String db = "rwbp";
    private String schema = "public";
    private String username = "rwbp";
    private String pass = "rwbp";
    private String featureTypeIdProperty = "id";
    private String outputExtension = ".shp";
    private Integer[] geselecteerdePlannen;
    private Gebruiker user;
    private String downloadservlet;
    private String mailhost;
    private String sendfrom;
    private String path;
    private boolean toelichting;
    private List<String> csvViews = new ArrayList<String>();
    private boolean exportvolledig;
    private boolean exporteenvoudig;
    private String explanationPath;
    
    
    private SimpleFeatureBuilder featureBuilder;

    public ExportBouwplannenThread(Integer[] geselecteerdePlannen, Gebruiker user, String path, boolean exporteenvoudig, boolean exportvolledig) throws Exception {
        this.geselecteerdePlannen = geselecteerdePlannen;
        this.user = user;
        this.path = path;
        this.host = ExportConfigServlet.getHost();
        this.port = ExportConfigServlet.getPort();
        this.db = ExportConfigServlet.getDb();
        this.schema = ExportConfigServlet.getSchema();
        this.username = ExportConfigServlet.getUsername();
        this.pass = ExportConfigServlet.getPass();
        this.featureTypeIdProperty = ExportConfigServlet.getFeatureTypeIdProperty();
        this.outputExtension = ExportConfigServlet.getOutputExtension();
        this.downloadservlet = ExportConfigServlet.getDownloadservlet();
        this.mailhost = ExportConfigServlet.getMailhost();
        this.sendfrom = ExportConfigServlet.getSendfrom();
        this.explanationPath = ExportConfigServlet.getExplanationPath();
        this.exportvolledig = exportvolledig;
        this.exporteenvoudig = exporteenvoudig;
      
        initExportTypes();
    }

    public void run() {
        Stripersist.requestInit();
        EntityManager em = Stripersist.getEntityManager();
        DataStore sds = null;
        Exception e = null;
        String workingName = null;

        try {
            //maak een working directory aan.
            workingName = ExportConfigServlet.uniqueName(File.separator, "", true);
            File workingDir = new File(workingName);
            boolean dirCreated = workingDir.mkdir();
            if(!dirCreated){
                log.error("Could not crate workingdir: " + workingDir.getAbsolutePath());
            }

            //Haal de data van de source op.
            sds = getSourceDatastore();
            
            if (sds == null) {
                throw new ServletException("Kan geen verbinding maken met bron.");
            }
            if (exportvolledig) {
                createShape(sds, "volledig", workingName);
            }
            if (exporteenvoudig) {
                createShape(sds, "eenvoudig", workingName);
            }

            // maak csv
            for (String view : csvViews) {

                int begin = view.indexOf("_");
                int eind = view.indexOf("_view");
                String type = view.substring(begin + 1, eind);
                String exportType = view.substring(0, begin);

                if (type.equals("opmerking")) {
                    type = "opmerkingen";
                } else if (type.equals("extravelden")) {
                    type = "extravelden";
                } else if (type.equals("aantal")) {
                    type = "aantallen";
                }
                String filename = exportType + "_" + type;

                if (view.indexOf("rapportage") != -1) {
                    filename = type + "_rapportage";
                    exportType = type;
                }

                List priveOpmerkingen = null;
                if (view.equals("volledig_opmerking_view")) {
                    priveOpmerkingen = em.createQuery("from Bouwplanopmerking where gebruiker = :gebruiker and accesslevel.id = :accesslevel")
                            .setParameter("gebruiker", user).setParameter("accesslevel", new Integer(1)).getResultList();
                }

                SimpleFeatureSource sfsCSV = sds.getFeatureSource(view);
                SimpleFeatureType sftCSV = (SimpleFeatureType) sfsCSV.getSchema();
                SimpleFeatureCollection sourceFcCSV = getFeatureCollection(sfsCSV, geselecteerdePlannen);
                
                CsvOutputStream csvWriter = null;
                FeatureIterator fit = null;
                try {
                    fit = sourceFcCSV.features();
                    File typeDir = new File(workingName + File.separator + exportType + File.separator);
                    typeDir.mkdir();
                    File f = new File(typeDir, filename + ".csv");

                    FileWriter fw = new FileWriter(f);
                    csvWriter = new CsvOutputStream(fw, ';', false);

                    //eerst de kolom namen
                    String[] kolommen = null;
                    if (view.equals("volledig_opmerking_view") && priveOpmerkingen != null && priveOpmerkingen.size() > 0) {
                        kolommen = new String[sftCSV.getAttributeCount() + 1];
                        kolommen[kolommen.length - 1] = "prive";
                    } else {
                        kolommen = new String[sftCSV.getAttributeCount()];
                    }

                    for (int i = 0; i < sftCSV.getAttributeCount(); i++) {
                        AttributeDescriptor ad = sftCSV.getDescriptor(i);
                        kolommen[i] = ad.getLocalName();
                    }
                    if (view.indexOf("pertype") == 0) {
                        // Make a descriptive header of the years of the calculations. Only applicable when making a Export per type
                        String[] head = {"", "", "", "", "", "", "","", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "Tot 2015", "", "", "", "", "", "", "", "", "", "2015 - 2019", "", "", "", "", "", "", "", "", "", "2020 - 2024", "", "", "", "", "", "", "", "", "", "2025 - 2029", "", "", "", "", "", "", "", "", "", "2030 en verder"};
                        csvWriter.writeRecord(head);
                    }

                    csvWriter.writeRecord(kolommen);
                    while (fit.hasNext()) {
                        Feature feature = fit.next();
                        String[] values = new String[kolommen.length];
                        boolean emptyOpmerking = true;
                        for (int i = 0; i < kolommen.length; i++) {
                            if (kolommen[i].equals("prive")) {
                                String waarde = "";
                                int bouwplanid = Integer.parseInt(values[0]);
                                for (Iterator op = priveOpmerkingen.iterator(); op.hasNext();) {
                                    Bouwplanopmerking opmerking = (Bouwplanopmerking) op.next();
                                    if (opmerking.getBouwplan().getId().intValue() == bouwplanid) {
                                        waarde = opmerking.getOpmerking();
                                        emptyOpmerking = false;
                                    }
                                }
                                if (waarde != null) {
                                    values[i] = waarde;
                                    if (waarde.contains("\r")) {
                                        waarde = waarde.replaceAll("\r", " ");
                                    }
                                    if (waarde.contains("\n")) {
                                        waarde = waarde.replaceAll("\n", " ");
                                    }
                                } else {
                                    values[i] = "";
                                }
                            } else if (kolommen[i].equals("oplevering")) {
                                Property prop = feature.getProperty(kolommen[i]);
                                if (prop != null && prop.getValue() != null) {
                                    Date datum = (Date) prop.getValue();
                                    SimpleDateFormat sdf = (SimpleDateFormat) SimpleDateFormat.getDateInstance();
                                    sdf.applyPattern("dd-MM-yyyy");
                                    String date = sdf.format(datum);
                                    values[i] = date.toString();
                                    if (i > 0) {
                                        emptyOpmerking = false;
                                    }
                                } else {
                                    values[i] = "";
                                }
                            } else {
                                Property prop = feature.getProperty(kolommen[i]);
                                if (prop != null && prop.getValue() != null) {
                                    String waarde = prop.getValue().toString();
                                    if (waarde.contains("\r")) {
                                        waarde = waarde.replaceAll("\r", " ");
                                    }
                                    if (waarde.contains("\n")) {
                                        waarde = waarde.replaceAll("\n", " ");
                                    }
                                    values[i] = waarde;
                                    if (i > 0) {
                                        emptyOpmerking = false;
                                    }
                                } else {
                                    values[i] = "";
                                }
                            }
                        }
                        if (!emptyOpmerking || !view.equals("volledig_opmerking_view")) {
                            csvWriter.writeRecord(values);
                        }
                    }
                } catch (Exception ex) {
                    log.error("Fout bij maken van csv", ex);
                } finally {
                    if (csvWriter != null) {
                        csvWriter.close();
                    }
                    if(fit != null){
                        fit.close();
                    }
                    
                    //sourceFcCSV.c
                   // sourceFcCSV.close(fit);
                }
            }
        } catch (Exception ex) {
            log.error("Fout bij exporteren", ex);
        } finally {
            sendEmail(workingName, e);
            if (sds != null) {
                sds.dispose();
            }
            Stripersist.requestComplete();
            log.debug("Done with making export files!");
        }
    }

    private void createShape(DataStore sds, String type, String workingName) throws IOException, Exception {
        String featureType = type + "_overzicht_shape_view";
        String filename = type + "_overzicht_shape";
        // Generate the shapefile
        SimpleFeatureSource sfs = sds.getFeatureSource(featureType);
        SimpleFeatureType sft = (SimpleFeatureType) sfs.getSchema();
        SimpleFeatureCollection sourceFc = getFeatureCollection(sfs, geselecteerdePlannen);
        CoordinateReferenceSystem crs = CRS.decode("EPSG:28992");//sft.getCoordinateReferenceSystem();

        // make shape attribute names max length 10
        SimpleFeatureType newFt = fixFeatureType(sft);
        featureBuilder = new SimpleFeatureBuilder(newFt);

        //maak een shape datastore.
        File newShapeFile = new File(workingName + File.separator + type + File.separator + filename + outputExtension);
        File typeDir = new File(workingName + File.separator + type);
        typeDir.mkdir();
        ShapefileDataStore dds = createDestinationDatastore(newShapeFile);
        dds.createSchema(newFt);
        dds.forceSchemaCRS(crs);

        //maak een transactie
        Transaction transaction = new DefaultTransaction("create");
        FeatureStore destFs = (FeatureStore) dds.getFeatureSource(filename);
        destFs.setTransaction(transaction);

        //schrijf de data
        try {
            
            List<SimpleFeature> features = new ArrayList<SimpleFeature>();
            SimpleFeatureIterator it = sourceFc.features();
            while(it.hasNext()){
                SimpleFeature sourceFeature = it.next();
                SimpleFeature destFeature = processFeature(sourceFeature, sft);
                features.add(destFeature);
            }
            SimpleFeatureCollection collection = DataUtilities.collection(features);  
            destFs.addFeatures(collection);
            transaction.commit();
        } catch (Exception exc) {
            log.error("Fout bij schrijven van features naar datastore... Doe rollback", exc);
            transaction.rollback();
            throw exc;
        } finally {
            transaction.close();
            dds.dispose();
        }
        // end of shapefilegeneration
    }

    private void sendEmail(String workingName, Exception e) {
        String prefix = "\\" + File.separator;
        String[] splitWorkingName = workingName.split(prefix);
        String filename = splitWorkingName[splitWorkingName.length - 1];
        String downloadLink = path + downloadservlet + "?filename=" + filename + "&toelichting=" + toelichting;

        String to = user.getEmail();

        Date today = new Date(System.currentTimeMillis());
        String subject = "Export bouwplannen " + FormUtils.DateToString(today, null);
        String body = null;
        if (e != null) {
            body = "De export is mislukt. \nFoutmelding: \n" + e;
        } else {
            body = "<html><body>"
                    + "<p>U kunt nu met de onder staande link de export downloaden."
                    + "<br>Let op! De bestanden worden na het downloaden van de server verwijderd."
                    + "<br>Deze link is dus slechts 1 maal te gebruiken. Tevens dient u ingelogd te zijn. </p>"
                    + "<a href=\"" + downloadLink + "\">Downloaden</a>"
                    + "</body></html>";
        }

        HtmlEmail email = new HtmlEmail();
        try {
            email.setHtmlMsg(body);
            email.addTo(to);
            email.setFrom(sendfrom);
            email.setSubject(subject);
            email.setHostName(mailhost);
            //email.setMsg(body);
            email.send();
        } catch (EmailException ex) {
            log.error("Error bij senden email " + ex);
        }

    }

    private ShapefileDataStore createDestinationDatastore(File file) throws MalformedURLException, IOException {
        String path = file.getAbsolutePath();
        if (!path.toLowerCase().endsWith(".shp")) {
            String newPath;
            if (!file.isDirectory()) {
                newPath = path.substring(0, path.length() - 4) + ".shp";
            } else {
                newPath = path += "shapefile.shp";
            }
            file = new File(newPath);
        }
        DataStoreFactorySpi factory = new ShapefileDataStoreFactory();
        Map params = new HashMap();
        params.put("url", file.toURI().toURL());
        params.put("create spatial index", Boolean.FALSE);
        ShapefileDataStore newDataStore = (ShapefileDataStore) factory.createNewDataStore(params);
        return newDataStore;
    }

    private DataStore getSourceDatastore() throws Exception {
        Map params = new HashMap();

        params.put(PostgisNGDataStoreFactory.DBTYPE.key, "postgis");
        params.put(PostgisNGDataStoreFactory.HOST.key, host);
        params.put(PostgisNGDataStoreFactory.PORT.key, port);
        params.put(PostgisNGDataStoreFactory.DATABASE.key, db);
        params.put(PostgisNGDataStoreFactory.USER.key, username);
        params.put(PostgisNGDataStoreFactory.PASSWD.key, pass);
        params.put(PostgisNGDataStoreFactory.SCHEMA.key, schema);

        return DataStoreFinder.getDataStore(params);
    }

    private SimpleFeatureCollection getFeatureCollection(SimpleFeatureSource fs, Integer[] geselecteerdePlannen) throws IOException {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(GeoTools.getDefaultHints());
        List orFilters = new ArrayList();
        for (int i = 0; i < geselecteerdePlannen.length; i++) {
            try {
                orFilters.add(ff.equals(ff.property(featureTypeIdProperty), ff.literal(geselecteerdePlannen[i])));
            } catch (NumberFormatException nfe) {
                log.error("Kan filter niet toevoegen. Plan: " + geselecteerdePlannen[i] + "is geen int", nfe);
            }
        }
        Filter combinedFilter = ff.or(orFilters);
        return fs.getFeatures(combinedFilter);
    }

    private void initExportTypes() throws Exception {
        if (exportvolledig) {
            csvViews.add("volledig_totaal_uitgebreid_view");
            csvViews.add("volledig_overzicht_additional_variables_view");
        }
    }

    /**
     * Make sure all feature type names have a length of <=10
     */
    private SimpleFeatureType fixFeatureType(SimpleFeatureType sft) {
        SimpleFeatureTypeBuilder schemaBuilder = new SimpleFeatureTypeBuilder();
        schemaBuilder.init(sft);
        List<AttributeDescriptor> attributeDescriptors = new ArrayList<AttributeDescriptor>(sft.getAttributeDescriptors());

        List<String> addedNames = new ArrayList<String>();
        for (int i = 0; i < attributeDescriptors.size(); i++) {
            AttributeDescriptor desc = attributeDescriptors.get(i);
            if (desc.getLocalName().length() > 10) {
                AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
                attributeTypeBuilder.init(desc);
                String newName = desc.getLocalName().substring(0, 10);
                int counter = 0;
                while (addedNames.contains(newName)) {
                    counter++;
                    if (counter == 100) {
                        break;
                    }
                    newName = newName.substring(0, 10 - (("" + counter).length()));
                    newName += counter;
                }
                addedNames.add(newName);
                desc = attributeTypeBuilder.buildDescriptor(newName);
                attributeDescriptors.set(i, desc);
            } else if(desc instanceof GeometryDescriptor){

                AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
                attributeTypeBuilder.init(desc);
                attributeTypeBuilder.setBinding(Polygon.class);
                GeometryType geometryType = attributeTypeBuilder.buildGeometryType();
                desc = attributeTypeBuilder.buildDescriptor( "the_geom",   geometryType ) ;
                attributeDescriptors.set(i, desc);
                addedNames.add(desc.getLocalName());
            }else {
                addedNames.add(desc.getLocalName());
            }
        }
        GeometryDescriptorImpl gdi = null;
        schemaBuilder.setAttributes(attributeDescriptors);
        schemaBuilder.setCRS(sft.getCoordinateReferenceSystem());
        schemaBuilder.setDefaultGeometry(sft.getGeometryDescriptor().getLocalName());

        return schemaBuilder.buildFeatureType();
    }
    
    private SimpleFeature processFeature(SimpleFeature source, SimpleFeatureType newFt){
        for (AttributeDescriptor attributeDescriptor : newFt.getAttributeDescriptors()) {
                Object b = source.getAttribute(attributeDescriptor.getLocalName());
                featureBuilder.add(b);
        }
        
        SimpleFeature feature = featureBuilder.buildFeature(null);
        return feature;
    }
}
