package nl.b3p.pzh.rwbp.stripes;

import java.io.StringReader;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariableValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.tag.BeanFirstPopulationStrategy;
import net.sourceforge.stripes.validation.OneToManyTypeConverter;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import nl.b3p.commons.stripes.CustomPopulationStrategy;
import nl.b3p.pzh.rwbp.entity.BouwplanAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.ConfigurableVariable;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Periode;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.ProvincieVariable;
import nl.b3p.pzh.rwbp.entity.Regio;
import nl.b3p.pzh.rwbp.entity.VariableType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author Meine Toonen meinetoonen@b3partners.nl
 */
@StrictBinding
@CustomPopulationStrategy(BeanFirstPopulationStrategy.class)
public class AdminFieldsActionBean extends ViewerActionBean{

    private static final Log log = LogFactory.getLog(AdminFieldsActionBean.class);
    private List<ConfigurableVariable> optionalVars = new ArrayList<ConfigurableVariable>();
    private List<ConfigurableVariable> optionalLabelVars = new ArrayList<ConfigurableVariable>();
    private List<ProvincieVariable> optionalProvincieVars = new ArrayList<ProvincieVariable>();
    private List<ProvincieAdditionalVariable> additionalVars = new ArrayList<ProvincieAdditionalVariable>();
    private List<ProvincieAdditionalVariable> additionalLabels = new ArrayList<ProvincieAdditionalVariable>();
    private final String JSP = "/WEB-INF/jsp/admin/fields.jsp";

    @Validate(converter=OneToManyTypeConverter.class)
    private List<Integer> additionalVarsIndices = new ArrayList<Integer>();
    
    @Validate
    private Integer[] savedOptVars = new Integer[0];
    @Validate
    private Integer[] savedOptNumVars = new Integer[0];
    
    private List<Periode> periodes;
    
    @ValidateNestedProperties({
        @Validate(field = "value"),
        @Validate(field = "id")
    })
    private Map<String, ProvincieVariable> optionalPeriodes = new HashMap<String, ProvincieVariable>();

    @Validate
    private Map<String, String> labelMap = new HashMap<String,String>();

    @Validate
    private String variableJSON;

    private String variables;

    private String labels;
    
    private String regios;

    @Validate
    private ProvincieAdditionalVariable variable;

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution removeVariable() throws JSONException{
        JSONObject json = new JSONObject();
        json.put("success",false);
        try{
            EntityManager em = Stripersist.getEntityManager();
            List<BouwplanAdditionalVariable> bpvars = em.createQuery("from BouwplanAdditionalVariable where variable = :variable").setParameter("variable", variable).getResultList();

            for (BouwplanAdditionalVariable bpvar : bpvars) {
                em.remove(bpvar);
            }
            em.remove(variable);
            em.getTransaction().commit();
            json.put("success",true);
        }catch (Exception e){
            json.put("message", "Variable niet verwijderd");
            log.error("Fout bij verwijderen: ",e);
        }
        return new StreamingResolution("application/json", new StringReader(json.toString()));
    }

    public Resolution saveLabel(){
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker ingelogd = (Gebruiker) context.getRequest().getUserPrincipal();

        gebruiker = em.find(Gebruiker.class, ingelogd.getId());
        Provincie p = gebruiker.getProvincie();

        try {
            JSONObject json = new JSONObject(variableJSON);
            ProvincieAdditionalVariable pav = null;

            boolean hasId = json.has("id");
            if (hasId) {
                int id = json.getInt("id");
                pav = em.find(ProvincieAdditionalVariable.class, id);
                List<ProvincieAdditionalVariableValue> oldValues = pav.getValues();
                for (ProvincieAdditionalVariableValue value : oldValues) {
                    em.remove(value);
                }
                pav.setValues(new ArrayList<ProvincieAdditionalVariableValue>());
                em.remove(pav);
            }

            pav = new ProvincieAdditionalVariable();
            populatePAV(json, pav, p);

            JSONArray values = json.optJSONArray("values");
//            em.persist(pav);

            Set<Regio> regiosSet = new HashSet<Regio>();
            List<ProvincieAdditionalVariableValue> newValues = new ArrayList<ProvincieAdditionalVariableValue>();

            for (int i = 0; i < values.length(); i++) {
                JSONObject valueObject = values.getJSONObject(i);

                ProvincieAdditionalVariableValue pavv = new ProvincieAdditionalVariableValue();
                
                JSONArray regiosJSON = valueObject.getJSONArray("regios");
                List<Regio> regioListTemp = getRegio(regiosJSON);
                regiosSet.addAll(regioListTemp);
                pavv.setRegios(regioListTemp);

                String value = valueObject.getString("value");
                boolean isUseByMunicipalities = isUsedByMunicipalities(regiosJSON);
                pavv.setProvincieadditionalvariable(pav);
                pavv.setValue(value);

                pavv.setUsedByMunicipalities(isUseByMunicipalities);
                em.persist(pavv);

                newValues.add(pavv);
            }

            List<Regio> regioList = new ArrayList<Regio>(regiosSet);
            pav.setRegios(regioList);
            pav.setValues(newValues);
            em.persist(pav);
            em.getTransaction().commit();

            return new StreamingResolution("application/json", new StringReader(pav
                    .toJSON(null).toString()));
        } catch (JSONException e) {
            log.error("Cannot save provincieadditionalfield: " + variableJSON , e);
        }
        return new ErrorResolution(500);
    }

    public Resolution saveVariable(){
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker ingelogd = (Gebruiker) context.getRequest().getUserPrincipal();

        gebruiker = em.find(Gebruiker.class, ingelogd.getId());
        Provincie p = gebruiker.getProvincie();

        try {

            JSONObject json = new JSONObject(variableJSON);

            ProvincieAdditionalVariable pav = null;
            boolean hasId = json.has("id");
            if(hasId){
                int id = json.getInt("id");
                pav = em.find(ProvincieAdditionalVariable.class, id);
            }else{
                pav = new ProvincieAdditionalVariable();
            }
            
            populatePAV(json,pav, p);

            JSONArray values = json.optJSONArray("values");
            em.persist(pav);

            List<Regio> regioList = null;
            String type = json.getString("type");
            if(type.equalsIgnoreCase("dropdown") ){
                Set<Regio> regiosSet = new HashSet<Regio>();
                List<ProvincieAdditionalVariableValue> newValues = new ArrayList<ProvincieAdditionalVariableValue>();

                for(int i = 0 ; i < values.length() ; i++){
                    JSONObject valueObject = values.getJSONObject(i);

                    ProvincieAdditionalVariableValue pavv;
                    // Update a possible existing ProvincieAdditionalVariableValue.
                    if(valueObject.has("id")){
                        pavv = em.find(ProvincieAdditionalVariableValue.class, valueObject.getInt("id"));
                    }else{
                        pavv = new ProvincieAdditionalVariableValue();
                    }
                    JSONArray regios = valueObject.getJSONArray("regios");
                    List<Regio> regioListTemp = getRegio(regios);
                    regiosSet.addAll(regioListTemp);
                    pavv.setRegios(regioListTemp);

                    String value = valueObject.getString("value");
                    boolean isUseByMunicipalities = isUsedByMunicipalities(regios);
                    pavv.setProvincieadditionalvariable(pav);
                    pavv.setValue(value);

                    pavv.setUsedByMunicipalities(isUseByMunicipalities);
                    em.persist(pavv);

                    newValues.add(pavv);
                }
              
                /**
                 * Here is how it is:
                 * When a user saves a Bouwplan and sets a dropdown (Which is a ProvincieAdditionalVariable, with type dropdown) at that plan, in the database there will be an implicit relation between the value saved at the bouwplan
                 * (BouwplanAdditionalVariable.variableValue -> ProvincieAdditionalVariableValue.id). It's not nice, but it's something (http://pre02.deviantart.net/5612/th/pre/f/2011/289/b/b/it__s_something_by_rober_raik-d4czhxe.png).
                 * So, when an admin removed that variableVALUE (important distinction, read this twice), that implicit relation must be maintained, and updated.
                 * First remove the BouwplanAdditionalVariable which belongs to the edited ProvincieAdditionalVariable and the removed ProvincieAdditionalVariableValue.
                 * After that set the new/updated array of values to the ProvincieAdditionalVariable.
                 * To prevent you hating me, here is a bribe: http://thecatapi.com/api/images/get?format=src&type=gif
                 */
                List<ProvincieAdditionalVariableValue> valuesToRemove = pav.getValues();
                valuesToRemove.removeAll(newValues);
                if(!valuesToRemove.isEmpty()){
                    List<String> ids = new ArrayList<String>();
                    for (ProvincieAdditionalVariableValue valueToRemove : valuesToRemove) {
                        ids.add("" + valueToRemove.getId());
                    }
                    em.createQuery("DELETE BouwplanAdditionalVariable WHERE variable = :var and variableValue in :list")
                            .setParameter("var", pav).setParameter("list", ids).executeUpdate();
                }
                pav.setValues(newValues);

                for (ProvincieAdditionalVariableValue valueToRemove : valuesToRemove) {
                    em.remove(valueToRemove);
                }
                em.persist(pav);
                
                regioList = new ArrayList<Regio>(regiosSet);
            }else{
                JSONArray regios = json.getJSONArray("regios");
                regioList = getRegio(regios);
                boolean isUseByMunicipalities = isUsedByMunicipalities(regios);
                pav.setUsedByMunicipalities(isUseByMunicipalities);
            }
            pav.setRegios(regioList);

            em.persist(pav);
            em.getTransaction().commit();

            return new StreamingResolution("application/json", new StringReader(pav
                    .toJSON(null).toString()));
        } catch (JSONException ex) {
            log.error("Cannot save provincieadditionalfield: " + variableJSON , ex);
        }
        return new ErrorResolution(500);

    }

    private void populatePAV(JSONObject json, ProvincieAdditionalVariable pav, Provincie p) throws JSONException{
        String naam = json.getString("name");
        String type = json.getString("type");
        String location = json.getString("location");
        boolean additionField = json.optBoolean("addupField", true);
        boolean provinceField = json.optString("provinceField", "nee").equals("ja");
        boolean label = json.optBoolean("label", false);

        pav.setAdditionField(additionField);
        pav.setLocation(location);
        pav.setType(type);
        pav.setProvincie(p);
        pav.setAdditional_variable(naam);
        pav.setProvinceField(provinceField);
        pav.setLabel(label);
    }

    public Resolution save() throws JSONException{
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker ingelogd = (Gebruiker) context.getRequest().getUserPrincipal();

        gebruiker = em.find(Gebruiker.class, ingelogd.getId());
        Provincie p = gebruiker.getProvincie();
        List<ConfigurableVariable> varsToBeRemoved = em.createQuery("FROM ConfigurableVariable WHERE type = :optional")
                .setParameter("optional", VariableType.OPTIONAL).getResultList();
        if(! varsToBeRemoved.isEmpty()){
            optionalProvincieVars = em.createQuery("FROM ProvincieVariable WHERE provincie = :provincie and variable in :vars").setParameter("provincie", p).setParameter("vars", varsToBeRemoved).getResultList();
            for (Iterator<ProvincieVariable> it = optionalProvincieVars.iterator(); it.hasNext();) {
                ProvincieVariable provVar = it.next();
                em.remove(provVar);
            }
        }
        if(savedOptVars != null){
            for (int i = 0; i < savedOptVars.length; i++) {
                Integer optVarId = savedOptVars[i];
                ConfigurableVariable var = em.find(ConfigurableVariable.class, optVarId);
                ProvincieVariable provVar = new ProvincieVariable();
                provVar.setProvincie(p);
                provVar.setVariable(var);
                em.persist(provVar);
            }
        }
        
        for (String key : labelMap.keySet()) {
            Integer id = Integer.parseInt(key);
            ConfigurableVariable var = em.find(ConfigurableVariable.class, id);
            
            String value = labelMap.get(key);
            ProvincieVariable provVar = new ProvincieVariable();
            provVar.setProvincie(p);
            provVar.setVariable(var);
            provVar.setValue(value);
            em.persist(provVar);
        }
        
        em.getTransaction().commit();
       
        SimpleMessage sm = new SimpleMessage("Opslaan gelukt");
        context.getMessages().add(sm);
        createLists();
        return new ForwardResolution(JSP);
    }
    
    @Before(stages= LifecycleStage.BindingAndValidation)
    private void createLists() throws JSONException{
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker ingelogd = (Gebruiker) context.getRequest().getUserPrincipal();

        gebruiker = em.find(Gebruiker.class, ingelogd.getId());
        Provincie p = gebruiker.getProvincie();
        VariableType optional = VariableType.OPTIONAL;
        
        optionalVars = em.createQuery("FROM ConfigurableVariable WHERE type = :type", ConfigurableVariable.class).setParameter("type", optional).getResultList();
        List<Integer> vars = em.createQuery("select variable.id FROM ProvincieVariable WHERE variable in :vars and provincie = :provincie")
                .setParameter("vars", optionalVars).setParameter("provincie",p).getResultList();
        savedOptVars = vars.toArray(new Integer[vars.size()]);


        optionalLabelVars = em.createQuery("FROM ConfigurableVariable WHERE type = :type", ConfigurableVariable.class).setParameter("type", VariableType.LABEL).getResultList();
        List<ProvincieVariable> labelVars = em.createQuery("FROM ProvincieVariable WHERE variable in :vars and provincie = :provincie")
                .setParameter("vars", optionalLabelVars).setParameter("provincie",p).getResultList();
        labelMap = new HashMap<String,String>();
        for (ProvincieVariable labelVar : labelVars) {
            labelMap.put(""+labelVar.getVariable().getId(), labelVar.getValue());
        }
        additionalVars = em.createQuery("FROM ProvincieAdditionalVariable WHERE provincie = :provincie and label = false order by id").setParameter("provincie",p).getResultList();
        JSONArray variablesJSON = new JSONArray();
        for (ProvincieAdditionalVariable additionalVar : additionalVars) {
            JSONObject var = additionalVar.toJSON(null);
            variablesJSON.put(var);
        }
        variables = variablesJSON.toString();

        additionalLabels = em.createQuery("FROM ProvincieAdditionalVariable WHERE provincie = :provincie and label = true order by id").setParameter("provincie",p).getResultList();
        JSONArray labelsJSON = new JSONArray();
        for (ProvincieAdditionalVariable label : additionalLabels) {
            JSONObject var = label.toJSON(null);
            labelsJSON.put(var);
        }
        labels = labelsJSON.toString();

        List<Regio> regioList = em.createQuery("select r from Regio r join r.provincie p where p = :provincie order by r.naam").setParameter("provincie",p).getResultList();

        JSONArray regioArray = new JSONArray();
        JSONObject rest = new JSONObject();
        rest.put("id", -1);
        rest.put("label", "Gemeentes");
        regioArray.put(rest);
        for (Regio regio : regioList) {
            regioArray.put(regio.toJSON());
        }
        regios = regioArray.toString();
    }

    private boolean isUsedByMunicipalities(JSONArray regios) throws JSONException {
         for (int j = 0; j < regios.length(); j++) {
            int regioId = regios.getInt(j);
            if(regioId == -1){
                return true;
            }
        }
         return false;
    }

    private List<Regio> getRegio(JSONArray regios) throws JSONException {

        EntityManager em = Stripersist.getEntityManager();
        List<Regio> regioList = new ArrayList<Regio>();
        for (int j = 0; j < regios.length(); j++) {
            int regioId = regios.getInt(j);
            if(regioId == -1){
                continue;
            }
            Regio r = em.find(Regio.class, regioId);
            regioList.add(r);
        }
        return regioList;
    }

    // <editor-fold defaultstate="collapsed" desc="getters en setters">
    public List<ConfigurableVariable> getOptionalVars() {
        return optionalVars;
    }

    public void setOptionalVars(List<ConfigurableVariable> optionalVars) {
        this.optionalVars = optionalVars;
    }

    public List<ProvincieAdditionalVariable> getAdditionalVars() {
        return additionalVars;
    }

    public void setAdditionalVars(List<ProvincieAdditionalVariable> additionalVars) {
        this.additionalVars = additionalVars;
    }

    public Integer[] getSavedOptVars() {
        return savedOptVars;
    }

    public void setSavedOptVars(Integer[] savedOptVars) {
        this.savedOptVars = savedOptVars;
    }

    public List<Integer> getAdditionalVarsIndices() {
        return additionalVarsIndices;
    }

    public void setAdditionalVarsIndices(List<Integer> additionalVarsIndices) {
        this.additionalVarsIndices = additionalVarsIndices;
    }

    public Integer[] getSavedOptNumVars() {
        return savedOptNumVars;
    }

    public void setSavedOptNumVars(Integer[] savedOptNumVars) {
        this.savedOptNumVars = savedOptNumVars;
    }

    public List<ProvincieVariable> getOptionalProvincieVars() {
        return optionalProvincieVars;
    }

    public void setOptionalProvincieVars(List<ProvincieVariable> optionalProvincieVars) {
        this.optionalProvincieVars = optionalProvincieVars;
    }
    // </editor-fold>

    public List<Periode> getPeriodes() {
        return periodes;
    }

    public void setPeriodes(List<Periode> periodes) {
        this.periodes = periodes;
    }

    public Map<String, ProvincieVariable> getOptionalPeriodes() {
        return optionalPeriodes;
    }

    public void setOptionalPeriodes(Map<String, ProvincieVariable> optionalPeriodes) {
        this.optionalPeriodes = optionalPeriodes;
    }

    public String getVariableJSON() {
        return variableJSON;
    }

    public void setVariableJSON(String variableJSON) {
        this.variableJSON = variableJSON;
    }

    public String getVariables() {
        return variables;
    }

    public void setVariables(String variables) {
        this.variables = variables;
    }

    public String getRegios() {
        return regios;
    }

    public void setRegios(String regios) {
        this.regios = regios;
    }

    public ProvincieAdditionalVariable getVariable() {
        return variable;
    }

    public void setVariable(ProvincieAdditionalVariable variable) {
        this.variable = variable;
    }

    public Map<String, String> getLabelMap() {
        return labelMap;
    }

    public void setLabelMap(Map<String, String> labelMap) {
        this.labelMap = labelMap;
    }

    public List<ConfigurableVariable> getOptionalLabelVars() {
        return optionalLabelVars;
    }

    public void setOptionalLabelVars(List<ConfigurableVariable> optionalLabelVars) {
        this.optionalLabelVars = optionalLabelVars;
    }

    public String getLabels() {
        return labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }


}
