/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package nl.b3p.pzh.rwbp.stripes;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.xml.bind.JAXBException;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.BouwplanVariable;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.parse.BouwplanException;
import nl.b3p.pzh.rwbp.parse.Parser;
import nl.b3p.pzh.rwbp.parse.ShapeParser;
import nl.b3p.pzh.rwbp.parse.XMLParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.hibernatespatial.criterion.SpatialRestrictions;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author Roy Braam
 */
@StrictBinding
public class ImportPlanActionBean extends ViewerActionBean{

    private static final Log log = LogFactory.getLog(ImportPlanActionBean.class);
    
    private String JSP = "/WEB-INF/jsp/importplan.jsp";
    @Validate
    private FileBean upload;        

    @DontValidate
    public Resolution importPlan() throws IOException, JAXBException, Exception {
        if (this.upload != null) {            
            Integer stored = 0;
            Parser parser = null;       
            EntityManager em = Stripersist.getEntityManager();
            String contentType = this.upload.getContentType();
            if (contentType.equalsIgnoreCase("text/xml")){
                parser= new XMLParser();     
            }else if (contentType.equalsIgnoreCase("application/zip")
                    || contentType.equalsIgnoreCase("application/x-zip-compressed")
                    || contentType.equalsIgnoreCase("application/octet-stream")
                    ){
                parser= new ShapeParser();
            }else{
                this.getContext().getMessages().add(new SimpleError("Bestandsformaat wordt niet ondersteund: " + contentType));
                log.error("Error tijdens importeren plannen Bestandsformaat wordt niet ondersteund: " + contentType);
                return new ForwardResolution(JSP);
            }
            try {
                List<Bouwplan> bouwplan = parser.parse(this.upload.getInputStream(), gebruiker);
                List<String> uniqueKeys = new ArrayList<String>();
                for (Bouwplan b : bouwplan) { 
                    try{
                        if (!hasImportRights(b,gebruiker)){
                            throw new BouwplanException("U heeft geen rechten om dit plan te importeren");
                        }
                        Geometry gebruikerGeom;
                        if (gebruiker.getProvincie()!=null){
                            gebruikerGeom= gebruiker.getProvincie().getTheGeom();
                        }else if (gebruiker.getGemeente() != null && b.getGemeente().getId() != gebruiker.getGemeente().getId()){
                            throw new BouwplanException("U heeft geen rechten om dit plan te importeren");
                        }else if (gebruiker.getGemeente()==null){
                            throw new BouwplanException("U moet een ingelogd zijn als gemeente om dit plan in te lezen");
                        }else{
                            gebruikerGeom=gebruiker.getGemeente().getTheGeom();
                        }
                        //set current gebruiker
                        b.setGebruiker(gebruiker);
                        //if no gemeente,set one.
                        if (gebruiker.getGemeente()!=null && b.getGemeente()==null){
                            b.setGemeente(gebruiker.getGemeente());
                        }else if (b.getGemeente()==null && b.getThe_geom()!=null){
                            Session sess = (Session) em.getDelegate();
                            Criteria criteria = sess.createCriteria(Gemeente.class);
                            criteria.createCriteria("gemeenteGeom")
                                    .add(Restrictions.isNotNull("theGeom"))
                                    .add(SpatialRestrictions.intersects("theGeom", b.getThe_geom()));
                            List<Gemeente> intersectingGemeente = criteria.list();
                            if (intersectingGemeente.size() >1){                                
                                Gemeente gemeente=null;
                                for (Gemeente g : intersectingGemeente){
                                    if (gemeente==null){
                                        gemeente = g;
                                        continue;
                                    }
                                    double gemeenteOverlap = gemeente.getTheGeom().intersection(b.getThe_geom()).getArea();
                                    double gOverlap = g.getTheGeom().intersection(b.getThe_geom()).getArea();
                                    if (gOverlap>gemeenteOverlap){
                                        gemeente = g;
                                    }                                    
                                }
                                long originalArea = Math.round(b.getThe_geom().getArea());
                                b.setGemeente(gemeente);                                
                                Polygon newGeom = correctGeometry(b.getThe_geom(),gemeente.getTheGeom());                                
                                b.setThe_geom(newGeom);
                                long newArea = Math.round(b.getThe_geom().getArea());
                                this.getContext().getMessages().add(new SimpleMessage("Het plan met de naam '"+b.getNaam()+"' valt over meer dan "
                                        + "1 gemeente. Dit kan komen door teken onnauwkeurigheid. De geometrie van het plan wordt daarom bijgesneden "
                                        + "zodat het past binnen de grenzen van de gemeente waarmee de meeste overlap is.  In dit geval is dat de "
                                        + "gemeente '"+gemeente.getNaam()+"'. De oppervlakte van de geometrie is daarmee verkleind "
                                        + "van ±"+originalArea+"m² naar ±"+newArea+"m²"));
                                //throw new Exception("Het plan valt binnen meerdere gemeenten en kan daarom niet ingelezen worden");
                            }else if (intersectingGemeente.size() ==0){
                                throw new BouwplanException("Het plan valt niet binnen een gemeenten en kan daarom niet ingelezen worden");
                            }else{
                                b.setGemeente(intersectingGemeente.get(0));
                            }
                        }
                        if (b.getThe_geom()!=null){
                            if (!gebruikerGeom.contains(b.getThe_geom())){
                                if (gebruikerGeom.intersects(b.getThe_geom())){
                                    long originalArea = Math.round(b.getThe_geom().getArea());
                                    Polygon newGeom = correctGeometry(b.getThe_geom(),gebruikerGeom);
                                    b.setThe_geom(newGeom);
                                    long newArea = Math.round(b.getThe_geom().getArea());
                                    this.getContext().getMessages().add(new SimpleMessage("Het plan met de naam '"+b.getNaam()+"' ligt niet (geheel) in het gebied waar u "
                                            + "rechten op heeft. De geometrie van het plan wordt daarom bijgesneden zodat het past binnen de grenzen van het gebied "
                                            + "waar u rechten op heeft. Dit kan komen door teken onnauwkeurigheid. De oppervlakte van de "
                                            + "geometrie is daarmee verkleind van ±"+originalArea+"m² naar ±"+newArea+"m²"));
                                }else{
                                    throw new BouwplanException("Het in te lezen plan ligt geheel buiten  het gebied waar u rechten op heeft en kan daarom niet worden ingelezen");
                                }
                            }
                        }
                        if (b.getGemeente()==null){
                            throw new BouwplanException("Er is geen gemeente voor het plan gevonden");
                        }
                         
                        em.flush();                    
                                   
                        em.persist(b);
                        
                        for (BouwplanVariable bouwplanVariable : b.getBouwplanVariables()) {
                            em.persist(bouwplanVariable);
                        }
                        SolrActionBean.addSingleBouwplan(b);
                        stored++;
                    }catch (Exception e){
                        if (e instanceof BouwplanException){  
                            this.getContext().getValidationErrors().addGlobalError(new SimpleError("Fout bij inladen van plan met de naam: "+b.getNaam()+": "+e.getMessage()));
                        }else{
                            throw new Exception("Fout bij inladen van plan met de naam: "+b.getNaam()+": "+e.getMessage(),e);                        
                        }
                    }
                }
                em.flush();
                em.getTransaction().commit();

                this.getContext().getMessages().add(new SimpleMessage("Met success " + stored + " plan(nen) geimporteerd"));
            } catch (Exception e) {
                this.getContext().getMessages().add(new SimpleError(e.getMessage()));
                log.error("Error tijdens importeren plannen", e);
                em.getTransaction().rollback();
            }
        } else {
            this.getContext().getMessages().add(new SimpleError("Geen plan gevonden"));
        }
        return new ForwardResolution(JSP);
    }

    

    @DefaultHandler
    public Resolution defaultHandler() {
        return new ForwardResolution(JSP);
    }

    //<editor-fold defaultstate="collapsed" desc="Getters setters">
    public FileBean getUpload() {
        return upload;
    }

    public void setUpload(FileBean upload) {
        this.upload = upload;
    }
    //</editor-fold>

    private String getUniqueKey(Bouwplan b) {
        if (b.getGemeente() !=null &&
                b.getGemeente().getNaam()!=null && 
                b.getPlanIdentificatie()!=null){
            return ""+b.getGemeente().getNaam()+"_"+b.getPlanIdentificatie();
        }else if (b.getId()!=null){
            return ""+b.getId();
        }else{
            return null;
        }
    }

    private static Polygon correctGeometry(Polygon bouwplanGeom, Geometry gebruikerGeom) throws Exception {
        Geometry g = gebruikerGeom.intersection(bouwplanGeom);
        g.setSRID(bouwplanGeom.getSRID());
        if (g instanceof Polygon){
            return (Polygon)g;
        }else if (g instanceof MultiPolygon){
            MultiPolygon mp = (MultiPolygon)g;
            int largestIndex=0;
            for (int i=1; i < mp.getNumGeometries(); i++){
                Double largestArea=mp.getGeometryN(largestIndex).getArea();
                Double thisArea=mp.getGeometryN(i).getArea();
                if (thisArea > largestArea){
                    largestIndex = i;
                }
            }
            return (Polygon) mp.getGeometryN(largestIndex);
        }else{
            throw new Exception("Geometry past niet binnen gemeente en kan niet worden verkleint. Intersectie met geometry van de gemeente grenzen levert geen (Multi)Polygon op.");
        }
    }
    
    public static boolean hasImportRights(Bouwplan bouwplan, Gebruiker gebruiker) throws Exception{ 
        //only provincies and gemeenten are allowed 
        if (gebruiker.getProvincie()==null && gebruiker.getGemeente()==null){
            return false;
        }        
        //get the most overlapping gemeente
        Gemeente planGemeente=null;
        if (bouwplan.getThe_geom()!=null){
            EntityManager em = Stripersist.getEntityManager();
            Session sess = (Session) em.getDelegate();
            Criteria criteria = sess.createCriteria(Gemeente.class);
            criteria.createCriteria("gemeenteGeom")
                    .add(Restrictions.isNotNull("theGeom"))
                    .add(SpatialRestrictions.intersects("theGeom", bouwplan.getThe_geom()));
            List<Gemeente> intersectingGemeente = criteria.list();
            
            if (intersectingGemeente.size() >1){  
                for (Gemeente g : intersectingGemeente){
                    if (planGemeente==null){
                        planGemeente = g;
                        continue;
                    }
                    double gemeenteOverlap = planGemeente.getTheGeom().intersection(bouwplan.getThe_geom()).getArea();
                    double gOverlap = g.getTheGeom().intersection(bouwplan.getThe_geom()).getArea();
                    if (gOverlap>gemeenteOverlap){
                        planGemeente = g;
                    }                                    
                }                
            }else if (intersectingGemeente.size() ==0){
                planGemeente=null;
            }else{
                planGemeente =intersectingGemeente.get(0);
            }
            
        }else if (bouwplan.getGemeente()!=null){
            planGemeente=bouwplan.getGemeente();
        }        
        if (planGemeente==null){
            return false;
        }
        //if user is of the given gemeente
        if (gebruiker.getGemeente()!=null && gebruiker.getGemeente().getId() == planGemeente.getId()){
            return true;
        }
        //if given gemeente is in provincie
        if (gebruiker.getProvincie()!=null && planGemeente.getProvincie().getId().equals(gebruiker.getProvincie().getId())){
            return true;
        }
        return false;
    }
}
