package nl.b3p.pzh.rwbp.stripes;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.EmailTypeConverter;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.entity.Provincie;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author Jytte
 */

@StrictBinding
public class ProfielActionBean extends ViewerActionBean{
    private static final Log log = LogFactory.getLog(ProfielActionBean.class);
   
    private Long exportAantal;

    @ValidateNestedProperties({
        @Validate(field="username", required=true, maxlength=255),
        @Validate(field="fullname", required=true, maxlength=255),
        @Validate(field="email", required=true, converter=EmailTypeConverter.class, maxlength=255),
        @Validate(field="phone", maxlength=255)
    })
    private Gebruiker gebruiker;
    
    @Validate(maxlength=255)
    private String wachtwoord;

    @Validate
    private boolean sluiten;

    @DefaultHandler
    @DontValidate
    public Resolution profiel() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if(sluiten){
            save();
            context.getRequest().getSession().setAttribute("searchProperties", null);
            return new ForwardResolution(SearchActionBean.class);
        }
        return new ForwardResolution("/WEB-INF/jsp/profiel.jsp");
    }
    
    public Resolution save() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        EntityManager em = Stripersist.getEntityManager();

        if(wachtwoord != null){
            gebruiker.changePassword(context.getRequest(), wachtwoord);
        }

        em.persist(gebruiker);
        em.flush();

        getContext().getMessages().add(new SimpleMessage("Uw gegevens zijn opgeslagen."));

        setNaamGebruiker(gebruiker.getFullname());

        em.getTransaction().commit();
        return new ForwardResolution("/WEB-INF/jsp/profiel.jsp");
    }

    @Before(stages = LifecycleStage.BindingAndValidation)
    public void calcExportAantal(){
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker ingelogd = (Gebruiker) context.getRequest().getUserPrincipal();

        gebruiker = em.find(Gebruiker.class, ingelogd.getId());
        exportAantal = (Long)context.getRequest().getSession().getAttribute("exportAantal");
    }

    // <editor-fold defaultstate="collapsed" desc="getters en setters">
    public boolean isSluiten() {
        return sluiten;
    }

    public void setSluiten(boolean sluiten) {
        this.sluiten = sluiten;
    }
    
    public String getWachtwoord() {
        return wachtwoord;
    }

    public void setWachtwoord(String wachtwoord) {
        this.wachtwoord = wachtwoord;
    }

    public Long getExportAantal() {
        return exportAantal;
    }

    public void setExportAantal(Long exportAantal) {
        this.exportAantal = exportAantal;
    }
    // </editor-fold>

}
