package nl.b3p.pzh.rwbp.stripes.sld;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.stripes.action.*;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.pzh.rwbp.OnzichtbaarWoningBouwplanEntry;
import nl.b3p.pzh.rwbp.SldMapEntry;
import nl.b3p.pzh.rwbp.WoningBouwplanEntry;
import nl.b3p.pzh.rwbp.ZichtbaarWoningBouwplanEntry;
import nl.b3p.pzh.rwbp.stripes.SearchActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@StrictBinding
public class SldFilterActionBean implements ActionBean {

    private static final String ENCODING = "UTF-8";
    private static final Log log = LogFactory.getLog(SldFilterActionBean.class);
    private ActionBeanContext context;
    @Validate
    private String sldkey;
    @Validate
    private String mode;
    
    public static final String OGCNS = "http://www.opengis.net/ogc";
    public static final String SLDNS = "http://www.opengis.net/sld";
    public static final String SENS = "http://www.opengis.net/se";
    public static final String STROKEOPACITY = "stroke-opacity";
    public static final String STROKEWIDTH = "stroke-width";
    public static final String TEXTCOLOR = "fill";
    public static final String HALOCOLOR = "halofill";
    public static final String FILLCOLOR = "fill-color";
    public static final String FILLOPACITY = "fill-opacity";
    public static final String FONTFAMILY = "font-family";
    public static final String FONTSIZE = "font-size";
    public static final int ACTIEF_BOUWPLAN = 1;
    public static final int INACTIEF_BOUWPLAN = 2;
    public static final String INACTIEVE_BOUWPLAN_KLEUR = "#BEC0C0";
    public static String serverUrl = null;

    // <editor-fold defaultstate="collapsed" desc="getters en setters">
    public ActionBeanContext getContext() {
        return context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    
    public String getSldkey() {
        return sldkey;
    }

    public void setSldkey(String sldkey) {
        this.sldkey = sldkey;
    }

    // </editor-fold>
    
    @DefaultHandler
    public Resolution displaySld() throws Exception {

        return new StreamingResolution("text/xml; charset=" + ENCODING) {

            @Override
            public void stream(HttpServletResponse response) throws Exception {
                ServletContext sc = context.getServletContext();
                Map<String, SldMapEntry> sldMap = SearchActionBean.getSldMap(sc);

                SldMapEntry entry = sldMap.get(sldkey);
                if (entry == null) {
                    log.error("Sld niet gevonden met key >" + sldkey + "<. Return null;");
                    throw new Exception("Sld niet gevonden met key >" + sldkey + "<. Return null;");
                }

                OutputStream out = response.getOutputStream();
                try {

                    HttpServletRequest request = context.getRequest();
                    URL url = new URL(request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath() + "/");
                    serverUrl = url.toString();

                    Document doc = getDefaultSld();

                    String cbpids = entry.getCbpids();
                    String obpids = entry.getObpids();
                    String cbpnrs = entry.getCbpnrs();

                    Node root = doc.getDocumentElement();
                    String[] cbpArray = new String[0];
                    String[] obpArray = new String[0];
                    if (obpids != null && obpids.length() != 0) {
                        obpArray = obpids.split(",");
                    }

                    String[] cbpNrsArray = new String[0];
                    if (cbpids != null && cbpids.length() != 0) {
                        cbpArray = cbpids.split(",");
                    }

                    if (cbpnrs != null && cbpnrs.length() != 0) {
                        cbpNrsArray = cbpnrs.split(",");
                    }

                    // Haal de kleuren op voor de cbpids
                    EntityManager em = Stripersist.getEntityManager();
                    // maak de lagen:
                    // haal per laag de zichtbare bouwplannen op, met in ieder geval: voortgang, id
                    // Haal per laag ook de labels op
                    // Haal per laag ook de onzichtbare ids op, met daarin iig de 
                    // maak per laag de verschillende variaties en OR de ids in de rule

                    //make layers and filters
                    String[] layerString = {"bouwplan_openbaar"};
                    String[] layers = new String[entry.getExtraLaag().length+layerString.length]; 
                    String[] filters= new String[layers.length];
                    String generatedFilter = getFilter(entry);
                    for (int i=0; i < layerString.length; i++){
                        layers[i]=layerString[i];
                        filters[i]="gebruikgegevensid = 1 or gebruikgegevensid is null";
                    }
                    for (int i=0; i < entry.getExtraLaag().length; i++){
                        layers[i+layerString.length]=entry.getExtraLaag()[i];
                        filters[i+layerString.length]=generatedFilter;
                    }
                    // onzichtbare ids
                    List<Integer> obpList = new ArrayList<Integer>();
                    for (int j = 0; j < obpArray.length; j++) {
                        String obpId = obpArray[j];
                        Integer val = Integer.valueOf(obpId);
                        obpList.add(val);
                    }

                    List<Integer> cbpList = new ArrayList<Integer>();
                    Map<String, String> koppeling_cbs_nrs = new HashMap<String, String>();
                    for (int j = 0; j < cbpArray.length; j++) {
                        String cbpId = cbpArray[j];
                        Integer val = Integer.valueOf(cbpId);
                        cbpList.add(val);
                        koppeling_cbs_nrs.put(cbpId, cbpNrsArray[j]);
                    }

                    
                    for (int i = 0; i < layers.length; i++) {
                        String laag = layers[i];

                        // De variatielijst is een map met daarin als key de  van de te groeperen SLD Rule's en als value een lijst met de entries
                        // Dit wordt gedaan om het SLD zo klein mogelijk te maken (OR-en van ids)
                        Map<String, List<WoningBouwplanEntry>> variatieLijst = new HashMap<String, List<WoningBouwplanEntry>>();

                        // Zichtbare ids
                        List<Object[]> lijstZichtbaar = new ArrayList<Object[]>();
                        if (cbpList.size() > 0) {
                            String queryString="SELECT id, plantype, naam, statusprojectid FROM bouwplan_view WHERE (id in (:id))";
                            if(!filters[i].isEmpty() ){
                                queryString += "AND (" + filters[i]+")";
                            }
                            Query queryZichtbaar = em.createNativeQuery(
                                    queryString).setParameter("id", cbpList);

                             lijstZichtbaar = (List<Object[]>) queryZichtbaar.getResultList();
                        }
                        if(!lijstZichtbaar.isEmpty()){
                            for (Iterator<Object[]> it = lijstZichtbaar.iterator(); it.hasNext();) {
                                ZichtbaarWoningBouwplanEntry wbe = new ZichtbaarWoningBouwplanEntry();

                                Object[] waarden = it.next();
                                Integer id = (Integer) waarden[0];
                                String plantype = (String) waarden[1];
                                String naam = (String) waarden[2];
                                String label = koppeling_cbs_nrs.get("" + id) + ". " + naam;
                                boolean hatch=false;
       
                                wbe.setId(id);
                     
                                wbe.setKleur(plantype);
                                wbe.setLijnKleur("#FF0000");
                                wbe.setLabel(label);
                                wbe.hasHatch(false);

                                // Identificeer deze variatie dmv status, kleur en of hij een hatch heeft
                                String key = "actief_" + plantype + hatch;

                                if (variatieLijst.containsKey(key)) {
                                    variatieLijst.get(key).add(wbe);
                                } else {
                                    List<WoningBouwplanEntry> entries = new ArrayList<WoningBouwplanEntry>();
                                    entries.add(wbe);
                                    variatieLijst.put(key, entries);
                                }
                            }
                        } else {
                            ZichtbaarWoningBouwplanEntry wbe = new ZichtbaarWoningBouwplanEntry();
                            wbe.setId(-1);
                            wbe.setKleur("FF0000");
                            wbe.setLijnKleur("#FF0000");
                            wbe.setLabel("asdf");
                            List<WoningBouwplanEntry> entries = new ArrayList<WoningBouwplanEntry>();
                            entries.add(wbe);
                            String key = "actief_" + "FF0000" + true;
                            variatieLijst.put(key, entries);
                        }

                        // Onzichtbare ids
                        if (obpList.size() > 0) {

                            String query = "SELECT id, plantype, naam, statusprojectid FROM bouwplan_view WHERE (id in (:id))";
                            if(!filters[i].isEmpty()){
                                query +=  " AND " + filters[i];
                            }
                            Query queryOnzichtbaar = em.createNativeQuery(query).setParameter("id", obpList);

                            List<Object[]> lijstOnzichtbaar = queryOnzichtbaar.getResultList();

                            for (Iterator<Object[]> it = lijstOnzichtbaar.iterator(); it.hasNext();) {
                                Object[] waarden = it.next();

                                Integer id = (Integer) waarden[0];                            
                                boolean hatch=false;
                                String kleur = (String) waarden[1];
                               
                                OnzichtbaarWoningBouwplanEntry wbe = new OnzichtbaarWoningBouwplanEntry();
                                wbe.setId(id);
                                wbe.hasHatch(hatch);
                        
                                wbe.setKleur(kleur);
                                wbe.setLijnKleur("#000000");
                                // Identificeer deze variatie dmv status, kleur en of hij een hatch heeft
                                String key = "inactief_" + kleur + hatch;

                                if (variatieLijst.containsKey(key)) {
                                    variatieLijst.get(key).add(wbe);
                                } else {
                                    List<WoningBouwplanEntry> ids = new ArrayList<WoningBouwplanEntry>();
                                    ids.add(wbe);
                                    variatieLijst.put(key, ids);
                                }
                            }
                        }
                        createLayer(doc, root, variatieLijst, laag);
                    }

                    DOMSource domSource = new DOMSource(root);
                    Transformer optimusPrime = TransformerFactory.newInstance().newTransformer();

                    optimusPrime.transform(domSource, new StreamResult(out));
                } catch (Exception e) {
                    log.error("Fout bij maken sld: ", e);
                    response.setContentType("text/html;charset=UTF-8");
                    PrintWriter pw = new PrintWriter(out);
                    pw.write(e.getMessage());
                } finally {
                    out.close();
                }
            }
        };
    }

    private void createLayer(Document doc, Node root, Map<String, List<WoningBouwplanEntry>> variatieLijst, String laag) throws Exception {
        Node namedLayer = doc.createElementNS(SLDNS, "NamedLayer");
        Node name = doc.createElementNS(SLDNS, "Name");
        name.appendChild(doc.createTextNode(laag));
        namedLayer.appendChild(name);

        Node userStyle = createUserstyle(doc, namedLayer);

        Set<Entry<String, List<WoningBouwplanEntry>>> entries = variatieLijst.entrySet();
        for (Iterator<Entry<String, List<WoningBouwplanEntry>>> it = entries.iterator(); it.hasNext();) {
            Entry<String, List<WoningBouwplanEntry>> entry = it.next();

            createVariatie(doc, entry.getKey(), entry.getValue(), userStyle);
        }
        root.appendChild(namedLayer);
    }

    private Node createUserstyle(Document doc, Node namedLayer) {
        Node userStyle = doc.createElementNS(SLDNS, "UserStyle");
        Node styleName = doc.createElementNS(SLDNS, "Name");
        Node featureTypeStyle = doc.createElementNS(SLDNS, "FeatureTypeStyle");

        styleName.appendChild(doc.createTextNode("nieuweStyle"));
        userStyle.appendChild(styleName);
        userStyle.appendChild(featureTypeStyle);
        namedLayer.appendChild(userStyle);
        return featureTypeStyle;
    }

    private void createVariatie(Document doc, String key, List<WoningBouwplanEntry> woningBouwplannen, Node userStyle) throws Exception {

        String actief = key.substring(0, key.indexOf("_"));
        int relatie = actief.equals("actief") ? 2 : 1;

        boolean isActief = actief.equals("actief");

        if (isActief) {
            for (WoningBouwplanEntry woningbouwplan : woningBouwplannen) {
                ZichtbaarWoningBouwplanEntry wbe = (ZichtbaarWoningBouwplanEntry) woningbouwplan;
                String label = wbe.getLabel();
                Node rule = doc.createElementNS(SLDNS, "Rule");
                Node filter = doc.createElementNS(OGCNS, "Filter");

                Node propertyIsEqualTo = doc.createElementNS(OGCNS, "PropertyIsEqualTo");
                Node propertyName = doc.createElementNS(OGCNS, "PropertyName");
                propertyName.appendChild(doc.createTextNode("id"));
                propertyIsEqualTo.appendChild(propertyName);
                Node literal = doc.createElementNS(OGCNS, "Literal");
                literal.appendChild(doc.createTextNode("" + wbe.getId()));
                propertyIsEqualTo.appendChild(literal);

                filter.appendChild(propertyIsEqualTo);
                rule.appendChild(filter);
                userStyle.appendChild(rule);

                Node polygonSymbolizer = createStylePolygon(doc, relatie, wbe, isActief);
                Node textSymbolizer = createStyleText(doc, label, relatie, isActief);
                rule.appendChild(polygonSymbolizer);
                rule.appendChild(textSymbolizer);
            }
        } else {

            Node rule = doc.createElementNS(SLDNS, "Rule");
            Node filter = doc.createElementNS(OGCNS, "Filter");
            Node connectCheck = filter;
            boolean needsOr = woningBouwplannen.size() > 1;
            if (needsOr) {
                Node or = doc.createElementNS(OGCNS, "Or");
                filter.appendChild(or);
                connectCheck = or;
            }
            for (WoningBouwplanEntry woningbouwplan : woningBouwplannen) {
                OnzichtbaarWoningBouwplanEntry wbe = (OnzichtbaarWoningBouwplanEntry) woningbouwplan;

                Node propertyIsEqualTo = doc.createElementNS(OGCNS, "PropertyIsEqualTo");
                Node propertyName = doc.createElementNS(OGCNS, "PropertyName");
                propertyName.appendChild(doc.createTextNode("id"));
                propertyIsEqualTo.appendChild(propertyName);
                Node literal = doc.createElementNS(OGCNS, "Literal");
                literal.appendChild(doc.createTextNode("" + wbe.getId()));
                propertyIsEqualTo.appendChild(literal);

                connectCheck.appendChild(propertyIsEqualTo);
            }

            rule.appendChild(filter);
            userStyle.appendChild(rule);

            // Maak de polygoonstyle: dit zijn ge-OR-de ids, met allemaal dezelfde styling, dus kan je het eerste woningBouwPlan pakken voor kleur en hatch
            Node polygonsymbolizer = createStylePolygon(doc, relatie, woningBouwplannen.get(0), isActief);
            rule.appendChild(polygonsymbolizer);
        }

    }

    private Node createStylePolygon(Document doc, int relatie, WoningBouwplanEntry wbe, boolean actief) throws Exception {
        String geoProperty = "geom";
        Map<String, String> styles = getStyleMap(actief);

        Node polygonSymbolizer = doc.createElementNS(SLDNS, "PolygonSymbolizer");
        Node geo = doc.createElementNS(SLDNS, "Geometry");
        Node propName = doc.createElementNS(OGCNS, "PropertyName");
        propName.appendChild(doc.createTextNode(geoProperty));
        geo.appendChild(propName);

        Node fill = doc.createElementNS(SLDNS, "Fill");

        Node stroke = doc.createElementNS(SLDNS, "Stroke");
        
        if (wbe.hasHatch()) {
            Node hatch = doc.createElementNS(SLDNS, "GraphicFill");
            Node graphic = doc.createElementNS(SLDNS, "Graphic");
            Node externalGraphic = doc.createElementNS(SLDNS, "ExternalGraphic");
            Element onlineResource = doc.createElementNS(SLDNS, "OnlineResource");
            Node size = doc.createElementNS(SLDNS, "Size");
            size.appendChild(doc.createTextNode("4"));
            String imageName = "%23" + wbe.getKleur().substring(1) + "hatchActive.png";

            onlineResource.setAttribute("xlink:href", serverUrl + "images/" + imageName);

            Node format = doc.createElementNS(SLDNS, "Format");
            format.appendChild(doc.createTextNode("image/png"));
            externalGraphic.appendChild(format);

            externalGraphic.appendChild(onlineResource);
            graphic.appendChild(externalGraphic);
            graphic.appendChild(size);
            hatch.appendChild(graphic);

            fill.appendChild(hatch);
        } else {
            Element cssParamFillColor = doc.createElementNS(SLDNS, "CssParameter");
            cssParamFillColor.setAttribute("name", "fill");
            cssParamFillColor.appendChild(doc.createTextNode(wbe.getKleur()));
            fill.appendChild(cssParamFillColor);
            Element cssParamFillOpacity = doc.createElementNS(SLDNS, "CssParameter");
            cssParamFillOpacity.setAttribute("name", FILLOPACITY);
            cssParamFillOpacity.appendChild(doc.createTextNode(styles.get(FILLOPACITY)));
            fill.appendChild(cssParamFillOpacity);
        }

        Element cssParamStrokeColor = doc.createElementNS(SLDNS, "CssParameter");
        cssParamStrokeColor.setAttribute("name", "stroke");
        cssParamStrokeColor.appendChild(doc.createTextNode(wbe.getLijnKleur()));
        stroke.appendChild(cssParamStrokeColor);
        Element cssParamStrokeOpacity = doc.createElementNS(SLDNS, "CssParameter");
        cssParamStrokeOpacity.setAttribute("name", STROKEOPACITY);
        cssParamStrokeOpacity.appendChild(doc.createTextNode(styles.get(STROKEOPACITY)));
        stroke.appendChild(cssParamStrokeOpacity);

        Element cssParamStrokeWidth = doc.createElementNS(SLDNS, "CssParameter");
        cssParamStrokeWidth.setAttribute("name", STROKEWIDTH);
        cssParamStrokeWidth.appendChild(doc.createTextNode(styles.get(STROKEWIDTH)));
        stroke.appendChild(cssParamStrokeWidth);
        polygonSymbolizer.appendChild(geo);
        polygonSymbolizer.appendChild(fill);

        polygonSymbolizer.appendChild(stroke);

        return polygonSymbolizer;
    }

    private Node createStyleText(Document doc, String text, int relatie, boolean actief) throws Exception {
        Map<String, String> styles = getStyleMap(actief);

        Node textSymbolizer = doc.createElement("TextSymbolizer");
        Node geometry = doc.createElement("Geometry");
        Node propertyName = doc.createElementNS(OGCNS, "PropertyName");
        propertyName.appendChild(doc.createTextNode("geom"));
        geometry.appendChild(propertyName);
        textSymbolizer.appendChild(geometry);

        Node label = doc.createElement("ogc:Label");
        label.appendChild(doc.createTextNode(text));
        Node fakePropertyName = doc.createElement("ogc:PropertyName");
        label.appendChild(fakePropertyName);
        textSymbolizer.appendChild(label);

        Node font = doc.createElement("Font");
        Element cssFontFamily = doc.createElementNS(SLDNS, "CssParameter");
        cssFontFamily.setAttribute("name", FONTFAMILY);
        cssFontFamily.appendChild(doc.createTextNode(styles.get(FONTFAMILY)));
        font.appendChild(cssFontFamily);

        Element cssFontSize = doc.createElementNS(SLDNS, "CssParameter");
        cssFontSize.setAttribute("name", "font-size");
        cssFontSize.appendChild(doc.createTextNode(styles.get(FONTSIZE)));
        font.appendChild(cssFontSize);
        textSymbolizer.appendChild(font);

        Node halo = doc.createElementNS(SLDNS, "Halo");
        Node radius = doc.createElementNS(SLDNS, "Radius");
        radius.appendChild(doc.createTextNode("3"));

        Node haloFill = doc.createElementNS(SLDNS, "Fill");
        Element cssParamHaloFillColor = doc.createElementNS(SLDNS, "CssParameter");
        cssParamHaloFillColor.setAttribute("name", "fill");
        cssParamHaloFillColor.appendChild(doc.createTextNode(styles.get(HALOCOLOR)));
        haloFill.appendChild(cssParamHaloFillColor);
        halo.appendChild(haloFill);
        halo.appendChild(radius);
        textSymbolizer.appendChild(halo);

        Node fill = doc.createElementNS(SLDNS, "Fill");
        Element cssParamFillColor = doc.createElementNS(SLDNS, "CssParameter");
        cssParamFillColor.setAttribute("name", "fill");
        cssParamFillColor.appendChild(doc.createTextNode(styles.get(TEXTCOLOR)));
        fill.appendChild(cssParamFillColor);
        textSymbolizer.appendChild(fill);

        Node labelPlacement = doc.createElement("LabelPlacement");
        Node pointPlacement = doc.createElement("PointPlacement");

        Node displacement = doc.createElement("Displacement");
        Node displacementX = doc.createElement("DisplacementX");
        displacementX.appendChild(doc.createTextNode("10"));
        Node displacementY = doc.createElement("DisplacementY");
        displacementY.appendChild(doc.createTextNode("20"));
        displacement.appendChild(displacementX);
        displacement.appendChild(displacementY);
        pointPlacement.appendChild(displacement);
        Node anchorPoint = doc.createElement("AnchorPoint");
        Node anchorPointX = doc.createElement("AnchorPointX");
        String anchorP = "1.0";

        anchorPointX.appendChild(doc.createTextNode(anchorP));
        Node anchorPointY = doc.createElement("AnchorPointY");
        anchorPointY.appendChild(doc.createTextNode(anchorP));
        anchorPoint.appendChild(anchorPointX);
        anchorPoint.appendChild(anchorPointY);
        pointPlacement.appendChild(anchorPoint);

        labelPlacement.appendChild(pointPlacement);

        textSymbolizer.appendChild(labelPlacement);

        return textSymbolizer;
    }

    private String getFilter(SldMapEntry entry) {
        String filter = "";
        if(entry.getExtraLaag().length != 0 && entry.getExtraLaag()[0] != null){
            String extraLaag = entry.getExtraLaag()[0];
            String rolId = entry.getExtraLaagId();
            if (extraLaag.startsWith("bouwplan_gemeente")) {
                filter = "gemeenteid = " + rolId + " and gebruikgegevensid != 1 or gebruikgegevensid = 4";
            } else if (extraLaag.startsWith("bouwplan_regio")) {
                filter = "regioid = " + rolId + " and (gebruikgegevensid != 3 and gebruikgegevensid != 1 or gebruikgegevensid is null) or gebruikgegevensid = 4";
            } else if (extraLaag.startsWith("bouwplan_provincie")) {
                filter = "provincieid = " + rolId + " and (gebruikgegevensid != 3 and gebruikgegevensid != 1 or gebruikgegevensid is null) or gebruikgegevensid = 4";
            } else if (extraLaag.startsWith("bouwplan_rijk")) {
                filter = "gebruikgegevensid = 4";
            }
        }
        return filter;
    }

    private Map<String, String> getStyleMap(boolean actief) throws Exception {
        Map<String, String> styles = new HashMap<String, String>();

        if (actief) {
            styles.put(FILLCOLOR, "#FF0000");
            styles.put(FILLOPACITY, "0.6");
            styles.put(STROKEOPACITY, "1.0");
            styles.put(STROKEWIDTH, "2.0");
            styles.put(TEXTCOLOR, "#000000");
            styles.put(HALOCOLOR, "#FFFFFF");
            styles.put(FONTFAMILY, "arial");
            styles.put(FONTSIZE, "10");
        } else {

            styles.put(FILLCOLOR, "#999999");
            styles.put(FILLOPACITY, "0.6");
            styles.put(STROKEOPACITY, "1.0");
            styles.put(STROKEWIDTH, "1.0");
        }

        return styles;
    }
    
    private Document getDefaultSld() {
        Document doc = null;

        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();

            ServletContext sc = getContext().getServletContext();
            String p = sc.getRealPath("/WEB-INF/DefaultSld.xml");
            File f = new File(p);

            doc = db.parse(f);
        } catch (Exception e) {
            log.error(e.getMessage());
        }

        return doc;
    }
}
