<%@include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@page contentType="text/html" session="false" pageEncoding="UTF-8"%>

<stripes:layout-render name="/WEB-INF/jsp/templates/tabTemplate.jsp" pageTitle="Beheer">
    <stripes:layout-component name="content">
        <stripes:form id="serviceForm" beanclass="nl.b3p.pzh.rwbp.stripes.AdminServicesActionBean">
            <div class="editform">
                <table class="exporttablehead" style="width: 1222px; margin-top: 0px;">
                    <tr>
                        <th style="width: 100px;">Naam</th>
                        <th style="width: 250px;">URL</th>
                        <th style="width: 256px;">Layers</th>
                        <th style="width: 32px">&nbsp;</th>
                        <th style="width: 42px">&nbsp;</th>
                    </tr>
                </table>
                <div class="scroll" id="scrolldiv" style="width: 1222px;height:350px;">
                    <table class="exporttablebody" id="exporttablebody" style="width: 1205px;">
                        <c:if test="${not empty actionBean.services}">
                            <c:set var="style" value="odd"/>
                            <c:forEach var="service" items="${actionBean.services}">
                                <tr class="${style}">
                                    <td style="padding-left: 2px; width: 98px;">
                                        <c:out value="${service.name}"/>
                                    </td>
                                    <td style="width: 250px;">
                                        <stripes:link beanclass="nl.b3p.pzh.rwbp.stripes.AdminServicesActionBean" event="selectService">
                                            <stripes:param name="serviceid" value="${service.id}"/>
                                            <c:out value="${service.url}"/>
                                        </stripes:link>
                                    </td>
                                    <td style="width: 256px;"><c:out value="${service.layers}"/></td>
                                    <td style="width: 32px;"> 
                                        <stripes:link beanclass="nl.b3p.pzh.rwbp.stripes.AdminServicesActionBean" onclick="return confirm('Weet u zeker dat u deze service wilt verwijderen?');" event="delete"><stripes:param name="serviceid" value="${service.id}"/><img src="./images/delete.png" alt="delete" /></stripes:link>
                                    </td>
                                    <td style="width: 42px;"></td>
                                </tr>
                                <c:choose>
                                    <c:when test="${style == 'odd'}">
                                        <c:set var="style" value="even"/>
                                    </c:when>
                                    <c:otherwise>
                                        <c:set var="style" value="odd"/>
                                    </c:otherwise>
                                </c:choose>
                            </c:forEach>
                        </c:if>
                    </table>
                </div>

                <div style="float: left; width: 400px;">
                    <p style="color:red"><stripes:errors/></p>
                    <p style="color:green"><stripes:messages/></p>
                    <strong>Servicegegevens</strong>
                    <table>
                        <stripes:hidden name="serviceid" value="${actionBean.serviceid}"/>
                        <tr>
                            <td>URL</td><td><stripes:text name="service.url"></stripes:text></td>
                        </tr>
                        <tr>
                            <td>Lagen</td><td><stripes:text name="service.layers"></stripes:text></td>
                        </tr>
                        <tr>
                            <td>Standaard aan</td><td><stripes:checkbox name="service.defaultOn"></stripes:checkbox></td>
                        </tr>
                        <tr>
                            <td>Naam</td><td><stripes:text name="service.name"></stripes:text></td>
                        </tr>
                        <tr>
                            <td><stripes:submit name="save"  class="inputbutton menubutton" style="width: auto;">Opslaan</stripes:submit></td>
                        </tr>
                    </table>
                </div>
            </div>
        </stripes:form>
    </stripes:layout-component>
</stripes:layout-render>
