<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.1"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">

    <xsl:import href="legend.xsl"/>

    <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>

    <xsl:param name="versionParam" select="'1.0'"/>

    <xsl:variable name="map-width-px" select="'237'"/>
    <xsl:variable name="map-height-px" select="'200'"/>

    <!-- See legend.xsl (does not currently affect size of other elements!) -->
    <xsl:variable name="legend-width-cm" select="5.6"/>
    <!-- See legend.xsl ('none', 'before', 'right') -->
    <xsl:variable name="legend-labels-pos" select="'before'"/>
    <xsl:variable name="legend-scale-images-same-ratio" select="true()"/>
    <xsl:attribute-set name="legend-attributes">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
    </xsl:attribute-set>

    <!-- formatter -->
    <xsl:decimal-format name="MyFormat" decimal-separator="." grouping-separator=","
    infinity="INFINITY" minus-sign="-" NaN="Not a Number" percent="%" per-mille="m"
    zero-digit="0" digit="#" pattern-separator=";" />

    <!-- includes -->
    <xsl:include href="calc.xsl"/>
    <xsl:include href="styles.xsl"/>

    <!-- master set -->
    <xsl:template name="layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="a4-staand" page-height="297mm" page-width="210mm" margin-top="0.4cm" margin-bottom="0.4cm" margin-left="0.4cm" margin-right="0.4cm">
                <fo:region-body region-name="body"/>
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:template>

    <!-- root -->
    <xsl:template match="printInfoList">
        <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xlink="http://www.w3.org/1999/xlink">
            <xsl:call-template name="layout-master-set"/>
            <fo:page-sequence master-reference="a4-staand">
                    <fo:flow flow-name="body">
                        <xsl:for-each select="info">
                            <xsl:call-template name="title-block"/>
                            <xsl:call-template name="basisgegevens"/>
                            <xsl:call-template name="Soortplan"/>
                            <fo:block-container width="8.8cm" height="9.5cm" top="11.5cm" left="0cm" xsl:use-attribute-sets="column-block-data">
                                <xsl:call-template name="map-block"/>
                            </fo:block-container>
                            <xsl:call-template name="Voortgang"/>
                            <fo:block page-break-before="always"> </fo:block>
                            <xsl:call-template name="Aantallen"/>
                            <xsl:call-template name="Woningtypen"/>
                            <xsl:call-template name="KoopHuur"/>
                            <xsl:call-template name="Overig"/>
                            <xsl:call-template name="BijzondereWoningen"/>
                            <xsl:call-template name="disclaimer-block"/>

                            <xsl:call-template name="disclaimer-block"/>
                            <xsl:if test="following-sibling::info">
                                <fo:block page-break-before="always"> </fo:block>
                            </xsl:if>
                        </xsl:for-each>
                    </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>

    <!-- blocks -->
    <xsl:template name="title-block">
        <fo:block-container width="20.45cm" height="1.5cm" top="0cm" left="0cm" background-color="#FFFFFF" xsl:use-attribute-sets="column-block">
            <fo:block margin-left="0.2cm" margin-top="0.5cm" xsl:use-attribute-sets="title-font">
                <xsl:value-of select="title"/>
            </fo:block>
        </fo:block-container>
    </xsl:template>

    <xsl:template name="basisgegevens"  >
        <fo:block-container width="8.8cm" height="9.5cm" top="1.6cm" left="0cm" xsl:use-attribute-sets="column-block-data">
            <fo:block margin-left="0.2cm" margin-top="0.5cm" xsl:use-attribute-sets="title-font" font-weight="bold">
                Basisgegevens
            </fo:block>
            <fo:block margin-left="0.2cm" margin-top="0cm" xsl:use-attribute-sets="default-font" font-size="10pt" >
                <fo:table>
                    <fo:table-body>
                        <xsl:for-each select="extra/info[@classname='basisgegevens']/root">
                          <fo:table-row><fo:table-cell><fo:block font-weight="bold">Plannaam</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Plannaam"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Gemeente</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Gemeente"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Plaatsnaam</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Plaatsnaam"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Referentienummer</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Referentienummer"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Bestemmingsplan</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Bestemmingsplan"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">IMRO-nummer</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="IMRO-nummer"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Masterplan</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Masterplan"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Opdrachtgever type</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Opdrachtgevertype"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Opdrachtgever</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Opdrachtgever"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Vertrouwelijk</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Vertrouwelijk"/></fo:block></fo:table-cell></fo:table-row>
                        </xsl:for-each>
                        <xsl:call-template name="additionalVars">
                            <xsl:with-param name="location" select="'basisgegevens'"></xsl:with-param>
                        </xsl:call-template>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:block-container>
    </xsl:template>

    <xsl:template name="Soortplan">
        <fo:block-container width="8.8cm" height="9.5cm" top="1.6cm" left="9cm" xsl:use-attribute-sets="column-block-data">
            <fo:block margin-left="0.2cm" margin-top="0.5cm" xsl:use-attribute-sets="title-font" font-weight="bold">
                Soort plan
            </fo:block>
            <fo:block margin-left="0.2cm" margin-top="0cm" xsl:use-attribute-sets="default-font" font-size="10pt" >
                <fo:table>
                    <fo:table-body>
                        <xsl:for-each select="extra/info[@classname='Soortplan']/root">
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Plantype</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Plantype"/></fo:block></fo:table-cell></fo:table-row>
                        </xsl:for-each>
                        <xsl:call-template name="additionalVars">
                            <xsl:with-param name="location" select="'soortplan'"></xsl:with-param>
                        </xsl:call-template>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:block-container>
    </xsl:template>

    <xsl:template name="Voortgang">
        <fo:block-container width="8.8cm" height="9.5cm" top="11.6cm" left="9cm" xsl:use-attribute-sets="column-block-data">
            <fo:block margin-left="0.2cm" margin-top="0.5cm" xsl:use-attribute-sets="title-font" font-weight="bold">
                Voortgang
            </fo:block>
            <fo:block margin-left="0.2cm" margin-top="0cm" xsl:use-attribute-sets="default-font" font-size="10pt" >
                <fo:table>
                    <fo:table-body>
                        <xsl:for-each select="extra/info[@classname='Voortgang']/root">
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Status planologisch</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Statusplanologisch"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Status project</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Statusproject"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Knelpunten</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Knelpunten"/></fo:block></fo:table-cell></fo:table-row>
                        </xsl:for-each>
                        <xsl:call-template name="additionalVars">
                            <xsl:with-param name="location" select="'voortgang'"></xsl:with-param>
                        </xsl:call-template>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:block-container>
    </xsl:template>

    <xsl:template name="Aantallen">
        <fo:block-container width="8.8cm" height="9.5cm" top="1.6cm" left="0cm" xsl:use-attribute-sets="column-block-data">
            <fo:block margin-left="0.2cm" margin-top="0.5cm" xsl:use-attribute-sets="title-font" font-weight="bold">
                Aantallen
            </fo:block>
            <fo:block margin-left="0.2cm" margin-top="0cm" xsl:use-attribute-sets="default-font" font-size="10pt" >
                <fo:table>
                    <fo:table-body>
                        <xsl:for-each select="extra/info[@classname='Aantallen']/root">
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Eerste oplevering</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="eersteoplevering"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Laatste oplevering</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="laatsteoplevering"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Restcapaciteit</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="restcapaciteit"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Resterende sloop</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="resterendesloop"/></fo:block></fo:table-cell></fo:table-row>
                        </xsl:for-each>
                        <xsl:call-template name="additionalVars">
                            <xsl:with-param name="location" select="'aantallenenplanning'"></xsl:with-param>
                        </xsl:call-template>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:block-container>
    </xsl:template>

    <xsl:template name="Woningtypen">
        <fo:block-container width="8.8cm" height="9.5cm" top="1.6cm" left="9cm" xsl:use-attribute-sets="column-block-data">
            <fo:block margin-left="0.2cm" margin-top="0.5cm" xsl:use-attribute-sets="title-font" font-weight="bold">
                Woningtypen
            </fo:block>
            <fo:block margin-left="0.2cm" margin-top="0cm" xsl:use-attribute-sets="default-font" font-size="10pt" >
                <fo:table>
                    <fo:table-body>
                        <xsl:for-each select="extra/info[@classname='Woningtypen']/root">
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Meergezinswoningen</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Meergezins"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Eengezinswoningen</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Eengezins"/></fo:block></fo:table-cell></fo:table-row>
                            <fo:table-row><fo:table-cell><fo:block font-weight="bold">Onbekend</fo:block></fo:table-cell><fo:table-cell><fo:block><xsl:value-of select="Woningtypeonbekend"/></fo:block></fo:table-cell></fo:table-row>
                        </xsl:for-each>
                        <xsl:call-template name="additionalVars">
                            <xsl:with-param name="location" select="'woningtypen'"></xsl:with-param>
                        </xsl:call-template>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:block-container>
    </xsl:template>

    <xsl:template name="KoopHuur">
        <fo:block-container width="10.8cm" height="9.5cm" top="11.6cm" left="0cm" xsl:use-attribute-sets="column-block-data">
            <fo:block-container width="5.4cm" left="0cm" border-right-color="#FAFAFA" xsl:use-attribute-sets="column-block-data" border-bottom-color="#FAFAFA">
                <fo:block margin-left="0.2cm" margin-top="0.5cm" xsl:use-attribute-sets="title-font" font-weight="bold">
                    Koop
                </fo:block>
                <fo:block margin-left="0.2cm" margin-top="0cm" xsl:use-attribute-sets="default-font" font-size="10pt" >
                    <fo:table>
                        <fo:table-column column-width="80%"/>
                        <fo:table-column column-width="20%"/>
                        <fo:table-body>
                            <xsl:for-each select="extra/info[@classname='Koop']/root">
                                <fo:table-row><fo:table-cell><fo:block font-weight="bold"><xsl:value-of select="//printInfoList/info/extra/info[@classname='AdditionalVariables']/root/labels/Koop1"/></fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Koop1"/></fo:block></fo:table-cell></fo:table-row>
                                <fo:table-row><fo:table-cell><fo:block font-weight="bold"><xsl:value-of select="//printInfoList/info/extra/info[@classname='AdditionalVariables']/root/labels/Koop2"/></fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Koop2"/></fo:block></fo:table-cell></fo:table-row>
                                <fo:table-row><fo:table-cell><fo:block font-weight="bold"><xsl:value-of select="//printInfoList/info/extra/info[@classname='AdditionalVariables']/root/labels/Koop3"/></fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Koop3"/></fo:block></fo:table-cell></fo:table-row>
                                <fo:table-row><fo:table-cell><fo:block font-weight="bold"><xsl:value-of select="//printInfoList/info/extra/info[@classname='AdditionalVariables']/root/labels/Koop4"/></fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Koop4"/></fo:block></fo:table-cell></fo:table-row>
                                <fo:table-row><fo:table-cell><fo:block font-weight="bold">Onbekend</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Kooponbekend"/></fo:block></fo:table-cell></fo:table-row>
                                <fo:table-row><fo:table-cell><fo:block font-weight="bold">Subtotaal</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Kooptotaal"/></fo:block></fo:table-cell></fo:table-row>
                            </xsl:for-each>
                        </fo:table-body>
                    </fo:table>
                </fo:block>
            </fo:block-container>
            <fo:block-container width="5.4cm" left="5.4cm" border-left-color="#FAFAFA" xsl:use-attribute-sets="column-block-data" border-bottom-color="#FAFAFA">
                <fo:block margin-left="0.2cm" margin-top="0.5cm" xsl:use-attribute-sets="title-font" font-weight="bold">
                    Huur
                </fo:block>
                <fo:block margin-left="0.2cm" margin-top="0cm" xsl:use-attribute-sets="default-font" font-size="10pt" >
                    <fo:table>
                        <fo:table-column column-width="80%"/>
                        <fo:table-column column-width="20%"/>
                        <fo:table-body>
                            <xsl:for-each select="extra/info[@classname='Huur']/root">
                                <fo:table-row><fo:table-cell><fo:block font-weight="bold"><xsl:value-of select="//printInfoList/info/extra/info[@classname='AdditionalVariables']/root/labels/Huur1"/></fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Huur1"/></fo:block></fo:table-cell></fo:table-row>
                                <fo:table-row><fo:table-cell><fo:block font-weight="bold"><xsl:value-of select="//printInfoList/info/extra/info[@classname='AdditionalVariables']/root/labels/Huur2"/></fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Huur2"/></fo:block></fo:table-cell></fo:table-row>
                                <fo:table-row><fo:table-cell><fo:block font-weight="bold"><xsl:value-of select="//printInfoList/info/extra/info[@classname='AdditionalVariables']/root/labels/Huur3"/></fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Huur3"/></fo:block></fo:table-cell></fo:table-row>
                                <fo:table-row><fo:table-cell><fo:block font-weight="bold"><xsl:value-of select="//printInfoList/info/extra/info[@classname='AdditionalVariables']/root/labels/Huur4"/></fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Huur4"/></fo:block></fo:table-cell></fo:table-row>
                                <fo:table-row><fo:table-cell><fo:block font-weight="bold">Onbekend</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Huuronbekend"/></fo:block></fo:table-cell></fo:table-row>
                                <fo:table-row><fo:table-cell><fo:block font-weight="bold">Subtotaal</fo:block></fo:table-cell><fo:table-cell><fo:block> <xsl:value-of select="Huurtotaal"/></fo:block></fo:table-cell></fo:table-row>
                            </xsl:for-each>
                         </fo:table-body>
                    </fo:table>
                </fo:block>
            </fo:block-container>
            <fo:block-container width="10.8cm" height="2.75cm" top="6.8cm" border-top-color="#FAFAFA" xsl:use-attribute-sets="column-block-data">
                <fo:block font-weight="bold">
                    Totaal <xsl:value-of select="extra/info[@classname='Huur']/root/Huurtotaal + extra/info[@classname='Koop']/root/Kooptotaal"/>
                </fo:block>
            </fo:block-container>
        </fo:block-container>
    </xsl:template>

    <xsl:template name="Overig">
        <fo:block-container width="6.8cm" height="9.5cm" top="11.6cm" left="11cm" xsl:use-attribute-sets="column-block-data">
            <fo:block margin-left="0.2cm" margin-top="0.5cm" xsl:use-attribute-sets="title-font" font-weight="bold">
                Overig
            </fo:block>
            <fo:block margin-left="0.2cm" margin-top="0cm" xsl:use-attribute-sets="default-font" font-size="10pt" >
                <xsl:for-each select="extra/info[@classname='Overig']/root">
                    <fo:block font-weight="bold">Opmerkingen</fo:block><fo:block> <xsl:value-of select="opmerking"/></fo:block>
                </xsl:for-each>

                <xsl:if test="//printInfoList/info/extra/info[@classname='AdditionalVariables']/root/overig != ''">
                    <fo:table>
                        <fo:table-column column-width="80%"/>
                        <fo:table-column column-width="20%"/>
                        <fo:table-body>
                            <xsl:call-template name="additionalVars">
                                <xsl:with-param name="location" select="'overig'"></xsl:with-param>
                            </xsl:call-template>
                        </fo:table-body>
                    </fo:table>
                </xsl:if>
            </fo:block>
        </fo:block-container>
    </xsl:template>

    <xsl:template name="BijzondereWoningen">
        <xsl:if test="//printInfoList/info/extra/info[@classname='AdditionalVariables']/root/bijzonderewoningen != ''">
            <fo:block page-break-before="always"> </fo:block>
            <fo:block-container width="8.8cm" height="9.5cm" top="1.6cm" left="0cm" xsl:use-attribute-sets="column-block-data">
                <fo:block margin-left="0.2cm" margin-top="0.5cm" xsl:use-attribute-sets="title-font" font-weight="bold">
                    Bijzondere woningen
                </fo:block>
                <fo:block margin-left="0.2cm" margin-top="0cm" xsl:use-attribute-sets="default-font" font-size="10pt" >
                    <fo:table>
                        <fo:table-column column-width="80%"/>
                        <fo:table-column column-width="20%"/>
                        <fo:table-body>
                            <xsl:call-template name="additionalVars">
                                <xsl:with-param name="location" select="'bijzonderewoningen'"></xsl:with-param>
                            </xsl:call-template>
                        </fo:table-body>
                    </fo:table>
                </fo:block>
            </fo:block-container>
        </xsl:if>
    </xsl:template>

    <xsl:template name="additionalVars">
        <xsl:param name="location"/>
        <xsl:for-each select="//printInfoList/info/extra/info[@classname='AdditionalVariables']/root/*[name()=$location]">
            <fo:table-row>
                <fo:table-cell><fo:block font-weight="bold"><xsl:value-of select="var"/></fo:block></fo:table-cell><fo:table-cell><fo:block><xsl:value-of select="value"/></fo:block></fo:table-cell>
            </fo:table-row>
        </xsl:for-each>
    </xsl:template>

    <!-- create map -->
    <xsl:template name="map-block">
        <xsl:variable name="bbox-corrected">
            <xsl:call-template name="correct-bbox">
                <xsl:with-param name="bbox" select="bbox"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="px-ratio" select="format-number($map-height-px div $map-width-px,'0.##','MyFormat')" />
        <xsl:variable name="map-height-px-corrected" select="quality"/>
        <xsl:variable name="map-width-px-corrected" select="format-number(quality div $px-ratio,'0','MyFormat')"/>
        <xsl:variable name="map">
            <xsl:value-of select="imageUrl"/>
            <xsl:text>&amp;width=</xsl:text>
            <xsl:value-of select="$map-width-px-corrected"/>
            <xsl:text>&amp;height=</xsl:text>
            <xsl:value-of select="$map-height-px-corrected"/>
            <xsl:text>&amp;bbox=</xsl:text>
            <xsl:value-of select="$bbox-corrected"/>
        </xsl:variable>

        <fo:block-container margin-top="0.5cm" height="2cm" xsl:use-attribute-sets="column-block">
            <fo:block margin-left="0.05cm" margin-right="0.05cm">
                <fo:external-graphic src="{$map}" content-height="scale-to-fit" content-width="scale-to-fit" scaling="uniform" width="{$map-width-px}" height="{$map-height-px}"/>
            </fo:block>
        </fo:block-container>

        <!-- create scalebar -->
        <fo:block margin-left="3cm" margin-top="7.3cm">
            <xsl:call-template name="calc-scale">
                <xsl:with-param name="m-width">
                    <xsl:call-template name="calc-bbox-width-m-corrected">
                        <xsl:with-param name="bbox" select="bbox"/>
                    </xsl:call-template>
                </xsl:with-param>
                <xsl:with-param name="px-width" select="$map-width-px"/>
            </xsl:call-template>
        </fo:block>

        <xsl:if test="//printInfoList/info/extra/info[@classname='AdditionalVariables']/root/locatie != ''">
            <fo:block-container margin-left="0.2cm" width="6.8cm" height="0.5cm" top="8.6cm" left="0cm" xsl:use-attribute-sets="column-block">
                <fo:block>
                    <fo:table>
                        <fo:table-body>
                            <xsl:call-template name="additionalVars">
                                <xsl:with-param name="location" select="'locatie'"></xsl:with-param>
                            </xsl:call-template>
                        </fo:table-body>
                    </fo:table>
                </fo:block>
            </fo:block-container>
        </xsl:if>
    </xsl:template>

    <xsl:template name="disclaimer-block">
        <fo:block-container width="22.0cm" height="2.3cm" top="26.5cm" left="0cm" xsl:use-attribute-sets="column-block">
            <fo:block margin-left="4.2cm" margin-top="0.5cm" color="#000000" xsl:use-attribute-sets="default-font">
                Aan deze kaart kunnen geen rechten worden ontleend.
                <fo:block margin-left="2.2cm" margin-top="0.5cm" font-size="10pt" xsl:use-attribute-sets="default-font">
                    www.planmonitorwonen.nl - <xsl:value-of select="date"/>
                </fo:block>
            </fo:block>
        </fo:block-container>
        <!--xsl:call-template name="logo-block"/-->
    </xsl:template>

    <xsl:template name="logo-block">
        <fo:block-container width="7.6cm" height="2.3cm" top="26.5cm" left="12.0cm" xsl:use-attribute-sets="column-block">
            <fo:block>
                <fo:external-graphic src="url('b3p_logo.png')" width="231px" height="56px"/>
            </fo:block>
        </fo:block-container>
    </xsl:template>
</xsl:stylesheet>