Ext.define('B3p.planmonitor.Edit', {

    extends: 'Ext.util.Observable',
    drawTool: null,
    viewer: null,
    overzichtExtent: null,
    kaartExtent: null,
    formChanged: false,
    layer: null,
    newGeom: true,
    mapInitialized:null,
    variableInstantiator:null,
    
    totaalcapaciteit: 0,
    koophuurtotaal: 0,

    config: {
        mapserverUrl: '',
        kaartlagen: '',
        querylagen: '',
        httpRequestParams: '',
        editPlan: false,
        bbox: '',
        isNew: false,
        geavanceerd: '',
        readonly: true,
        wktGeom: '',
        bouwplanId:null,
        saveGeometryUrl: '',
        variables:null,
        variableValues:null,
        searchGemeenteUrl: '',
        isProvince: false,
        canEdit: true,
        showWoningtypes:true,
        showOwnership: true
    },

    constructor: function(config) {
        var me = this;
        this.initConfig(config);
        this.mapInitialized = false;
        this.viewer = Ext.create('B3p.planmonitor.Viewer', {
            mapDiv: "edit_map"
        });
        var me = this;
        $('#bewerk-plan').on("dialogopened", function(){
            me.startEditting();
        });
        $('#cancelGeometry').on("click", this.closeGeometryDialog.bind(this));
        $('#saveGeometry').on("click",$.proxy(this.saveGeometry,this));
        $('[name = "closebtn"]').on("click",function(){
            window.open("Search.action?close=true","_self");
        });
        $('#editBouwplanForm').submit($.proxy(this.saveBouwplan,this));
        $('[name="deleteButton"]').on("click",function(){
            if(confirm("Weet u zeker dat het plan verwijderd moet worden?")){
                window.open("Edit.action?deletePlan=true&bouwplan="+me.config.bouwplanId,"_self");
            }
        });
        $('[name="printButton"]').on("click",function(){
            window.open("Print.action?bouwplans="+me.config.bouwplanId,"_blank");
        });
        var variables = this.config.variables !== '' ? Ext.JSON.decode(this.config.variables) : [];
        var variableValues = this.config.variableValues !== '' ? Ext.JSON.decode(this.config.variableValues) : [];
        this.variableInstantiator = Ext.create("B3p.planmonitor.VariableInstantiator",{
            variables : variables,
            variableValues: variableValues,
            isProvince: this.config.isProvince
        });
        if(this.config.isProvince || !this.config.canEdit) {
            var inputs = document.querySelectorAll(".gemeentefield");
            for (var i = 0; i < inputs.length; i++){
                inputs[i].setAttribute('readonly', true);
            }
            Ext.ComponentQuery.query('combobox[cls~=nice-select][cls~=gemeentefield]').forEach(function(combobox) {
                combobox.setDisabled(true);
            });
        }
        // init autosuggest for gemeente field
        var searchGemeenteURL = this.config.searchGemeenteUrl;
        $("#gemeente").autocomplete({
            source: function( request, response ) {
                $.ajax({
                    url: searchGemeenteURL,
                    dataType: "json",
                    data: {
                        gemeente: request.term
                    },
                    success: function( data ) {
                        response( data );
                    }
                });
            },
            minLength: 2
        });

        if (this.config.showOwnership!== "") {
            // Init totals counter huur/koop
            var koophuurcounter = Ext.create('B3p.planmonitor.TotalCounter', {
                parent: '.huurkoop-counter',
                fields: [
                    'koop', 'huur'
                ],
                total: '.koop-huur-total',
                totalChanged: (function(field, totals, total) {
                    this.koophuurtotaal = total;
                    this.checkOnbekendOnbekend();
                }).bind(this)
            });
            this.koophuurtotaal = koophuurcounter.getTotal();
        }else{
            this.koophuurtotaal = 0;
        }
        this.checkOnbekendOnbekend();
        if (this.config.showWoningtypes !== "") {
            Ext.create('B3p.planmonitor.TotalCounter', {
                parent: '.woningtype-counter',
                fields: [
                    'woningtype'
                ],
                total: '.woningtype-total'
            });
        }
        // Init some checks
        this.initChecks();
        // init totaalcapaciteit / bijzondere woningen checks
        this.initTotaalcapaciteit();
        // Make all blocks even height
        this.evenBlockHeight();
        // Init formMonitor
        this.initFormmonitor();

        $('#detailType').on('change',this.checkPlannerLinks.bind(this));
        $('#totaalcapaciteit').on('keyup change',this.capaciteitChanged.bind(this));
        $('#gerealiseerdecapaciteit').on('keyup',this.capaciteitChanged.bind(this));
        this.checkPlannerLinks();
    },
    
    checkPlannerLinks : function(){
        var plannerType = $('#detailType').val();
        if(plannerType === "normaal"){
            $("#detailUitgebreidPopupLink").hide();
            $("#detailPopupLink").show();
            $('#totaalcapaciteit')[0].readOnly=true;
            $('#gerealiseerdecapaciteit')[0].readOnly=true;
        }else if( plannerType === "uitgebreid"){
            $("#detailPopupLink").hide();
            $("#detailUitgebreidPopupLink").show();
            $('#totaalcapaciteit')[0].readOnly=true;
            $('#gerealiseerdecapaciteit')[0].readOnly=true;
        }else{
            $('#totaalcapaciteit')[0].readOnly=false || this.config.isProvince || !this.config.canEdit;
            $('#gerealiseerdecapaciteit')[0].readOnly=false || this.config.isProvince || !this.config.canEdit;
            $("#detailPopupLink").hide();
            $("#detailUitgebreidPopupLink").hide();
        }
    },

    initTotaalcapaciteit: function() {
        var totaalcapaciteit = document.getElementById('totaalcapaciteit');
        var bijzonderewoningen = document.getElementById('bijzonderewoningen').querySelectorAll('input');
        totaalcapaciteit.addEventListener('input', (function() {
            this.totaalcapaciteit = +(totaalcapaciteit.value);
            for(var i = 0; i < bijzonderewoningen.length; i++) {
                this.checkBijzonderewoningen({ target: bijzonderewoningen[i] });
            }
            this.checkOnbekendOnbekend();
        }).bind(this));
        this.totaalcapaciteit = +(totaalcapaciteit.value);
        for(var i = 0; i < bijzonderewoningen.length; i++) {
            bijzonderewoningen[i].addEventListener('input', this.checkBijzonderewoningen.bind(this));
        }
    },

    capaciteitChanged : function(){
        var total = document.getElementById('totaalcapaciteit').value;
        var gerealiseerdTotaal = document.getElementById('gerealiseerdecapaciteit').value;
        var resterendecapaciteit = total - gerealiseerdTotaal;

        document.getElementById('restcapaciteit').value = resterendecapaciteit;
        document.getElementById('restcapaciteit').readonly = true;
    },

    checkBijzonderewoningen: function(e) {
        var val = +(e.target.value);
        var row = $(e.target).closest('.row');
        row.removeClass('error').find('.error-message').remove();
        if(val > this.totaalcapaciteit) {
            row.addClass('error').append('<span class="error-message">Waarde mag niet hoger dan plancapaciteit totaal (' + this.totaalcapaciteit + ') zijn</span>');
        }
    },
    
    initChecks: function() {
        var eerste_oplevering = document.getElementById('jaar_eerste_oplevering');
        var laatste_oplevering = document.getElementById('jaar_laatste_oplevering');
        var laatste_oplevering_row = laatste_oplevering.parentNode.parentNode;
        var error = document.createElement('span');
        error.innerHTML = 'Laatste oplevering mag niet voor Eerste oplevering liggen';
        error.className = 'error-message';
        function checkYears() {
            var yearStart = parseInt(eerste_oplevering.value, 10);
            var yearEnd = parseInt(laatste_oplevering.value, 10);
            if(yearStart > yearEnd) {
                if(laatste_oplevering_row.className.indexOf('error') === -1) {
                    laatste_oplevering_row.className += ' error';
                    laatste_oplevering_row.appendChild(error);
                }
            } else {
                if(laatste_oplevering_row.className.indexOf('error') !== -1) {
                    laatste_oplevering_row.className = laatste_oplevering_row.className.replace(' error', '');
                    laatste_oplevering_row.removeChild(error);
                }
            }
        }
        eerste_oplevering.addEventListener('change', checkYears);
        laatste_oplevering.addEventListener('change', checkYears);
    },
    
    checkOnbekendOnbekend: function() {
        var onbekend = this.totaalcapaciteit - this.koophuurtotaal;
        document.querySelector('.onbekend-onbekend-total').innerHTML = (onbekend > 0 ? onbekend : 0);
    },

    evenBlockHeight: function() {
        var sections = document.querySelectorAll('#editBouwplanForm section');
        for(var i = 0; i < sections.length; i++) {
            var maxHeight = 0;
            var blocks = sections[i].querySelectorAll('.blocks .block');
            for(var j = 0; j < blocks.length; j++) {
                if(blocks[j].offsetHeight > maxHeight) {
                    maxHeight = blocks[j].offsetHeight;
                }
            }
            for(j = 0; j < blocks.length; j++) {
                blocks[j].style.height = maxHeight + 'px';
            }
        }
    },

    startEditting: function(){
        var me = this;
        this.viewer.viewerController.layoutManager.resizeLayout();
        // Figure out better way for settimeout
        setTimeout(function () {
            if (me.viewer.getViewerController().layersInitialized) {
                me.initViewer();
            } else {
                me.viewer.getViewerController().addListener(viewer.viewercontroller.controller.Event.ON_LAYERS_INITIALIZED, me.initViewer, me);
            }
        }, 250);
    },

    initViewer: function(){
        if(!this.mapInitialized){
            this.drawTool = new DrawTool({ canEdit: this.config.canEdit, isProvince: this.config.isProvince }, this.viewer.getViewerController(), this);
            this.viewer.voegGrenzenToe(this.config.mapserverUrl);
            loadBackgroundLayers(this.viewer.getViewerController(), this.viewer.getLegend());
            this.voegLayersToeEdit(this.config.querylagen, this.config.kaartlagen, this.config.httpRequestParams,false);
            var panTool=this.viewer.getViewerController().mapComponent.getToolsByType(viewer.viewercontroller.controller.Tool.PAN)[0];
            panTool.activate();
            var identifyTool=this.viewer.getViewerController().mapComponent.getToolsByType(viewer.viewercontroller.controller.Tool.GET_FEATURE_INFO)[0];
            identifyTool.setVisible(false);
            this.drawTool.setVisible(true);
            this.viewer.naarBbox(this.config.bbox);
            this.mapInitialized = true;
            this.drawTool.editButtonDown();
        }
    },

    initFormmonitor: function() {
        document.body.addEventListener('change', this.formChange.bind(this));
        document.body.addEventListener('input', this.formChange.bind(this));
    },

    formChange: function(e) {
        var tagName = e.target.tagName.toLowerCase();
        if(['input', 'select', 'textarea','geometry'].indexOf(tagName) === -1) {
            return;
        }
        if(!this.formChanged) {
            document.querySelector(".header-plannaam").innerHTML += ' *';
            window.onbeforeunload = function() {
                return 'U heeft uw wijzigingen nog niet opgeslagen, weet u zeker dat u deze pagina wilt verlaten?';
            };
        }
        this.formChanged = true;
    },

    voegLayersToeEdit: function(querylayers, layers, httpRequestParams,visible){
        var url = this.config.mapserverUrl;
        url += (url.indexOf("?") === -1 ? "?" : "&");
        url += httpRequestParams + "&";
        this.viewer.voegLayerToe(url, layers, querylayers, null, visible);
    },

    /**
    * Get all the map properties/values.
    * Nice ripoff from Roy Braam's Print Component.
    */
   getMapValues: function(){
       var values = new Object();
       var printLayers = new Array();
       var wktGeoms = new Array();
       //get last getmap request from all layers
       var layers=this.viewerController.mapComponent.getMap().getLayers();
       for (var i=0; i < layers.length; i ++){
           var layer = layers[i];
           if (layer.getVisible()){
               if (layer.getType()== viewer.viewercontroller.controller.Layer.VECTOR_TYPE){
                   var features=layer.getAllFeatures();
                   for (var f =0; f < features.length; f++){
                       var feature=features[f];
                       if (feature.getWktgeom()!=null){
                           wktGeoms.push(feature);
                       }
                   }
               }else{
                   var requests=layer.getLastMapRequest();
                   for (var r in requests){
                       var request= requests[r];
                       if (request){
                           request.protocol=layer.getType();
                           var alpha=layer.getAlpha();
                           if (alpha!=null)
                               request.alpha = alpha;
                           printLayers.push(request);
                           //do a to string for the extent.
                           if (request.extent){
                               request.extent=request.extent.toString();
                           }
                           //TODO tiling is now added as images, needs te be added as a tiling server
                           if (layer.getType()== viewer.viewercontroller.controller.Layer.TILING_TYPE){
                               request.protocol=viewer.viewercontroller.controller.Layer.IMAGE_TYPE;
                           }
                       }
                   }
               }
           }
       }
       values.requests=printLayers;
       var bbox=this.viewerController.mapComponent.getMap().getExtent();
       if (bbox){
           values.bbox = bbox.minx+","+bbox.miny+","+bbox.maxx+","+bbox.maxy;
       }
       values.width = this.viewerController.mapComponent.getMap().getWidth();
       values.height = this.viewerController.mapComponent.getMap().getHeight();
       values.geometries = wktGeoms;
       return values;
    },

    saveGeometry : function(){
        var wkt = this.drawTool.getWKT();
        Ext.get("bewerk-plan").mask("Opslaan geometrie...");
        if(wkt){
            if(this.config.bouwplanId !== ""){
                var me = this;
                Ext.Ajax.request({
                    url: this.config.saveGeometryUrl,
                    scope:me,
                    params: {
                        bouwplan: this.config.bouwplanId,
                        geometry: wkt
                    },
                    success: function (result) {
                        var response = Ext.JSON.decode(result.responseText);
                        if (response.success) {
                            var layers = this.viewer.layers;
                            for( var i = 0 ; i < layers.length; i++){
                                var layer = layers[i].layer;
                                layer.reload();
                            }
                        } else {
                            console.log("Error", response);
                        }

                        document.getElementById("geometry").value = wkt;
                        this.closeGeometryDialog();
                        this.reloadImage(document.querySelector('#map_thumb img'));
                        Ext.get("bewerk-plan").unmask();
                    },
                    failure: function (error) {
                        console.log("Error", error);
                        Ext.get("bewerk-plan").unmask();
                        this.closeGeometryDialog();
                    }
                });
            }else{
                document.getElementById("geometry").value = wkt;
                Ext.get("bewerk-plan").unmask();
                this.closeGeometryDialog();
            }
        }
    },
    
    reloadImage: function(img) {
        var src = img.src;
        var cache = 'cache=' + Date.now();
        if(src.indexOf('cache=') !== -1) {
            src = src.replace(/cache=[0-9]*/ig, cache);
        } else {
            var separator = '?';
            if(src.indexOf('?') !== -1) {
                separator = '&';
            }
            src += separator + cache;
        }
        img.src = src;
    },

    closeGeometryDialog : function(){
        $("#bewerk-plan").dialog('close');
    },

    saveBouwplan: function () {
        var additionalVariables = this.variableInstantiator.getValues();
        document.getElementById("additionalVariables").value = Ext.JSON.encode(additionalVariables);
        window.onbeforeunload = null;
        return true;
    },

    printBouwplan: function(){
        var settings = this.getMapValues();
        document.getElementById("settings").value= Ext.JSON.encode(settings);

        var form = document.getElementById("printForm");
        form.submit();
    },

    editGeometry: function(){
        if (this.config.wktGeom !== ''){
            var feature = new viewer.viewercontroller.controller.Feature({
                id: 1,
                wktgeom: this.config.wktGeom
            });
            this.drawTool.setFeature(feature);
        }
    }

});

Ext.define ("DrawTool", {
    viewerController: null,
    editTool: null,
    pointButton: null,
    polygonButton: null,
    editButton: null,
    removeButton: null,
    pointImage: "images/edit_point.png",
    polygonImage: "images/edit_poly.png",
    editImage: "images/edit.png",
    removeImage: "images/remove_geom.png",
    
    config: {
        canEdit: true,
        isProvince: false
    },

    constructor: function (config, viewerController, editTool) {
        this.initConfig(config);
        this.viewerController=viewerController;
        this.editTool = editTool;
        this.createVectorLayer();
        this.createButtons();
    },
    
    isEditable: function(vis) {
        return this.config.canEdit && !this.config.isProvince && (typeof vis === 'undefined' || vis);
    },
    
    createVectorLayer : function (){
        this.vectorLayer=this.viewerController.mapComponent.createVectorLayer({
            name:'drawingVectorLayer',
            geometrytypes:["Polygon","Point"],
            showmeasures:false,
            viewerController: this.viewerController,
            style: {
                'fillcolor': this.color || 'FF0000',
                'fillopacity': 50,
                'strokecolor': "FF0000",
                'strokeopacity': 50
            }
        });
        this.viewerController.mapComponent.getMap().addLayer(this.vectorLayer);

        this.vectorLayer.addListener (viewer.viewercontroller.controller.Event.ON_ACTIVE_FEATURE_CHANGED,this.activeFeatureChanged,this);
        this.vectorLayer.addListener (viewer.viewercontroller.controller.Event.ON_FEATURE_ADDED,this.activeFeatureFinished,this);
    },
    createButtons: function(){
        this.pointButton= this.viewerController.mapComponent.createTool({
            type: viewer.viewercontroller.controller.Tool.BUTTON,
            id: "drawPoint",
            iconUrl_up: this.pointImage,
            iconUrl_over: this.pointImage,
            iconUrl_sel: this.pointImage,
            iconUrl_dis: this.pointImage,
            tooltip: "Teken plan als punt",
            viewerController: this.viewerController,
            visible: false
        });
        this.viewerController.mapComponent.addTool(this.pointButton);
        this.pointButton.addListener(viewer.viewercontroller.controller.Event.ON_EVENT_DOWN,this.pointButtonDown, this);

        this.polygonButton= this.viewerController.mapComponent.createTool({
            type: viewer.viewercontroller.controller.Tool.BUTTON,
            id: "drawPolygon",
            iconUrl_up: this.polygonImage,
            iconUrl_over: this.polygonImage,
            iconUrl_sel: this.polygonImage,
            iconUrl_dis: this.polygonImage,
            tooltip: "Teken plan als vlak",
            viewerController: this.viewerController,
            visible: false
        });
        this.viewerController.mapComponent.addTool(this.polygonButton);
        this.polygonButton.addListener(viewer.viewercontroller.controller.Event.ON_EVENT_DOWN,this.polygonButtonDown, this);

        this.editButton= this.viewerController.mapComponent.createTool({
            type: viewer.viewercontroller.controller.Tool.BUTTON,
            id: "editGeometry",
            iconUrl_up: this.editImage,
            iconUrl_over: this.editImage,
            iconUrl_sel: this.editImage,
            iconUrl_dis: this.editImage,
            tooltip: "Bewerk opgeslagen geometrie",
            viewerController: this.viewerController,
            visible: false
        });
        this.viewerController.mapComponent.addTool(this.editButton);
        this.editButton.addListener(viewer.viewercontroller.controller.Event.ON_EVENT_DOWN,this.editButtonDown, this);

        this.removeButton= this.viewerController.mapComponent.createTool({
            type: viewer.viewercontroller.controller.Tool.BUTTON,
            id: "removeGeometry",
            iconUrl_up: this.removeImage,
            iconUrl_over: this.removeImage,
            iconUrl_sel: this.removeImage,
            iconUrl_dis: this.removeImage,
            tooltip: "Verwijder getekende geometry",
            viewerController: this.viewerController,
            visible: false
        });
        this.viewerController.mapComponent.addTool(this.removeButton);
        this.removeButton.addListener(viewer.viewercontroller.controller.Event.ON_EVENT_DOWN,this.removeButtonDown, this);
    },

    checkForFeatures: function(func){
        var features=this.vectorLayer.getAllFeatures();
        if (features==undefined || features ==null || features.length ==0){
            func.call();
        }else{
            var returnValue;
            Ext.Msg.confirm("Nieuwe Feature", "Een plan kan maximaal uit 1 geometry bestaan, \n\
                wilt u de reeds getekende geometry verwijderen?",
                function(btn,txt){
                    if (btn=='yes'){
                        func.call();
                    }
                }
            );
        }
    },
    removeAllFeatures: function(){
        this.getVectorLayer().removeAllFeatures();
        this.startNewGeom();
    },
    startNewGeom: function(){
        if(this.config.wktGeom){
            this.getEditButton().setVisible(true);
        }
        this.getRemoveButton().setVisible(false);
        this.getPointButton().setVisible(true);
        this.getPolygonButton().setVisible(true);
    },
    editExistingGeom: function(){
        if(this.config.wktGeom){
            this.getEditButton().setVisible(this.isEditable());
        }
        this.getRemoveButton().setVisible(this.isEditable());
        this.getPointButton().setVisible(false);
        this.getPolygonButton().setVisible(false);
    },
    pointButtonDown: function(){
        this.disableZoomInControls();
        var vl= this.vectorLayer;
        this.checkForFeatures(function(){
            vl.removeAllFeatures();
            vl.drawFeature("Point");
        });
    },
    polygonButtonDown: function(){
        this.disableZoomInControls();
        var vl= this.vectorLayer;
        this.checkForFeatures(function(){
            vl.removeAllFeatures();
            vl.drawFeature("Polygon");
        });
    },
    editButtonDown: function(){
        this.editTool.formChange({target:{tagName: "geometry"}});
        var vl= this.vectorLayer;
        var me = this;
        this.checkForFeatures(function(){
            vl.removeAllFeatures();
            me.editTool.editGeometry();
        });
    },
    editButtonUp: function(){
        //console.log("need to be implemented");
        confirmPopup('Geometrie wijzigen', 'geomMessage');
    },

    removeButtonDown: function(){
        var me = this;
        Ext.Msg.confirm("Verwijder Feature", "Weet u zeker dat u de getekende geometrie wilt verwijderen? \n\
                Het is vereist om een geometry op te slaan, \n\
                zolang u geen nieuwe geometry heeft getekend blijft de oude geometry bestaan.",
                function(btn,txt){
                    if (btn=='yes'){
                        me.removeAllFeatures();
                    }
                }
            );
    },
    setFeature: function(feature){
        this.vectorLayer.removeAllFeatures();
        this.vectorLayer.addFeature(feature);
        this.getRemoveButton().setVisible(this.isEditable());
    },

    setVisible: function(vis){
        this.pointButton.setVisible(vis);
        this.polygonButton.setVisible(vis);
        this.editButton.setVisible(this.isEditable(vis));
        this.removeButton.setVisible(this.isEditable(vis));
        this.vectorLayer.setVisible(vis);
    },
    activeFeatureChanged: function(){

    },
    activeFeatureFinished: function(){
        this.editExistingGeom();
    },
    getPointButton: function(){
        return this.pointButton;
    },
    getPolygonButton: function(){
        return this.polygonButton;
    },
    getEditButton: function(){
        return this.editButton;
    },
    getVectorLayer: function(){
        return this.vectorLayer;
    },
    getRemoveButton: function(){
        return this.removeButton;
    },
    disableZoomInControls: function(){
        var comps = this.viewerController.getComponentsByClassName("viewer.components.tools.ZoomIn");
        for(var i = 0 ; i < comps.length ; i++){
            var component = comps[i];
            var tool = component.tool;
            tool.deactivate();
        }
    },
    getWKT : function(){

        var features=this.vectorLayer.getAllFeatures();
        if(features && features.length > 0){
            var feature = features[0];
            return feature.getWktgeom();
        }else{
            return null;
        }
    }
});