// Input 0
Ext.define("viewer.viewercontroller.ViewerController", {extend:"Ext.util.Observable", queryParams:null, components:{}, mapComponent:null, app:null, layoutManager:null, layers:null, logger:null, dataSelectionChecker:null, layersInitialized:false, constructor:function(a, b, c, d, e) {
  this.events = {};
  this.callParent([{listeners:d}]);
  this.dataSelectionChecker = Ext.create("viewer.components.DataSelectionChecker", {viewerController:this});
  this.app = c;
  this.queryParams = Ext.urlDecode(window.location.search.substring(1));
  d = viewer.components.Logger.LEVEL_ERROR;
  if(this.isDebug()) {
    d = viewer.components.Logger.LEVEL_DEBUG
  }
  this.logger = Ext.create("viewer.components.Logger", {logLevel:d});
  if(c.layout) {
    d = null;
    c.details && c.details.maxHeight && parseInt(c.details.maxHeight, 10) !== 0 && (d = parseInt(c.details.maxHeight, 10));
    c = {layout:c.layout, configuredComponents:c.components, maxHeight:d};
    if(b) {
      c.wrapperId = b
    }
    this.layoutManager = Ext.create("viewer.LayoutManager", c)
  }
  this.layers = {};
  var b = this.layoutManager.getMapId(), c = this.app.components, d = {}, f;
  for(f in c) {
    var g = c[f];
    if(g.className == "viewer.mapcomponents.FlamingoMap" || g.className == "viewer.mapcomponents.OpenLayersMap") {
      d = g.config;
      break
    }
  }
  Ext.apply(d, e || {});
  a == "flamingo" ? this.mapComponent = new viewer.viewercontroller.FlamingoMapComponent(this, b, d) : a == "openlayers" ? this.mapComponent = new viewer.viewercontroller.OpenLayersMapComponent(this, b, d) : this.logger.error("No correct viewerType defined. This might be a problem. ViewerType: " + a);
  this.mapComponent.addListener(viewer.viewercontroller.controller.Event.ON_CONFIG_COMPLETE, this.onMapContainerLoaded, this);
  this.addListener(viewer.viewercontroller.controller.Event.ON_SELECTEDCONTENT_CHANGE, this.onSelectedContentChanged, this);
  a == "openlayers" && this.mapComponent.fireEvent(viewer.viewercontroller.controller.Event.ON_CONFIG_COMPLETE)
}, showLoading:function(a) {
  var b = "Loading...";
  a && (b += " " + a);
  document.getElementById("loader").innerHTML = b;
  document.getElementById("loadwrapper").style.zIndex = "900000"
}, hideLoading:function() {
  document.getElementById("loadwrapper").style.zIndex = "0"
}, isDebug:function() {
  return this.queryParams.hasOwnProperty("debug") && this.queryParams.debug == "true"
}, mapContainerLoaded:false, onMapContainerLoaded:function() {
  if(!this.configCompleted) {
    this.configCompleted = true;
    try {
      var a = this.getLayout("top_menu"), b = a.height && a.height >= 0 ? a.height : 0;
      a.heightmeasure && (b += a.heightmeasure == "px" ? "" : a.heightmeasure);
      var c = this.getLayout("content_bottom"), d = c.height && c.height >= 0 ? c.height : 0;
      c.heightmeasure && (d += c.heightmeasure == "px" ? "" : c.heightmeasure);
      var e = this.app.maxExtent, f;
      f = e != void 0 ? Ext.create("viewer.viewercontroller.controller.Extent", e.minx, e.miny, e.maxx, e.maxy) : Ext.create("viewer.viewercontroller.controller.Extent", "12000,304000,280000,620000");
      var g, h = this.app.startExtent;
      g = h ? Ext.create("viewer.viewercontroller.controller.Extent", h.minx, h.miny, h.maxx, h.maxy) : Ext.create("viewer.viewercontroller.controller.Extent", "12000,304000,280000,620000");
      this.mapComponent.addMap(this.mapComponent.createMap("map", {viewerController:this, options:{left:0, top:b, width:"100%", bottom:d, visible:"true", maxExtent:f, startExtent:g, extenthistory:"10"}}));
      this.initializeConfiguredComponents();
      this.bookmarkValuesFromURL(this.queryParams) || this.initLayers();
      this.layersInitialized = true;
      this.fireEvent(viewer.viewercontroller.controller.Event.ON_LAYERS_INITIALIZED)
    }catch(i) {
      this.logger.error(i)
    }
  }
}, initializeConfiguredComponents:function() {
  for(var a = this.layoutManager.getComponentList(), b = 0;b < a.length;b++) {
    var c = a[b], d = this.app.components[c.componentName];
    if(d) {
      d.config.div = c.htmlId, d.config.isPopup = c.isPopup, d.config.hasSharedPopup = c.hasSharedPopup, d.config.showOnStartup = c.showOnStartup, d.config.regionName = c.regionName, this.createComponent(d.name, d.className, d.config, d.details)
    }
  }
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_COMPONENTS_FINISHED_LOADING)
}, createComponent:function(a, b, c, d) {
  if(this.components[a] != void 0) {
    throw"Component with name " + a + " (class " + b + ") already added, cannot add component of class " + b + " with the same name";
  }
  if(b == "viewer.mapcomponents.FlamingoMap" || b == "viewer.mapcomponents.OpenLayersMap") {
    return null
  }
  c.viewerController = this;
  c.name = a;
  c.details = d;
  try {
    var e = Ext.create(b, c);
    if(e.hasSharedPopup) {
      e.popup = this.layoutManager.popupWin
    }
    this.components[a] = {className:b, instance:e}
  }catch(f) {
    this.logger.error("Error creating component with className " + b + ": error " + f + " with config" + c), this.isDebug() && f instanceof Error && (console.log(f), f.stack != void 0 && console.log(f.stack))
  }
  return e
}, addService:function(a) {
  this.app.services[a.id] == void 0 && (this.app.services[a.id] = a)
}, addAppLayer:function(a) {
  this.app.appLayers[a.id] == void 0 && (this.app.appLayers[a.id] = a)
}, counter:0, max:0, setSelectedContent:function(a) {
  this.counter = 0;
  this.max = this.mapComponent.getMap().layers.length;
  var b = this, c = function() {
    this.counter++;
    this.counter >= this.max && setTimeout(function() {
      b.app.selectedContent = a;
      b.uncheckUnselectedContent();
      b.initLayers();
      b.mapComponent.getMap().removeListener(viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED, c, b);
      b.fireEvent(viewer.viewercontroller.controller.Event.ON_SELECTEDCONTENT_CHANGE)
    }, 1)
  };
  this.max == 0 && c.call(this);
  this.mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED, c, this);
  this.clearLayers()
}, onSelectedContentChanged:function() {
  var a = this.app.appLayers, b;
  for(b in a) {
    var c = a[b];
    c.filter && (this.getLayer(c).setQuery(c.filter), this.fireEvent(viewer.viewercontroller.controller.Event.ON_FILTER_ACTIVATED, c.filter, c))
  }
}, uncheckUnselectedContent:function() {
  var a = [], b;
  for(b in this.app.selectedContent) {
    var c = this.app.selectedContent[b];
    c.type == "appLayer" ? a.push(c.id) : a = a.concat(this.getLevelAppLayerIds(this.app.levels[c.id]))
  }
  for(b in this.app.appLayers) {
    if(c = this.app.appLayers[b], c.checked && Ext.Array.indexOf(a, c.id + "") == -1) {
      c.checked = false
    }
  }
}, traverseSelectedContent:function(a, b) {
  var c = this.app, d = function(e) {
    a(e);
    if(e.children) {
      for(var f in e.children) {
        d(c.levels[e.children[f]])
      }
    }
    if(e.layers) {
      for(f in e.layers) {
        b(c.appLayers[e.layers[f]])
      }
    }
  }, e;
  for(e in c.selectedContent) {
    var f = c.selectedContent[e];
    f.type == "level" ? d(c.levels[f.id]) : f.type == "appLayer" && b(c.appLayers[f.id])
  }
}, getLevelAppLayerIds:function(a) {
  var b = [];
  if(a.layers) {
    for(var c in a.layers) {
      b.push(a.layers[c])
    }
  }
  if(a.children) {
    for(var d in a.children) {
      c = this.getLevelAppLayerIds(this.app.levels[a.children[d]]), b = b.concat(c)
    }
  }
  return b
}, getAppLayerParent:function(a) {
  var a = "" + a, b;
  for(b in this.app.levels) {
    var c = this.app.levels[b];
    if(c.layers && Ext.Array.contains(c.layers, a)) {
      return c
    }
  }
  return null
}, getLevelParent:function(a) {
  var a = "" + a, b;
  for(b in this.app.levels) {
    var c = this.app.levels[b];
    if(c.children && Ext.Array.contains(c.children, a)) {
      return c
    }
  }
  return null
}, getDocumentsInLevel:function(a) {
  var b = {};
  if(a.documents) {
    for(var c = 0;c < a.documents.length;c++) {
      var d = a.documents[c];
      b[d.id] = d
    }
  }
  a = this.getLevelParent(a.id);
  a != null && (a = this.getDocumentsInLevel(a), Ext.apply(b, a));
  return b
}, clearLayers:function() {
  this.layers = [];
  this.mapComponent.getMap().removeAllLayers()
}, initLayers:function(a) {
  if(a == void 0) {
    this.initLayers(true), this.initLayers(false)
  }else {
    for(var b = this.app.selectedContent.length - 1;b >= 0;b--) {
      var c = this.app.selectedContent[b];
      c.type == "appLayer" ? this.initAppLayer(c.id, a) : this.initLevel(c.id, a)
    }
  }
}, initAppLayer:function(a, b) {
  var c = this.app.appLayers[a];
  if(c.background == b) {
    var d = this.getOrCreateLayer(c);
    d && this.mapComponent.getMap().setLayerVisible(d, c.checked)
  }
}, initLevel:function(a, b) {
  var c = this.app.levels[a];
  if(c.background == b) {
    if(c.layers) {
      for(var d = c.layers.length - 1;d >= 0;d--) {
        this.initAppLayer(c.layers[d], b)
      }
    }
    if(c.children) {
      for(d = c.children.length - 1;d >= 0;d--) {
        this.initLevel(c.children[d], b)
      }
    }
  }
}, setLayerVisible:function(a, b) {
  var c = this.getLayer(a);
  if(c) {
    c.visible = b, this.mapComponent.getMap().setLayerVisible(c, b)
  }
}, getLayer:function(a, b) {
  b && this.isDebug() && this.logger.warning("getLayer() old method call is used!");
  return this.layers[a.id] == void 0 ? (this.layersInitialized ? this.logger.warning("The layer #" + a.id + " can't be found!") : this.logger.warning("Layers not initialized! getLayer() caller should wait for the layers to be added!"), null) : this.layers[a.id]
}, getOrCreateLayer:function(a) {
  var b = a.id;
  this.layers[b] == void 0 && this.createLayer(a);
  return this.layers[b]
}, getAppLayerById:function(a) {
  return this.app.appLayers[a]
}, getAppLayer:function(a, b) {
  this.logger.warning("viewerController.getAppLayer() with serviceId and LayerName is not unique");
  var c = 0, d = null, e;
  for(e in this.app.appLayers) {
    var f = this.app.appLayers[e];
    f.layerName == b && f.serviceId == a && (c++, d == null && (d = f))
  }
  c > 1 && this.logger.warning("viewerController.getAppLayer() with serviceId and LayerName found " + c + " application layers with serviceId: '" + a + "' and layerName: '" + b + "' returning the first");
  return d
}, getAppLayerFeatureService:function(a) {
  if(a.featureService == void 0) {
    if(a.added) {
      var b = this.app.services[a.serviceId];
      a.featureService = Ext.create("viewer.DirectFeatureService", {appLayer:a, protocol:b.protocol, url:b.url})
    }else {
      a.featureService = Ext.create("viewer.AppLayerService", {appId:this.app.id, appLayer:a, debug:this.isDebug()})
    }
  }
  return a.featureService
}, createLayer:function(a) {
  var b = a.id, c = this.app.services[a.serviceId], d = c.layers[a.layerName], e = {id:b, ratio:1, visible:a.checked};
  if(a.details && a.details.transparency != void 0) {
    e.alpha = 100 - a.details.transparency
  }
  var f = null;
  try {
    if(c.protocol == "wms") {
      var g = c.url;
      e.isBaseLayer = false;
      var h = {exceptions:"application/vnd.ogc.se_inimage", srs:"EPSG:28992", version:"1.1.1", layers:d.name, styles:"", format:"image/png", transparent:true, noCache:true};
      if(d.queryable) {
        h.query_layers = d.name
      }
      if(d.name == void 0 && d.details && d.details.all_children) {
        e.layers = d.details.all_children
      }
      f = this.mapComponent.createWMSLayer(d.name, g, h, e, this)
    }else {
      if(c.protocol == "arcims" || c.protocol == "arcgis") {
        e.layers = d.name;
        if(d.details && d.details.all_children) {
          e.layers = d.details.all_children
        }
        c.protocol == "arcims" ? (e.type = "ArcIMS", e.mapservice = c.serviceName, f = this.mapComponent.createArcIMSLayer(a.layerName, c.url, e, this)) : (e.type = "ArcGIS", f = this.mapComponent.createArcServerLayer(a.layerName, c.url, e, this))
      }else {
        if(c.protocol == "tiled") {
          for(var i = d.resolutions.split(","), g = 0;i.length > g;g++) {
            i[g] = Number(i[g])
          }
          e.tileHeight = d.tileHeight;
          e.tileWidth = d.tileWidth;
          e.serviceEnvelope = d.bbox.minx + "," + d.bbox.miny + "," + d.bbox.maxx + "," + d.bbox.maxy;
          e.resolutions = i;
          e.protocol = c.tilingProtocol;
          e.viewerController = this;
          if(d.details && d.details.image_extension) {
            e.extension = d.details.image_extension
          }
          f = this.mapComponent.createTilingLayer(a.layerName, c.url, e)
        }
      }
    }
  }catch(j) {
    return this.logger.error(Ext.String.format("Error creating layer object for appLayer #{0} ({1} {2} layer {3}: {4}", b, c.protocol, c.url, a.layerName, j)), this.isDebug() && j instanceof Error && (console.log(j), j.stack != void 0 && console.log(j.stack)), null
  }
  f.serviceId = a.serviceId;
  f.appLayerId = a.id;
  this.layers[b] = f;
  this.mapComponent.getMap().addLayer(f);
  return f
}, getLayerByLayerId:function(a) {
  this.logger.warning("viewerController.getLayerByLayerId() is not returning a unique layer!");
  for(var b in this.app.services) {
    var c = this.app.services[b], d;
    for(d in c.layers) {
      var e = c.layers[d];
      if(a == e.id) {
        return this.getLayer(c.id, e.name)
      }
    }
  }
  return null
}, getServiceLayerById:function(a) {
  for(var b in this.app.services) {
    var c = this.app.services[b], d;
    for(d in c.layers) {
      var e = c.layers[d];
      if(a == e.id) {
        return e
      }
    }
  }
  return null
}, getServiceLayer:function(a) {
  return this.app.services[a.serviceId].layers[a.layerName]
}, getVisibleLayers:function() {
  var a = this.layers, b = [], c;
  for(c in a) {
    a[c].getVisible() && b.push(c)
  }
  return b
}, setLayersVisible:function(a, b) {
  for(var c = 0;c < a.length;c++) {
    this.setLayerVisible(a[c], b)
  }
}, isWithinScale:function(a, b) {
  var c = this.getServiceLayer(a), d = c.minScale, e = c.maxScale;
  if(d != void 0 && e != void 0 && d > e) {
    d = c.maxScale, e = c.minScale
  }
  if(!d && !e) {
    return true
  }
  if(b == void 0 || b == null) {
    b = this.mapComponent.getMap().getScale()
  }
  return(c = this.app.services[a.serviceId]) && c.protocol == "arcgis" ? true : d && b < d ? false : e && b > e ? false : true
}, getLayerTitle:function(a, b) {
  var c = this.app.services[a].layers[b];
  return c.titleAlias != void 0 ? c.titleAlias : c.title
}, getLayerLegendImage:function(a) {
  var b = this.app.services[a.serviceId].layers[a.layerName];
  return b.legendImageUrl != void 0 ? b.legendImageUrl : this.getLayer(a).getLegendGraphic()
}, getLayerLegendInfo:function(a, b, c) {
  try {
    var d = this.getLayer(a);
    if(d) {
      var e = this.getServiceLayer(a);
      e.legendImageUrl ? b(a, {parts:[{url:e.legendImageUrl}]}) : d.getLayerLegendInfo ? d.getLayerLegendInfo(function(c) {
        b(a, c)
      }, function() {
        c(a)
      }) : (this.logger.error("Layer class " + d.$className + " does not support getLayerLegendInfo"), c(a))
    }else {
      c(a)
    }
  }catch(f) {
    this.logger.error("Error creating legend info for appLayerId " + a.id + ": " + f), c(a)
  }
}, getLayerMetadata:function(a, b) {
  return this.app.services[a].layers[b].details["metadata.stylesheet"]
}, setFilter:function(a, b) {
  if(!b.filter) {
    b.filter = Ext.create("viewer.components.CQLFilterWrapper", {id:"", cql:"", operator:""})
  }
  b.filter.addOrReplace(a);
  this.getLayer(b).setQuery(b.filter);
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_FILTER_ACTIVATED, b.filter, b)
}, removeFilter:function(a, b) {
  if(b.filter) {
    b.filter = b.filter.removeFilterById(a);
    if(b.filter.filters.length == 0) {
      b.filter = null
    }
    this.getOrCreateLayer(b).setQuery(b.filter);
    this.fireEvent(viewer.viewercontroller.controller.Event.ON_FILTER_ACTIVATED, b.filter, b)
  }
}, getComponentsByClassName:function(a) {
  var b = [], c;
  for(c in this.components) {
    var d = this.components[c];
    d.className == a && b.push(d.instance)
  }
  return b
}, getComponentByName:function(a) {
  a = this.components[a];
  return a != void 0 ? a.instance : null
}, bookmarkValuesFromURL:function(a) {
  var b = false, c = false, d = this.app.appLayers, e;
  for(e in a) {
    var f = a[e];
    if(e == "bookmark") {
      var g = this;
      Ext.create("viewer.Bookmark").getBookmarkParams(f, function(a) {
        g.succesReadUrl(a)
      }, function(a) {
        g.failureReadUrl(a)
      });
      c = b = true
    }else {
      if(e == "layers") {
        Ext.isArray(f) || (f = f.split(",")), d = this.loadBookmarkLayers(f), b = true
      }else {
        if(e == "extent") {
          var h = f, i = {};
          Ext.isObject(f) ? i = h : (h = f.split(","), i.minx = h[0], i.miny = h[1], i.maxx = h[2], i.maxy = h[3]);
          g = this;
          g.newExtent = i;
          var j = function() {
            g.mapComponent.getMap().zoomToExtent(g.newExtent);
            g.mapComponent.getMap().removeListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, j, j)
          };
          this.mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, j, j)
        }
      }
    }
  }
  if(b && !c) {
    this.app.appLayers = d, this.setSelectedContent(this.app.selectedContent)
  }
  return b
}, loadBookmarkLayers:function(a) {
  var b = this.app.appLayers, c;
  for(c in b) {
    for(var d = b[c], e = false, f = 0;f < a.length;f++) {
      if(d.id == a[f]) {
        e = true;
        break
      }
    }
    d.checked = e ? true : false
  }
  return b
}, succesReadUrl:function(a) {
  for(var a = Ext.JSON.decode(a), b = {}, c = 0;c < a.params.length;c++) {
    var d = a.params[c];
    b[d.name] = d.value
  }
  this.bookmarkValuesFromURL(b)
}, failureReadUrl:function() {
}, getBookmarkUrl:function() {
  var a = {params:[]}, b = document.URL, c = b.indexOf("?"), d = "", d = c > 0 ? b.substring(0, c) + "?" : b + "?";
  a.params.push({name:"url", value:d});
  if(c > 0) {
    c = b.substring(c + 1).split("&");
    for(b = 0;b < c.length;b++) {
      var e = c[b], f = e.indexOf("="), d = e.substring(0, f), e = e.substring(f + 1);
      d != "layers" && d != "extent" && d != "bookmark" && a.params.push({name:d, value:e})
    }
  }
  c = this.getVisibleLayers();
  for(b = c.length - 1;b >= 0;b--) {
    this.getAppLayerById(c[b]).status == "added" && c.splice(b, 1)
  }
  c.length != 0 && a.params.push({name:"layers", value:c});
  b = {name:"extent", value:this.mapComponent.getMap().getExtent()};
  a.params.push(b);
  return a
}, getApplicationSprite:function() {
  return Ext.isDefined(this.app.details) && Ext.isDefined(this.app.details.iconSprite) ? this.app.details.iconSprite : null
}, getLayoutHeight:function(a) {
  var b = -1;
  if((a = this.getLayout(a)) && a.height) {
    b = a.height
  }
  return b
}, getLayout:function(a) {
  return(a = this.app.layout[a]) && a.layout ? a.layout : null
}, getTopMenuHeightInPixels:function() {
  var a = this.getLayout("top_menu"), b = Number(a.height && a.height >= 0 ? a.height : 0);
  a.heightmeasure && a.heightmeasure == "%" && (a = Ext.get(this.layoutManager.mapId).getHeight(), b = Math.round(a / 100 * b));
  return b
}, resizeComponents:function() {
  this.layoutManager.resizeLayout();
  this.mapComponent.doResize && this.mapComponent.doResize();
  for(var a in this.components) {
    this.components[a].instance.resizeScreenComponent()
  }
  return true
}, isEmptyObject:function(a) {
  for(var b in a) {
    if(a.hasOwnProperty(b)) {
      return false
    }
  }
  return true
}});
// Input 1
Ext.define("viewer.viewercontroller.MapComponent", {extend:"Ext.util.Observable", eventList:null, maps:null, tools:null, events:null, components:null, panel:null, viewerController:null, config:{resolutions:null, id:null}, constructor:function(a, b, c) {
  this.eventList = {};
  this.maps = [];
  this.tools = [];
  this.events = [];
  this.components = [];
  this.initConfig(c);
  this.initEvents();
  this.viewerController = a;
  this.addEvents(viewer.viewercontroller.controller.Event.ON_CONFIG_COMPLETE);
  return this
}, createMap:function() {
  Ext.Error.raise({msg:"MapComponent.createMap(...) not implemented! Must be implemented in sub-class"})
}, createWMSLayer:function() {
  Ext.Error.raise({msg:"MapComponent.createWMSLayer() Not implemented! Must be implemented in sub-class"})
}, createTilingLayer:function() {
  Ext.Error.raise({msg:"MapComponent.createTMSLayer() Not implemented! Must be implemented in sub-class"})
}, createArcIMSLayer:function() {
  Ext.Error.raise({msg:"MapComponent.createArcIMSLayer needs te be implemented in the sub-class"})
}, createArcServerLayer:function() {
  Ext.Error.raise({msg:"MapComponent.createArcServerLayer needs te be implemented in the sub-class"})
}, createImageLayer:function() {
  Ext.Error.raise({msg:"MapComponent.createImageLayer() Not implemented! Must be implemented in sub-class"})
}, createVectorLayer:function() {
  Ext.Error.raise({msg:"MapComponent.createVectorLayer() Not implemented! Must be implemented in sub-class"})
}, createTool:function() {
  Ext.Error.raise({msg:"MapComponent.createTool(...) not implemented! Must be implemented in sub-class"})
}, createComponent:function() {
  Ext.Error.raise({msg:"MapComponent.createComponent() not implemented! Must be implemented in the sub-class"})
}, addTools:function(a) {
  for(var b = 0;b < a.length;b++) {
    addTool(a[b])
  }
}, addTool:function(a) {
  a instanceof viewer.viewercontroller.controller.Tool || (Ext.Error.raise({msg:"Given tool not of type 'Tool'", options:{tool:a}}), Ext.err());
  a.mapComponent = this;
  this.tools.push(a)
}, removeTool:function(a) {
  a instanceof viewer.viewercontroller.controller.Tool || Ext.Error.raise({msg:"Given tool not of type 'Tool'"});
  for(var b = 0;b < this.tools;b++) {
    if(this.tools[b] == a) {
      this.tools.splice(b, 1);
      break
    }
  }
}, getTool:function(a) {
  for(var b = 0;b < this.tools.length;b++) {
    var c = this.tools[b];
    if(c.getId() == a) {
      return c
    }
  }
  return null
}, getTools:function() {
  return this.tools
}, getToolsByType:function(a) {
  for(var b = [], c = 0;c < this.tools.length;c++) {
    this.tools[c].getType() == a && b.push(this.tools[c])
  }
  return b
}, removeToolById:function() {
  Ext.Error.raise({msg:"MapComponent.removeToolById() Not implemented! Must be implemented in sub-class"})
}, addComponent:function(a) {
  a instanceof viewer.viewercontroller.controller.Component || (Ext.Error.raise({msg:"Given tool not of type 'Component'", options:{tool:a}}), Ext.err());
  this.components.push(a)
}, addMap:function() {
  Ext.Error.raise({msg:"MapComponent.addMap() Not implemented! Must be implemented in sub-class"})
}, getMap:function() {
  Ext.Error.raise({msg:"MapComponent.getMap() Not implemented! Must be implemented in sub-class"})
}, removeMap:function() {
  Ext.Error.raise({msg:"MapComponent.removeMap() Not implemented! Must be implemented in sub-class"})
}, handleEvents:function() {
  Ext.Error.raise({msg:"MapComponent.handleEvents() Not implemented! Must be implemented in sub-class"})
}, initEvents:function() {
  Ext.Error.raise({msg:"MapComponent.initEvent() Not implemented! Must be implemented in sub-class"})
}, getGenericEventName:function(a) {
  if(a == void 0 || a == null) {
    return null
  }
  this.eventList.length == 0 && this.initEvents();
  for(var b in this.eventList) {
    if(this.eventList[b] == a) {
      return b
    }
  }
  return null
}, getSpecificEventName:function(a) {
  return this.eventList[a]
}, activateTool:function() {
  Ext.Error.raise({msg:"MapComponent.activateTool() Not implemented! Must be implemented in sub-class"})
}, getWidth:function() {
  Ext.Error.raise({msg:"MapComponent.getWidth() Not implemented! Must be implemented in sub-class"})
}, getHeight:function() {
  Ext.Error.raise({msg:"MapComponent.getHeight() Not implemented! Must be implemented in sub-class"})
}});
// Input 2
Ext.define("viewer.components.Component", {extend:"Ext.util.Observable", events:null, popup:null, config:{name:"naam", div:{}, viewerController:null, isPopup:false, hasSharedPopup:false, regionName:""}, defaultButtonWidth:46, defaultButtonHeight:46, forceState:false, haveSprite:false, constructor:function(a) {
  var b = this;
  b.initConfig(a);
  b.createIconStylesheet();
  if(b.isPopup) {
    b.popup = Ext.create("viewer.components.ScreenPopup", a), b.popup.setComponent(b), b.popup.popupWin.addListener("resize", function() {
      b.doResize()
    }), b.popup.setIconClass(b.getPopupIcon())
  }
  b.name && b.title && b.viewerController.layoutManager.setTabTitle(b.name, b.title);
  b.events = [];
  return b
}, getContentDiv:function() {
  return this.isPopup ? this.popup.getContentId() : this.div
}, renderButton:function(a) {
  var b = this, c = null, d = "", e = "", f = b.defaultButtonWidth, g = this.getBaseClass();
  b.options = a;
  a.icon ? c = a.icon : b.haveSprite ? e = "applicationSpriteClass buttonDefaultClass_normal " + g + "_normal" : (d = a.text || b.name || "", f = "autoWidth");
  b.button = Ext.create("Ext.button.Button", {text:d, cls:e, renderTo:b.div, scale:"large", icon:c, tooltip:a.tooltip || null, handler:function() {
    b.popup && b.popup.isVisible() ? b.popup.hide() : (b.viewerController.showLoading(b.title || ""), setTimeout(function() {
      a.handler();
      b.viewerController.hideLoading()
    }, 0))
  }, width:f, height:b.defaultButtonHeight, enableToggle:true, style:{height:b.defaultButtonHeight + "px"}, listeners:{click:function() {
    b.setButtonState("click")
  }, mouseover:function() {
    b.setButtonState("hover")
  }, mouseout:function() {
    b.setButtonState("normal")
  }}})
}, setButtonState:function(a, b) {
  var c = this.button, d = this.getBaseClass();
  if(this.options && this.button) {
    if(!this.options.icon && this.haveSprite && (!this.forceState || b)) {
      a == "hover" ? (c.removeCls(d + "_normal"), c.removeCls(d + "_click"), c.removeCls("buttonDefaultClass_click"), c.removeCls("buttonDefaultClass_normal"), c.addCls("buttonDefaultClass_hover"), c.addCls(d + "_hover")) : a == "click" ? (c.removeCls(d + "_normal"), c.removeCls(d + "_hover"), c.removeCls("buttonDefaultClass_normal"), c.removeCls("buttonDefaultClass_hover"), c.addCls("buttonDefaultClass_click"), c.addCls(d + "_click")) : (c.removeCls(d + "_click"), c.removeCls(d + "_hover"), c.removeCls("buttonDefaultClass_click"), 
      c.removeCls("buttonDefaultClass_hover"), c.addCls("buttonDefaultClass_normal"), c.addCls(d + "_normal"))
    }
    a == "click" && (!this.forceState || b) && !c.pressed ? c.toggle() : (!this.forceState || b) && c.pressed && c.toggle();
    if(b && this.forceState) {
      this.forceState = false
    }else {
      if(b && !this.forceState) {
        this.forceState = b
      }
    }
  }
}, getBaseClass:function() {
  return this.$className.replace(/\./g, "")
}, getPopupIcon:function() {
  var a = this.getBaseClass();
  if(this.config.titlebarIcon) {
    var b = a + "_popupicon";
    Ext.util.CSS.createStyleSheet("." + b + " { background-image: url('" + this.config.titlebarIcon + "') !important; }", a + "iconStyle");
    return b
  }
  return"applicationSpriteClassPopup " + a + "_popup"
}, createIconStylesheet:function() {
  if(document.getElementById("appSpriteStyle") != null) {
    this.haveSprite = true
  }else {
    var a = this.viewerController.getApplicationSprite();
    if(Ext.isEmpty(a)) {
      this.haveSprite = false
    }else {
      this.haveSprite = true;
      a.indexOf("://") == -1 && (a.indexOf("/viewer/") == 0 && (a = a.substring(7)), !a.charAt(0) == "/" && (a = "/" + a), a = contextPath + a);
      var b = {normal:3, hover:2, click:1}, c = ".applicationSpriteClass button { background-image: url('" + a + "') !important; width: 100%; height: 100%; } ";
      c += ".applicationSpriteClassPopup { background-image: url('" + a + "') !important; } ";
      c += " .buttonDefaultClass_normal button { background-position: -" + (b.normal - 1) * 55 + "px 0px; } ";
      c += " .buttonDefaultClass_hover button { background-position: -" + (b.hover - 1) * 55 + "px 0px; } ";
      c += " .buttonDefaultClass_click button { background-position: -" + (b.click - 1) * 55 + "px 0px; } ";
      Ext.Object.each({viewercomponentsSelectionModule:2, viewercomponentsLegend:3, viewercomponentsBuffer:4, viewercomponentsDataSelection:5, viewercomponentsSearch:6, viewercomponentsEdit:7, viewercomponentsDrawing:8, viewercomponentsBookmark:9, viewercomponentsTransparencySlider:10, viewercomponentsInfluenceImage:11, viewercomponentsRelatedDocuments:12, viewercomponentsAttributeList:13, viewercomponentsPrint:15}, function(a, e) {
        Ext.Object.each(b, function(b, g) {
          c += " ." + a + "_" + b + " button { background-position: -" + ((g - 1) * 55 + 3) + "px -" + ((e - 1) * 55 + 3) + "px !important; }"
        });
        c += " ." + a + "_popup { background-position: -575px -" + ((e - 1) * 55 + 14) + "px !important; }"
      });
      Ext.util.CSS.createStyleSheet(c, "appSpriteStyle")
    }
  }
}, bind:function(a, b, c, d) {
  this.addListener(a, b, d)
}, isTool:function() {
  return this.superclass && this.superclass.$className && (this.superclass.$className == "viewer.viewercontroller.controller.Tool" || this.superclass.$className == "viewer.components.tools.JSButton")
}, resizeScreenComponent:function() {
  !this.isTool() && !this.isPopup && this.doResize();
  MobileManager.isMobile() && this.isPopup && (this.popup.resizePopup(), this.doResize())
}, doResize:function() {
  if(this.getExtComponents) {
    for(var a = this.getExtComponents(), b = 0;b < a.length;b++) {
      var c = Ext.getCmp(a[b]);
      c != void 0 && c != null && (c.doLayout ? c.doLayout() : c.forceComponentLayout && c.forceComponentLayout())
    }
  }
}});
// Input 3
Ext.define("viewer.components.LogMessage", {statics:{ERROR:"error", WARNING:"warning", INFO:"info", DEBUG:"debug"}, config:{type:"", message:""}, date:null, constructor:function(a) {
  this.initConfig(a);
  this.date = new Date
}, toHtmlElement:function() {
  var a = new Ext.Element(document.createElement("div"));
  a.addCls("logger_" + this.getType());
  a.insertHtml("beforeEnd", this.date.toString() + ": <br/>" + this.getMessage());
  return a
}});
// Input 4
Ext.define("viewer.components.Logger", {config:{title:"Logger", logLevel:0}, statics:{LEVEL_ERROR:2, LEVEL_WARNING:1, LEVEL_INFO:0, LEVEL_DEBUG:-1}, popup:null, messageDiv:null, messages:null, iconDiv:null, iconSize:16, constructor:function(a) {
  this.initConfig(a);
  this.messages = [];
  var b = this;
  Ext.EventManager.onWindowResize(function() {
    b.onResize()
  }, this)
}, error:function(a) {
  this.logLevel <= viewer.components.Logger.LEVEL_ERROR && (this.message(a, viewer.components.LogMessage.ERROR), console.log(a))
}, warning:function(a) {
  this.logLevel <= viewer.components.Logger.LEVEL_WARNING && this.message(a, viewer.components.LogMessage.WARNING)
}, warn:function(a) {
  this.warning.call(this, a)
}, info:function(a) {
  this.logLevel <= viewer.components.Logger.LEVEL_INFO && this.message(a, viewer.components.LogMessage.INFO)
}, debug:function(a) {
  this.logLevel <= viewer.components.Logger.LEVEL_DEBUG && this.message(a, viewer.components.LogMessage.DEBUG)
}, message:function(a, b) {
  var c = Ext.create("viewer.components.LogMessage", {message:a, type:b});
  this.messages.push(c);
  this.popup != null && this.messageDiv.appendChild(c.toHtmlElement());
  b != viewer.components.LogMessage.DEBUG && this.setIconVisible(true)
}, show:function() {
  if(this.popup == null) {
    this.popup = Ext.create("viewer.components.ScreenPopup", this.config);
    var a = Ext.get(this.popup.getContentId());
    Ext.create("Ext.container.Container", {renderTo:this.popup.getContentId(), width:"100%", items:{xtype:"button", text:"Clear", style:{"float":"right", marginLeft:"5px"}, listeners:{click:{scope:this, fn:function() {
      this.clear()
    }}}}});
    this.messageDiv = new Ext.Element(document.createElement("div"));
    this.messageDiv.addCls("logger_messages");
    a.appendChild(this.messageDiv);
    for(a = 0;a < this.messages.length;a++) {
      this.messageDiv.appendChild(this.messages[a].toHtmlElement())
    }
  }
  this.popup.show()
}, clear:function() {
  this.messageDiv.update("");
  this.messages = [];
  this.setIconVisible(false)
}, setIconVisible:function(a) {
  if(a && this.iconDiv == null) {
    this.iconDiv = new Ext.Element(document.createElement("div")), this.iconDiv.addCls("logger_icon"), this.iconDiv.applyStyles({left:"0px", top:Ext.getBody().getHeight() - this.iconSize + "px", width:this.iconSize + "px", height:this.iconSize + "px"}), this.iconDiv.on("click", function() {
      this.show();
      this.setIconVisible(false)
    }, this), Ext.getBody().appendChild(this.iconDiv)
  }
  this.iconDiv != null && this.iconDiv.setVisible(a)
}, onResize:function() {
  this.iconDiv != null && this.iconDiv.applyStyles({top:Ext.getBody().getHeight() - this.iconSize + "px"})
}});
// Input 5
Ext.define("viewer.components.DataSelectionChecker", {config:{viewerController:null}, constructor:function(a) {
  this.initConfig(a);
  this.viewerController.addListener(viewer.viewercontroller.controller.Event.ON_COMPONENTS_FINISHED_LOADING, this.init, this)
}, init:function() {
  this.viewerController.mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_VISIBILITY_CHANGED, this.layerVisibilityChanged, this);
  this.viewerController.mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_ADDED, this.layerVisibilityChanged, this)
}, layerVisibilityChanged:function(a, b) {
  var c = this.viewerController.getAppLayerById(b.layer.appLayerId);
  c && c.checked && this.hasLayerDataSelectionAttributes(c, function(a) {
    a || setTimeout(function() {
      this.viewerController.setLayerVisible(c, false)
    }, 100)
  })
}, hasLayerDataSelectionAttributes:function(a, b) {
  if(a) {
    var c = this.viewerController.getAppLayerFeatureService(a);
    if(a != null) {
      var d = this;
      a.attributes == void 0 ? c.loadAttributes(a, function() {
        b(d.checkAppLayerForDataselection(a), d)
      }) : b(this.checkAppLayerForDataselection(a), d)
    }else {
      return b(true, d)
    }
  }else {
    return b(true, d)
  }
}, checkAppLayerForDataselection:function(a) {
  var b = this.hasSelectableAttributes(a);
  if(b >= 0 && (a.filter == void 0 || a.filter == null)) {
    var c = a.alias || a.layerName, d = this.viewerController.getComponentsByClassName("viewer.components.DataSelection");
    if(d.length == 0) {
      this.viewerController.logger.warning('Dataselectiemodule niet beschikbaar, kaartlaag "' + c + '" kan niet weergegeven worden.')
    }else {
      for(var e = false, f = 0;f < d.length;f++) {
        var g = d[f], h = a;
        if(g.allLayers || g.hasAppLayerConfigured(a)) {
          e = true;
          this.viewerController.addListener(viewer.viewercontroller.controller.Event.ON_FILTER_ACTIVATED, function(b, c) {
            h.serviceId == c.serviceId && h.layerName == c.layerName && (this.viewerController.setLayerVisible(h, true), g.removeForcedLayer(a))
          }, this);
          if(b == 1) {
            return g.applyFilterWithDefaults(), true
          }else {
            g.showAndForceLayer(a)
          }
          g.selectAppLayer(a)
        }
      }
      e || this.viewerController.logger.warning('Kaartlaag "' + c + '" niet geconfigureerd bij een dataselectiecomponent.')
    }
    return false
  }else {
    return true
  }
}, hasSelectableAttributes:function(a) {
  for(var b = -1, c = 0;c < a.attributes.length;c++) {
    if(a.attributes[c].selectable) {
      if(a.attributes[c].defaultValue) {
        b = 1
      }else {
        b = 0;
        break
      }
    }
  }
  return b
}});
// Input 6
Ext.override(Ext.form.field.Picker, {expand:function() {
  var a = this;
  a.callOverridden();
  window.setTimeout(function() {
    a.getPicker().el.alignTo(a.inputEl, "tl-bl?")
  }, 0)
}});
typeof MobileManager !== "undefined" && MobileManager.isMobile() && (Ext.override(Ext.form.field.ComboBox, {editable:false}), Ext.override(Ext.form.field.Trigger, {editable:false}));
Ext.override(Ext.form.field.HtmlEditor, {defaultValue:""});
// Input 7
Ext.define("viewer.components.ScreenPopup", {popupWin:null, config:{title:"", showOnStartup:null, details:{x:100, y:100, width:400, height:600, changeablePosition:true, changeableSize:true, items:null, position:"center"}}, component:null, currentOrientation:null, constructor:function(a) {
  var b = this;
  this.initConfig(a);
  var c = {title:this.title || "Titel", closable:true, closeAction:"hide", hideMode:"offsets", width:parseInt(this.details.width), height:parseInt(this.details.height), resizable:"true" == this.details.changeableSize, draggable:"true" == this.details.changeablePosition, layout:"fit", modal:false, renderTo:Ext.getBody(), autoScroll:true};
  if(this.details.position == "fixed" && !MobileManager.isMobile()) {
    a = Ext.get("wrapper"), c.x = parseInt(this.details.x) + a.getX(), c.y = parseInt(this.details.y) + a.getY()
  }
  if(MobileManager.isMobile()) {
    c.modal = true, c.width = "90%", c.height = "90%", c.draggable = false, c.resizable = false, this.currentOrientation = MobileManager.getOrientation()
  }
  this.details.items ? (c.items = this.details.items, c.bodyStyle = {background:"#fff"}) : (a = document.createElement("div"), a.style.height = "100%", a.style.background = "#FFFFFF", a.style.width = "100%", c.contentEl = a);
  this.popupWin = Ext.create("Ext.window.Window", c);
  this.showOnStartup && this.popupWin.show();
  c.draggable && (this.popupWin.addListener("dragstart", this.disableBody, this), this.popupWin.addListener("dragend", this.enableBody, this));
  c.resizable && (this.popupWin.resizer.addListener("beforeresize", this.disableBody, this), this.popupWin.resizer.addListener("resize", this.enableBody, this));
  this.popupWin.addListener("hide", function() {
    b.component && b.component.setButtonState("normal", true);
    b.enableBody()
  });
  this.popupWin.addListener("show", function() {
    b.component && b.component.setButtonState("click", true);
    if(MobileManager.isMobile()) {
      if(MobileManager.getOrientation() !== b.currentOrientation) {
        b.currentOrientation = MobileManager.getOrientation(), setTimeout(function() {
          b.component.resizeScreenComponent()
        }, 0)
      }
      c.modal && MobileManager.closePopupOnTapMask(b.popupWin)
    }
  });
  if(MobileManager.isMobile() && MobileManager.hasHammer()) {
    (new Hammer(document.getElementById(b.popupWin.header.id))).ondoubletap = function() {
      b.hide()
    }
  }
  return this
}, setComponent:function(a) {
  this.component = a
}, getContentId:function() {
  return this.popupWin.contentEl.id
}, show:function() {
  this.popupWin.show()
}, hide:function() {
  this.popupWin.hide()
}, disableBody:function() {
  Ext.getBody().mask()
}, enableBody:function() {
  Ext.getBody().unmask()
}, setIconClass:function(a) {
  this.popupWin.setIconCls(a)
}, isVisible:function() {
  return this.popupWin.isVisible()
}, resizePopup:function() {
  if(MobileManager.isMobile() && this.isVisible()) {
    this.popupWin.setSize(Ext.Element.getViewportWidth() * 0.9, Ext.Element.getViewportHeight() * 0.9), this.popupWin.setPosition(Ext.Element.getViewportWidth() * 0.05, Ext.Element.getViewportHeight() * 0.05), this.popupWin.doLayout(), this.currentOrientation = MobileManager.getOrientation()
  }
}});
// Input 8
Ext.define("viewer.components.CQLFilterWrapper", {filters:null, logicOperators:null, config:{id:null, cql:null, operator:null, type:null}, constructor:function(a) {
  this.initConfig(a);
  this.filters = [];
  this.logicOperators = ["AND", "OR"];
  if(!this.type) {
    this.type = "ATTRIBUTE"
  }
}, getCQL:function() {
  for(var a = this.getInternalCQL(), b = 0;b < this.logicOperators.length;b++) {
    var a = Ext.String.trim(a), c = this.logicOperators[b];
    a.indexOf(c) == 0 && (a = a.substr(c.length))
  }
  return a
}, getCQLWithoutType:function(a) {
  for(var a = this.getInternalCQLWithoutType(a), b = 0;b < this.logicOperators.length;b++) {
    var a = Ext.String.trim(a), c = this.logicOperators[b];
    a.indexOf(c) == 0 && (a = a.substr(c.length))
  }
  return a
}, getInternalCQLWithoutType:function(a) {
  var b = "";
  this.type != a && this.cql != "" && (b = " " + this.operator + " " + this.cql);
  for(var c = 0;c < this.filters.length;c++) {
    var d = this.filters[c];
    d.type != a && (b += d.getInternalCQLWithoutType(a))
  }
  return b
}, getInternalCQL:function() {
  var a = "";
  this.cql != "" && (a = " " + this.operator + " " + this.cql);
  for(var b = 0;b < this.filters.length;b++) {
    a += this.filters[b].getInternalCQL()
  }
  return a
}, addFilter:function(a) {
  this.filters.push(a)
}, removeFilter:function(a) {
  this.removeFilterById(a.id)
}, removeFilterById:function(a) {
  for(var b = 0;b < this.filters.length;b++) {
    if(this.filters[b].id == a) {
      this.filters.splice(b, 1);
      break
    }
  }
  return this
}, addOrReplace:function(a) {
  this.removeFilter(a);
  this.addFilter(a)
}});
// Input 9
Ext.define("viewer.components.MobileSlider", {extend:"Ext.util.Observable", xtype:"mobileslider", sliderid:"", labelid:"", eventTimer:null, config:{width:"100%", value:0, increment:1, fieldLabel:"", minValue:0, maxValue:100, renderTo:""}, constructor:function(a) {
  this.initConfig(a);
  this.render();
  this.addEvents("change", "changecomplete");
  this.listeners = a.listeners;
  this.callParent(arguments)
}, render:function() {
  var a = this;
  a.sliderid = Ext.id();
  a.labelid = Ext.id();
  var b = document.createElement("label");
  b.id = a.labelid;
  if(a.config.fieldLabel !== "") {
    b.innerHTML = a.config.fieldLabel
  }
  var c = document.createElement("div");
  c.className = "slidercomponent";
  if(a.config.width !== "100%") {
    c.style.width = a.config.width
  }
  var d = document.createElement("div");
  d.className = "rangecontrol minrangecontrol";
  var e = document.createElement("div");
  e.className = "rangecontrol plusrangecontrol";
  var f = document.createElement("input");
  f.id = a.sliderid;
  f.type = "range";
  f.min = a.config.minValue;
  f.max = a.config.maxValue;
  f.value = a.config.value;
  c.appendChild(d);
  c.appendChild(f);
  c.appendChild(e);
  document.getElementById(a.config.renderTo).appendChild(b);
  document.getElementById(a.config.renderTo).appendChild(c);
  a.holdButton(d, "subtract", f, 100, 2);
  a.holdButton(e, "add", f, 100, 2);
  f.onchange = function() {
    a.sliderChanged(f, f.value)
  }
}, holdButton:function(a, b, c, d, e) {
  var f, g = this, h = function() {
    if(b == "add" && c.value < 100) {
      c.value++
    }else {
      if(b == "subtract" && c.value > 0) {
        c.value--
      }else {
        clearTimeout(f);
        return
      }
    }
    f = setTimeout(h, d);
    d /= e;
    g.sliderChanged(c, c.value)
  };
  MobileManager.hasHammer() ? (a = new Hammer(a), a.onhold = h, a.onrelease = function() {
    clearTimeout(f)
  }) : a.onclick = function() {
    h();
    clearTimeout(f)
  }
}, sliderChanged:function(a, b) {
  var c = this;
  c.eventTimer !== null && clearTimeout(c.eventTimer);
  c.eventTimer = setTimeout(function() {
    c.fireEvent("change", a, b);
    c.fireEvent("changecomplete", a, b);
    c.config.tipText && c.changeLabel(c.config.tipText(a))
  }, 50)
}, changeLabel:function(a) {
  var b = "";
  this.config.fieldLabel !== "" && (b = this.config.fieldLabel + " ");
  document.getElementById(this.labelid).innerHTML = b + a
}, setValue:function(a) {
  if(this.sliderid !== "") {
    var b = document.getElementById(this.sliderid);
    b.value = a;
    this.sliderChanged(b, a)
  }
}, getValue:function() {
  return this.sliderid !== "" ? document.getElementById(this.sliderid).value : 0
}, getId:function() {
  return this.sliderid
}});
// Input 10
Ext.define("viewer.components.FlamingoCombobox", {alias:"widget.flamingocombobox", constructor:function(a) {
  return typeof MobileManager !== "undefined" && MobileManager.isMobile() ? Ext.create("viewer.components.MobileCombobox", a) : Ext.create("Ext.form.ComboBox", a)
}});
// Input 11
Ext.define("viewer.components.MobileCombobox", {extend:"Ext.form.field.Base", alias:"widget.mobilecombo", options:null, fieldSubTpl:['<select id="{id}" ', '<tpl if="name">name="{name}" </tpl>', '<tpl if="tabIdx">tabIndex="{tabIdx}" </tpl>', 'class="{fieldCls} {typeCls}">{options}</select>', {compiled:true, disableFormats:true}], inputType:"select", focusCls:"", emptyIndex:null, inputEl:{dom:{}}, prevValue:null, renderComplete:false, config:{fieldLabel:"", emptyText:"", store:null, displayField:"text", 
valueField:"id", listeners:{}, renderTo:"", value:"", width:"100%", disabled:false, id:"", name:"", labelWidth:150, style:{}, hidden:false, emptyCls:"x-form-empty-field"}, constructor:function(a) {
  this.initConfig(a);
  if(this.id === "") {
    this.id = Ext.id()
  }
  this.listeners = a.listeners;
  a = this.bindStore(a);
  this.callParent(arguments);
  this.bindChangeEvent();
  this.renderComplete = true
}, bindStore:function(a) {
  var b = this;
  if(Ext.isArray(b.store)) {
    var c = [b.valueField, b.displayField];
    if(b.store.length > 0 && !Ext.isArray(b.store[0])) {
      b.displayField = b.valueField, c = [{name:b.valueField, convert:function(a, b) {
        return b.raw
      }}]
    }
    b.store = Ext.create("Ext.data.ArrayStore", {fields:c, data:b.store})
  }else {
    if(!(b.store instanceof Ext.data.AbstractStore)) {
      b.store = Ext.create("Ext.data.ArrayStore", b.store)
    }
  }
  b.store.on("datachanged", function() {
    b.updateSelect()
  });
  b.createOptionsFromStore();
  a.store = b.store;
  return a
}, afterRender:function() {
  this.width && this.inputEl.setWidth(this.width);
  this.style && !this.style.width && this.inputEl.setStyle(this.style);
  this.disabled && this.setDisabled(this.disabled);
  this.hidden && this.inputEl.setVisible(!this.hidden)
}, onFocus:function() {
}, bindChangeEvent:function() {
  var a = this;
  a.inputEl.dom.addEventListener ? a.inputEl.dom.addEventListener("change", function() {
    a.fireChangeEvent()
  }, false) : a.inputEl.dom.attachEvent && a.inputEl.dom.attachEvent("change", function() {
    a.fireChangeEvent()
  });
  a.prevValue = a.getValue()
}, fireChangeEvent:function() {
  this.fireEvent("change", this, this.getValue(), this.prevValue, {})
}, createOptionsFromStore:function() {
  var a = this, b = 0, c = a.getValue();
  a.options = [];
  if(a.emptyText) {
    a.emptyIndex = b, a.options.push({index:b++, display:a.emptyText, value:"", html:'<option value="" class="' + this.emptyCls + '">' + a.emptyText + "</option>"})
  }
  a.store.each(function(d) {
    var e = d.get(a.valueField), d = d.get(a.displayField), f = Ext.isObject(e) ? Ext.id() : e;
    a.options.push({index:b++, display:d, value:e, html:'<option value="' + f + '"' + (e == c ? ' selected="selected"' : "") + ">" + d + "</option>"})
  });
  a.prevValue = c;
  return a.options
}, getOptionsHTML:function() {
  this.options === null && this.createOptionsFromStore();
  var a = "", b;
  for(b in this.options) {
    a += this.options[b].html
  }
  return a
}, getSubTplData:function() {
  return{id:this.getInputId(), cmpId:this.id, name:this.name || "", tabIdx:this.tabIndex || null, fieldCls:"", typeCls:"", options:this.getOptionsHTML()}
}, updateSelect:function() {
  this.createOptionsFromStore();
  this.inputEl.dom.innerHTML = this.getOptionsHTML()
}, getStore:function() {
  return this.store
}, setValue:function(a) {
  if(a == null) {
    this.clearValue()
  }else {
    for(var b in this.options) {
      if(this.options[b].value == a) {
        this.inputEl.dom.selectedIndex = this.options[b].index
      }
    }
    this.rendered && this.fireChangeEvent()
  }
}, select:function(a) {
  this.setValue(a)
}, getValue:function() {
  if(!this.rendered) {
    return null
  }
  for(var a in this.options) {
    if(this.options[a].index === this.inputEl.dom.selectedIndex) {
      return this.options[a].value
    }
  }
  return null
}, getRawValue:function() {
  if(this.inputEl.dom.selectedIndex === -1) {
    return""
  }
  var a = this.inputEl.dom[this.inputEl.dom.selectedIndex];
  return typeof a === "undefined" ? "" : a.value
}, clearValue:function() {
  this.inputEl.dom.selectedIndex = 0
}, setDisabled:function(a) {
  this.inputEl.dom.disabled = a;
  this.rendered && this.callParent(arguments)
}, getId:function() {
  return this.sliderid
}, setVisible:function(a) {
  viewer.components.MobileCombobox.superclass.setVisible.call(this, a);
  this.inputEl.setVisible(a)
}});
// Input 12
Ext.define("viewer.ServiceInfo", {config:{actionbeanUrl:null, protocol:"wms", url:null}, url:null, constructor:function(a) {
  this.initConfig(a);
  if(this.config.actionbeanUrl == null) {
    this.config.actionbeanUrl = actionBeans.service
  }
}, loadInfo:function(a, b) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:this.config, success:function(c) {
    c = Ext.JSON.decode(c.responseText);
    c.success ? a(c.service) : b != void 0 && b(c.error)
  }, failure:function(a) {
    b != void 0 && b("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}});
// Input 13
Ext.define("viewer.CSWClient", {config:{actionbeanUrl:null, url:null}, url:null, constructor:function(a) {
  this.initConfig(a);
  if(this.config.actionbeanUrl == null) {
    this.config.actionbeanUrl = actionBeans.csw
  }
}, loadInfo:function(a, b) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:this.config, success:function(c) {
    c = Ext.JSON.decode(c.responseText);
    c.success ? a(c.results) : b != void 0 && b(c.error)
  }, failure:function(a) {
    b != void 0 && b("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}});
// Input 14
Ext.define("viewer.DirectFeatureService", {config:{actionBeanUrl:null, appLayer:null, protocol:null, url:null}, constructor:function(a) {
  this.initConfig(a);
  if(this.config.actionbeanUrl == null) {
    this.config.actionbeanUrl = actionBeans.feature
  }
}, loadAttributes:function(a, b) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{getLayerFeatureType:true, protocol:this.protocol, layer:this.appLayer.layerName}, success:function(c) {
    c = Ext.JSON.decode(c.responseText);
    c.success ? a(c.attributes) : b != void 0 && b(c.error)
  }, failure:function(a) {
    b != void 0 && b("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}});
Ext.define("viewer.AppLayerService", {config:{actionbeanUrl:null, appId:null, appLayer:null, debug:false}, constructor:function(a) {
  if(a.actionbeanUrl == null) {
    a.actionbeanUrl = actionBeans.attributes
  }
  this.initConfig(a)
}, loadAttributes:function(a, b, c) {
  isNaN(a.id) ? c != void 0 && c("Ajax request failed with status " + result.status + " " + result.statusText + ": " + result.responseText) : Ext.Ajax.request({url:this.config.actionbeanUrl, params:{attributes:true, application:this.appId, appLayer:this.appLayer.id}, success:function(d) {
    d = Ext.JSON.decode(d.responseText);
    d.success ? (a.attributes = d.attributes, a.geometryAttributeIndex = d.geometryAttributeIndex, a.geometryAttribute = d.geometryAttribute, b(d.attributes)) : c != void 0 && c(d.error)
  }, failure:function(a) {
    c != void 0 && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}, getStoreUrl:function() {
  var a = this.getActionbeanUrl();
  return Ext.urlAppend(a, "store=1&application=" + this.appId + "&appLayer=" + this.appLayer.id + (this.debug ? "&debug=true" : ""))
}});
// Input 15
Ext.define("viewer.SLD", {config:{actionbeanUrl:null}, constructor:function(a) {
  this.initConfig(a);
  if(this.config.actionbeanUrl == null) {
    this.config.actionbeanUrl = actionBeans.sld
  }
}, create:function(a, b, c, d, e) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{layers:a, styles:b, filters:c}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? d(a.sld) : e != void 0 && e(a.error)
  }, failure:function(a) {
    e != void 0 && e("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}});
// Input 16
Ext.define("viewer.Bookmark", {config:{actionbeanUrl:null}, constructor:function(a) {
  this.initConfig(a);
  if(this.config.actionbeanUrl == null) {
    this.config.actionbeanUrl = actionBeans.bookmark
  }
}, createBookmark:function(a, b, c) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{create:true, "bookmark.params":a}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? b(a.bookmark) : c != void 0 && c(a.error)
  }, failure:function(a) {
    c != void 0 && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}, getBookmarkParams:function(a, b, c) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{load:true, bookmark:a}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? b(a.params) : c != void 0 && c(a.error)
  }, failure:function(a) {
    c != void 0 && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}});
// Input 17
Ext.define("viewer.components.LayerSelector", {extend:"viewer.components.Component", popupWin:null, layerList:null, layerArray:null, combobox:null, div:null, forcedLayers:null, config:{viewerController:{}, restriction:null, layers:null}, constructor:function(a) {
  this.initConfig(a);
  this.forcedLayers = [];
  a = Ext.create("Ext.data.Store", {fields:["id", "title", "layer"], data:[]});
  this.combobox = Ext.create("viewer.components.FlamingoCombobox", {fieldLabel:"Kies kaartlaag", emptyText:"Maak uw keuze", store:a, queryMode:"local", displayField:"title", valueField:"layer", listeners:{change:{fn:this.changed, scope:this}}, renderTo:this.div});
  this.addEvents(viewer.viewercontroller.controller.Event.ON_LAYERSELECTOR_CHANGE);
  var a = actionBeans.layerlist, b = {};
  b[this.restriction] = true;
  b.appId = appId;
  var c = this;
  if(this.layers != null && this.layers.length > 0) {
    b.layers = this.layers, b.hasConfiguredLayers = true
  }
  Ext.Ajax.request({url:a, params:b, success:function(a) {
    c.layerList = Ext.JSON.decode(a.responseText);
    c.initLayers()
  }, failure:function() {
    Ext.MessageBox.alert("Foutmelding", "Er is een onbekende fout opgetreden waardoor de lijst met kaartlagen niet kan worden weergegeven")
  }});
  this.viewerController.mapComponent.getMap().addListener(viewer.viewercontroller.controller.Event.ON_LAYER_VISIBILITY_CHANGED, this.layerVisibilityChanged, this);
  return this
}, addForcedLayer:function(a) {
  for(var b = false, c = 0;c < this.forcedLayers.length;c++) {
    if(this.forcedLayers[c] == a) {
      b = true;
      break
    }
  }
  b || this.forcedLayers.push(a)
}, removeForcedLayer:function(a) {
  for(var b = this.forcedLayers.length - 1;b >= 0;b--) {
    this.forcedLayers[b] == a && this.forcedLayers.splice(b, 1)
  }
}, initLayers:function() {
  this.layerArray = [];
  for(var a = this.viewerController.getVisibleLayers(), b = 0;b < this.forcedLayers.length;b++) {
    a.push(this.forcedLayers[b].id)
  }
  var c = this.combobox.getStore();
  c.removeAll();
  var d = 0;
  if(this.layerList != null) {
    for(b = 0;b < this.layerList.length;b++) {
      for(var e = this.layerList[b], f = 0;f < a.length;f++) {
        if(a[f] == e.id || a[f] == "" + e.id) {
          c.add({id:e.id, title:e.alias || e.layerName, layer:e});
          d++;
          break
        }
      }
    }
  }
  d === 0 ? (this.combobox.inputEl.dom.placeholder = "Geen kaartlagen beschikbaar", this.combobox.setDisabled(true)) : (this.combobox.inputEl.dom.placeholder = "Maak uw keuze", this.combobox.setDisabled(false))
}, changed:function(a, b, c) {
  a = null;
  b && (a = this.viewerController.getAppLayerById(b.id));
  this.fireEvent(viewer.viewercontroller.controller.Event.ON_LAYERSELECTOR_CHANGE, a, c, this)
}, getValue:function() {
  var a = this.combobox.getValue();
  return a ? this.viewerController.getAppLayerById(a.id) : null
}, setValue:function(a) {
  this.combobox.setValue(a)
}, getSelectedAppLayer:function() {
  var a = this.getValue();
  return a == null ? null : this.viewerController.getAppLayerById(a.id)
}, getExtComponents:function() {
  return[this.combobox.getId()]
}, layerVisibilityChanged:function() {
  this.initLayers()
}});
// Input 18
Ext.define("viewer.CombineImage", {config:{actionbeanUrl:null}, constructor:function(a) {
  this.initConfig(a);
  if(this.config.actionbeanUrl == null) {
    this.config.actionbeanUrl = actionBeans.combineimage
  }
}, getImageUrl:function(a, b, c) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{create:true, params:a}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? b(a.imageUrl) : c != void 0 && c(a.error)
  }, failure:function(a) {
    c != void 0 && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}});
// Input 19
Ext.define("viewer.FeatureInfo", {config:{actionBeanUrl:null, viewerController:null}, constructor:function(a) {
  this.initConfig(a);
  if(this.config.actionbeanUrl == null) {
    this.config.actionbeanUrl = actionBeans.featureinfo
  }
}, getVisibleAppLayers:function() {
  var a = this.viewerController.getVisibleLayers(), b = {}, c;
  for(c in a) {
    var d = viewerController.getAppLayerById(a[c]);
    d != null && (b[d.id] = true)
  }
  return b
}, featureInfoInternal:function(a, b, c) {
  var d = this, a = Ext.apply(a, {application:this.viewerController.app.id});
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:a, timeout:4E4, success:function(a) {
    var a = Ext.JSON.decode(a.responseText), c;
    for(c in a) {
      var g = a[c];
      if(g.request.appLayer) {
        g.appLayer = d.viewerController.app.appLayers[g.request.appLayer]
      }else {
        if(g.request.service) {
          g.service = d.viewerController.app.services[g.request.service]
        }
      }
    }
    b(a)
  }, failure:function(a) {
    c != void 0 && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}, featureInfo:function(a, b, c, d, e) {
  var f = this.getVisibleAppLayers(), g = [], h;
  for(h in f) {
    var i = this.viewerController.app.appLayers[h], j = {appLayer:i.id};
    if(i.filter) {
      j.filter = i.filter.getCQL()
    }
    g.push(j)
  }
  this.featureInfoInternal({featureInfo:true, x:a, y:b, distance:c, queryJSON:Ext.JSON.encode(g)}, d, e)
}, layersFeatureInfo:function(a, b, c, d, e, f) {
  var g = this.getVisibleAppLayers(), h = [], i;
  for(i in d) {
    var j = d[i];
    if(g[j.id] === true) {
      var k = {appLayer:j.id};
      if(j.filter) {
        k.filter = j.filter.getCQLWithoutType("GEOMETRY")
      }
      h.push(k)
    }
  }
  a = {featureInfo:true, x:a, y:b, distance:c, queryJSON:Ext.JSON.encode(h)};
  h.length > 0 && this.featureInfoInternal(a, e, f)
}, editFeatureInfo:function(a, b, c, d, e, f) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{application:this.viewerController.app.id, featureInfo:true, edit:true, arrays:true, x:a, y:b, distance:c, queryJSON:Ext.JSON.encode([{appLayer:d.id}])}, timeout:4E4, success:function(a) {
    a = Ext.JSON.decode(a.responseText)[0];
    a.error ? f("Error finding feature to edit: " + a.error) : e(a.features)
  }, failure:function(a) {
    f != void 0 && f("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}});
// Input 20
Ext.define("viewer.EditFeature", {config:{actionBeanUrl:null, viewerController:null}, constructor:function(a) {
  this.initConfig(a);
  if(this.config.actionbeanUrl == null) {
    this.config.actionbeanUrl = actionBeans.editfeature
  }
}, edit:function(a, b, c, d) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{application:this.viewerController.app.id, appLayer:a.id, feature:Ext.JSON.encode(b)}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? a.hasOwnProperty("__fid") ? c(a.__fid) : c(null) : d != void 0 && d(a.error)
  }, failure:function(a) {
    d != void 0 && d("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}});
// Input 21
Ext.define("viewer.ArcQueryUtil", {config:{actionbeanUrl:null}, constructor:function(a) {
  this.initConfig(a);
  if(this.config.actionbeanUrl == null) {
    this.config.actionbeanUrl = actionBeans.arcqueryutil
  }
}, cqlToArcXMLSpatialQuery:function(a, b, c) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{cql:a}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? b(a.SPATIALQUERY) : c != void 0 && c(a.error)
  }, failure:function(a) {
    c != void 0 && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}, cqlToArcXMLWhere:function(a, b, c) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{cql:a, whereOnly:true}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? b(a.where) : c != void 0 && c(a.error)
  }, failure:function(a) {
    c != void 0 && c("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}, cqlToArcFIDS:function(a, b, c, d) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{cql:a, getObjectIds:true, appLayer:b, application:appId}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? c(a.objectIds, a.objectIdFieldName) : d != void 0 && d(a.message)
  }, failure:function(a) {
    d != void 0 && d("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}});
// Input 22
Ext.define("viewer.Twitter", {config:{actionbeanUrl:null}, constructor:function(a) {
  this.initConfig(a);
  if(this.config.actionbeanUrl == null) {
    this.config.actionbeanUrl = actionBeans.twitter
  }
}, getTweets:function(a, b, c, d, e) {
  Ext.Ajax.request({url:this.config.actionbeanUrl, params:{term:a, rpp:b, latestId:c}, success:function(a) {
    a = Ext.JSON.decode(a.responseText);
    a.success ? d(a) : e != void 0 && e(a.error)
  }, failure:function(a) {
    e != void 0 && e("Ajax request failed with status " + a.status + " " + a.statusText + ": " + a.responseText)
  }})
}});
// Input 23
Ext.define("viewer.viewercontroller.controller.Map", {extend:"Ext.util.Observable", events:[], layers:[], frameworkMap:null, enabledEvents:{}, config:{id:null, mapComponent:null, viewerController:null, options:null}, constructor:function(a) {
  this.initConfig(a);
  this.addEvents(viewer.viewercontroller.controller.Event.ON_ALL_LAYERS_LOADING_COMPLETE, viewer.viewercontroller.controller.Event.ON_CHANGE_EXTENT, viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO, viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO_DATA, viewer.viewercontroller.controller.Event.ON_FINISHED_CHANGE_EXTENT, viewer.viewercontroller.controller.Event.ON_LAYER_VISIBILITY_CHANGED);
  return this
}, fire:function(a, b) {
  this.fireEvent(a, this, b)
}, getFrameworkMap:function() {
  return this.frameworkMap
}, addLayers:function(a) {
  for(var b = 0;b < a.length;b++) {
    this.addLayer(a[b])
  }
}, getLayers:function() {
  if(this.layers == void 0) {
    this.layers = []
  }
  return this.layers
}, getLayer:function(a) {
  for(var b = 0;b < this.layers.length;b++) {
    if(a == this.layers[b].getId()) {
      return this.layers[b]
    }
  }
  return null
}, removeLayerById:function(a) {
  this.removeLayer(this.getLayer(a))
}, removeAllLayers:function() {
  for(var a = this.layers.length - 1;a >= 0;a--) {
    this.removeLayer(this.layers[a])
  }
}, getLayerIndex:function(a) {
  for(var b = 0;b < this.getLayers().length;b++) {
    if(this.getLayers()[b] == a) {
      return b
    }
  }
  return-1
}, addLayer:function(a) {
  this.layers.push(a);
  a.setMap(this)
}, removeLayer:function(a) {
  a = this.getLayerIndex(a);
  a == -1 ? this.viewerController.logger.warning("Map.removeLayer(): Layer not available in map!") : this.layers.splice(a, 1)
}, setLayerIndex:function(a, b) {
  a instanceof viewer.viewercontroller.controller.Layer || Ext.Error.raise({msg:"Given layer not of type Layer"});
  var c = this.getLayerIndex(a), d = [], e = this.getLayers(), f = e.length, g = 0;
  e.splice(c, 1);
  for(var h = 0;h < f;h++) {
    b == h ? d.push(a) : (d.push(e[g]), g++)
  }
  this.layers = d;
  return c
}, setLayerVisible:function(a, b) {
  this.viewerController.app.appLayers[a.appLayerId].checked = b
}, getId:function() {
  Ext.Error.raise({msg:"Map.getId() Not implemented! Must be implemented in sub-class"})
}, getAllWMSLayers:function() {
  Ext.Error.raise({msg:"Map.getAllWMSLayers() Not implemented! Must be implemented in sub-class"})
}, getAllVectorLayers:function() {
  Ext.Error.raise({msg:"Map.getAllVectorLayers() Not implemented! Must be implemented in sub-class"})
}, remove:function() {
  Ext.Error.raise({msg:"Map.remove() Not implemented! Must be implemented in sub-class"})
}, zoomToExtent:function() {
  Ext.Error.raise({msg:"Map.moveToExtent() Not implemented! Must be implemented in sub-class"})
}, zoomToMaxExtent:function() {
  Ext.Error.raise({msg:"Map.zoomToMaxExtent() Not implemented! Must be implemented in sub-class"})
}, zoomToScale:function() {
  Ext.Error.raise({msg:"Map.zoomToScale() Not implemented! Must be implemented in sub-class"})
}, zoomToResolution:function() {
  Ext.Error.raise({msg:"Map.zoomToResolution() Not implemented! Must be implemented in sub-class"})
}, moveTo:function() {
  Ext.Error.raise({msg:"Map.moveTo() Not implemented! Must be implemented in sub-class"})
}, getExtent:function() {
  Ext.Error.raise({msg:"Map.getExtent() Not implemented! Must be implemented in sub-class"})
}, setMaxExtent:function() {
  Ext.Error.raise({msg:"Map.setMaxExtent() Not implemented! Must be implemented in sub-class"})
}, getMaxExtent:function() {
  Ext.Error.raise({msg:"Map.getFullExtent() Not implemented! Must be implemented in sub-class"})
}, doIdentify:function() {
  Ext.Error.raise({msg:"Map.doIdentify() Not implemented! Must be implemented in sub-class"})
}, update:function() {
  Ext.Error.raise({msg:"Map.update() Not implemented! Must be implemented in sub-class"})
}, setMarker:function() {
  Ext.Error.raise({msg:"Map.setMarker() Not implemented! Must be implemented in sub-class"})
}, removeMarker:function() {
  Ext.Error.raise({msg:"Map.removeMarker() Not implemented! Must be implemented in sub-class"})
}, getScale:function() {
  Ext.Error.raise({msg:"Map.getScale() Not implemented! Must be implemented in sub-class"})
}, getResolution:function() {
  Ext.Error.raise({msg:"Map.getResolution() Not implemented! Must be implemented in sub-class"})
}, coordinateToPixel:function() {
  Ext.Error.raise({msg:"Map.coordinateToPixel() Not implemented! Must be implemented in sub-class"})
}, getCenter:function() {
  Ext.Error.raise({msg:"Map.getCenter() Not implemented! Must be implemented in sub-class"})
}, getWidth:function() {
  Ext.Error.raise({msg:"Map.getWidth() Not implemented! Must be implemented in sub-class"})
}, getHeight:function() {
  Ext.Error.raise({msg:"Map.getHeight() Not implemented! Must be implemented in sub-class"})
}});
// Input 24
Ext.define("viewer.viewercontroller.controller.Layer", {extend:"Ext.util.Observable", statics:{WMS_TYPE:"WMS", ARCSERVER_TYPE:"ARCSERVER", ARCSERVERREST_TYPE:"ARCSERVERREST", ARCIMS_TYPE:"ARCIMS", VECTOR_TYPE:"VECTOR", IMAGE_TYPE:"IMAGE", TILING_TYPE:"TILING"}, maptips:[], map:null, visible:true, serviceId:null, config:{id:null, options:null, viewerController:null, url:null, appLayerId:null, frameworkLayer:null}, constructor:function(a) {
  this.initConfig(a);
  this.callParent(arguments)
}, getOption:function(a) {
  var b = "", c;
  for(c in this.options) {
    if(c.toLowerCase() == a.toLowerCase()) {
      return this.options[c]
    }
    b += c + ","
  }
  return null
}, getAppLayerName:function() {
  return this.viewerController.app.appLayers[this.appLayerId].layerName
}, addMapTip:function(a) {
  this.maptips.push(a)
}, setMaptips:function(a) {
  this.maptips = a
}, getMaptips:function() {
  return this.maptips
}, getMapTipByFeatureType:function(a) {
  for(var b = 0;b < this.maptips.length;b++) {
    if(this.maptips[b].layer == a || this.maptips[b].aka == a) {
      return this.maptips[b]
    }
  }
  return null
}, getMap:function() {
  return this.map
}, setMap:function(a) {
  this.map = a
}, getType:function() {
  Ext.Error.raise({msg:"Layer.getType() Not implemented! Must be implemented in sub-class"})
}, setOption:function() {
  Ext.Error.raise({msg:"Layer.getOption() Not implemented! Must be implemented in sub-class"})
}, getLayers:function() {
  Ext.Error.raise({msg:"Get layers must be implemented by implementation"})
}, setAlpha:function() {
  Ext.Error.raise({msg:"Layer.setAlpha() Not implemented! Must be implemented in sub-class"})
}, setVisible:function() {
  Ext.Error.raise({msg:"Layer.setVisible() Not implemented! Must be implemented in sub-class"})
}, getVisible:function() {
  Ext.Error.raise({msg:"Layer.getVisible() Not implemented! Must be implemented in sub-class"})
}, setQuery:function() {
  Ext.Error.raise({msg:"Layer.setQuery() Not implemented! Must be implemented in sub-class"})
}, getLayerLegendInfo:function() {
  Ext.Error.raise({msg:"Layer.getLayerLegendInfo() Not implemented! Must be implemented in sub-class"})
}, getLastMapRequest:function() {
  Ext.Error.raise({msg:"Layer.getLastMapRequest() Not implemented! Must be implemented in sub-class"})
}, reload:function() {
  Ext.Error.raise({msg:"Layer.reload() Not implemented! Must be implemented in sub-class"})
}, fire:function(a, b) {
  this.fireEvent(a, this, b)
}, destroy:function() {
  this.clearListeners();
  viewer.viewercontroller.controller.Layer.superclass.destroy.call(this)
}});
// Input 25
Ext.define("viewer.viewercontroller.controller.TilingLayer", {extend:"viewer.viewercontroller.controller.Layer", config:{protocol:null, resolutions:null, serviceEnvelope:null, tileWidth:null, tileHeight:null, extension:null}, constructor:function(a) {
  viewer.viewercontroller.controller.TilingLayer.superclass.constructor.call(this, a);
  this.type = viewer.viewercontroller.controller.Layer.TILING_TYPE
}, setQuery:function() {
}, getLayerLegendInfo:function() {
  return null
}});
// Input 26
Ext.define("viewer.viewercontroller.controller.WMSLayer", {extend:"viewer.viewercontroller.controller.Layer", constructor:function(a) {
  viewer.viewercontroller.controller.WMSLayer.superclass.constructor.call(this, a);
  this.type = viewer.viewercontroller.controller.Layer.WMS_TYPE;
  this.url = a.options.url
}, getLayerLegendInfo:function(a) {
  var b = this.id;
  if(this.appLayerId) {
    b = this.viewerController.getAppLayerById(this.appLayerId).alias
  }
  a({name:b, parts:[{url:this.getLegendGraphic()}]})
}, getLegendGraphic:function() {
  var a = this.url, b = a.indexOf("?") == -1 ? "?" : "&";
  a.substring(a.length) != b && (a += b);
  return a + "request=GetLegendGraphic&layer=" + this.getAppLayerName() + "&version=1.1.1&format=image/png"
}});
// Input 27
Ext.define("viewer.viewercontroller.controller.ImageLayer", {extend:"viewer.viewercontroller.controller.Layer", config:{extent:null}, constructor:function(a) {
  viewer.viewercontroller.controller.ImageLayer.superclass.constructor.call(this, a);
  this.type = viewer.viewercontroller.controller.Layer.IMAGE_TYPE
}, setExtent:function() {
  Ext.Error.raise({msg:"ImageLayer.setExtent() Not implemented! Must be implemented in sub-class"})
}, getLayerLegendInfo:function() {
  return null
}});
// Input 28
Ext.define("viewer.viewercontroller.controller.VectorLayer", {extend:"viewer.viewercontroller.controller.Layer", config:{geometrytypes:null, showmeasures:null, editable:true, labelPropertyName:null, style:{fillcolor:"0xFF0000", fillopacity:50, strokecolor:"0xFF0000", strokeopacity:100}, colorPrefix:null}, constructor:function(a) {
  viewer.viewercontroller.controller.VectorLayer.superclass.constructor.call(this, a)
}, removeAllFeatures:function() {
  Ext.Error.raise({msg:"VectorLayer.removeAllFeatures() Not implemented! Must be implemented in sub-class"})
}, removeFeature:function() {
  Ext.Error.raise({msg:"VectorLayer.removeFeature() Not implemented! Must be implemented in sub-class"})
}, getActiveFeature:function() {
  Ext.Error.raise({msg:"VectorLayer.getActiveFeature() Not implemented! Must be implemented in sub-class"})
}, getFeature:function() {
  Ext.Error.raise({msg:"VectorLayer.getFeature() Not implemented! Must be implemented in sub-class"})
}, getFeatureById:function() {
  Ext.Error.raise({msg:"VectorLayer.getFeatureById() Not implemented! Must be implemented in sub-class"})
}, getAllFeatures:function() {
  Ext.Error.raise({msg:"VectorLayer.getAllFeatures() Not implemented! Must be implemented in sub-class"})
}, addFeature:function() {
  Ext.Error.raise({msg:"VectorLayer.addFeature() Not implemented! Must be implemented in sub-class"})
}, addFeatures:function() {
  Ext.Error.raise({msg:"VectorLayer.addFeatures() Not implemented! Must be implemented in sub-class"})
}, drawFeature:function() {
  Ext.Error.raise({msg:"VectorLayer.drawFeature() Not implemented! Must be implemented in sub-class"})
}, stopDrawingFeature:function() {
  Ext.Error.raise({msg:"VectorLayer.stopDrawingFeature() Not implemented! Must be implemented in sub-class"})
}});
// Input 29
Ext.define("viewer.viewercontroller.controller.ArcLayer", {extend:"viewer.viewercontroller.controller.Layer", legendInfoCache:{}, constructor:function(a) {
  viewer.viewercontroller.controller.ArcLayer.superclass.constructor.call(this, a)
}, getLayerLegendInfo:function(a, b) {
  this.getType() == viewer.viewercontroller.controller.Layer.ARCSERVER_TYPE || this.getType() == viewer.viewercontroller.controller.Layer.ARCSERVERREST_TYPE ? this.getLayerLegendInfoArcGIS(function(b) {
    var d = {name:b.layerName, parts:[]}, e;
    for(e in b.legend) {
      var f = b.legend[e];
      d.parts.push({label:f.label, url:"data:" + f.contentType + ";base64," + f.imageData})
    }
    a(d)
  }, b) : (this.getViewerController().logger.warn("appLayer " + this.getAppLayerId() + ": legend for ArcXML layers not supported"), b())
}, getLayerLegendInfoArcGIS:function(a, b) {
  var c = this, d = "appLayer " + this.getAppLayerId() + ": legend for ArcGIS not available: ", e = this.getAppLayerId(), f = this.getViewerController().getAppLayerById(e), e = this.getViewerController().app.services[f.serviceId];
  if(e.arcGISVersion) {
    if(e.arcGISVersion.major < 10) {
      this.getViewerController().logger.warn(d + "needs at least ArcGIS Server version 10 but version is " + e.arcGISVersion.s), b()
    }else {
      var g = this.legendInfoCache[e.url];
      if(g && g.failedPreviously) {
        b()
      }else {
        var h = function(c) {
          (c = c[f.layerName]) ? a(c) : b()
        };
        g && !g.inProgress ? h(g) : g && g.inProgress ? g.joiners.push({success:h, failure:b}) : (g = {inProgress:true, joiners:[]}, this.legendInfoCache[e.url] = g, Ext.data.JsonP.request({url:e.url + "/legend", params:{f:"json"}, disableCaching:false, success:function(a) {
          for(var b in a.layers) {
            var c = a.layers[b];
            g[c.layerId] = c
          }
          g.inProgress = false;
          h(g);
          for(b in g.joiners) {
            g.joiners[b].success(g)
          }
          delete g.joiners
        }, failure:function(a) {
          g.failedPreviously = true;
          g.inProgress = false;
          c.getViewerController().logger.error(d + "error retrieving legend JSON from ArcGIS: " + a);
          b();
          for(var e in g.joiners) {
            g.joiners[e].failure()
          }
          delete g.joiners
        }}))
      }
    }
  }else {
    this.getViewerController().logger.warn(d + "no server version info, please update service registry"), b()
  }
}, getId:function() {
  Ext.Error.raise({msg:"ArcLayer.getId() Not implemented! Must be implemented in sub-class"})
}, reload:function() {
  Ext.Error.raise({msg:"ArcLayer.reload() Not implemented! Must be implemented in sub-class"})
}, getName:function() {
  Ext.Error.raise({msg:"ArcLayer.getName() Not implemented! Must be implemented in sub-class"})
}, getServer:function() {
  Ext.Error.raise({msg:"ArcLayer.getServer() Not implemented! Must be implemented in sub-class"})
}, getService:function() {
  Ext.Error.raise({msg:"ArcLayer.getService() Not implemented! Must be implemented in sub-class"})
}, getServlet:function() {
  Ext.Error.raise({msg:"ArcLayer.getServlet() Not implemented! Must be implemented in sub-class"})
}, getMapservice:function() {
  Ext.Error.raise({msg:"ArcLayer.getMapservice() Not implemented! Must be implemented in sub-class"})
}, getLayers:function() {
  Ext.Error.raise({msg:"ArcLayer.getLayers() Not implemented! Must be implemented in sub-class"})
}, setMaptips:function() {
  Ext.Error.raise({msg:"ArcLayer.setMaptips() Not implemented! Must be implemented in sub-class"})
}, passMaptips:function() {
  Ext.Error.raise({msg:"ArcLayer.passMaptips() Not implemented! Must be implemented in sub-class"})
}, setVisible:function() {
  Ext.Error.raise({msg:"ArcLayer.setVisible() Not implemented! Must be implemented in sub-class"})
}, getLegendGraphic:function() {
  Ext.Error.raise({msg:"ArcLayer.getLegendGraphic() Not implemented! Must be implemented in sub-class"})
}, setBuffer:function() {
  Ext.Error.raise({msg:"ArcLayer.setBuffer() Not implemented! Must be implemented in sub-class"})
}, removeBuffer:function() {
  Ext.Error.raise({msg:"ArcLayer.removeBuffer() Not implemented! Must be implemented in sub-class"})
}});
// Input 30
Ext.define("viewer.viewercontroller.controller.Feature", {config:{id:null, wktgeom:null, color:null, label:null}, constructor:function(a) {
  this.initConfig(a);
  if(this.label == null) {
    this.label = ""
  }
}, toJsonObject:function() {
  var a = {};
  a.id = this.id;
  a.wktgeom = this.wktgeom;
  a.color = this.color;
  a.label = this.label;
  return a
}});
// Input 31
function MapTip(a, b, c) {
  this.layer = a;
  this.mapTipField = b;
  this.aka = c
}
;
// Input 32
Ext.define("viewer.viewercontroller.controller.Extent", {minx:null, maxx:null, miny:null, maxy:null, constructor:function(a, b, c, d) {
  a != void 0 && b == void 0 && c == void 0 && d == void 0 ? (a = a.split(","), a.length != 4 && Ext.Error.raise({msg:"Can not create Extent because there is no bbox found"}), this.minx = a[0], this.miny = a[1], this.maxx = a[2], this.maxy = a[3]) : (this.minx = a, this.maxx = c, this.miny = b, this.maxy = d);
  return this
}, isIn:function(a, b) {
  return this.minx == null || this.maxx == null || this.miny == null || this.maxy == null ? false : a >= this.minx && a <= this.maxx && b >= this.miny && b <= this.maxy ? true : false
}, toWKT:function() {
  var a = "POLYGON((";
  a += this.minx + " " + this.miny + ", ";
  a += this.maxx + " " + this.miny + ", ";
  a += this.maxx + " " + this.maxy + ", ";
  a += this.minx + " " + this.maxy + ", ";
  a += this.minx + " " + this.miny + "))";
  return a
}, toString:function() {
  var a = "";
  a += this.minx + "," + this.miny + "," + this.maxx + "," + this.maxy;
  return a
}});
// Input 33
Ext.define("viewer.viewercontroller.controller.Event", {statics:{ON_CONFIG_COMPLETE:"ON_CONFIG_COMPLETE", ON_SET_TOOL:"ON_SET_TOOL", ON_GET_FEATURE_INFO_PROGRESS:"ON_GET_FEATURE_INFO_PROGRESS", ON_GET_FEATURE_INFO:"ON_GET_FEATURE_INFO", ON_GET_FEATURE_INFO_DATA:"ON_GET_FEATURE_INFO_DATA", ON_ALL_LAYERS_LOADING_COMPLETE:"ON_ALL_LAYERS_LOADING_COMPLETE", ON_CHANGE_EXTENT:"ON_CHANGE_EXTENT", ON_FINISHED_CHANGE_EXTENT:"ON_FINISHED_CHANGE_EXTENT", ON_LAYERS_INITIALIZED:"ON_LAYERS_INITIALIZED", ON_LAYER_ADDED:"ON_LAYER_ADDED", 
ON_LAYER_REMOVED:"ON_LAYER_REMOVED", ON_MAPTIP_CANCEL:"ON_MAPTIP_CANCEL", ON_GET_CAPABILITIES:"ON_REQUEST", ON_REQUEST:"ON_REQUEST", ON_LOADING_START:"ON_LOADING_START", ON_LOADING_END:"ON_LOADING_END", ON_MAPTIP:"ON_MAPTIP", ON_MAPTIP_DATA:"ON_MAPTIP_DATA", ON_EVENT_DOWN:"ON_EVENT_DOWN", ON_EVENT_UP:"ON_EVENT_UP", ON_EVENT_OVER:"ON_EVENT_OVER ", ON_CLICK:"ON_CLICK", ON_MEASURE:"ON_MEASURE", ON_ONIT:"ON_ONIT", ON_LAYER_VISIBILITY_CHANGED:"ON_LAYER_VISIBILITY_CHANGED", ON_LAYERSELECTOR_CHANGE:"ON_LAYERSELECTOR_CHANGE", 
ON_COMPONENTS_FINISHED_LOADING:"ON_COMPONENTS_FINISHED_LOADING", ON_SELECTEDCONTENT_CHANGE:"ON_SELECTEDCONTENT_CHANGE", ON_MAP_CLICKED:"ON_MAP_CLICKED", ON_ACTIVE_FEATURE_CHANGED:"ON_ACTIVE_FEATURE_CHANGED", ON_FEATURE_ADDED:"ON_FEATURE_ADDED", ON_FILTER_ACTIVATED:"ON_FILTER_ACTIVATED", ON_ACTIVATE:"ON_ACTIVATE", ON_DEACTIVATE:"ON_DEACTIVATE", ON_GET_SERVICE_INFO:"ON_GET_SERVICE_INFO"}});
// Input 34
Ext.define("viewer.viewercontroller.controller.Tool", {extend:"Ext.util.Observable", statics:{NAVIGATION_HISTORY:1, ZOOMIN_BOX:2, ZOOMOUT_BOX:3, PAN:4, SUPERPAN:5, GET_FEATURE_INFO:10, MEASURE:11, ZOOM_BAR:13, DEFAULT:15, PREVIOUS_EXTENT:19, NEXT_EXTENT:20, FULL_EXTENT:21, MAP_CLICK:22, TOGGLE:23, BUTTON:24, MAP_TOOL:25}, tool:null, mapComponent:null, events:null, config:{id:null, frameworkObject:null, visible:true, type:null, tooltip:null, iconUrl_up:null, iconUrl_over:null, iconUrl_sel:null, iconUrl_dis:null, 
viewerController:null}, constructor:function(a) {
  this.initConfig(a);
  this.events = [];
  return this
}, getFrameworkTool:function() {
  return this.frameworkObject
}, setToolVisible:function() {
  Ext.Error.raise({msg:"Tool.setVisible() not implemented! Must be implemented in sub-class"})
}, fire:function(a, b) {
  this.fireEvent(a, this, b)
}, isActive:function() {
  Ext.Error.raise({msg:"Tool.isActive() not implemented! Must be implemented in sub-class"})
}, activate:function() {
  Ext.Error.raise({msg:"Tool.activate() not implemented! Must be implemented in sub-class"})
}, deactivate:function() {
  Ext.Error.raise({msg:"Tool.deactivate() not implemented! Must be implemented in sub-class"})
}});
// Input 35
Ext.define("viewer.viewercontroller.controller.Component", {extend:"Ext.util.Observable", config:{id:null, frameworkObject:null, type:-1, viewerController:null}, constructor:function(a) {
  this.initConfig(a);
  return this
}, statics:{LOADING_BAR:1, SCALEBAR:2, BORDER_NAVIGATION:3, COORDINATES:4, NAVIGATIONPANEL:5, MAPTIP:6, LOADMONITOR:7, OVERVIEW:8}, setVisible:function() {
  Ext.Error.raise({msg:"setVisible() function must be implemented in implementation"})
}, destroy:function() {
  this.clearListeners();
  viewer.viewercontroller.controller.Component.superclass.destroy.call(this)
}});
// Input 36
Ext.define("viewer.viewercontroller.controller.ToolMapClick", {extend:"viewer.viewercontroller.controller.Tool", id:null, config:{name:null}, constructor:function(a) {
  viewer.viewercontroller.controller.ToolMapClick.superclass.constructor.call(this, a);
  return this
}, activateTool:function() {
  Ext.Error.raise({msg:"ToolMapClick.activateTool() Not implemented! Must be implemented in sub-class"})
}, deactivateTool:function() {
  Ext.Error.raise({msg:"ToolMapClick.deactivateTool() Not implemented! Must be implemented in sub-class"})
}});
