/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import nl.b3p.pzh.rwbp.entity.ConfigurableVariable;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieVariable;
import nl.b3p.pzh.rwbp.entity.VariableType;
import nl.b3p.pzh.rwbp.stripes.ViewerActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StrictBinding
public class AdminGeneralActionBean
extends ViewerActionBean {
    private static final Log log = LogFactory.getLog(AdminGeneralActionBean.class);
    private final String JSP = "/WEB-INF/jsp/admin/general.jsp";
    private List<ConfigurableVariable> vars = new ArrayList<ConfigurableVariable>();
    @ValidateNestedProperties(value={@Validate(field="value"), @Validate(field="id")})
    private Map<Integer, ProvincieVariable> varMap = new HashMap<Integer, ProvincieVariable>();

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution("/WEB-INF/jsp/admin/general.jsp");
    }

    public Resolution save() {
        Provincie p = this.gebruiker.resolveProvincie();
        EntityManager em = Stripersist.getEntityManager();
        Set<Integer> keys = this.varMap.keySet();
        for (Integer key : keys) {
            ProvincieVariable provVar = this.varMap.get(key);
            ConfigurableVariable cv = (ConfigurableVariable)em.find(ConfigurableVariable.class, (Object)key);
            provVar.setVariable(cv);
            provVar.setProvincie(p);
            em.persist((Object)provVar);
        }
        em.getTransaction().commit();
        this.createList();
        return new ForwardResolution("/WEB-INF/jsp/admin/general.jsp");
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    private void createList() {
        EntityManager em = Stripersist.getEntityManager();
        Provincie p = this.gebruiker.getProvincie();
        this.vars = em.createQuery("FROM ConfigurableVariable WHERE type = :type").setParameter("type", (Object)VariableType.GENERAL).getResultList();
        this.varMap = new HashMap<Integer, ProvincieVariable>();
        List provincieVars = em.createQuery("FROM ProvincieVariable WHERE provincie = :provincie AND variable in :vars").setParameter("provincie", (Object)p).setParameter("vars", this.vars).getResultList();
        for (ProvincieVariable provincieVariable : provincieVars) {
            this.varMap.put(provincieVariable.getVariable().getId(), provincieVariable);
        }
    }

    public List<ConfigurableVariable> getVars() {
        return this.vars;
    }

    public void setVars(List<ConfigurableVariable> vars) {
        this.vars = vars;
    }

    public Map<Integer, ProvincieVariable> getVarMap() {
        return this.varMap;
    }

    public void setVarMap(Map<Integer, ProvincieVariable> varMap) {
        this.varMap = varMap;
    }
}

