/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.tag.BeanFirstPopulationStrategy;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationErrorHandler;
import net.sourceforge.stripes.validation.ValidationErrors;
import nl.b3p.commons.stripes.CustomPopulationStrategy;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieService;
import nl.b3p.pzh.rwbp.stripes.ViewerActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StrictBinding
@CustomPopulationStrategy(value=BeanFirstPopulationStrategy.class)
public class AdminServicesActionBean
extends ViewerActionBean
implements ValidationErrorHandler {
    private static final Log log = LogFactory.getLog(AdminServicesActionBean.class);
    private final String JSP = "/WEB-INF/jsp/admin/services.jsp";
    private List<ProvincieService> services = new ArrayList<ProvincieService>();
    @ValidateNestedProperties(value={@Validate(field="url", mask="((([A-Za-z]{3,9}:(?:\\/\\/)?)(?:[-;:&=\\+\\$,\\w]+@)?[A-Za-z0-9.-]+|(?:www.|[-;:&=\\+\\$,\\w]+@)[A-Za-z0-9.-]+)((?:\\/[\\+~%\\/.\\w-_]*)?\\??(?:[-\\+=&;%@.\\w_]*)#?(?:[\\w]*))?)/?", required=true, maxlength=255, on={"save"}), @Validate(field="layers", label="Lagen", required=true, maxlength=255, on={"save"}), @Validate(field="name", maxlength=255), @Validate(field="defaultOn", on={"save"})})
    private ProvincieService service;
    @Validate
    private Integer serviceid;

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution("/WEB-INF/jsp/admin/services.jsp");
    }

    public Resolution selectService() {
        return new ForwardResolution("/WEB-INF/jsp/admin/services.jsp");
    }

    public Resolution save() {
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker g = this.getGebruiker();
        Provincie provincie = g.getProvincie();
        this.service.setProvincie(provincie);
        em.persist((Object)this.service);
        em.getTransaction().commit();
        this.serviceid = null;
        this.service = null;
        this.context.getMessages().add(new SimpleMessage("Service opgeslagen", new Object[0]));
        return new ForwardResolution("/WEB-INF/jsp/admin/services.jsp");
    }

    public Resolution delete() {
        EntityManager em = Stripersist.getEntityManager();
        em.remove((Object)this.service);
        em.getTransaction().commit();
        this.service = null;
        this.context.getMessages().add(new SimpleMessage("Service verwijderd", new Object[0]));
        return new ForwardResolution("/WEB-INF/jsp/admin/services.jsp");
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    private void loadEntity() {
        EntityManager em = Stripersist.getEntityManager();
        Integer id = null;
        try {
            id = Integer.parseInt(this.context.getRequest().getParameter("serviceid"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (id != null) {
            this.serviceid = id;
            this.service = (ProvincieService)em.find(ProvincieService.class, (Object)this.serviceid);
        }
    }

    @After(stages={LifecycleStage.EventHandling})
    private void createLists() {
        EntityManager em = Stripersist.getEntityManager();
        Provincie provincie = this.gebruiker.getProvincie();
        this.services = em.createQuery("FROM ProvincieService WHERE provincie = :provincie ORDER BY id").setParameter("provincie", (Object)provincie).getResultList();
    }

    public List<ProvincieService> getServices() {
        return this.services;
    }

    public void setServices(List<ProvincieService> services) {
        this.services = services;
    }

    public Integer getServiceid() {
        return this.serviceid;
    }

    public void setServiceid(Integer serviceid) {
        this.serviceid = serviceid;
    }

    public ProvincieService getService() {
        return this.service;
    }

    public void setService(ProvincieService service) {
        this.service = service;
    }

    public Resolution handleValidationErrors(ValidationErrors errors) throws Exception {
        this.createLists();
        return null;
    }
}

