CREATE OR REPLACE VIEW shape_view AS
select b.the_geom, b.id, b.naam as plannaam, g.naam as gemeente, r.naam as regio, b.gebruikeractiontijd as "laatste wijziging",
(select sum(f.planningaantal) from factmetperiode f where f.bouwplanid = b.id and f.factsoortid != 1 and f.factsoortid != 2 and f.factsoortid != 19) as "aantal gepland" 
from bouwplan b
left join gemeente g
on g.id = b.gemeenteid
left join regio r
on r.id = g.regioid
where b.statusprojectid != 11
and b.the_geom IS NOT NULL
  ORDER BY b.id;

ALTER TABLE shape_view OWNER TO rwbp;