CREATE OR REPLACE VIEW basis_view AS
select b.id, b.naam as plannaam, g.naam as gemeente, 
(select vs.type from bouwplanvoortgang bv left join voortgangstatus vs on vs.id = bv.voortgangstatusid where bv.voortgangsoortid = 1 and bv.bouwplanid = b.id) as voortgang, 
--s.type as "status (planologisch)", 
b.prognose_oplevering as oplevering,
(select sum(planningaantal) from factmetperiode where bouwplanid = b.id and factsoortid != 1 and factsoortid != 2 and factsoortid != 19) as "gepland nieuwbouw",
(select sum(planningaantal) from factmetperiode where bouwplanid = b.id and (factsoortid = 3 or factsoortid = 6 or factsoortid = 9 or factsoortid = 4 or factsoortid = 7 or factsoortid = 10 or factsoortid = 12 or factsoortid = 14 or factsoortid = 16)) as "gepland sociaal",
(select sum(planningaantal) from factmetperiode where bouwplanid = b.id and factsoortid = 2) as "gepland sloop",
(select sum(realisatieaantal) from factmetperiode where bouwplanid = b.id and factsoortid != 1 and factsoortid != 2 and factsoortid != 19) as "gerealiseerd nieuwbouw",
(select sum(realisatieaantal) from factmetperiode where bouwplanid = b.id and (factsoortid = 3 or factsoortid = 6 or factsoortid = 9 or factsoortid = 4 or factsoortid = 7 or factsoortid = 10 or factsoortid = 12 or factsoortid = 14 or factsoortid = 16)) as "gerealiseerd sociaal",
(select sum(realisatieaantal) from factmetperiode where bouwplanid = b.id and factsoortid = 2) as "gerealiseerd sloop"
from bouwplan b
left join gemeente g
on b.gemeenteid = g.id
left join statusplanologisch s
on b.statusplanologischid = s.id
where b.statusprojectid != 11
and b.the_geom IS NOT NULL
  ORDER BY id;

ALTER TABLE basis_view OWNER TO rwbp;