CREATE OR REPLACE VIEW planningaantal_per_soort_per_periode_per_bouwplan AS 
 SELECT b.id AS bouwplanid, p.id AS periodeid, p.omschrijving AS periodeomschrijving, fmt.factsoortid, fmt.planningaantal
   FROM bouwplan b, periode p, factmetperiode fmt
  WHERE fmt.bouwplanid = b.id AND fmt.periodeid = p.id
  AND b.the_geom IS NOT NULL
  ORDER BY b.id, p.id, p.omschrijving, fmt.factsoortid;

ALTER TABLE planningaantal_per_soort_per_periode_per_bouwplan OWNER TO rwbp;



CREATE OR REPLACE VIEW realisatieaantal_per_soort_per_periode_per_bouwplan AS 
 SELECT b.id AS bouwplanid, p.id AS periodeid, p.omschrijving AS periodeomschrijving, fmt.factsoortid, fmt.realisatieaantal
   FROM bouwplan b, periode p, factmetperiode fmt
  WHERE fmt.bouwplanid = b.id AND fmt.periodeid = p.id
  AND b.the_geom IS NOT NULL
  ORDER BY b.id, p.id, p.omschrijving, fmt.factsoortid;

ALTER TABLE realisatieaantal_per_soort_per_periode_per_bouwplan OWNER TO rwbp;


CREATE OR REPLACE VIEW gepland_view AS 
 SELECT p.bouwplanid as id, p.periodeomschrijving as omschrijving, 
 sum( CASE WHEN p.factsoortid <> 1 AND p.factsoortid <> 2 AND p.factsoortid <> 19 THEN p.planningaantal ELSE NULL::integer END) AS p_t, 
 max( CASE WHEN p.factsoortid = 3 THEN p.planningaantal ELSE NULL::integer END) AS p_h_eg_g, 
 max( CASE WHEN p.factsoortid = 5 THEN p.planningaantal ELSE NULL::integer END) AS p_h_eg_m, 
 max( CASE WHEN p.factsoortid = 21 THEN p.planningaantal ELSE NULL::integer END) AS p_h_eg_o, 
 max( CASE WHEN p.factsoortid = 4 THEN p.planningaantal ELSE NULL::integer END) AS p_h_eg_s, 
 max( CASE WHEN p.factsoortid = 6 THEN p.planningaantal ELSE NULL::integer END) AS p_h_mg_g, 
 max( CASE WHEN p.factsoortid = 8 THEN p.planningaantal ELSE NULL::integer END) AS p_h_mg_m, 
 max( CASE WHEN p.factsoortid = 22 THEN p.planningaantal ELSE NULL::integer END) AS p_h_mg_o, 
 max( CASE WHEN p.factsoortid = 7 THEN p.planningaantal ELSE NULL::integer END) AS p_h_mg_s, 
 max( CASE WHEN p.factsoortid = 9 THEN p.planningaantal ELSE NULL::integer END) AS p_h_on_g, 
 max( CASE WHEN p.factsoortid = 11 THEN p.planningaantal ELSE NULL::integer END) AS p_h_on_m,
 max( CASE WHEN p.factsoortid = 23 THEN p.planningaantal ELSE NULL::integer END) AS p_h_on_o, 
 max( CASE WHEN p.factsoortid = 10 THEN p.planningaantal ELSE NULL::integer END) AS p_h_on_s,
 max( CASE WHEN p.factsoortid = 13 THEN p.planningaantal ELSE NULL::integer END) AS p_k_eg_m, 
 max( CASE WHEN p.factsoortid = 24 THEN p.planningaantal ELSE NULL::integer END) AS p_k_eg_o, 
 max( CASE WHEN p.factsoortid = 12 THEN p.planningaantal ELSE NULL::integer END) AS p_k_eg_s, 
 max( CASE WHEN p.factsoortid = 15 THEN p.planningaantal ELSE NULL::integer END) AS p_k_mg_m, 
 max( CASE WHEN p.factsoortid = 25 THEN p.planningaantal ELSE NULL::integer END) AS p_k_mg_o, 
 max( CASE WHEN p.factsoortid = 14 THEN p.planningaantal ELSE NULL::integer END) AS p_k_mg_s, 
 max( CASE WHEN p.factsoortid = 17 THEN p.planningaantal ELSE NULL::integer END) AS p_k_on_m, 
 max( CASE WHEN p.factsoortid = 26 THEN p.planningaantal ELSE NULL::integer END) AS p_k_on_o,
 max( CASE WHEN p.factsoortid = 16 THEN p.planningaantal ELSE NULL::integer END) AS p_k_on_s, 
 max( CASE WHEN p.factsoortid = 18 THEN p.planningaantal ELSE NULL::integer END) AS p_o,
 max( CASE WHEN p.factsoortid = 2 THEN p.planningaantal ELSE NULL::integer END) AS p_s
 FROM planningaantal_per_soort_per_periode_per_bouwplan p
 GROUP BY p.bouwplanid, p.periodeomschrijving
 ORDER BY p.bouwplanid, p.periodeomschrijving;

ALTER TABLE gepland_view OWNER TO rwbp;


CREATE OR REPLACE VIEW gerealiseerd_view AS 
 SELECT p.bouwplanid as id, p.periodeomschrijving as omschrijving, 
 sum( CASE WHEN p.factsoortid <> 1 AND p.factsoortid <> 2 AND p.factsoortid <> 19 THEN p.realisatieaantal ELSE NULL::integer END) AS r_t, 
 max( CASE WHEN p.factsoortid = 3 THEN p.realisatieaantal ELSE NULL::integer END) AS r_h_eg_g, 
 max( CASE WHEN p.factsoortid = 5 THEN p.realisatieaantal ELSE NULL::integer END) AS r_h_eg_m, 
 max( CASE WHEN p.factsoortid = 21 THEN p.realisatieaantal ELSE NULL::integer END) AS r_h_eg_o, 
 max( CASE WHEN p.factsoortid = 4 THEN p.realisatieaantal ELSE NULL::integer END) AS r_h_eg_s, 
 max( CASE WHEN p.factsoortid = 6 THEN p.realisatieaantal ELSE NULL::integer END) AS r_h_mg_g, 
 max( CASE WHEN p.factsoortid = 8 THEN p.realisatieaantal ELSE NULL::integer END) AS r_h_mg_m, 
 max( CASE WHEN p.factsoortid = 22 THEN p.realisatieaantal ELSE NULL::integer END) AS r_h_mg_o, 
 max( CASE WHEN p.factsoortid = 7 THEN p.realisatieaantal ELSE NULL::integer END) AS r_h_mg_s, 
 max( CASE WHEN p.factsoortid = 9 THEN p.realisatieaantal ELSE NULL::integer END) AS r_h_on_g, 
 max( CASE WHEN p.factsoortid = 11 THEN p.realisatieaantal ELSE NULL::integer END) AS r_h_on_m,
 max( CASE WHEN p.factsoortid = 23 THEN p.realisatieaantal ELSE NULL::integer END) AS r_h_on_o, 
 max( CASE WHEN p.factsoortid = 10 THEN p.realisatieaantal ELSE NULL::integer END) AS r_h_on_s,
 max( CASE WHEN p.factsoortid = 13 THEN p.realisatieaantal ELSE NULL::integer END) AS r_k_eg_m, 
 max( CASE WHEN p.factsoortid = 24 THEN p.realisatieaantal ELSE NULL::integer END) AS r_k_eg_o, 
 max( CASE WHEN p.factsoortid = 12 THEN p.realisatieaantal ELSE NULL::integer END) AS r_k_eg_s, 
 max( CASE WHEN p.factsoortid = 15 THEN p.realisatieaantal ELSE NULL::integer END) AS r_k_mg_m, 
 max( CASE WHEN p.factsoortid = 25 THEN p.realisatieaantal ELSE NULL::integer END) AS r_k_mg_o, 
 max( CASE WHEN p.factsoortid = 14 THEN p.realisatieaantal ELSE NULL::integer END) AS r_k_mg_s, 
 max( CASE WHEN p.factsoortid = 17 THEN p.realisatieaantal ELSE NULL::integer END) AS r_k_on_m, 
 max( CASE WHEN p.factsoortid = 26 THEN p.realisatieaantal ELSE NULL::integer END) AS r_k_on_o,
 max( CASE WHEN p.factsoortid = 16 THEN p.realisatieaantal ELSE NULL::integer END) AS r_k_on_s, 
 max( CASE WHEN p.factsoortid = 18 THEN p.realisatieaantal ELSE NULL::integer END) AS r_o,
 max( CASE WHEN p.factsoortid = 2 THEN p.realisatieaantal ELSE NULL::integer END) AS r_s
 FROM realisatieaantal_per_soort_per_periode_per_bouwplan p
 GROUP BY p.bouwplanid, p.periodeomschrijving
 ORDER BY p.bouwplanid, p.periodeomschrijving;

ALTER TABLE gerealiseerd_view OWNER TO rwbp;