/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.parse;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.persistence.EntityManager;
import nl.b3p.commons.services.StreamCopy;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.BouwplanVariable;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Gebruikgegevens;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.entity.Ontwikkelaartype;
import nl.b3p.pzh.rwbp.entity.Plantype;
import nl.b3p.pzh.rwbp.entity.Statusplanologisch;
import nl.b3p.pzh.rwbp.entity.Statusproject;
import nl.b3p.pzh.rwbp.export.ExportConfigServlet;
import nl.b3p.pzh.rwbp.parse.Parser;
import nl.b3p.pzh.rwbp.parse.ShapeParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.stripesstuff.stripersist.Stripersist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ShapeParser
extends Parser {
    private static final Log log = LogFactory.getLog(ShapeParser.class);
    public static final String ID = "id";
    public static final String NAAM = "plannaam";
    public static final String GEMEENTE = "gemeente";
    public static final String PLAATSNAAM = "PLAATSNAAM";
    public static final String REFERENTIE = "referentie";
    public static final String BESTEMMINGSPLANNAAM = "best-plan";
    public static final String IMRO_NUMMER = "imronummer";
    public static final String MASTERPLAN = "masterplan";
    public static final String ONTWIKKELAARSTYPE = "opdr_type";
    public static final String ONTWIKKELAAR_NAMELIJK = "opdr_naam";
    public static final String PLANTYPE = "plantype";
    public static final String STATUSPLAN = "status_pla";
    public static final String STATUSPROJECT = "status_pro";
    public static final String KNELPUNTEN = "knelpunten";
    public static final String JAAR_BEGIN = "jaar_begin";
    public static final String JAAR_EIND = "jaar_eind";
    public static final String PLANCAPACITEIT = "totaalcap";
    public static final String RESTCAPACITEIT = "restcapaci";
    public static final String SLOOP = "sloop";
    public static final String RESTSLOOP = "rest_sloop";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Bouwplan> parse(InputStream is, Gebruiker gebruiker) throws IOException, Exception {
        String workingName = ExportConfigServlet.uniqueName((String)File.separator, (String)"", (boolean)true);
        File workingDir = new File(workingName);
        workingDir.mkdir();
        List bouwplannen = null;
        try {
            this.writeZipToWorkingDir(is, workingDir);
            bouwplannen = this.parseFiles(workingDir, gebruiker);
        }
        finally {
            ShapeParser.deleteDir((File)workingDir);
        }
        return bouwplannen;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            for (int i = 0; i < children.length; ++i) {
                boolean success = false;
                if (children[i].isDirectory()) {
                    ShapeParser.deleteDir((File)children[i]);
                    continue;
                }
                children[i].delete();
            }
            return dir.delete();
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZipToWorkingDir(InputStream is, File workingDir) throws IOException {
        ZipInputStream zip = new ZipInputStream(is);
        try {
            ZipEntry currentFile;
            byte[] buffer = new byte[2048];
            while ((currentFile = zip.getNextEntry()) != null) {
                String newFile = workingDir.getAbsolutePath() + File.separator + currentFile.getName();
                File file = new File(newFile);
                this.createParentDir(new File(newFile));
                if (currentFile.isDirectory()) continue;
                try {
                    FileOutputStream os = new FileOutputStream(newFile);
                    try {
                        StreamCopy.copy((InputStream)zip, (OutputStream)os);
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                }
                catch (FileNotFoundException fne) {
                    log.debug((Object)fne);
                }
                finally {
                    zip.closeEntry();
                }
            }
        }
        finally {
            zip.close();
        }
    }

    private List<Bouwplan> parseFiles(File file, Gebruiker gebruiker) throws IOException, Exception {
        ArrayList<Bouwplan> bouwplannen = new ArrayList<Bouwplan>();
        if (file.isDirectory() && file.listFiles() != null) {
            for (File f : file.listFiles()) {
                bouwplannen.addAll(this.parseFiles(f, gebruiker));
            }
        } else if (file.isFile() && file.getName().toLowerCase().endsWith(".shp")) {
            bouwplannen.addAll(this.parseShape(file, gebruiker));
        }
        return bouwplannen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Bouwplan> parseShape(File file, Gebruiker gebruiker) throws IOException, Exception {
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
        DataStore datastore = DataStoreFinder.getDataStore(map);
        SimpleFeatureSource fs = datastore.getFeatureSource(datastore.getTypeNames()[0]);
        FeatureCollection fc = fs.getFeatures();
        FeatureIterator iterator = fc.features();
        EntityManager em = Stripersist.getEntityManager();
        ArrayList<Bouwplan> bouwplannen = new ArrayList<Bouwplan>();
        try {
            while (iterator.hasNext()) {
                List list;
                List list2;
                EasyFeature f = new EasyFeature(this, iterator.next());
                Bouwplan b = new Bouwplan();
                b.setNaam(f.getString("plannaam"));
                String gemeente = f.getString("gemeente");
                if (gemeente != null && (list2 = em.createQuery("FROM Gemeente where naam=:n").setParameter("n", (Object)gemeente).getResultList()).size() > 0) {
                    b.setGemeente((Gemeente)list2.get(0));
                }
                b.setPlaatsnaam(f.getString("PLAATSNAAM"));
                b.setReferentienummer(f.getString("referentie"));
                b.setBestemmingsplannaam(f.getString("best-plan"));
                b.setImronummer(f.getString("imronummer"));
                b.setMasterplan(f.getString("masterplan"));
                String ontwType = f.getString("opdr_type");
                if (ontwType != null) {
                    List list3 = em.createQuery("FROM Ontwikkelaartype where type=:t").setParameter("t", (Object)ontwType).getResultList();
                    if (list3.size() > 0) {
                        b.setOntwikkelaartype((Ontwikkelaartype)list3.get(0));
                    }
                } else {
                    b.setOntwikkelaartype(null);
                }
                b.setOntwikkelaar_namelijk(f.getString("opdr_naam"));
                String plantype = f.getString("plantype");
                if (plantype != null) {
                    List list4 = em.createQuery("FROM Plantype where type=:t").setParameter("t", (Object)plantype).getResultList();
                    if (list4.size() > 0) {
                        b.setPlantype((Plantype)list4.get(0));
                    }
                } else {
                    b.setPlantype(null);
                }
                String statusPlan = f.getString("status_pla");
                if (statusPlan != null) {
                    List list5 = em.createQuery("FROM Statusplanologisch where type=:t").setParameter("t", (Object)statusPlan).getResultList();
                    if (list5.size() > 0) {
                        b.setStatusplanologisch((Statusplanologisch)list5.get(0));
                    }
                } else {
                    b.setStatusplanologisch(null);
                }
                String statusProject = f.getString("status_pro");
                if (statusProject != null && (list = em.createQuery("FROM Statusproject where type=:t").setParameter("t", (Object)statusProject).getResultList()).size() > 0) {
                    b.setStatusproject((Statusproject)list.get(0));
                }
                if (b.getStatusproject() == null) {
                    Statusproject sp = (Statusproject)em.find(Statusproject.class, (Object)Statusproject.ONBEKEND_ID);
                    b.setStatusproject(sp);
                }
                b.setKnelpunten(f.getString("knelpunten"));
                b.setJaar_eerste_oplevering(f.getInteger("jaar_begin"));
                b.setJaar_laatste_oplevering(f.getInteger("jaar_eind"));
                b.setTotaalcapaciteit(f.getInteger("totaalcap"));
                b.setRestcapaciteit(f.getInteger("restcapaci"));
                b.setResterendesloop(f.getInteger("rest_sloop"));
                b.setSloop(f.getInteger("sloop"));
                Gebruikgegevens gg = (Gebruikgegevens)em.find(Gebruikgegevens.class, (Object)3);
                b.setGebruikgegevens(gg);
                b.setDatumlaatstewijziging(new Date());
                List bvs = this.loadPlanning(b, f);
                b.setBouwplanVariables(bvs);
                Geometry geom = f.getGeometry();
                try {
                    b.setThe_geom(this.correctGeometry(geom));
                }
                catch (Exception cause) {
                    throw new Exception("Fout bij laden geometry van plan met naam: " + b.getNaam() + ". Reden: " + cause.getMessage(), cause);
                }
                bouwplannen.add(b);
            }
        }
        finally {
            iterator.close();
        }
        return bouwplannen;
    }

    private List<BouwplanVariable> loadPlanning(Bouwplan b, EasyFeature f) throws IOException {
        ArrayList<BouwplanVariable> bvs = new ArrayList<BouwplanVariable>();
        for (int i = 2013; i < 2041; ++i) {
            BouwplanVariable bv = this.getBouwplanVariable(b, f, i);
            bvs.add(bv);
        }
        return bvs;
    }

    private BouwplanVariable getBouwplanVariable(Bouwplan b, EasyFeature f, int year) {
        Integer value = 0;
        String key = "gep" + year;
        BouwplanVariable var = new BouwplanVariable();
        try {
            value = f.getInteger(key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        var.setBouwplan(b);
        var.setGepland(value);
        var.setYear(Integer.valueOf(year));
        return var;
    }

    private void createParentDir(File f) {
        if (f.getParentFile().exists()) {
            return;
        }
        f.getParentFile().mkdir();
        this.createParentDir(f.getParentFile());
    }
}

