Ext.define('B3p.planmonitor.TotalCounter', {
    totals: null,
    parentField: null,
    totalField: null,
    config: {
        parent: '',
        fields: [],
        subTotalSuffix: '-total',
        subTotalHiddenSuffix: '-total-hidden',
        total: '',
        totalChanged: null,
        repeatingFields: 1 // If fields are added multiple times using different classes then supply the no of times here
    },
    constructor: function(config) {
        this.initConfig(config);
        this.totals = {};
        this.parentField = document.querySelector(this.config.parent);
        if(this.config.total) {
            this.totalField = this.parentField.querySelector(this.config.total);
        }
        this.resetTotals();
        this.parentField.addEventListener('keyup', this.handleKeyup.bind(this));
    },
    resetTotals: function() {
        for(var i = 0; i < this.config.fields.length; i++) {
            this.totals[this.config.fields[i]] = 0;
            this.getTotalForField(this.config.fields[i]);
        }
    },
    handleKeyup: function(e) {
        if(e.target.tagName.toLowerCase() !== 'input') {
            return;
        }
        for(var i = 0; i < this.config.fields.length; i++) {
            if(e.target.className.indexOf(this.config.fields[i]) !== -1) {
                this.getTotalForField(this.config.fields[i]);
            }
        }
    },
    getTotalForField: function(field) {
        // Find all fields
        if(!this.parentField){
            return;
        }
        var total = 0;
        var fields = this.parentField.querySelectorAll('.' + field);
        for(var i = 0; i < fields.length; i++) {
            total += +(fields[i].value);
        }
        this.totals[field] = total;
        this.setSubTotal(field);
        return total;
    },
    setSubTotal: function(field) {
        // set total
        var subtotal = this.parentField.querySelector('.' + field + this.config.subTotalSuffix);
        if(subtotal) {
            subtotal.innerHTML = this.totals[field];
        }
        var hidden = this.parentField.querySelector('.' + field + this.config.subTotalHiddenSuffix);
        if(hidden){
            hidden.value = this.totals[field];
        }
        this.setTotal();
        if(this.config.totalChanged && Object.prototype.toString.call(this.config.totalChanged) === '[object Function]') {
            this.config.totalChanged(field, this.totals, this.getTotal());
        }
    },
    setTotal: function() {
        if(!this.totalField) {
            return;
        }
        var total = this.getTotal();
        this.totalField.innerHTML = total;
    },
    getTotal: function() {
        var total = 0;
        for(var field in this.totals) if(this.totals.hasOwnProperty(field)) {
            total += this.totals[field];
        }
        if(this.config.repeatingFields > 1) {
            total = total / this.config.repeatingFields;
        }
        return total;
    }
});