package nl.b3p.pzh.rwbp.entity;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author Meine Toonen meinetoonen@b3partners.nl
 */
@Entity
public class ProvincieAdditionalVariable {
    
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    
    private String additional_variable;
    
    @ManyToOne
    @JoinColumn(name="provincie")
    private Provincie provincie;

    private String type;

    private String location;

    private boolean additionField = true;

    private boolean usedByMunicipalities = true;

    private boolean provinceField = false;
    
    private String mainCategory;

    @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL,mappedBy = "provincieadditionalvariable")
    private List<ProvincieAdditionalVariableValue> values = new ArrayList<ProvincieAdditionalVariableValue>();


    @ManyToMany(fetch = FetchType.LAZY, cascade = CascadeType.PERSIST)
    @JoinTable(name="regio_additional_variable",
                joinColumns={@JoinColumn(name="value")},
                inverseJoinColumns={@JoinColumn(name="regio")})
    private List<Regio> regios = new ArrayList<Regio>();

    @OneToMany(orphanRemoval=true, cascade=CascadeType.ALL, mappedBy="variable", fetch = FetchType.LAZY)
    private List<BouwplanAdditionalVariable> bouwplanAdditionalVariables = new ArrayList<BouwplanAdditionalVariable>();

    private boolean label = false;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Provincie getProvincie() {
        return provincie;
    }

    public void setProvincie(Provincie provincie) {
        this.provincie = provincie;
    }

    public String getAdditional_variable() {
        return additional_variable;
    }

    public void setAdditional_variable(String additional_variable) {
        this.additional_variable = additional_variable;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean isAdditionField() {
        return additionField;
    }

    public void setAdditionField(boolean additionField) {
        this.additionField = additionField;
    }

    public List<ProvincieAdditionalVariableValue> getValues() {
        return values;
    }

    public void setValues(List<ProvincieAdditionalVariableValue> values) {
        this.values = values;
    }

    public void addValue(ProvincieAdditionalVariableValue value){
        this.values.add(value);
    }

    public List<Regio> getRegios() {
        return regios;
    }

    public void setRegios(List<Regio> regios) {
        this.regios = regios;
    }

    public boolean isUsedByMunicipalities() {
        return usedByMunicipalities;
    }

    public void setUsedByMunicipalities(boolean usedByMunicipalities) {
        this.usedByMunicipalities = usedByMunicipalities;
    }

    public boolean isProvinceField() {
        return provinceField;
    }

    public void setProvinceField(boolean provinceField) {
        this.provinceField = provinceField;
    }

    public boolean isLabel() {
        return label;
    }

    public void setLabel(boolean label) {
        this.label = label;
    }

    public List<BouwplanAdditionalVariable> getBouwplanAdditionalVariables() {
        return bouwplanAdditionalVariables;
    }

    public void setBouwplanAdditionalVariables(List<BouwplanAdditionalVariable> bouwplanAdditionalVariables) {
        this.bouwplanAdditionalVariables = bouwplanAdditionalVariables;
    }

    public String getMainCategory() {
        return mainCategory;
    }

    public void setMainCategory(String mainCategory) {
        this.mainCategory = mainCategory;
    }
    
    public JSONObject toJSON(Gemeente gemeente) throws JSONException{
        JSONObject json = new JSONObject();

        json.put("id", id);
        json.put("name", additional_variable);
        json.put("type", type);
        json.put("location",location);
        json.put("additionField", additionField);
        json.put("provinceField", provinceField);
        json.put("label", label);
        json.put("mainCategory", mainCategory);
        
        if(type.equalsIgnoreCase("dropdown") || label){
            JSONArray valuesArray = new JSONArray();
            for (ProvincieAdditionalVariableValue value : values) {
                boolean canAdd = false;
                if(gemeente != null){
                    if(gemeente.getRegio() == null && value.isUsedByMunicipalities()){
                        canAdd = true;
                    }else if (gemeente.getRegio() != null && value.getRegios().contains(gemeente.getRegio())){
                        canAdd = true;
                    }
                }else{
                    canAdd = true;
                }
                if (canAdd) {
                    JSONObject valueObject = value.toJSON();
                    valuesArray.put(valueObject);
                }
            }
            json.put("values",valuesArray);
        }else{
            JSONArray regiosArray = new JSONArray();
            for (Regio regio : regios) {
                regiosArray.put(regio.getId());
            }
            if(usedByMunicipalities){
                regiosArray.put(-1);
            }
            json.put("regios",regiosArray);
        }

        return json;
    }
}
