/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.OneToManyTypeConverter;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.imagetool.CombineImageSettings;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.BouwplanAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.BouwplanVariable;
import nl.b3p.pzh.rwbp.entity.ConfigurableVariable;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariableValue;
import nl.b3p.pzh.rwbp.entity.ProvincieVariable;
import nl.b3p.pzh.rwbp.entity.Regio;
import nl.b3p.pzh.rwbp.entity.VariableType;
import nl.b3p.pzh.rwbp.printen.PrintExtraInfo;
import nl.b3p.pzh.rwbp.printen.PrintInfo;
import nl.b3p.pzh.rwbp.printen.PrintInfoList;
import nl.b3p.pzh.rwbp.stripes.BouwplanUtils;
import nl.b3p.pzh.rwbp.stripes.EditActionBean;
import nl.b3p.pzh.rwbp.stripes.PrintActionBean;
import nl.b3p.pzh.rwbp.stripes.SearchActionBean;
import nl.b3p.pzh.rwbp.stripes.ViewerActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StrictBinding
public class PrintActionBean
extends ViewerActionBean {
    private static final Log log = LogFactory.getLog(PrintActionBean.class);
    protected static Logger fopLogger = Logger.getLogger((String)"org.apache.fop");
    public static final String A5_Landscape = "A5_Landscape.xsl";
    public static final String A5_Portrait = "A5_Portrait.xsl";
    public static final String A4_Landscape = "A4_Landscape.xsl";
    public static final String A4_Portrait = "A4_Portrait.xsl";
    public static final String A3_Landscape = "A3_Landscape.xsl";
    public static final String A3_Portrait = "A3_Portrait.xsl";
    public static final String A0_Landscape = "A0_Landscape.xsl";
    public static final String A0_Portrait = "A0_Portrait.xsl";
    public static final String DEFAULT_TEMPLATE_PATH = "/WEB-INF/print/";
    public static final String A5 = "a5";
    public static final String A4 = "a4";
    public static final String A3 = "a3";
    public static final String A0 = "a0";
    public static final String LANDSCAPE = "landscape";
    public static final String PORTRAIT = "portrait";
    public static SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy", new Locale("NL"));
    @Validate(converter=OneToManyTypeConverter.class, required=true)
    private List<Integer> bouwplans = new ArrayList();

    @DefaultHandler
    public Resolution print() throws JSONException, Exception {
        boolean authorized = this.isAuthorized();
        if (!authorized) {
            return new RedirectResolution(SearchActionBean.class, "close");
        }
        PrintInfoList pil = new PrintInfoList();
        EntityManager em = Stripersist.getEntityManager();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        for (Integer id : this.bouwplans) {
            Bouwplan bouwplan = (Bouwplan)em.find(Bouwplan.class, (Object)id);
            CombineImageSettings cis = EditActionBean.createCombineImageSettings((Bouwplan)bouwplan, (String)this.getMapserverUrl(), (String)this.getLayers(), (int)1600, (int)800, (String)this.getHttpRequestParams());
            PrintInfo info = new PrintInfo();
            if (cis != null) {
                String imageUrl = this.getImageUrl(bouwplan, cis.getWidth().intValue(), cis.getHeight().intValue());
                info.setImageUrl(imageUrl + "&key=" + cis.hashCode());
                info.setBbox(BouwplanUtils.makeBboxBouwplan((Bouwplan)bouwplan));
            }
            info.setTitle(bouwplan.getNaam());
            info.setSubtitle("www.planmonitorwonen.nl");
            info.setDate(df.format(new Date()));
            info.setRemark("Extratesk");
            log.debug((Object)"Print Parse 'extra'");
            JSONArray jarray = this.getExtra(bouwplan);
            ArrayList<PrintExtraInfo> peis = new ArrayList<PrintExtraInfo>();
            for (int i = 0; i < jarray.length(); ++i) {
                JSONObject extraObj = jarray.getJSONObject(i);
                PrintExtraInfo pei = new PrintExtraInfo();
                String className = extraObj.getString("className");
                String componentName = extraObj.getString("componentName");
                pei.setClassName(className);
                pei.setComponentName(componentName);
                pei.setInfoText(extraObj);
                peis.add(pei);
            }
            PrintExtraInfo additionalVars = new PrintExtraInfo();
            JSONObject vars = this.getAdditionalVars(bouwplan);
            additionalVars.setClassName("AdditionalVariables");
            additionalVars.setComponentName("AdditionalVariables");
            additionalVars.setInfoText(vars);
            peis.add(additionalVars);
            PrintExtraInfo subcategories = new PrintExtraInfo();
            JSONObject subVars = this.getSubcategories(bouwplan);
            subcategories.setClassName("SubCategories");
            subcategories.setComponentName("SubCategories");
            subcategories.setInfoText(subVars);
            peis.add(subcategories);
            PrintExtraInfo optionalVars = new PrintExtraInfo();
            JSONObject optVars = this.getOptionalVariables(bouwplan);
            optionalVars.setClassName("OptionalVariables");
            optionalVars.setComponentName("OptionalVariables");
            optionalVars.setInfoText(optVars);
            peis.add(optionalVars);
            PrintExtraInfo planningVars = new PrintExtraInfo();
            JSONObject dp = this.getDetailplannings(bouwplan);
            planningVars.setClassName("DetailPlanning");
            planningVars.setComponentName("DetailPlanning");
            planningVars.setInfoText(dp);
            peis.add(planningVars);
            info.setExtra(peis);
            pil.getInfos().add(info);
        }
        String pageFormat = A4;
        String orientation = PORTRAIT;
        String templateName = this.getTemplateName(pageFormat, orientation);
        String mimeType = "application/pdf";
        String templateUrl = this.context.getServletContext().getRealPath(DEFAULT_TEMPLATE_PATH + templateName);
        1 res = new /* Unavailable Anonymous Inner Class!! */;
        return res;
    }

    private JSONObject getDetailplannings(Bouwplan bouwplan) {
        JSONObject planning = new JSONObject();
        String detailType = bouwplan.getDetailType();
        planning.put("detailType", (Object)detailType);
        EntityManager em = Stripersist.getEntityManager();
        TypedQuery q = em.createQuery("FROM BouwplanVariable where bouwplan = :bouwplan order by year", BouwplanVariable.class).setParameter("bouwplan", (Object)bouwplan);
        List bvs = q.getResultList();
        JSONArray bvArray = new JSONArray();
        for (BouwplanVariable bv : bvs) {
            bvArray.put((Object)bv.toJSON());
        }
        if (detailType.equals("uitgebreid")) {
            int egkoop1 = 0;
            int egkoop2 = 0;
            int egkoop3 = 0;
            int egkoop4 = 0;
            int egkooponb = 0;
            int eghuur1 = 0;
            int eghuur2 = 0;
            int eghuur3 = 0;
            int eghuur4 = 0;
            int eghuuronb = 0;
            int egonbekend = 0;
            int mgkoop1 = 0;
            int mgkoop2 = 0;
            int mgkoop3 = 0;
            int mgkoop4 = 0;
            int mgkooponb = 0;
            int mghuur1 = 0;
            int mghuur2 = 0;
            int mghuur3 = 0;
            int mghuur4 = 0;
            int mghuuronb = 0;
            int mgonbekend = 0;
            int onbkoop1 = 0;
            int onbkoop2 = 0;
            int onbkoop3 = 0;
            int onbkoop4 = 0;
            int onbkooponb = 0;
            int onbhuur1 = 0;
            int onbhuur2 = 0;
            int onbhuur3 = 0;
            int onbhuur4 = 0;
            int onbhuuronb = 0;
            int onbonbekend = 0;
            int meergezinstotaal = 0;
            int eengezinstotaal = 0;
            int onbekendtotaal = 0;
            JSONObject totals = new JSONObject();
            for (BouwplanVariable bv : bvs) {
                egkoop1 += bv.getEengezinskoop1().intValue();
                egkoop2 += bv.getEengezinskoop2().intValue();
                egkoop3 += bv.getEengezinskoop3().intValue();
                egkoop4 += bv.getEengezinskoop4().intValue();
                egkooponb += bv.getEengezinskooponb().intValue();
                eghuur1 += bv.getEengezinshuur1().intValue();
                eghuur2 += bv.getEengezinshuur2().intValue();
                eghuur3 += bv.getEengezinshuur3().intValue();
                eghuur4 += bv.getEengezinshuur4().intValue();
                eghuuronb += bv.getEengezinshuuronb().intValue();
                egonbekend += bv.getEengezinsonbekend().intValue();
                mgkoop1 += bv.getMeergezinskoop1().intValue();
                mgkoop2 += bv.getMeergezinskoop2().intValue();
                mgkoop3 += bv.getMeergezinskoop3().intValue();
                mgkoop4 += bv.getMeergezinskoop4().intValue();
                mgkooponb += bv.getMeergezinskooponb().intValue();
                mghuur1 += bv.getMeergezinshuur1().intValue();
                mghuur2 += bv.getMeergezinshuur2().intValue();
                mghuur3 += bv.getMeergezinshuur3().intValue();
                mghuur4 += bv.getMeergezinshuur4().intValue();
                mghuuronb += bv.getMeergezinshuuronb().intValue();
                mgonbekend += bv.getMeergezinsonbekend().intValue();
                onbkoop1 += bv.getOnbekendkoop1().intValue();
                onbkoop2 += bv.getOnbekendkoop2().intValue();
                onbkoop3 += bv.getOnbekendkoop3().intValue();
                onbkoop4 += bv.getOnbekendkoop4().intValue();
                onbkooponb += bv.getOnbekendkooponb().intValue();
                onbhuur1 += bv.getOnbekendhuur1().intValue();
                onbhuur2 += bv.getOnbekendhuur2().intValue();
                onbhuur3 += bv.getOnbekendhuur3().intValue();
                onbhuur4 += bv.getOnbekendhuur4().intValue();
                onbhuuronb += bv.getOnbekendhuuronb().intValue();
                onbonbekend += bv.getOnbekendonbekend().intValue();
                Integer yearEgTotal = bv.getEengezinskoop1() + bv.getEengezinskoop2() + bv.getEengezinskoop3() + bv.getEengezinskoop4() + bv.getEengezinskooponb() + bv.getEengezinshuur1() + bv.getEengezinshuur2() + bv.getEengezinshuur3() + bv.getEengezinshuur4() + bv.getEengezinshuuronb() + bv.getEengezinsonbekend();
                Integer yearMgTotal = bv.getMeergezinskoop1() + bv.getMeergezinskoop2() + bv.getMeergezinskoop3() + bv.getMeergezinskoop4() + bv.getMeergezinskooponb() + bv.getMeergezinshuur1() + bv.getMeergezinshuur2() + bv.getMeergezinshuur3() + bv.getMeergezinshuur4() + bv.getMeergezinshuuronb() + bv.getMeergezinsonbekend();
                Integer yearOnbTotal = bv.getOnbekendkoop1() + bv.getOnbekendkoop2() + bv.getOnbekendkoop3() + bv.getOnbekendkoop4() + bv.getOnbekendkooponb() + bv.getOnbekendhuur1() + bv.getOnbekendhuur2() + bv.getOnbekendhuur3() + bv.getOnbekendhuur4() + bv.getOnbekendhuuronb() + bv.getOnbekendonbekend();
                meergezinstotaal += yearMgTotal.intValue();
                eengezinstotaal += yearEgTotal.intValue();
                onbekendtotaal += yearOnbTotal.intValue();
                totals.put("egYear" + bv.getYear(), (Object)yearEgTotal);
                totals.put("mgYear" + bv.getYear(), (Object)yearMgTotal);
                totals.put("onbYear" + bv.getYear(), (Object)yearOnbTotal);
            }
            totals.put("egkoop1", egkoop1);
            totals.put("egkoop2", egkoop2);
            totals.put("egkoop3", egkoop3);
            totals.put("egkoop4", egkoop4);
            totals.put("egkooponb", egkooponb);
            totals.put("eghuur1", eghuur1);
            totals.put("eghuur2", eghuur2);
            totals.put("eghuur3", eghuur3);
            totals.put("eghuur4", eghuur4);
            totals.put("eghuuronb", eghuuronb);
            totals.put("egonbekend", egonbekend);
            totals.put("mgkoop1", mgkoop1);
            totals.put("mgkoop2", mgkoop2);
            totals.put("mgkoop3", mgkoop3);
            totals.put("mgkoop4", mgkoop4);
            totals.put("mgkooponb", mgkooponb);
            totals.put("mghuur1", mghuur1);
            totals.put("mghuur2", mghuur2);
            totals.put("mghuur3", mghuur3);
            totals.put("mghuur4", mghuur4);
            totals.put("mghuuronb", mghuuronb);
            totals.put("mgonbekend", mgonbekend);
            totals.put("onbkoop1", onbkoop1);
            totals.put("onbkoop2", onbkoop2);
            totals.put("onbkoop3", onbkoop3);
            totals.put("onbkoop4", onbkoop4);
            totals.put("onbkooponb", onbkooponb);
            totals.put("onbhuur1", onbhuur1);
            totals.put("onbhuur2", onbhuur2);
            totals.put("onbhuur3", onbhuur3);
            totals.put("onbhuur4", onbhuur4);
            totals.put("onbhuuronb", onbhuuronb);
            totals.put("onbonbekend", onbonbekend);
            totals.put("meergezinstotaal", meergezinstotaal);
            totals.put("eengezinstotaal", eengezinstotaal);
            totals.put("onbekendtotaal", onbekendtotaal);
            totals.put("totaalkoop1", egkoop1 + mgkoop1 + onbkoop1);
            totals.put("totaalkoop2", egkoop2 + mgkoop2 + onbkoop2);
            totals.put("totaalkoop3", egkoop3 + mgkoop3 + onbkoop3);
            totals.put("totaalkoop4", egkoop4 + mgkoop4 + onbkoop4);
            totals.put("totaalkooponb", egkooponb + mgkooponb + onbkooponb);
            totals.put("totaalhuur1", eghuur1 + mghuur1 + onbhuur1);
            totals.put("totaalhuur2", eghuur2 + mghuur2 + onbhuur2);
            totals.put("totaalhuur3", eghuur3 + mghuur3 + onbhuur3);
            totals.put("totaalhuur4", eghuur4 + mghuur4 + onbhuur4);
            totals.put("totaalhuuronb", eghuuronb + mghuuronb + onbhuuronb);
            totals.put("totaalonbekend", egonbekend + mgonbekend + onbonbekend);
            totals.put("totaaltotaal", meergezinstotaal + eengezinstotaal + onbekendtotaal);
            planning.put("bouwplanvariableTotals", (Object)totals);
        }
        planning.put("bouwplanvariables", (Object)bvArray);
        return planning;
    }

    private JSONObject getOptionalVariables(Bouwplan bouwplan) {
        EntityManager em = Stripersist.getEntityManager();
        JSONObject optionalVars = new JSONObject();
        Gemeente gemeente = bouwplan.getGemeente();
        Provincie p = gemeente.getProvincie();
        List optionalLabelVars = em.createQuery("FROM ConfigurableVariable WHERE type = :type", ConfigurableVariable.class).setParameter("type", (Object)VariableType.OPTIONAL).getResultList();
        List optVars = null;
        optVars = optionalLabelVars.size() > 0 ? em.createQuery("FROM ProvincieVariable WHERE variable in :vars and provincie = :provincie").setParameter("vars", (Object)optionalLabelVars).setParameter("provincie", (Object)p).getResultList() : new ArrayList();
        for (ProvincieVariable optVar : optVars) {
            optionalVars.put(optVar.getVariable().getName(), true);
        }
        return optionalVars;
    }

    private JSONObject getSubcategories(Bouwplan bouwplan) throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        List vars = null;
        Gemeente gemeente = bouwplan.getGemeente();
        Provincie p = gemeente.getProvincie();
        vars = gemeente.getRegio() != null ? em.createQuery("select p FROM ProvincieAdditionalVariable p join p.regios r where p.label = false and p.mainCategory is not null and r.id = :regio order by additional_variable", ProvincieAdditionalVariable.class).setParameter("regio", (Object)gemeente.getRegio().getId()).getResultList() : em.createQuery("FROM ProvincieAdditionalVariable where label = false and mainCategory is not null and provincie = :provincie and usedByMunicipalities = true order by additional_variable", ProvincieAdditionalVariable.class).setParameter("provincie", (Object)p).getResultList();
        JSONObject subcategories = new JSONObject();
        for (ProvincieAdditionalVariable var : vars) {
            String location = var.getLocation();
            if (!subcategories.has(location)) {
                JSONArray loc = new JSONArray();
                subcategories.put(location, (Object)loc);
            }
            JSONArray locationArray = subcategories.getJSONArray(location);
            JSONObject jsonVar = new JSONObject();
            jsonVar.put("var", (Object)var.getAdditional_variable());
            jsonVar.put("maincategory", (Object)var.getMainCategory());
            locationArray.put((Object)jsonVar);
            try {
                BouwplanAdditionalVariable bav = (BouwplanAdditionalVariable)em.createQuery("FROM BouwplanAdditionalVariable WHERE bouwplan = :bouwplan and variable = :var", BouwplanAdditionalVariable.class).setParameter("bouwplan", (Object)bouwplan).setParameter("var", (Object)var).getSingleResult();
                List values = var.getValues();
                ProvincieAdditionalVariableValue value = null;
                for (ProvincieAdditionalVariableValue val : values) {
                    if (Integer.parseInt(bav.getVariableValue()) != val.getId()) continue;
                    value = val;
                    break;
                }
                if (value != null) {
                    jsonVar.put("value", (Object)value.getValue());
                    continue;
                }
                jsonVar.put("value", (Object)bav.getVariableValue());
            }
            catch (NoResultException noResultException) {}
        }
        return subcategories;
    }

    private JSONObject getAdditionalVars(Bouwplan bouwplan) throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        List vars = null;
        Gemeente gemeente = bouwplan.getGemeente();
        Provincie p = gemeente.getProvincie();
        vars = gemeente.getRegio() != null ? em.createQuery("select p FROM ProvincieAdditionalVariable p join p.regios r where p.label = false and p.mainCategory is null and r.id = :regio order by additional_variable", ProvincieAdditionalVariable.class).setParameter("regio", (Object)gemeente.getRegio().getId()).getResultList() : em.createQuery("FROM ProvincieAdditionalVariable where label = false and mainCategory is null and provincie = :provincie and usedByMunicipalities = true order by additional_variable", ProvincieAdditionalVariable.class).setParameter("provincie", (Object)p).getResultList();
        JSONObject additionalVars = new JSONObject();
        for (ProvincieAdditionalVariable var : vars) {
            String location = var.getLocation();
            if (!additionalVars.has(location)) {
                JSONArray loc = new JSONArray();
                additionalVars.put(location, (Object)loc);
            }
            JSONArray locationArray = additionalVars.getJSONArray(location);
            JSONObject jsonVar = new JSONObject();
            jsonVar.put("var", (Object)var.getAdditional_variable());
            locationArray.put((Object)jsonVar);
            try {
                BouwplanAdditionalVariable bav = (BouwplanAdditionalVariable)em.createQuery("FROM BouwplanAdditionalVariable WHERE bouwplan = :bouwplan and variable = :var", BouwplanAdditionalVariable.class).setParameter("bouwplan", (Object)bouwplan).setParameter("var", (Object)var).getSingleResult();
                List values = var.getValues();
                ProvincieAdditionalVariableValue value = null;
                for (ProvincieAdditionalVariableValue val : values) {
                    if (Integer.parseInt(bav.getVariableValue()) != val.getId()) continue;
                    value = val;
                    break;
                }
                if (value != null) {
                    jsonVar.put("value", (Object)value.getValue());
                    continue;
                }
                jsonVar.put("value", (Object)bav.getVariableValue());
            }
            catch (NoResultException bav) {}
        }
        List optionalLabelVars = em.createQuery("SELECT label FROM ConfigurableVariable WHERE type = :type", String.class).setParameter("type", (Object)VariableType.LABEL).getResultList();
        List labelVars = null;
        labelVars = optionalLabelVars.size() > 0 ? em.createQuery("FROM ProvincieAdditionalVariable WHERE label = true and additional_variable in :vars and provincie = :provincie").setParameter("vars", (Object)optionalLabelVars).setParameter("provincie", (Object)p).getResultList() : new ArrayList();
        HashMap<String, String> labelMap = new HashMap<String, String>();
        Regio regio = gemeente.getRegio();
        for (String optionalLabelVar : optionalLabelVars) {
            String value = null;
            for (ProvincieAdditionalVariable labelVar : labelVars) {
                if (!labelVar.getAdditional_variable().equals(optionalLabelVar)) continue;
                for (ProvincieAdditionalVariableValue pavv : labelVar.getValues()) {
                    if (regio == null && pavv.isUsedByMunicipalities()) {
                        value = pavv.getValue();
                    }
                    if (!pavv.getRegios().contains(gemeente.getRegio())) continue;
                    value = pavv.getValue();
                }
            }
            labelMap.put("" + optionalLabelVar, value != null ? value : optionalLabelVar);
        }
        JSONObject labels = new JSONObject(labelMap);
        additionalVars.put("labels", (Object)labels);
        return additionalVars;
    }

    private String getImageUrl(Bouwplan bouwplan, int width, int height) throws Exception {
        RedirectResolution cia = (RedirectResolution)((RedirectResolution)((RedirectResolution)((RedirectResolution)new RedirectResolution(EditActionBean.class).addParameter("bouwplan", new Object[]{bouwplan.getId()})).addParameter("width", new Object[]{width})).addParameter("height", new Object[]{height})).addParameter("bouwplanImage", new Object[]{Boolean.TRUE});
        String url = this.context.getRequest().getRequestURL().toString();
        String pm = "planmonitor/";
        int index = url.indexOf(pm);
        url = url.substring(0, index + pm.length());
        url = url + cia.getUrl(new Locale("NL"));
        return url;
    }

    private String getTemplateName(String pageFormat, String orientation) {
        if (A5.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A5_Landscape;
        }
        if (A5.equalsIgnoreCase(pageFormat) && PORTRAIT.equalsIgnoreCase(orientation)) {
            return A5_Portrait;
        }
        if (A4.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A4_Landscape;
        }
        if (A3.equalsIgnoreCase(pageFormat) && PORTRAIT.equalsIgnoreCase(orientation)) {
            return A3_Portrait;
        }
        if (A3.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A3_Landscape;
        }
        if (A0.equalsIgnoreCase(pageFormat) && PORTRAIT.equalsIgnoreCase(orientation)) {
            return A0_Portrait;
        }
        if (A0.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A0_Landscape;
        }
        return A4_Portrait;
    }

    public List<Integer> getBouwplans() {
        return this.bouwplans;
    }

    public void setBouwplans(List<Integer> bouwplans) {
        this.bouwplans = bouwplans;
    }

    private boolean isAuthorized() {
        ArrayList<Bouwplan> newPlans = new ArrayList<Bouwplan>();
        EntityManager em = Stripersist.getEntityManager();
        for (Integer id : this.bouwplans) {
            Bouwplan bouwplan = (Bouwplan)em.find(Bouwplan.class, (Object)id);
            if (!BouwplanUtils.isAuthorized((Bouwplan)bouwplan, (Gebruiker)this.gebruiker)) continue;
            newPlans.add(bouwplan);
        }
        if (newPlans.isEmpty()) {
            return false;
        }
        this.bouwplans = new ArrayList();
        for (Bouwplan plan : newPlans) {
            this.bouwplans.add(plan.getId());
        }
        return true;
    }

    private String printInfoToString(PrintInfo info) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PrintInfo.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter sw = new StringWriter();
        m.marshal((Object)info, (Writer)sw);
        String s = sw.toString();
        return s;
    }

    private JSONArray getExtra(Bouwplan bouwplan) throws JSONException {
        JSONArray ar = new JSONArray();
        ar.put((Object)this.getBasisgegevens(bouwplan));
        ar.put((Object)this.getSoort(bouwplan));
        ar.put((Object)this.getVoortgang(bouwplan));
        ar.put((Object)this.getAantallen(bouwplan));
        ar.put((Object)this.getWoningtypen(bouwplan));
        ar.put((Object)this.getKoop(bouwplan));
        ar.put((Object)this.getHuur(bouwplan));
        ar.put((Object)this.getOverig(bouwplan));
        ar.put((Object)this.getSloop(bouwplan));
        return ar;
    }

    private JSONObject getBasisgegevens(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"basisgegevens");
        json.put("componentName", (Object)"Basisgegevens");
        json.put("PlanID", (Object)bouwplan.getId());
        json.put("Plannaam", (Object)bouwplan.getNaam());
        json.put("DatumLaatsteWijziging", (Object)df.format(bouwplan.getDatumlaatstewijziging()));
        json.put("Gemeente", (Object)bouwplan.getGemeente().getNaam());
        json.put("Referentienummer", (Object)bouwplan.getReferentienummer());
        json.put("Bestemmingsplan", (Object)bouwplan.getBestemmingsplannaam());
        json.put("IMRO-nummer", (Object)bouwplan.getImronummer());
        json.put("Masterplan", (Object)bouwplan.getMasterplan());
        if (bouwplan.getOntwikkelaartype() != null) {
            json.put("Oprachtgevertype", (Object)bouwplan.getOntwikkelaartype().getType());
        }
        json.put("Opdrachtgever", (Object)bouwplan.getOntwikkelaar_namelijk());
        json.put("Vertrouwelijk", (Object)bouwplan.getGebruikgegevens().getNaam());
        return json;
    }

    private JSONObject getSoort(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Soortplan");
        json.put("componentName", (Object)"Soortplan");
        json.put("Plantype", (Object)bouwplan.getPlantype().getType());
        if (bouwplan.getWoonmilieu() != null) {
            json.put("Woonmilieu", (Object)bouwplan.getWoonmilieu().getType());
        }
        json.put("Woonmilieuabf14", (Object)bouwplan.getWoonmilieuabf14());
        return json;
    }

    private JSONObject getVoortgang(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Voortgang");
        json.put("componentName", (Object)"Voortgang");
        json.put("Statusplanologisch", (Object)bouwplan.getStatusplanologisch().getType());
        json.put("Statusproject", (Object)bouwplan.getStatusproject().getType());
        json.put("Knelpunten", (Object)bouwplan.getKnelpunten());
        return json;
    }

    private JSONObject getSloop(Bouwplan bouwplan) {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Sloop");
        json.put("componentName", (Object)"Sloop");
        json.put("resterendesloop", (Object)bouwplan.getResterendesloop());
        json.put("totaalsloop", (Object)bouwplan.getTotaalsloop());
        json.put("gerealiseerdesloop", (Object)bouwplan.getGerealiseerdesloop());
        return json;
    }

    private JSONObject getAantallen(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Aantallen");
        json.put("componentName", (Object)"Aantallen");
        json.put("eersteoplevering", (Object)bouwplan.getJaar_eerste_oplevering());
        json.put("laatsteoplevering", (Object)bouwplan.getJaar_laatste_oplevering());
        json.put("restcapaciteit", (Object)bouwplan.getRestcapaciteit());
        json.put("totaalcapaciteit", (Object)bouwplan.getTotaalcapaciteit());
        json.put("gerealiseerdecapaciteit", (Object)bouwplan.getGerealiseerdecapaciteit());
        json.put("resterendesloop", (Object)bouwplan.getResterendesloop());
        return json;
    }

    private JSONObject getWoningtypen(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Woningtypen");
        json.put("componentName", (Object)"Woningtypen");
        json.put("Meergezins", (Object)bouwplan.getMeergezins());
        json.put("Eengezins", (Object)bouwplan.getEensgezins());
        json.put("Woningtypeonbekend", (Object)bouwplan.getWoningtypeonbekend());
        return json;
    }

    private JSONObject getKoop(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Koop");
        json.put("componentName", (Object)"Koop");
        json.put("Koop1", (Object)bouwplan.getKoop1());
        json.put("Koop2", (Object)bouwplan.getKoop2());
        json.put("Koop3", (Object)bouwplan.getKoop3());
        json.put("Koop4", (Object)bouwplan.getKoop4());
        json.put("Kooponbekend", (Object)bouwplan.getKoopprijsonbekend());
        json.put("Kooptotaal", (Object)bouwplan.getKooptotaal());
        json.put("OnbekendOnbekend", (Object)bouwplan.getOnbekendonbekend());
        return json;
    }

    private JSONObject getHuur(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Huur");
        json.put("componentName", (Object)"Huur");
        json.put("Huur1", (Object)bouwplan.getHuur1());
        json.put("Huur2", (Object)bouwplan.getHuur2());
        json.put("Huur3", (Object)bouwplan.getHuur3());
        json.put("Huur4", (Object)bouwplan.getHuur4());
        json.put("Huuronbekend", (Object)bouwplan.getHuurprijsonbekend());
        json.put("Huurtotaal", (Object)bouwplan.getHuurtotaal());
        return json;
    }

    private JSONObject getOverig(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Overig");
        json.put("componentName", (Object)"Overig");
        if (!bouwplan.isOpmerkingenprive()) {
            json.put("opmerking", (Object)bouwplan.getOpmerkingen());
        }
        return json;
    }

    static /* synthetic */ List access$000(PrintActionBean x0) {
        return x0.bouwplans;
    }

    static /* synthetic */ Log access$100() {
        return log;
    }
}

