<%@include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@page contentType="text/html" session="false" pageEncoding="UTF-8"%>

<stripes:layout-render name="/WEB-INF/jsp/templates/viewerTemplate.jsp" pageTitle="Bewerken">
    <stripes:layout-component name="head">
        <script type="text/javascript" src="./js/totalcount.js"></script>
        <script type="text/javascript" src="./js/conditionalcount.js"></script>
        <script type="text/javascript" src="./js/detailplanning.js"></script>
        <script type="text/javascript" src="./js/detailplanninguitgebreid.js"></script>
        <script type="text/javascript" src="./js/editfunctions.js"></script>
        <script type="text/javascript" src="./js/variableinstantiator.js"></script>
    </stripes:layout-component>
    <stripes:layout-component name="content">
        <stripes:form id="editBouwplanForm" beanclass="nl.b3p.pzh.rwbp.stripes.EditActionBean" name="editBouwplanForm" class="edit">
            <div class="buttons">
                <h1 class="header-plannaam">Plannaam: ${actionBean.bouwplan.naam}</h1>
                <jsp:include page="/WEB-INF/jsp/edit/buttons.jsp" />
            </div>
            <div>
                <p style="color:red">
                    <stripes:errors/>
                </p>
                <p style="color:green">
                    <stripes:messages/>
                </p>
            </div>
            <stripes:hidden id="additionalVariables" name="additionalVariables"/>
            <stripes:hidden id="geometry" name="geometry"/>

            <%-- Form sections --%>
            <jsp:include page="/WEB-INF/jsp/edit/planinformatie.jsp" />
            <jsp:include page="/WEB-INF/jsp/edit/planning.jsp" />
            <jsp:include page="/WEB-INF/jsp/edit/woningtypen.jsp" />
            <jsp:include page="/WEB-INF/jsp/edit/overige.jsp" />
            <%-- Popups --%>
            <jsp:include page="/WEB-INF/jsp/edit/bewerkplan.jsp" />
            <jsp:include page="/WEB-INF/jsp/edit/detailplanning.jsp" />
            <jsp:include page="/WEB-INF/jsp/edit/detailplanningsloop.jsp" />
            <jsp:include page="/WEB-INF/jsp/edit/detailplanninguitgebreid.jsp" />
            <div class="buttons bottom">
                <div class="pull-left">
                    Velden gemarkeerd met * zijn verplicht
                </div>
                <jsp:include page="/WEB-INF/jsp/edit/buttons.jsp" />
            </div>
        </stripes:form>
        <script>
            var detailplannerUitgebreid = null, detailplanner = null, detailplannersloop = null;
            var edit = null;
            Ext.onReady(function() {
                detailplanner = Ext.create('B3p.planmonitor.DetailPlanner', {
                    div: "detailplanningpopup",
                    beginYear: 2015,
                    endYear: 2016,
                    postfix: "",
                    col: "gepland",
                    attributesToSave: ['sloop', 'gerealiseerdsloop'],
                    totalField: "totaalcapaciteit",
                    realisedField : "gerealiseerdecapaciteit",
                    canEdit: ${actionBean.canEdit},
                    retrieveDetailData : "<stripes:url beanclass="nl.b3p.pzh.rwbp.stripes.EditActionBean" event="retrieveDetailData"/>",
                    saveDetailData : "<stripes:url beanclass="nl.b3p.pzh.rwbp.stripes.EditActionBean" event="saveDetailData"/>"
                });
                
                detailplannersloop = Ext.create('B3p.planmonitor.DetailPlanner', {
                    div: "detailplanningpopupsloop",
                    postfix: "sloop",
                    beginYear: 2015,
                    endYear: 2016,
                    col: "sloop",
                    totalField: "totaalsloop",
                    attributesToSave: ['gepland', 'gerealiseerd'],
                    realisedField : "gerealiseerdesloop",
                    canEdit: ${actionBean.canEdit},
                    retrieveDetailData : "<stripes:url beanclass="nl.b3p.pzh.rwbp.stripes.EditActionBean" event="retrieveDetailData"/>",
                    saveDetailData : "<stripes:url beanclass="nl.b3p.pzh.rwbp.stripes.EditActionBean" event="saveDetailData"/>"
                });
                detailplannerUitgebreid = Ext.create('B3p.planmonitor.DetailPlannerUitgebreid', {
                    div: "detailplanninguitgebreidpopup",
                    labels: ${actionBean.labelMapJSON},
                    beginYear: 2015,
                    endYear: 2016,
                    canEdit: ${actionBean.canEdit},
                    retrieveDetailData : "<stripes:url beanclass="nl.b3p.pzh.rwbp.stripes.EditActionBean" event="retrieveDetailData"/>",
                    saveDetailData : "<stripes:url beanclass="nl.b3p.pzh.rwbp.stripes.EditActionBean" event="saveDetailData"/>"
                });
                edit = Ext.create('B3p.planmonitor.Edit', {
                    kaartlagen: '${actionBean.layers}',
                    mapserverUrl: '${actionBean.mapserverUrl}',
                    host: '${actionBean.absoluteUrlPrefix}${contextPath}/sld',
                    querylagen: '${actionBean.querylayers}',
                    sldkey_eenvoudig: '${actionBean.sldkey_eenvoudig}',
                    httpRequestParams: '${actionBean.httpRequestParams}',
                    bbox: '${actionBean.bbox}',
                    wktGeom: '${actionBean.bouwplan.the_geom}',
                    bouwplanId: '${actionBean.bouwplan.id}',
                    variables : '${fn:replace(actionBean.variables, "'" , "\\'")}',
                    variableValues : '${fn:replace(actionBean.variableValues, "'" , "\\'")}',
                    isProvince:  ${actionBean.gebruiker.provincie != null},
                    canEdit: ${actionBean.canEdit},
                    saveGeometryUrl: "<stripes:url beanclass="nl.b3p.pzh.rwbp.stripes.EditActionBean" event="saveGeometry"/>",
                    searchGemeenteUrl: "<stripes:url beanclass="nl.b3p.pzh.rwbp.stripes.EditActionBean" event="filterGemeentes"/>"
                });
            });
        </script>
    </stripes:layout-component>
</stripes:layout-render>
