<%-- 
    Document   : planning
    Created on : Feb 24, 2015, 8:23:56 PM
    Author     : geertplaisier
--%>

<%@include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@page contentType="text/html" pageEncoding="UTF-8"%>

<section class="planning">
    <h1>Planning</h1>
    <div class="blocks">
        <div id="voortgang"  class="block">
            <h2>Voortgang</h2>
            <div class="row">
                <label>Status planologisch *</label>
                <div class="input">
                    <stripes:select name="bouwplan.statusplanologisch" class="gemeentefield">
                        <stripes:option value="">-- Kies status planologisch --</stripes:option>
                        <stripes:options-collection collection="${actionBean.statusplanologisch}" value="id" label="type"/>
                    </stripes:select>
                </div>
            </div>
            <div class="row">
                <label>Status project *</label>
                <div class="input">
                    <stripes:select name="bouwplan.statusproject" class="gemeentefield">
                        <stripes:option value="">-- Kies status project --</stripes:option>
                        <stripes:options-collection collection="${actionBean.statusprojecten}" value="id" label="type"/>
                    </stripes:select>
                </div>
            </div>
            <div class="row">
                <label>Knelpunten</label>
                <div class="input">
                    <stripes:textarea name="bouwplan.knelpunten" class="gemeentefield"></stripes:textarea>
                </div>
            </div>
        </div>
        <div id="aantallenenplaning" class="block">
            <h2>Aantallen en planning</h2>
            <div class="small-block">
                <stripes:hidden name="detailData" id="detailData"/>
                <stripes:hidden name="detailDatasloop" id="detailDatasloop"/>
                <div class="row">
                    <label>Eerste oplevering *</label>
                    <div class="input">
                        <stripes:select id="jaar_eerste_oplevering" name="bouwplan.jaar_eerste_oplevering" class="gemeentefield">
                            <c:forEach begin="${actionBean.beginYear}" end="2040" var="year">
                                <stripes:option>${year}</stripes:option>
                            </c:forEach>
                        </stripes:select>
                    </div>
                </div>
                <div class="row">
                    <label>Laatste oplevering *</label>
                    <div class="input">
                        <stripes:select id="jaar_laatste_oplevering" name="bouwplan.jaar_laatste_oplevering" class="gemeentefield">
                            <c:forEach begin="${actionBean.beginYear}" end="2040" var="year">
                                <stripes:option>${year}</stripes:option>
                            </c:forEach>
                        </stripes:select>
                    </div>
                </div>
                <div class="row">
                    <stripes:select id="detailType" name="bouwplan.detailType" class="gemeentefield">
                        <stripes:option label="Geen detailplanning"/>
                        <stripes:option label="Standaard detailplanning" value="normaal"/>
                        <stripes:option label="Uitgebreide detailplanning" value="uitgebreid"/>
                    </stripes:select>
                    <a href="#" class="modal-dialog-toggle" id="detailPopupLink" data-target="#detailplanning">Vul detailplanning per jaar in</a>
                    <a href="#" class="modal-dialog-toggle" id="detailUitgebreidPopupLink" data-target="#detailplanninguitgebreid">Vul uitgebreide detailplanning in</a>
                </div>
                <div class="row space-above">
                    <label>Plancapaciteit totaal *</label>
                    <div class="input">
                    <stripes:text name="bouwplan.totaalcapaciteit" id="totaalcapaciteit" class="numeric gemeentefield" />
                    </div>
                </div>
                <div class="row">
                    <label>Plancapaciteit gerealiseerd *</label>
                    <div class="input">
                        <stripes:text name="bouwplan.gerealiseerdecapaciteit" id="gerealiseerdecapaciteit" class="numeric gemeentefield" />
                    </div>
                </div>
                <div class="row">
                    <label>Plancapaciteit resterend</label>
                    <div class="input">
                        <stripes:text name="bouwplan.restcapaciteit" id="restcapaciteit" readonly="true" class="numeric" />
                    </div>
                </div>
            </div>
        </div>
        <div id="sloop" class="block">
            <h2>Sloop</h2>
            <div class="small-block">
                <div class="row">
                    <stripes:select id="detailTypesloop" name="bouwplan.detailTypeSloop" class="gemeentefield">
                        <stripes:option label="Geen detailplanning voor sloop"/>
                        <stripes:option label="Gebruik detailplanning" value="normaal"/>
                    </stripes:select>
                    <a href="#" class="modal-dialog-toggle" id="detailPopupLinksloop" data-target="#detailplanningsloop">Vul sloop per jaar in</a>
                </div>
                <div class="row">
                    <label>Sloop totaal *</label>
                    <div class="input">
                        <stripes:text name="bouwplan.totaalsloop" id="totaalsloop" class="numeric gemeentefield" />
                    </div>
                </div>
                <div class="row">
                    <label>Sloop gerealiseerd *</label>
                    <div class="input">
                        <stripes:text name="bouwplan.gerealiseerdesloop" id="gerealiseerdesloop" class="numeric gemeentefield" />
                    </div>
                </div>
                <div class="row">
                    <label>Sloop resterend</label>
                    <div class="input">
                        <stripes:text name="bouwplan.resterendesloop" id="resterendesloop" class="numeric gemeentefield" />
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>