/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.EmailTypeConverter;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.stripes.SearchActionBean;
import nl.b3p.pzh.rwbp.stripes.ViewerActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
public class ProfielActionBean
extends ViewerActionBean {
    private static final Log log = LogFactory.getLog(ProfielActionBean.class);
    private Long exportAantal;
    @ValidateNestedProperties(value={@Validate(field="username", required=true, maxlength=255), @Validate(field="fullname", required=true, maxlength=255), @Validate(field="email", required=true, converter=EmailTypeConverter.class, maxlength=255), @Validate(field="phone", maxlength=255)})
    private Gebruiker gebruiker;
    @Validate(maxlength=255)
    private String wachtwoord;
    @Validate
    private boolean sluiten;

    @DefaultHandler
    @DontValidate
    public Resolution profiel() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (this.sluiten) {
            this.save();
            this.context.getRequest().getSession().setAttribute("searchProperties", null);
            return new ForwardResolution(SearchActionBean.class);
        }
        return new ForwardResolution("/WEB-INF/jsp/profiel.jsp");
    }

    public Resolution save() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        EntityManager em = Stripersist.getEntityManager();
        if (this.wachtwoord != null) {
            this.gebruiker.changePassword(this.context.getRequest(), this.wachtwoord);
        }
        em.persist((Object)this.gebruiker);
        em.flush();
        this.getContext().getMessages().add(new SimpleMessage("Uw gegevens zijn opgeslagen.", new Object[0]));
        this.setNaamGebruiker(this.gebruiker.getFullname());
        em.getTransaction().commit();
        return new ForwardResolution("/WEB-INF/jsp/profiel.jsp");
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public void calcExportAantal() {
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker ingelogd = (Gebruiker)this.context.getRequest().getUserPrincipal();
        this.gebruiker = (Gebruiker)em.find(Gebruiker.class, (Object)ingelogd.getId());
        this.exportAantal = (Long)this.context.getRequest().getSession().getAttribute("exportAantal");
    }

    public boolean isSluiten() {
        return this.sluiten;
    }

    public void setSluiten(boolean sluiten) {
        this.sluiten = sluiten;
    }

    public String getWachtwoord() {
        return this.wachtwoord;
    }

    public void setWachtwoord(String wachtwoord) {
        this.wachtwoord = wachtwoord;
    }

    public Long getExportAantal() {
        return this.exportAantal;
    }

    public void setExportAantal(Long exportAantal) {
        this.exportAantal = exportAantal;
    }
}

