/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package nl.b3p.pzh.rwbp.parse;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.Bouwplanvoortgang;
import nl.b3p.pzh.rwbp.entity.Factmetperiode;
import nl.b3p.pzh.rwbp.entity.Factsoort;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Gebruikgegevens;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.entity.Ontwikkelaartype;
import nl.b3p.pzh.rwbp.entity.Periode;
import nl.b3p.pzh.rwbp.entity.Plantype;
import nl.b3p.pzh.rwbp.entity.Statusplanologisch;
import nl.b3p.pzh.rwbp.entity.Statusproject;
import nl.b3p.pzh.rwbp.entity.Voortgangsoort;
import nl.b3p.pzh.rwbp.entity.Voortgangstatus;
import nl.b3p.pzh.rwbp.entity.Woonmilieu;
import nl.woningbouwplannen.Geometrie;
import nl.woningbouwplannen.Knelpunten;
import nl.woningbouwplannen.Ontwikkelaar;
import nl.woningbouwplannen.Planinformatie;
import nl.woningbouwplannen.Planning;
import nl.woningbouwplannen.Voortgang;
import nl.woningbouwplannen.WoonmilieuABF;
import nl.woningbouwplannen.WoonmilieuRosetta;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.gml2.GMLConfiguration;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.stripesstuff.stripersist.Stripersist;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/**
 *
 * @author Roy Braam
 */
public class XMLParser extends Parser {

    private static final Log log = LogFactory.getLog(XMLParser.class);
    private static final HashMap<nl.woningbouwplannen.Bouwplan.PlanType, Integer> mapping_plantype = new HashMap<nl.woningbouwplannen.Bouwplan.PlanType, Integer>();
    private static final HashMap<Ontwikkelaar.OntwikkelaarType, Integer> mapping_ontwikkelaartype = new HashMap<Ontwikkelaar.OntwikkelaarType, Integer>();
    private static final HashMap<nl.woningbouwplannen.Bouwplan.Publicatie, Integer> mapping_publicatie = new HashMap<nl.woningbouwplannen.Bouwplan.Publicatie, Integer>();
    private static final HashMap<WoonmilieuABF.WoonmilieuABFType, Integer> mapping_woonmilieu_abf = new HashMap<WoonmilieuABF.WoonmilieuABFType, Integer>();
    private static final HashMap<Voortgang.StatusPlanologisch, Integer> mapping_statusplanologisch = new HashMap<Voortgang.StatusPlanologisch, Integer>();
    private static final HashMap<Voortgang.StatusProject.StatusProjectType, Integer> mapping_statusproject = new HashMap<Voortgang.StatusProject.StatusProjectType, Integer>();
    private static final HashMap<Knelpunten.KnelpuntType, Integer> mapping_knelpunten = new HashMap<Knelpunten.KnelpuntType, Integer>();
    private static final HashMap<Planning.Periode.Gepland.EigendomSituatie, Integer> mapping_eigendom = new HashMap<Planning.Periode.Gepland.EigendomSituatie, Integer>();
    private static final HashMap<Planning.Periode.Gepland.TypeWoning, String> mapping_typewoning = new HashMap<Planning.Periode.Gepland.TypeWoning, String>();
    private static final HashMap<Planning.Periode.Gepland.Prijsklasse, String> mapping_prijsklasse = new HashMap<Planning.Periode.Gepland.Prijsklasse, String>();

    static {
        mapping_plantype.put(nl.woningbouwplannen.Bouwplan.PlanType.UITLEG, new Integer(1));
        mapping_plantype.put(nl.woningbouwplannen.Bouwplan.PlanType.HERSTRUCTURERING, new Integer(2));
        mapping_plantype.put(nl.woningbouwplannen.Bouwplan.PlanType.TRANSFORMATIE, new Integer(3));
        mapping_plantype.put(nl.woningbouwplannen.Bouwplan.PlanType.VERDICHTING, new Integer(6));
        mapping_plantype.put(nl.woningbouwplannen.Bouwplan.PlanType.ONBEKEND, new Integer(99));

        mapping_ontwikkelaartype.put(Ontwikkelaar.OntwikkelaarType.GEMEENTE, new Integer(2));
        mapping_ontwikkelaartype.put(Ontwikkelaar.OntwikkelaarType.WONINGBOUWCORPORATIE, new Integer(3));
        mapping_ontwikkelaartype.put(Ontwikkelaar.OntwikkelaarType.PROJECTONTWIKKELAAR, new Integer(4));
        mapping_ontwikkelaartype.put(Ontwikkelaar.OntwikkelaarType.PARTICULIER, new Integer(5));
        mapping_ontwikkelaartype.put(Ontwikkelaar.OntwikkelaarType.MEERDERE, new Integer(6));
        mapping_ontwikkelaartype.put(Ontwikkelaar.OntwikkelaarType.ANDERS, new Integer(7));
        mapping_ontwikkelaartype.put(Ontwikkelaar.OntwikkelaarType.ONBEKEND, new Integer(1));

        mapping_publicatie.put(nl.woningbouwplannen.Bouwplan.Publicatie.OPENBAAR, new Integer(1));
        mapping_publicatie.put(nl.woningbouwplannen.Bouwplan.Publicatie.AFGESCHERMD, new Integer(2));

        mapping_woonmilieu_abf.put(WoonmilieuABF.WoonmilieuABFType.ONBEKEND, new Integer(1));
        mapping_woonmilieu_abf.put(WoonmilieuABF.WoonmilieuABFType.CENTRUM_STEDELIJK, new Integer(2));
        mapping_woonmilieu_abf.put(WoonmilieuABF.WoonmilieuABFType.BUITEN_CENTRUM, new Integer(3));
        mapping_woonmilieu_abf.put(WoonmilieuABF.WoonmilieuABFType.GROEN_STEDELIJK, new Integer(4));
        mapping_woonmilieu_abf.put(WoonmilieuABF.WoonmilieuABFType.DORPS, new Integer(5));
        mapping_woonmilieu_abf.put(WoonmilieuABF.WoonmilieuABFType.LANDELIJK, new Integer(6));
        mapping_woonmilieu_abf.put(WoonmilieuABF.WoonmilieuABFType.ANDERS, new Integer(7));

        mapping_statusplanologisch.put(Voortgang.StatusPlanologisch.ONBEKEND, new Integer(1));
        mapping_statusplanologisch.put(Voortgang.StatusPlanologisch.ONHERROEPELIJK, new Integer(2));
        mapping_statusplanologisch.put(Voortgang.StatusPlanologisch.ONHERROEPELIJK_NOG_UIT_TE_WERKEN, new Integer(3));
        mapping_statusplanologisch.put(Voortgang.StatusPlanologisch.VASTGESTELD, new Integer(4));
        mapping_statusplanologisch.put(Voortgang.StatusPlanologisch.IN_VOORBEREIDING, new Integer(5));
        mapping_statusplanologisch.put(Voortgang.StatusPlanologisch.VISIE, new Integer(6));
        mapping_statusplanologisch.put(Voortgang.StatusPlanologisch.OPTIE, new Integer(7));

        mapping_statusproject.put(Voortgang.StatusProject.StatusProjectType.ONBEKEND, new Integer(1));
        mapping_statusproject.put(Voortgang.StatusProject.StatusProjectType.AFGEROND, new Integer(2));
        mapping_statusproject.put(Voortgang.StatusProject.StatusProjectType.NAZORG, new Integer(3));
        //TODO: nog vasstellen of volgende 2 goed zijn:
        mapping_statusproject.put(Voortgang.StatusProject.StatusProjectType.BOUWVOORBEREIDING, new Integer(13));
        mapping_statusproject.put(Voortgang.StatusProject.StatusProjectType.VOORBEREIDING, new Integer(5));

        mapping_statusproject.put(Voortgang.StatusProject.StatusProjectType.ONTWERP, new Integer(6));
        mapping_statusproject.put(Voortgang.StatusProject.StatusProjectType.DEFINITIE, new Integer(7));
        mapping_statusproject.put(Voortgang.StatusProject.StatusProjectType.INITIATIEF, new Integer(8));
        mapping_statusproject.put(Voortgang.StatusProject.StatusProjectType.START, new Integer(9));
        mapping_statusproject.put(Voortgang.StatusProject.StatusProjectType.VERVALLEN, new Integer(10));
        mapping_statusproject.put(Voortgang.StatusProject.StatusProjectType.VERWIJDERD, new Integer(11));
        //TODO: nog vasstellen of volgende 2 goed zijn:
        mapping_statusproject.put(Voortgang.StatusProject.StatusProjectType.REALISATIE_TOT_EERSTE_WONING, new Integer(4));
        mapping_statusproject.put(Voortgang.StatusProject.StatusProjectType.REALISATIE_TOT_LAATSTE_WONING, new Integer(12));

        mapping_knelpunten.put(Knelpunten.KnelpuntType.GEEN_KNELPUNTEN, new Integer(1));
        mapping_knelpunten.put(Knelpunten.KnelpuntType.KNELPUNTEN_VOORZIEN, new Integer(2));
        mapping_knelpunten.put(Knelpunten.KnelpuntType.KNELPUNTEN, new Integer(3));
        mapping_knelpunten.put(Knelpunten.KnelpuntType.ONBEKEND, new Integer(5));

        mapping_prijsklasse.put(Planning.Periode.Gepland.Prijsklasse.MARKT_1, "Markt 1");
        mapping_prijsklasse.put(Planning.Periode.Gepland.Prijsklasse.MARKT_2, "Markt 2");
        mapping_prijsklasse.put(Planning.Periode.Gepland.Prijsklasse.ONBEKEND, "Onbekend");
        mapping_prijsklasse.put(Planning.Periode.Gepland.Prijsklasse.SOCIAAL_1, "Sociaal 1");
        mapping_prijsklasse.put(Planning.Periode.Gepland.Prijsklasse.SOCIAAL_2, "Sociaal 2");
        mapping_prijsklasse.put(Planning.Periode.Gepland.Prijsklasse.SOCIAAL_3, "Sociaal 3");
        mapping_prijsklasse.put(Planning.Periode.Gepland.Prijsklasse.SOCIAAL_4, "Sociaal 4");

        mapping_eigendom.put(Planning.Periode.Gepland.EigendomSituatie.HUUR, new Integer(3));
        mapping_eigendom.put(Planning.Periode.Gepland.EigendomSituatie.KOOP, new Integer(4));
        mapping_eigendom.put(Planning.Periode.Gepland.EigendomSituatie.ONBEKEND, new Integer(5));

        mapping_typewoning.put(Planning.Periode.Gepland.TypeWoning.EENGEZINS, "Eengezin");
        mapping_typewoning.put(Planning.Periode.Gepland.TypeWoning.MEERGEZINS, "Meergezin");
        mapping_typewoning.put(Planning.Periode.Gepland.TypeWoning.ONBEKEND, "Onbekend");

    }

    public Planinformatie parsePlaninformatie(InputStream is) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance("nl.woningbouwplannen");
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        unmarshaller.setSchema(null);
        return (Planinformatie) unmarshaller.unmarshal(is);
    }

    public List<Bouwplan> parse(InputStream is,Gebruiker gebruiker) throws Exception {
        Planinformatie planinfo = parsePlaninformatie(is);

        EntityManager em = Stripersist.getEntityManager();
        List<Bouwplan> plannen = new ArrayList<Bouwplan>();
        if (planinfo.getBouwplannen() == null && planinfo.getBouwplannen().getBouwplan() == null) {
            return plannen;
        }

        Session sess = (Session) em.getDelegate();
        for (nl.woningbouwplannen.Bouwplan imPlan : planinfo.getBouwplannen().getBouwplan()) {
            Bouwplan plan = null;
            if (imPlan.getGemeente() != null && imPlan.getPlanidentificatie() != null) {
                List<Bouwplan> bouwplannen = em.createQuery("FROM Bouwplan where gemeente.naam = :g and planIdentificatie = :id")
                        .setParameter("g", imPlan.getGemeente())
                        .setParameter("id", imPlan.getPlanidentificatie()).getResultList();
                //check if user may edit
                if (bouwplannen.size() > 1) {
                    throw new Exception("Meerdere plannen bekend met gemeentenaam: " + imPlan.getGemeente() + " en identificatie: " + imPlan.getPlanidentificatie() + ". Kan plan niet bijwerken");
                }
                if (bouwplannen.size() == 1) {
                    plan = bouwplannen.get(0);
                }
            }
            if (plan == null) {
                plan = new Bouwplan();
            }
            //set dates
            plan.setAanmaakdatum(new Date());
            plan.setGebruikeractiontijd(new Date());
            //find and set gemeente    
            plan = parseGemeente(plan, imPlan.getGemeente());
            //set plannaam
            plan.setNaam(imPlan.getPlannaam());
            //set identificatie
            plan.setPlanIdentificatie(imPlan.getPlanidentificatie());
            //get plan type
            plan = parsePlantype(plan, imPlan.getPlantype());
            //geometry!!!
            plan = parseGeometry(plan, imPlan.getGeometrie());
            //set publicatie/gebruik gegevens            
            plan = parsePublicatie(plan, imPlan.getPublicatie());
            //set ontwikkelaar
            plan = parseOntwikkelaar(plan, imPlan.getOntwikkelaar());
            //set woonmilieu ABF
            plan = parseWoonMilieuABF(plan, imPlan.getWoonmilieuABF());
            //set woonmilieu Rosetta
            plan = parseWoonMilieuRosetta(plan, imPlan.getWoonmilieuRosetta());
            //voortgang
            plan = parseVoortgang(plan, imPlan.getVoortgang());
            //
            plan = parsePlanning(plan, imPlan.getPlanning());

            plannen.add(plan);
            em.flush();
        }
        return plannen;
    }

    /**
     * add voortgang to plan.
     */
    private Bouwplan parseVoortgang(Bouwplan plan, Voortgang voortgang) {
        EntityManager em = Stripersist.getEntityManager();
        SimpleDateFormat df = new SimpleDateFormat("MM-yyyy");
        if (voortgang.getStartPrognose() != null) {
            try {
                plan.setPrognose_start(df.parse(voortgang.getStartPrognose()));
            } catch (ParseException pe) {
                log.error("Error while parsing date StartPrognose", pe);
            }
        } else {
            plan.setPrognose_start(null);
        }
        if (voortgang.getOpleveringPrognose() != null) {
            try {
                plan.setPrognose_oplevering(df.parse(voortgang.getOpleveringPrognose()));
            } catch (ParseException pe) {
                log.error("Error while parsing date OpleveringPrognose", pe);
            }
        } else {
            plan.setPrognose_oplevering(null);
        }
        if (voortgang.getStatusPlanologisch() != null) {
            Integer statusPlanologischId = mapping_statusplanologisch.get(voortgang.getStatusPlanologisch());
            plan.setStatusplanologisch(em.find(Statusplanologisch.class, statusPlanologischId));
        } else {
            plan.setStatusplanologisch(null);
        }

        Integer statusProjectTypeId = mapping_statusproject.get(voortgang.getStatusProject().getType());
        plan.setStatusproject(em.find(Statusproject.class, statusProjectTypeId));
        if (plan.getStatusproject()==null){
            plan.setStatusproject(em.find(Statusproject.class,Statusproject.ONBEKEND_ID));
        }
        plan.setStatus_namelijk(voortgang.getStatusProject().getToelichting());
        //first remove all bouwplan voortgang.
        if (plan.getBouwplanvoortgang() != null) {
            for (Bouwplanvoortgang bv : plan.getBouwplanvoortgang()) {
                if (bv != null) {
                    em.remove(bv);
                }
            }
            plan.setBouwplanvoortgang(null);
            em.flush();
        }
        if (voortgang.getKnelpunten() != null) {
            Bouwplanvoortgang bv = new Bouwplanvoortgang();
            bv.setBouwplan(plan);
            bv.setToelichting(voortgang.getKnelpunten().getToelichting());
            Integer voortgangstatus = mapping_knelpunten.get(voortgang.getKnelpunten().getType());
            bv.setVoortgangstatus(em.find(Voortgangstatus.class, voortgangstatus));
            //always set 'algemeen' as knelpunt voortgang
            bv.setVoortgangsoort(em.find(Voortgangsoort.class, new Integer(1)));
            plan.addBouwplanvoortgang(bv);
        }

        return plan;
    }

    /**
     * add ontwikkelaar to plan.
     */
    private Bouwplan parseOntwikkelaar(Bouwplan plan, Ontwikkelaar ontw) {
        if (ontw != null) {
            EntityManager em = Stripersist.getEntityManager();
            plan.setOntwikkelaar_namelijk(ontw.getNaam());
            if (ontw.getType() != null) {
                Integer ontwType = mapping_ontwikkelaartype.get(ontw.getType());
                plan.setOntwikkelaartype(em.find(Ontwikkelaartype.class, ontwType));
            } else {
                plan.setOntwikkelaartype(null);
            }
        }
        return plan;
    }

    /**
     * Parse gemeente and add to plan.
     */
    private Bouwplan parseGemeente(Bouwplan plan, String gemeente) {
        EntityManager em = Stripersist.getEntityManager();
        Session sess = (Session) em.getDelegate();
        Criteria c = sess.createCriteria(Gemeente.class);
        c.add(Restrictions.ilike("naam", gemeente));
        Gemeente gem = (Gemeente) c.uniqueResult();
        plan.setGemeente(gem);
        return plan;
    }

    private Bouwplan parsePublicatie(Bouwplan plan, nl.woningbouwplannen.Bouwplan.Publicatie publicatie) {
        if (publicatie != null) {
            EntityManager em = Stripersist.getEntityManager();
            Integer publicatieId = mapping_publicatie.get(publicatie);
            plan.setGebruikgegevens(em.find(Gebruikgegevens.class, publicatieId));
        } else {
            plan.setGebruikgegevens(null);
        }
        return plan;
    }

    private Bouwplan parsePlantype(Bouwplan plan, nl.woningbouwplannen.Bouwplan.PlanType plantype) {
        if (plantype != null) {
            EntityManager em = Stripersist.getEntityManager();
            Integer planType = mapping_plantype.get(plantype);
            plan.setPlantype(em.find(Plantype.class, planType));
        } else {
            plan.setPlantype(null);
        }
        return plan;
    }

    private Bouwplan parseWoonMilieuABF(Bouwplan plan, WoonmilieuABF woonmilieuABF) {
        if (woonmilieuABF != null) {
            EntityManager em = Stripersist.getEntityManager();
            plan.setWoonmilieu_namelijk(woonmilieuABF.getToelichting());
            if (woonmilieuABF.getType() != null) {
                Integer abfTypeId = mapping_woonmilieu_abf.get(woonmilieuABF.getType());
                plan.setWoonmilieu(em.find(Woonmilieu.class, abfTypeId));
            } else {
                plan.setWoonmilieu(null);
            }
        }
        return plan;
    }

    private Bouwplan parseWoonMilieuRosetta(Bouwplan plan, WoonmilieuRosetta rosetta) {
        if (rosetta != null) {
            //plan.setWoonmilieuRamelijk(rosetta.getToelichting());
            if (rosetta.getType() != null) {
                plan.setWoonmilieu_rosetta(rosetta.getType());
            } else {
                plan.setWoonmilieu_rosetta(null);
            }
        }
        return plan;
    }

    private Bouwplan parsePlanning(Bouwplan plan, Planning planning) {
        EntityManager em = Stripersist.getEntityManager();
        if (plan.getFactsmetperiode() != null) {
            for (Factmetperiode fperiode : plan.getFactsmetperiode()) {
                em.remove(fperiode);
            }
            plan.setFactsmetperiode(null);
        }
        for (Planning.Periode periode : planning.getPeriode()) {
            //get the correct periode jaar
            String minJaar = (String) em.createQuery("select min(jaar) from Periode where jaar > '0000'").getSingleResult();
            String maxJaar = (String) em.createQuery("select max(jaar) from Periode").getSingleResult();
            String periodeJaar = periode.getJaar().toString();
            if (periode.getJaar().intValue() > new BigInteger(maxJaar).intValue()) {
                periodeJaar = maxJaar;
            } else if (periode.getJaar().intValue() < new BigInteger(minJaar).intValue()) {
                periodeJaar = minJaar;
            }
            Periode p = (Periode) em.createQuery("From Periode where jaar = :j").setParameter("j", periodeJaar).getSingleResult();

            for (Planning.Periode.Gepland gepland : periode.getGepland()) {
                if (gepland.getAantalBouw() != null) {
                    Factmetperiode fmp = new Factmetperiode();
                    fmp.setBouwplan(plan);
                    fmp.setPeriode(p);
                    fmp.setPlanningaantal(gepland.getAantalBouw().intValue());

                    Integer factGroupId = mapping_eigendom.get(gepland.getEigendomSituatie());
                    String factSubGroupNaam = mapping_typewoning.get(gepland.getTypeWoning());
                    String prijsklasseNaam = mapping_prijsklasse.get(gepland.getPrijsklasse());
                    Factsoort factSoort = (Factsoort) em.createQuery("FROM Factsoort where naam = :p and factsubgroup.naam = :sn and factsubgroup.factgroup.id = :fgid")
                            .setParameter("p", prijsklasseNaam)
                            .setParameter("sn", factSubGroupNaam)
                            .setParameter("fgid", factGroupId).getSingleResult();

                    if (factSoort == null) {
                        log.error("Geen factSoort gevonden met\n naam: " + prijsklasseNaam + "\nsubgroupnaam: " + factSubGroupNaam + "\nfactgroupid: " + factGroupId);
                    }
                    fmp.setFactSoort(factSoort);
                    plan.addFactsmetperiode(fmp);
                }
                if (gepland.getAantalSloop() != null) {
                    Factmetperiode fmp = new Factmetperiode();
                    fmp.setBouwplan(plan);
                    fmp.setPeriode(p);
                    fmp.setPlanningaantal(gepland.getAantalBouw().intValue());

                    Factsoort factSoort = (Factsoort) em.createQuery("FROM Factsoort where naam = 'Sloop'").getSingleResult();

                    fmp.setFactSoort(factSoort);
                    plan.addFactsmetperiode(fmp);
                }
                //Factgroup factGroup = em.find(Factgroup.class,factGroupId);
                //Factsubgroup subGroup = em.createQuery("FROM Factsubgroup where naam = :n and factgroup= :f").setParameter("n",factSubGroupNaam ).setParameter("f",factGroup);

            }

        }
        return plan;
    }

    private Bouwplan parseGeometry(Bouwplan plan, Geometrie geometrie) throws IOException, SAXException, ParserConfigurationException, TransformerException, Exception {
        //MultiPolygon mp = 
        GMLConfiguration gml = new GMLConfiguration();
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(), 28992);
        gml.getContext().registerComponentInstance(gf);
        org.geotools.xml.Parser parser = new org.geotools.xml.Parser(gml);

        Document doc = geometrie.getAny().getOwnerDocument();
        Node polygonNode = geometrie.getAny();


        String xml = domNodeToString(polygonNode);

        Object o = parser.parse(new StringReader(xml));
        try {
            if (o != null) {
                Geometry geom = (Geometry) o;
                plan.setThe_geom(correctGeometry(geom));
            }
        } catch (Exception cause) {
            throw new Exception("Fout bij laden geometry van plan met naam: " + plan.getNaam(), cause);
        }
        return plan;
    }

    private static String domNodeToString(Node node) throws TransformerConfigurationException, TransformerException {
        Source source = new DOMSource(node);
        StringWriter xml = new StringWriter();
        StreamResult result = new StreamResult(xml);

        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        t.transform(source, result);
        return xml.toString();
    }
}
