/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package nl.b3p.pzh.rwbp.stripes;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.tag.BeanFirstPopulationStrategy;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationErrorHandler;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import nl.b3p.commons.stripes.CustomPopulationStrategy;
import nl.b3p.imagetool.Bbox;
import nl.b3p.imagetool.CombineImageSettings;
import nl.b3p.imagetool.CombineImageUrl;
import nl.b3p.imagetool.CombineImagesHandler;
import nl.b3p.imagetool.CombineTMSUrl;
import nl.b3p.imagetool.CombineWmsUrl;
import nl.b3p.imagetool.ImageTool;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.BouwplanAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.BouwplanVariable;
import nl.b3p.pzh.rwbp.entity.Gebruikgegevens;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.entity.Ontwikkelaartype;
import nl.b3p.pzh.rwbp.entity.Plantype;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariableValue;
import nl.b3p.pzh.rwbp.entity.ProvincieVariable;
import nl.b3p.pzh.rwbp.entity.Regio;
import nl.b3p.pzh.rwbp.entity.Statusplanologisch;
import nl.b3p.pzh.rwbp.entity.Statusproject;
import nl.b3p.pzh.rwbp.entity.VariableType;
import nl.b3p.pzh.rwbp.entity.Woonmilieu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author Meine Toonen
 */
@StrictBinding
@CustomPopulationStrategy(BeanFirstPopulationStrategy.class)
public class EditActionBean extends ViewerActionBean implements ValidationErrorHandler{
    private static final Log log = LogFactory.getLog(EditActionBean.class);

    @Validate
    @ValidateNestedProperties({
        @Validate(field = "id", on = "save"),
        @Validate(field = "naam", required = true, maxlength = 255, on = "save"),
        @Validate(field = "referentienummer", maxlength = 255, on = "save"),
        @Validate(field = "masterplan", maxlength = 255, on = "save"),
        @Validate(field = "bestemmingsplannaam", maxlength = 255, on = "save"),
        @Validate(field = "plantype", maxlength = 255, required = true, on = "save"),
        @Validate(field = "imronummer", maxlength = 255, on = "save"),
        @Validate(field = "ontwikkelaartype", on = "save"),
        @Validate(field = "statusproject", required = true, on = "save"),
        @Validate(field = "woonmilieu", on = "save"),
        @Validate(field = "woonmilieuabf14", on = "save"),
        @Validate(field = "statusplanologisch",required = true,  on = "save"),
        @Validate(field = "gebruikgegevens",required = true,  on = "save"),
        @Validate(field = "ontwikkelaar_namelijk", on = "save"),
        @Validate(field = "jaar_eerste_oplevering", required = true, on = "save"),
        @Validate(field = "jaar_laatste_oplevering",required = true,  on = "save"),
        @Validate(field = "restcapaciteit", required = true, on = "save"),
        @Validate(field = "totaalcapaciteit", required = true, on = "save"),
        @Validate(field = "gerealiseerdecapaciteit", required = true, on = "save"),
        @Validate(field = "resterendesloop", on = "save"),
        @Validate(field = "totaalsloop",required = true, on = "save"),
        @Validate(field = "gerealiseerdesloop",required = true, on = "save"),
        @Validate (field = "koop1", on = "save"),
        @Validate (field = "koop2", on = "save"),
        @Validate (field = "koop3", on = "save"),
        @Validate (field = "koop4", on = "save"),
        @Validate (field = "koopprijsonbekend", on = "save"),
        @Validate (field = "kooptotaal", on = "save"),
        @Validate (field = "huur1", on = "save"),
        @Validate (field = "huur2", on = "save"),
        @Validate (field = "huur3", on = "save"),
        @Validate (field = "huur4", on = "save"),
        @Validate (field = "huurprijsonbekend", on = "save"),
        @Validate (field = "huurtotaal", on = "save"),
        @Validate (field = "eensgezins", on = "save"),
        @Validate (field = "meergezins", on = "save"),
        @Validate (field = "woningtypeonbekend", on = "save"),
        @Validate (field = "knelpunten", on = "save"),
        @Validate (field = "opmerkingen", on = "save"),
        @Validate (field = "opmerkingenprive", on = "save"),
        @Validate (field = "opmerkingenprovincie", on = "save"),
        @Validate (field = "plaatsnaam", on = "save"),
        @Validate (field = "detailType", on = "save"),
        @Validate (field = "detailTypeSloop", on = "save"),
        @Validate (field = "onbekendonbekend", on = "save"),
    })
    private Bouwplan bouwplan;

    @Validate
    private String geometry;

    private List<Plantype> plantypes = new ArrayList<Plantype>();
    private List<Woonmilieu> woonmilieus = new ArrayList<Woonmilieu>();
    private List<Ontwikkelaartype> ontwikkelaartypes = new ArrayList< Ontwikkelaartype>();
    private List<Statusplanologisch> statusplanologisch = new ArrayList<Statusplanologisch>();
    private List<Statusproject> statusprojecten = new ArrayList<Statusproject>();
    private List<Gebruikgegevens> gebruikgegevens = new ArrayList<Gebruikgegevens>();

    private String bbox;

    @Validate(on = { "saveDetailData", "save" })
    private String detailData;

    @Validate
    private String additionalVariables;

    private String variableValues;
    
    private String variables;

    private int beginYear;

    @Validate
    private String gemeente;

    private List<ProvincieVariable> optionalVariables = new ArrayList<ProvincieVariable>();
    private Map<String, Boolean> bpOptionalVariables = new HashMap<String, Boolean>();
    private Map<String, String> labelMap = new HashMap<String,String>();

    private String labelMapJSON;

    private boolean canEdit = false;

    @Validate
    private boolean add = false;

    @Validate
    private int width = 370;

    @Validate
    private int height = 285;

    @Validate
    private String key;

    private static LinkedHashMap<String,CombineImageSettings> imageSettings = new LinkedHashMap<String,CombineImageSettings>();

    @DefaultHandler
    public Resolution edit(){
        boolean authorized = isAuthorized();
        if(! authorized){
            return new RedirectResolution(SearchActionBean.class, "close");
        }else{
            return new ForwardResolution("/WEB-INF/jsp/edit.jsp");
        }
    }

    public Resolution retrieveDetailData() {
        try {
            JSONObject json = new JSONObject();
            json.put("success", false);

            EntityManager em = Stripersist.getEntityManager();
            Query q = em.createQuery("FROM BouwplanVariable where bouwplan = :bouwplan and nieuw <> true", BouwplanVariable.class).setParameter("bouwplan", bouwplan);
            List<BouwplanVariable> bvs = q.getResultList();
            JSONArray bvArray = new JSONArray();
            for (BouwplanVariable bv : bvs) {
                bvArray.put(bv.toJSON());
            }
            json.put("bouwplanvariables",bvArray);
            json.put("success",true);

            return new StreamingResolution("application/json", new StringReader(json.toString(4)));
        } catch (JSONException ex) {
            log.error("Fout met ophalen detail data: ",ex);
        }
        return new ErrorResolution(500, "Fout bij ophalen detail data");
    }

    public Resolution saveGeometry(){
        try {
            JSONObject json = new JSONObject();
            json.put("success", false);

            EntityManager em = Stripersist.getEntityManager();

            if (geometry != null) {
                Polygon p = parseGeometry(json);
                if( p != null && json.getBoolean("success")){
                    bouwplan.setThe_geom(p);
                    em.getTransaction().commit();
                    SolrActionBean.addSingleBouwplan(bouwplan);
                }
            }
            return new StreamingResolution("application/json", new StringReader(json.toString(4)));
        } catch (JSONException ex) {
            log.error("Fout met opslaan geometrie: ",ex);
        }
        return new ErrorResolution(500, "Fout met opslaan geometrie");
    }

    public Resolution saveDetailData() {
        try {
            JSONObject json = new JSONObject();
            json.put("success", false);
            if(bouwplan == null){
                json.put("message", "Bouwplan nog niet opgeslagen.");
                return new StreamingResolution("application/json", new StringReader(json.toString(4)));
            }

            EntityManager em = Stripersist.getEntityManager();
            saveDetailData(bouwplan, detailData, em);

            em.getTransaction().commit();
            json.put("success", true);
            return new StreamingResolution("application/json", new StringReader(json.toString(4)));
        } catch (JSONException ex) {
            log.error("Fout met ophalen detail data: ",ex);
        }
        return new ErrorResolution(500, "Fout bij opslaan detail data");
    }

    public Resolution save() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        bouwplan.setDatumlaatstewijziging(new Date());
        if (bouwplan.getId() == null) {
            bouwplan.setGemeente(gebruiker.getGemeente());
        } else {
            String prevDetailType = (String) em.createNativeQuery("Select detail_type from bouwplan where id = :id").setParameter("id", bouwplan.getId()).getSingleResult();
            if (!prevDetailType.equals(bouwplan.getDetailType())) {
                Query q = em.createQuery("FROM BouwplanVariable where bouwplan = :bouwplan", BouwplanVariable.class).setParameter("bouwplan", bouwplan);
                List<BouwplanVariable> bvs = q.getResultList();
                for (BouwplanVariable bv : bvs) {
                    if (!bouwplan.getDetailTypeSloop().equals("Geen detailplanning voor sloop")) {
                        BouwplanVariable newBv = new BouwplanVariable();
                        newBv.setYear(bv.getYear());
                        newBv.setBouwplan(bouwplan);
                        newBv.setSloop(bv.getSloop());
                        newBv.setGerealiseerdesloop(bv.getGerealiseerdesloop());
                        em.persist(newBv);
                    }
                    em.remove(bv);
                }
            } else if (bouwplan.getDetailType().equals("Geen detailplanning") && bouwplan.getDetailTypeSloop().equals("Geen detailplanning voor sloop")) {
                removeDetailData(bouwplan, em);
            } else if (bouwplan.getDetailTypeSloop().equals("Geen detailplanning voor sloop")) { // geen sloopplanning, maar wel (onveranderde) detailplanning
                Query q = em.createQuery("FROM BouwplanVariable where bouwplan = :bouwplan", BouwplanVariable.class).setParameter("bouwplan", bouwplan);
                List<BouwplanVariable> bvs = q.getResultList();
                for (BouwplanVariable bv : bvs) {

                    bv.setSloop(null);
                    bv.setGerealiseerdesloop(null);
                    em.persist(bv);
                }
            }
        }
        if (geometry != null) {
            JSONObject json = new JSONObject();
            Polygon p = parseGeometry(json);
            if (p != null) {
                bouwplan.setThe_geom(p);
            }
        }
        
        em.persist(bouwplan);
        saveAdditionalVariables();
        saveDetailData(bouwplan, detailData, em);
        em.getTransaction().commit();
        SolrActionBean.addSingleBouwplan(bouwplan);
        add=false;
        return edit();
    }

    public Resolution deletePlan(){
        EntityManager em = Stripersist.getEntityManager();
        removeBouwplan(bouwplan, em);
        SolrActionBean.removeSingleBouwplan(bouwplan);
        return new RedirectResolution(SearchActionBean.class);
    }

    public void removeBouwplan(Bouwplan bp, EntityManager em) {
        em.remove(bp);
        em.getTransaction().commit();
    }

    public Resolution bouwplanImage() throws Exception {
        if (bouwplan != null && bouwplan.getThe_geom() != null) {
            final CombineImageSettings cis;
            if(key != null){
                cis = imageSettings.get(key);
                cis.setWidth(width);
                cis.setHeight(height);
            }else{
                cis = createCombineImageSettings(bouwplan, getMapserverUrl(), getLayers(), width, height, getHttpRequestParams());
            }
            return new StreamingResolution("") {
                @Override
                public void stream(HttpServletResponse response) throws IOException {
                    OutputStream out = response.getOutputStream();
                    try {
                        CombineImagesHandler.combineImage(out, cis, cis.getMimeType(), 10000);
                    } catch (Exception e) {
                        log.error("Fout maken image:", e);
                    } finally {
                        out.close();
                    }
                }
            };
        } else {
            final BufferedImage img = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB_PRE);
            Graphics2D g = img.createGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, width, height);
            return new StreamingResolution("") {
                @Override
                public void stream(HttpServletResponse response) throws IOException {
                    OutputStream out = response.getOutputStream();
                    try {
                        ImageTool.writeImage(img, "image/png", out);
                    } catch (Exception e) {
                        log.error("Fout maken image:", e);
                    } finally {
                        out.close();
                    }
                }
            };
        }
    }

    public static CombineImageSettings createCombineImageSettings(Bouwplan bouwplan, String mapUrl, String layers, int width, int height, String httpRequestParams) throws Exception{
        String bbox = BouwplanUtils.makeBboxBouwplan(bouwplan);
        if(bbox == null){
            return null;
        }
        
        if (mapUrl.contains("?")) {
            mapUrl += "&";
        } else {
            mapUrl += "?";
        }
        mapUrl += "layers=" + layers + "&version=1.1.1&format=image/png&srs=EPSG:28992&request=getmap&service=wms&width=" + width + "&height=" + height + "&bbox=" + bbox + "&" + httpRequestParams;
        String tms = "http://geodata.nationaalgeoregister.nl/tiles/service/tms/1.0.0/brtachtergrondkaart@EPSG:28992@png8/";

        final CombineImageSettings cis = new CombineImageSettings();
        CombineImageUrl ciu;

        CombineTMSUrl ctu = new CombineTMSUrl();
        ctu.setServiceBbox(new Bbox("-285401.0,22598.0,595401.0,903401.0"));
        ctu.setTileWidth(256);
        ctu.setTileHeight(256);
        ctu.setExtension("png");
        String resolutions = "3440.64,1720.32,860.16,430.08,215.04,107.52,53.76,26.88,13.44,6.72,3.36,1.68,0.84,0.42,0.21,0.105";
        String[] tokens = resolutions.split(",");
        Double[] res = new Double[tokens.length];
        for (int i = 0; i < tokens.length; i++) {
            res[i] = new Double(tokens[i]);
        }
        ctu.setResolutions(res);
        ciu = ctu;
        ciu.setUrl(tms);

        cis.addUrl(ciu);

        CombineWmsUrl cmu = new CombineWmsUrl();
        cmu.setUrl(mapUrl);
        cis.addUrl(cmu);

        cis.setBbox(bbox);
        cis.setHeight(height);
        cis.setWidth(width);
        cis.setSrid(28992);
        cis.setMimeType("image/png");

        imageSettings.put(""+cis.hashCode(), cis);
        return cis;
    }

    @ValidationMethod(on = "save")
    public void handleGeometryValidation(){
        if(geometry == null && bouwplan.getThe_geom() == null){
            getContext().getValidationErrors().add("Geometrie", new SimpleError("Geometrie mag niet leeg zijn. Teken een geometrie."));
        }
    }
    
    public Resolution filterGemeentes() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        Session sess = (Session) em.getDelegate();

        Criteria criteria = sess.createCriteria(Gemeente.class);
        criteria.addOrder(Order.asc("naam"));
        criteria.add(Restrictions.ilike("naam", gemeente, MatchMode.ANYWHERE));
        List<Gemeente> gemeentes = criteria.list();
        JSONArray gems = new JSONArray();
        for (Gemeente gem : gemeentes) {
            gems.put(gem.getNaam());
        }
        return new StreamingResolution("application/json", new StringReader(gems.toString()));
    }

    @Before(stages = LifecycleStage.BindingAndValidation)
    private void createLists() throws JSONException{
        EntityManager em = Stripersist.getEntityManager();
        plantypes = em.createQuery("from Plantype order by id").getResultList();
        woonmilieus  = em.createQuery("from Woonmilieu order by type").getResultList();
        ontwikkelaartypes = em.createQuery("from Ontwikkelaartype order by id").getResultList();
        statusplanologisch = em.createQuery("from Statusplanologisch order by id").getResultList();
        statusprojecten = em.createQuery("from Statusproject order by volgorde").getResultList();
        gebruikgegevens = em.createQuery("from Gebruikgegevens order by volgorde").getResultList();

        String id = context.getRequest().getParameter("bouwplan.id");
        if(id != null && !id.isEmpty() ){
            Integer idValue = Integer.parseInt(id);
            bouwplan = em.find(Bouwplan.class, idValue);
        }
        Calendar c = Calendar.getInstance();
        beginYear = c.get(Calendar.YEAR) -2 ;

    }

    @DontValidate
    @After(stages = LifecycleStage.EventHandling,on = "!bouwplanImage")
    private void retrieveVariables() throws JSONException{
        EntityManager em = Stripersist.getEntityManager();
        List<ProvincieAdditionalVariable> vars = null;
        Gemeente gemeente = null;
        if(bouwplan != null && bouwplan.getGemeente() != null){
            gemeente = bouwplan.getGemeente();
        }else{
            gemeente = gebruiker.getGemeente();
        }

        Provincie p = gemeente.getProvincie();
        if (gemeente.getRegio() != null) {
            vars = em.createQuery("select p FROM ProvincieAdditionalVariable p join p.regios r where p.label = false and r.id = :regio order by additional_variable", ProvincieAdditionalVariable.class).setParameter("regio", gemeente.getRegio().getId()).getResultList();
        } else {
            vars = em.createQuery("FROM ProvincieAdditionalVariable where label = false and provincie = :provincie and usedByMunicipalities = true order by additional_variable", ProvincieAdditionalVariable.class).setParameter("provincie", p).getResultList();
        }
        
        JSONArray ar = new JSONArray();
        for (ProvincieAdditionalVariable var : vars) {
            ar.put(var.toJSON(gemeente));
        }
        variables = ar.toString();

        if (bouwplan != null && !add) {
            List<BouwplanAdditionalVariable> values = em.createQuery("FROM BouwplanAdditionalVariable WHERE bouwplan = :bouwplan").setParameter("bouwplan", bouwplan).getResultList();
            JSONObject valuesObject = new JSONObject();
            for (BouwplanAdditionalVariable var : values) {
                if(var.getVariable() != null){
                    valuesObject.put(var.getVariable().getId().toString(), var.toJSON());
                }
            }
            variableValues = valuesObject.toString();
        }else{
            variableValues = new JSONArray().toString();
        }

        optionalVariables = em.createQuery("FROM ProvincieVariable WHERE provincie = :provincie", ProvincieVariable.class).setParameter("provincie", p).getResultList();

        for (ProvincieVariable provincieVariable : optionalVariables) {
            bpOptionalVariables.put(provincieVariable.getVariable().getName(), Boolean.TRUE);
        }
        
        //List<ConfigurableVariable> optionalLabelVars = em.createQuery("FROM ConfigurableVariable WHERE type = :type", ConfigurableVariable.class).setParameter("type", VariableType.LABEL).getResultList();
        List<String> optionalLabelVars = em.createQuery("SELECT label FROM ConfigurableVariable WHERE type = :type", String.class)
                .setParameter("type", VariableType.LABEL).getResultList();

        List<ProvincieAdditionalVariable> labelVars = null;
        if (optionalLabelVars.size() > 0) {
            labelVars = em.createQuery("FROM ProvincieAdditionalVariable WHERE label = true and additional_variable in :vars and provincie = :provincie")
                    .setParameter("vars", optionalLabelVars).setParameter("provincie", p).getResultList();
        }else{
            labelVars = new ArrayList<ProvincieAdditionalVariable>();
        }
        labelMap = new HashMap<String,String>();
        Regio regio = gemeente.getRegio();
        for (String optionalLabelVar : optionalLabelVars) {
            String value = null;
            for (ProvincieAdditionalVariable labelVar : labelVars) {
                if(labelVar.getAdditional_variable().equals(optionalLabelVar)){
                    for (ProvincieAdditionalVariableValue pavv : labelVar.getValues()) {
                        if(regio == null && pavv.isUsedByMunicipalities()){
                            value = pavv.getValue();
                        }
                        if(pavv.getRegios().contains(gemeente.getRegio())){
                            value = pavv.getValue();
                        }
                    }
                }
            }
            labelMap.put("" + optionalLabelVar, value != null ? value : optionalLabelVar);
        }
        labelMapJSON = new JSONObject(labelMap).toString();

        canEdit = gebruiker != null ? gebruiker.getProvincie() == null : false;
        if(bouwplan != null && gebruiker != null ){
            canEdit = (gebruiker.getGemeente() != null && gebruiker.getGemeente().getId() == bouwplan.getGemeente().getId()) || (gebruiker.getProvincie() != null && gebruiker.getProvincie().getId() == bouwplan.getGemeente().getProvincie().getId());
        }
       
        if (bouwplan != null && bouwplan.getThe_geom() != null) {
            bbox = BouwplanUtils.makeBboxBouwplan(bouwplan);
        } else if (gebruiker != null) {
            bbox = BouwplanUtils.makeBbox(gebruiker);
        }
    }

    private boolean isAuthorized(){
        boolean authorized = false;
        if(bouwplan != null){
            authorized = BouwplanUtils.isAuthorized(bouwplan, gebruiker);
        }else if(add){
            authorized = gebruiker != null ? gebruiker.getGemeente() != null : false;
        }
        return authorized;
    }

    private Polygon parseGeometry(JSONObject json) throws JSONException{
        Polygon p = null;
        WKTReader wktreader = new WKTReader(new GeometryFactory(new PrecisionModel(), 28992));
        Geometry geom = null;
        try {
            geom = wktreader.read(geometry);
            if (geom.getGeometryType().equalsIgnoreCase("Point")) {
                geom = geom.buffer(50, 4, BufferParameters.CAP_ROUND);
            }

            Geometry gemeenteGeom = gebruiker.getGemeente().getTheGeom();
            if (!geom.within(gemeenteGeom)) {
                json.put("message", "Geometrie niet binnen gemeente");
            }
            if (geom.getGeometryType().equalsIgnoreCase("MultiPolygon")) {
                log.error("Geometry kan niet als multipolygon worden opgeslagen");
                json.put("message", "Geometry kan niet als multipolygon worden opgeslagen");
            } else if (geom.getGeometryType().equalsIgnoreCase("Polygon")) {
                p = (Polygon) geom;
                if (!p.isValid()) {
                    log.debug("Geometry is invalide. Maak valide");
                    p = (Polygon) p.buffer(0);
                }
                if (!p.isValid()) {
                    json.put("message", "Geometry is invalide. Maak valide");
                }else{
                    json.put("success", true);
                }

            } else {
                log.error("Geometry moet of als polygon zijn getekend of als multipolygon.");
                json.put("message", "Geometry moet of als polygon zijn getekend of als multipolygon.");

            }
        } catch (ParseException e) {
            log.error("Geometry kan niet worden opgeslagen");
            json.put("message", "Geometry kan niet worden opgeslagen");

        }
        return p;
    }

    private void saveAdditionalVariables() {
        try {
            EntityManager em = Stripersist.getEntityManager();

            // Remove all previous variables
            em.createQuery("DELETE BouwplanAdditionalVariable WHERE bouwplan = :bouwplan").setParameter("bouwplan", bouwplan).executeUpdate();
            // Save them variables
            JSONObject values = new JSONObject(additionalVariables);
            for (Iterator<String> iterator = values.keys(); iterator.hasNext();) {
                String key = iterator.next();
                JSONObject value = values.getJSONObject(key);
                ProvincieAdditionalVariable pav = em.find(ProvincieAdditionalVariable.class, value.getInt("id"));
                BouwplanAdditionalVariable bav = new BouwplanAdditionalVariable();
                bav.setBouwplan(bouwplan);
                bav.setVariable(pav);
                bav.setVariableValue(value.get("value").toString());
                em.persist(bav);

            }
        } catch (JSONException ex) {
            log.error("Cannot save additional variables",ex);
        }
    }

    private void removeDetailData(Bouwplan bouwplan, EntityManager em) {
        Query q = em.createQuery("FROM BouwplanVariable where bouwplan = :bouwplan", BouwplanVariable.class).setParameter("bouwplan", bouwplan);
        List<BouwplanVariable> bvs = q.getResultList();
        for (BouwplanVariable bv : bvs) {
            em.remove(bv);
        }
    }

    private void saveDetailData(Bouwplan bouwplan, String detailData, EntityManager em) throws JSONException {
        if (detailData != null) {
            removeDetailData(bouwplan, em);
            JSONArray newDetailData = new JSONArray(detailData);
            for (int i = 0; i < newDetailData.length(); i++) {
                JSONObject bv = newDetailData.getJSONObject(i);
                BouwplanVariable bouwplanVariable = BouwplanVariable.fromJSON(bv);
                bouwplanVariable.setBouwplan(bouwplan);
                em.persist(bouwplanVariable);
            }
        }
    }

    // <editor-fold defaultstate="collapsed" desc="Getters and Setters">
    public void setAdd(boolean add) {
        this.add = add;
    }

    public boolean isAdd() {
        return add;
    }

    public Bouwplan getBouwplan() {
        return bouwplan;
    }

    public void setBouwplan(Bouwplan bouwplan) {
        this.bouwplan = bouwplan;
    }

    public List<Plantype> getPlantypes() {
        return plantypes;
    }

    public void setPlantypes(List<Plantype> plantypes) {
        this.plantypes = plantypes;
    }

    public List<Ontwikkelaartype> getOntwikkelaartypes() {
        return ontwikkelaartypes;
    }

    public void setOntwikkelaartypes(List<Ontwikkelaartype> ontwikkelaartypes) {
        this.ontwikkelaartypes = ontwikkelaartypes;
    }

    public List<Statusplanologisch> getStatusplanologisch() {
        return statusplanologisch;
    }

    public void setStatusplanologisch(List<Statusplanologisch> statusplanologisch) {
        this.statusplanologisch = statusplanologisch;
    }

    public List<Statusproject> getStatusprojecten() {
        return statusprojecten;
    }

    public void setStatusprojecten(List<Statusproject> statusprojecten) {
        this.statusprojecten = statusprojecten;
    }

    public String getDetailData() {
        return detailData;
    }

    public void setDetailData(String detailData) {
        this.detailData = detailData;
    }

    public List<Woonmilieu> getWoonmilieus() {
        return woonmilieus;
    }

    public void setWoonmilieus(List<Woonmilieu> woonmilieus) {
        this.woonmilieus = woonmilieus;
    }

    public String getBbox() {
        return bbox;
    }

    public void setBbox(String bbox) {
        this.bbox = bbox;
    }

    public String getGeometry() {
        return geometry;
    }

    public void setGeometry(String geometry) {
        this.geometry = geometry;
    }
    
    public String getVariables() {
        return variables;
    }

    public void setVariables(String variables) {
        this.variables = variables;
    }

    public String getAdditionalVariables() {
        return additionalVariables;
    }

    public void setAdditionalVariables(String additionalVariables) {
        this.additionalVariables = additionalVariables;
    }

    public String getVariableValues() {
        return variableValues;
    }

    public void setVariableValues(String variableValues) {
        this.variableValues = variableValues;
    }

    public int getBeginYear() {
        return beginYear;
    }

    public void setBeginYear(int beginYear) {
        this.beginYear = beginYear;
    }

    public List<Gebruikgegevens> getGebruikgegevens() {
        return gebruikgegevens;
    }

    public void setGebruikgegevens(List<Gebruikgegevens> gebruikgegevens) {
        this.gebruikgegevens = gebruikgegevens;
    }

    public String getGemeente() {
        return gemeente;
    }

    public void setGemeente(String gemeente) {
        this.gemeente = gemeente;
    }

    public Map<String, Boolean> getBpOptionalVariables() {
        return bpOptionalVariables;
    }

    public void setBpOptionalVariables(Map<String, Boolean> bpOptionalVariables) {
        this.bpOptionalVariables = bpOptionalVariables;
    }
        
    public Map<String, String> getLabelMap() {
        return labelMap;
    }

    public void setLabelMap(Map<String, String> labelMap) {
        this.labelMap = labelMap;
    }

    public boolean isCanEdit() {
        return canEdit;
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getLabelMapJSON() {
        return labelMapJSON;
    }

    public void setLabelMapJSON(String labelMapJSON) {
        this.labelMapJSON = labelMapJSON;
    }

    // </editor-fold>

    public Resolution handleValidationErrors(ValidationErrors ve) throws Exception {
        // Prevents nullpointer in retrieveVariables() when saving when there is no geometry saved. This happens when determining if the used can edit.
        if(bouwplan != null && bouwplan.getGemeente() == null && gebruiker != null){
            bouwplan.setGemeente(gebruiker.getGemeente());
        }
        retrieveVariables();
        return null;
    }
}
