/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.entity;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import nl.b3p.pzh.rwbp.entity.BouwplanAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariableValue;
import nl.b3p.pzh.rwbp.entity.Regio;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class ProvincieAdditionalVariable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    private String additional_variable;
    @ManyToOne
    @JoinColumn(name="provincie")
    private Provincie provincie;
    private String type;
    private String location;
    private boolean additionField = true;
    private boolean usedByMunicipalities = true;
    private boolean provinceField = false;
    private boolean uitgebreidsteField = false;
    private String mainCategory;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="provincieadditionalvariable")
    private List<ProvincieAdditionalVariableValue> values = new ArrayList();
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinTable(name="regio_additional_variable", joinColumns={@JoinColumn(name="value")}, inverseJoinColumns={@JoinColumn(name="regio")})
    private List<Regio> regios = new ArrayList();
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="variable", fetch=FetchType.LAZY)
    private List<BouwplanAdditionalVariable> bouwplanAdditionalVariables = new ArrayList();
    private boolean label = false;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Provincie getProvincie() {
        return this.provincie;
    }

    public void setProvincie(Provincie provincie) {
        this.provincie = provincie;
    }

    public String getAdditional_variable() {
        return this.additional_variable;
    }

    public void setAdditional_variable(String additional_variable) {
        this.additional_variable = additional_variable;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean isAdditionField() {
        return this.additionField;
    }

    public void setAdditionField(boolean additionField) {
        this.additionField = additionField;
    }

    public List<ProvincieAdditionalVariableValue> getValues() {
        return this.values;
    }

    public void setValues(List<ProvincieAdditionalVariableValue> values) {
        this.values = values;
    }

    public void addValue(ProvincieAdditionalVariableValue value) {
        this.values.add(value);
    }

    public List<Regio> getRegios() {
        return this.regios;
    }

    public void setRegios(List<Regio> regios) {
        this.regios = regios;
    }

    public boolean isUsedByMunicipalities() {
        return this.usedByMunicipalities;
    }

    public void setUsedByMunicipalities(boolean usedByMunicipalities) {
        this.usedByMunicipalities = usedByMunicipalities;
    }

    public boolean isProvinceField() {
        return this.provinceField;
    }

    public void setProvinceField(boolean provinceField) {
        this.provinceField = provinceField;
    }

    public boolean isLabel() {
        return this.label;
    }

    public void setLabel(boolean label) {
        this.label = label;
    }

    public List<BouwplanAdditionalVariable> getBouwplanAdditionalVariables() {
        return this.bouwplanAdditionalVariables;
    }

    public void setBouwplanAdditionalVariables(List<BouwplanAdditionalVariable> bouwplanAdditionalVariables) {
        this.bouwplanAdditionalVariables = bouwplanAdditionalVariables;
    }

    public String getMainCategory() {
        return this.mainCategory;
    }

    public void setMainCategory(String mainCategory) {
        this.mainCategory = mainCategory;
    }

    public boolean isUitgebreidsteField() {
        return this.uitgebreidsteField;
    }

    public void setUitgebreidsteField(boolean uitgebreidsteField) {
        this.uitgebreidsteField = uitgebreidsteField;
    }

    public JSONObject toJSON(Gemeente gemeente) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.id);
        json.put("name", (Object)this.additional_variable);
        json.put("type", (Object)this.type);
        json.put("location", (Object)this.location);
        json.put("additionField", this.additionField);
        json.put("provinceField", this.provinceField);
        json.put("uitgebreidsteField", this.uitgebreidsteField);
        json.put("label", this.label);
        json.put("mainCategory", (Object)this.mainCategory);
        if (this.type.equalsIgnoreCase("dropdown") || this.label) {
            JSONArray valuesArray = new JSONArray();
            for (ProvincieAdditionalVariableValue value : this.values) {
                boolean canAdd = false;
                if (gemeente != null) {
                    if (gemeente.getRegio() == null && value.isUsedByMunicipalities()) {
                        canAdd = true;
                    } else if (gemeente.getRegio() != null && value.getRegios().contains(gemeente.getRegio())) {
                        canAdd = true;
                    }
                } else {
                    canAdd = true;
                }
                if (!canAdd) continue;
                JSONObject valueObject = value.toJSON();
                valuesArray.put((Object)valueObject);
            }
            json.put("values", (Object)valuesArray);
        } else {
            JSONArray regiosArray = new JSONArray();
            for (Regio regio : this.regios) {
                regiosArray.put(regio.getId());
            }
            if (this.usedByMunicipalities) {
                regiosArray.put(-1);
            }
            json.put("regios", (Object)regiosArray);
        }
        return json;
    }
}

