Ext.define('B3p.planmonitor.DetailPlanner', {
    bouwplan: null,
    initCompleted: false,
    tableBody: null,
    totalsCounter: null,
    // Keeps a reference to which fields is updated last, the restcapaciteit field
    // or the detailfields which make up a total.
    capacityCountLastUpdate: '',
    capacityTotal: 0,
    initData:null,
    capacityDividedButNotSaved:null,
    firstInit:null,
    config: {
        postfix:null,
        div: null,
        col:null,
        totalField: null,
        realisedField : null,
        beginYear: null,
        endYear: null,
        canEdit:null,
        retrieveDetailData: '',
        saveDetailData: '',
        attributesToSave:null
    },
    constructor: function(config) {
        this.initConfig(config);
        this.cols = ["Jaar", this.config.col,"Gerealiseerd"];
        this.bouwplan = document.getElementById("bouwplanid").value;
        this.initForm();
        this.capacityTotal = +(document.getElementById(this.config.totalField).value);
        document.getElementById("cancelDetailPlanning" + this.config.postfix).addEventListener("click", this.closeDialog.bind(this));
        if (this.config.canEdit) {
            document.getElementById("saveDetailPlanning" + this.config.postfix).addEventListener("click", this.save.bind(this));
        }
        document.getElementById("detailPopupLink" + this.config.postfix).addEventListener("click", this.popupOpen.bind(this));
        document.getElementById(this.config.totalField).addEventListener('input', this.totalCapaciteitChange.bind(this));
        this.firstInit = true;
        this.popupOpen();
    },
    totalCapaciteitChange: function(e) {
        var val = +(e.target.value);
        if(val !== this.capacityTotal) {
            this.capacityCountLastUpdate = 'restcapaciteit';
            this.capacityTotal = val;
            if(this.initCompleted) {
                this.divideCapacityTotal();
            }
        }
    },
    popupOpen: function() {
        var begin = parseInt(Ext.get( "jaar_eerste_oplevering").getValue(), 10);
        var end = parseInt(Ext.get( "jaar_laatste_oplevering").getValue(), 10);
        if(!this.initCompleted || this.config.beginYear !== begin || this.config.endYear !== end) {
            this.config.beginYear = begin;
            this.config.endYear = end;
        }
        this.init();
    },
    init: function(){
        Ext.Ajax.request({
            url: this.config.retrieveDetailData,
            scope: this,
            params: {
                bouwplan: this.bouwplan
            },
            success: function (result) {
                var response = Ext.JSON.decode(result.responseText);
                if (response.success) {
                    var d = response.bouwplanvariables;
                    // Process data for easier lookup
                    var data = {};
                    for ( var i = 0 ; i < d.length ;i++){
                        data[d[i].year] = d[i];
                    }
                    this.initData = data;
                    this.createForm(data);
                } else {
                    console.log("Error", response);
                }
            },
            failure: function (error) {
                console.log("Error", error);
            }
        });
    },
    save: function(){
        var bvs = [];
        for(var i = this.config.beginYear ; i <= this.config.endYear ; i ++ ){
            var bv = this.getBouwplanVariable(i);
            bvs.push(bv);
        }
        var onbekend = this.getBouwplanVariable(-1); // Retrieve onbekend jaar
        bvs.push(onbekend);

        document.getElementById("detailData" + this.config.postfix).value = Ext.JSON.encode(bvs);
        if(this.bouwplan){
            Ext.Ajax.request({
                url: this.config.saveDetailData,
                scope: this,
                params: {
                    bouwplan: this.bouwplan,
                    detailData: Ext.JSON.encode(bvs)
                },
                success: function (result) {
                    var response = Ext.JSON.decode(result.responseText);
                    if (response.success) {
                        this.updateMainScreen();
                    } else {
                        console.log("Error", response);
                    }
                    this.capacityDividedButNotSaved = false;
                    this.closeDialog();
                },
                failure: function (error) {
                    console.log("Error", error);
                }
            });
        }else{
            this.updateMainScreen();
            this.closeDialog();
        }
    },
    getTotal : function(){
        return this.totalsCounter.getTotalForField(this.config.col);
    },
    getRealisedTotal : function(){
        return this.gerealiseerdCounter.getTotal();
    },
    updateMainScreen : function (){
        var total = this.getTotal();
        var gerealiseerdTotaal = this.getRealisedTotal();

        this.capacityCountLastUpdate = 'details';
        this.capacityTotal = total;

        var totalElement = document.getElementById(this.config.totalField);
        totalElement.value = total;
        totalElement.readOnly = true;

        var gerealiseerdeElement = document.getElementById(this.config.realisedField);
        gerealiseerdeElement.value = gerealiseerdTotaal;
        gerealiseerdeElement.readOnly = true;

        $(totalElement).change();
    },
    getBouwplanVariable: function (year){
        var prevData = this.initData[year];
        var bouwplanVariable = {
            "year": year
        };
        bouwplanVariable ["gerealiseerd" + this.config.postfix] = document.getElementById("gerealiseerd"+ this.config.postfix +year).checked;
        bouwplanVariable [this.config.col] = document.getElementById(this.config.col+year).value;
        for(var i = 0 ; i < this.config.attributesToSave.length ;i++){
            var key = this.config.attributesToSave[i];
            if(prevData){
                bouwplanVariable[key] = prevData[key];
            }
        }
        return bouwplanVariable;
    },
    initForm: function() {
        var table = document.createElement ("table");
        table.className = "planning-counter" + this.config.col;
        table.id = "detailstable";
        table.appendChild(this.createHeader());
        this.tableBody = document.createElement("tbody");
        table.appendChild(this.tableBody);
        var tfoot = document.createElement('tfoot');
        tfoot.appendChild(this.createTotal());
        table.appendChild(tfoot);
        var div = document.getElementById(this.config.div);
        div.appendChild(table);
        
        this.totalsCounter = Ext.create('B3p.planmonitor.TotalCounter', {
            parent: '.planning-counter' + this.config.col,
            fields: [
                this.config.col
            ]
        });
        
        this.gerealiseerdCounter = Ext.create('B3p.planmonitor.ConditionalCounter', {
            parent: '.planning-counter' + this.config.col,
            rowSelector: '.inputrow',
            conditionSelector: '.gerealiseerd_checkbox'
        });
    },
    createForm: function(data){
        if(!this.firstInit){
            this.initCompleted = true;
        }else{
            this.firstInit = false;
        }
        this.clearChildren(this.tableBody);
        for (var i = this.config.beginYear; i <= this.config.endYear; i++) {
            var yearData = data.hasOwnProperty(i) ? data[i] : {};
            var row = this.createRow(i, yearData);
            this.tableBody.appendChild(row);
        }
        var unknownData = Ext.isDefined(data[-1]) ? data[-1] : {};
        var unknownRow = this.createRow(-1, unknownData);
        this.tableBody.appendChild(unknownRow);
        if(this.totalsCounter) {
            this.totalsCounter.resetTotals();
        }
        if(this.capacityCountLastUpdate === 'restcapaciteit') {
            this.divideCapacityTotal();
        }
    },
    createHeader: function(){
        var thead = document.createElement('thead');
        var tr = document.createElement("tr");
        for( var i = 0 ; i < this.cols.length ;i++){
            var th = document.createElement("th");
            th.innerHTML = this.capitalizeFirstLetter(this.cols[i]);
            tr.appendChild(th);
        }
        thead.appendChild(tr);
        return thead;
    },
    capitalizeFirstLetter: function (string) {
        return string.charAt(0).toUpperCase() + string.slice(1);
    },
    createTotal: function(){
        var tr = document.createElement ("tr");
        var td = document.createElement("td");
        td.innerHTML = "Totaal";
        tr.appendChild(td);
        tr.appendChild(this.createTotalTD(this.config.col));

        tr.appendChild(document.createElement("td"));
        
        return tr;
    },
    createTotalTD: function(type){
        var td = document.createElement("td");
        var spangepland = document.createElement("span");
        spangepland.className = "total "+ type + "-total";
        td.appendChild(spangepland);
        return td;
    },
    createRow: function (year, yearData){
        var tr = document.createElement ("tr");
        tr.className = 'inputrow';
        for (var i = 0 ; i < this.cols.length ; i ++){
            var col = this.createColumn(year, this.cols[i],yearData);
            tr.appendChild(col);
        }
        return tr;
    },
    createColumn: function(year, colName, yearData){
        var lowerCaseName = colName.toLowerCase();
        var td = document.createElement("td");
        td.className = "detail-div";
        if(colName !== "Jaar") {
            var inputField = document.createElement("input");
            if (colName === "Gerealiseerd") {
                lowerCaseName = lowerCaseName + this.config.postfix;
                inputField.id = lowerCaseName + year;
                inputField.name = lowerCaseName + year;
                inputField.className = 'gerealiseerd_checkbox';
                inputField.type = "checkbox";
                inputField.value = true;
                inputField.checked = yearData.hasOwnProperty(lowerCaseName) && yearData[lowerCaseName];
            } else {
                inputField.id = lowerCaseName + year;
                inputField.name = lowerCaseName + year;
                inputField.type = "text";
                inputField.value = yearData.hasOwnProperty(lowerCaseName) ? yearData[lowerCaseName] : "";
                inputField.className = "numeric " + lowerCaseName;
            }
            td.appendChild(inputField);
        } else {
            year = year === -1 ? "Onbekend" : year;
            td.innerHTML = year;
        }
        return td;
    },
    divideCapacityTotal: function() {
        var totaalcapaciteit = +(document.getElementById(this.config.totalField).value);
        var rows = (this.config.endYear - this.config.beginYear) + 1;
        var average = Math.floor(totaalcapaciteit / rows);
        var rest = totaalcapaciteit - (rows * average);
        for (var i = this.config.beginYear; i <= this.config.endYear; i++) {
            document.getElementById(this.config.col + i).value = (i === this.config.beginYear ? average + rest : average);
        }
        if(this.totalsCounter) {
            this.totalsCounter.resetTotals();
        }
        this.capacityCountLastUpdate = '';
        this.capacityDividedButNotSaved = true;
    },
    clearChildren: function(container) {
        if(!container) {
            return;
        }
        while (container.firstChild) {
            container.removeChild(container.firstChild);
        }
    },
    closeDialog : function(){
        $("#detailplanning" + this.config.postfix).dialog("close");
    }
});