Ext.define('B3p.planmonitor.DetailPlannerUitgebreid', {
    types: ["Meergezins", "Eengezins", "Onbekend"],
    cols: ["Koop1", "Koop2", "Koop3", "Koop4", "Koop Onb.", "Huur1", "Huur2", "Huur3", "Huur4", "Huur Onb.", "Onbekend", "Gerealiseerd"],
    bouwplan: null,
    initCompleted: false,
    tableBody: null,
    totalsCounter: null,
    firstInit:null,
    grids: {
        meergezins: null,
        eengezins: null,
        onbekend: null
    },
    config: {
        div: null,
        beginYear: null,
        labels:null,
        canEdit:null,
        endYear: null,
        retrieveDetailData: '',
        saveDetailData: '',
        subTypes: {
            meergezins: [],
            eengezins: [],
            onbekend: []
        },
        variables: []
    },
    constructor: function(config) {
        this.initConfig(config);
        this.config.labels["Gerealiseerd"] = "Gereal.";
        this.bouwplan = document.getElementById("bouwplanid").value;
        if (this.config.canEdit) {
            document.getElementById("saveDetailPlanningUitgebreid").addEventListener("click", this.save.bind(this));
        }
        document.getElementById("cancelDetailPlanningUitgebreid").addEventListener("click", this.closeDialog);
        document.getElementById("detailUitgebreidPopupLink").addEventListener("click", this.popupOpen.bind(this));
        this.firstInit = true;
        this.initVariables();
        this.popupOpen();
    },
    initVariables: function() {
        var variables = this.config.variables !== '' ? Ext.JSON.decode(this.config.variables) : [];
        for(var i = 0; i < variables.length; i++) {
            if(variables[i].location === 'woningtypen' && variables[i].mainCategory && variables[i].uitgebreidsteField) {
                this.config.subTypes[variables[i].mainCategory].push({
                    name: variables[i].name,
                    id: variables[i].id
                });
            }
        }
    },
    popupOpen: function() {
        var begin = parseInt(Ext.get( "jaar_eerste_oplevering").getValue(), 10);
        var end = parseInt(Ext.get( "jaar_laatste_oplevering").getValue(), 10);
        if(!this.initCompleted || this.config.beginYear !== begin || this.config.endYear !== end) {
            this.config.beginYear = begin;
            this.config.endYear = end;
            this.init();
        }
    },
    init: function(){
        Ext.Ajax.request({
            url: this.config.retrieveDetailData,
            scope: this,
            params: {
                bouwplan: this.bouwplan
            },
            success: function (result) {
                var response = Ext.JSON.decode(result.responseText);
                if (response.success) {
                    var d = response.bouwplanvariables;
                    // Process data for easier lookup
                    var data = {};
                    for ( var i = 0 ; i < d.length ;i++){
                        if(!data[d[i].type]){
                                data[d[i].type] = {};
                        }
                        data[d[i].type][d[i].year] = d[i];
                    }
                    this.createForm(data);
                } else {
                }
            },
            failure: function (error) {
            }
        });
    },
    hasMainTypeSubTypeDifferences: function () {
        for(var i = 0; i < this.types.length; i++) {
            var subtypes = [];
            var lowerType = this.types[i].toLowerCase();
            if(this.config.subTypes.hasOwnProperty(lowerType)) {
                subtypes = this.config.subTypes[lowerType];
            }
            if(subtypes.length === 0) {
                continue;
            }
            var mainTypeTotal = this.grids[lowerType].getTotal();
            var subTypeTotals = 0;
            for(var j = 0; j < subtypes.length; j++) {
                var subType = this.getTypeSubtypeKey(lowerType, subtypes[j].name);
                subTypeTotals += this.grids[subType].getTotal();
            }
            if(mainTypeTotal !== subTypeTotals) {
                return {
                    hasDifference: true,
                    mainType: this.types[i],
                    subtypes: subtypes.map(function(item) {
                        return item.name
                    }).join(", ")
                };
            }
        }
        return { hasDifference: false };
    },
    save: function() {
        var differenceCheckResult = this.hasMainTypeSubTypeDifferences();
        if(!differenceCheckResult.hasDifference) {
            this.doSave();
            return;
        }
        Ext.Msg.confirm(
            "Verschil tussen hoofd- en subtypen",
            [
                "Er is verschil tussen het totaal van hoofdtype ",
                differenceCheckResult.mainType,
                " en de subtypes ",
                differenceCheckResult.subtypes,
                ". ",
                "Indien u doorgaat zal het totaal van het hoofdtype worden overschreven door het totaal van de subtypes. ",
                "Weet u zeker dat u wilt opslaan?"
            ].join(""),
            function(btn, txt) {
                if (btn=='yes') {
                    this.doSave();
                }
            },
            this
        );
    },
    doSave: function() {
        this.overwriteMainTypes();
        var bvs = [];
        for(var i = this.config.beginYear ; i <= this.config.endYear ; i ++ ) {
            for(var key in this.grids) if(this.grids.hasOwnProperty(key)) {
                var grid = this.grids[key];
                var bv = grid.getBouwplanVariable(i);
                bvs.push(bv);
            }
        }
        document.getElementById("detailData").value = Ext.JSON.encode(bvs);
        if(this.bouwplan) {
            Ext.Ajax.request({
                url: this.config.saveDetailData,
                scope: this,
                params: {
                    bouwplan: this.bouwplan,
                    detailData: Ext.JSON.encode(bvs)
                },
                success: function (result) {
                    var response = Ext.JSON.decode(result.responseText);
                    if (response.success) {
                        this.updateMainscreen()
                    }
                    this.closeDialog();
                },
                failure: function (error) {
                }
            });
        } else {
            this.updateMainscreen();
            this.closeDialog();
        }
    },
    getTotal : function() {
        return this.grids.meergezins.getTotal() +
               this.grids.eengezins.getTotal() +
               this.grids.onbekend.getTotal();
    },
    getRealisedTotal : function(){
        return this.grids.meergezins.getRealisedTotal() +
            this.grids.eengezins.getRealisedTotal() +
            this.grids.onbekend.getRealisedTotal();
    },
    updateMainscreen : function(){
        var total = this.getTotal();
        var gerealiseerdTotaal = this.getRealisedTotal();
        var totalElement = document.getElementById('totaalcapaciteit');
        totalElement.value = total;
        totalElement.readonly = true;

        var gerealiseerdeElement = document.getElementById('gerealiseerdecapaciteit');
        gerealiseerdeElement.value = gerealiseerdTotaal;
        gerealiseerdeElement.readonly = true;
        
        // prijsklassen
        var fields = ['type-meergezins','type-eengezins','type-onbekend','koop1','koop2','koop3','koop4', 'kooponb','huur1','huur2','huur3','huur4', 'huuronb', 'onbekend'];
        for (var i = 0 ; i < fields.length ;i++ ){
            var field = fields[i];
            var input = document.getElementById(field);
            input.value = this.getTotalsForField(field);
        }

        var subtypes;
        var lowerType;
        var subtypeinput;
        for(var k = 0; k < this.types.length; k++) {
            subtypes = [];
            lowerType = this.types[k].toLowerCase();
            if(this.config.subTypes.hasOwnProperty(lowerType)) {
                subtypes = this.config.subTypes[lowerType];
            }
            for(var j = 0; j < subtypes.length; j++) {
                subtypeinput = document.getElementById(subtypes[j].id);
                subtypeinput.value = this.getGridForSubtype(lowerType, subtypes[j].name).getTotal();
            }
        }

        edit.koophuurcounter.resetTotals();
        edit.woningtypencounter.resetTotals();
        edit.variableInstantiator.resetSubcategoryCounters();
        $(totalElement).change();
    },
    getGridForSubtype: function(type, subtype) {
        return this.grids[this.getTypeSubtypeKey(type, subtype)];
    },
    getTotalsForField: function(field) {
        return this.grids.meergezins.getTotalCounter().getTotalForField(field) +
            this.grids.eengezins.getTotalCounter().getTotalForField(field) +
            this.grids.onbekend.getTotalCounter().getTotalForField(field);
    },
    totalChanged: function() {
        var div = document.getElementById(this.config.div);
        var tableTotal = 0;
        var total;
        var field;
        for( var i = 0 ; i < this.cols.length ;i++){
            if(this.cols[i] === "Gerealiseerd") {
                continue;
            }
            field = this.getSubtypeKey(this.cols[i]);
            total = this.getTotalsForField(field);
            this.setTotalForField(div, field, total);
            tableTotal += total;
        }
        this.setTotalForField(div, "table", tableTotal);
    },
    setTotalForField: function(div, field, total) {
        var el = div.querySelector("." + field + "-total");
        if(el) {
            el.innerHTML = total;
        }
    },
    watchTotals: function() {
        this.grids.meergezins.getTotalCounter().addListener('total_changed', this.totalChanged, this);
        this.grids.eengezins.getTotalCounter().addListener('total_changed', this.totalChanged, this);
        this.grids.onbekend.getTotalCounter().addListener('total_changed', this.totalChanged, this);
    },
    clearTotalWatchers: function() {
        this.grids.meergezins.getTotalCounter().removeListener('total_changed', this.totalChanged, this);
        this.grids.eengezins.getTotalCounter().removeListener('total_changed', this.totalChanged, this);
        this.grids.onbekend.getTotalCounter().removeListener('total_changed', this.totalChanged, this);
    },
    createForm: function(data) {
        var div = document.getElementById(this.config.div);
        this.clearChildren(div);
        var lowerType;
        var subtypes;
        var container;
        var subcontainer;
        for(var i = 0; i < this.types.length; i++) {
            subtypes = [];
            lowerType = this.types[i].toLowerCase();
            if(this.config.subTypes.hasOwnProperty(lowerType)) {
                subtypes = this.config.subTypes[lowerType];
            }
            container = document.createElement('div');
            container.className = 'planner-grid-container';
            div.appendChild(container);
            this.createGridForType(container, data, this.types[i], subtypes.length >= 1 ? false : this.config.canEdit, subtypes.length > 0);
            for(var j = 0; j < subtypes.length; j++) {
                subcontainer = document.createElement('div');
                subcontainer.className = 'planner-grid-container';
                container.appendChild(subcontainer);
                this.createGridForType(subcontainer, data, this.types[i], this.config.canEdit, false, subtypes[j].name);
                this.linkMainTypeSubTypes(subcontainer, lowerType, subtypes[j].name, subtypes);
            }
        }
        // We add an extra totals row to the bottom grid (onbekend) to show totals for all grids
        this.grids.onbekend.addTotalRow();
        this.watchTotals();
        this.totalChanged();
    },
    createGridForType: function(container, data, type, canEdit, afgeleidedata,subtype) {
        var lowerType = type.toLowerCase();
        var label = type;
        if(subtype) {
            lowerType = this.getTypeSubtypeKey(type, subtype);
            label += ' - ' + subtype
        }
        this.grids[lowerType] = Ext.create('B3p.planmonitor.PlannerGrid', {
            container: container,
            beginYear: this.config.beginYear,
            endYear: this.config.endYear,
            labels: this.config.labels,
            canEdit: canEdit,
            data: data[lowerType],
            type: lowerType,
            afgeleidedata: afgeleidedata,
            typeLabel: label
        });
    },
    closeDialog : function() {
        this.clearTotalWatchers();
        $("#detailplanninguitgebreid").dialog("close");
    },
    linkMainTypeSubTypes: function(container, type, subtype, subtypes) {
        container.addEventListener('change', (function(e) {
            this.handleSubtypeChange(e, type, subtype, subtypes);
        }).bind(this));
        container.addEventListener('keyup', (function(e) {
            this.handleSubtypeChange(e, type, subtype, subtypes);
        }).bind(this));
    },
    handleSubtypeChange: function(e, type, subtype, subtypes, preventCount) {
        var input = e.target;
        var mainKey = input.id.replace('-' + this.getSubtypeKey(subtype), '');
        var mainInput = document.getElementById(mainKey);
        if(mainInput) {
            if(input.type === 'checkbox') {
                mainInput.checked = this.getAllChecked(mainKey, subtypes);
            } else {
                mainInput.value = this.getTotalValueForSubtypes(mainKey, subtypes);
                if(preventCount){
                    return;
                }
                this.grids[type].runCounters();
            }
        }
    },
    getTotalValueForSubtypes: function(mainKey, subtypes) {
        var total = 0;
        var subtypeinput;
        for(var i = 0; i < subtypes.length; i++) {
            subtypeinput = document.getElementById(mainKey + '-' + this.getSubtypeKey(subtypes[i].name));
            if(subtypeinput) {
                total += +(subtypeinput.value) || 0;
            }
        }
        return total;
    },
    getAllChecked: function(mainKey, subtypes) {
        var subtypeinput;
        for(var i = 0; i < subtypes.length; i++) {
            subtypeinput = document.getElementById(mainKey + '-' + this.getSubtypeKey(subtypes[i].name));
            if(subtypeinput && !subtypeinput.checked) {
                return false;
            }
        }
        return true;
    },
    clearChildren: function(container) {
        if(!container) {
            return;
        }
        while (container.firstChild) {
            container.removeChild(container.firstChild);
        }
    },
    getTypeSubtypeKey: function(type, subtype) {
        return type.toLowerCase() + '-' + this.getSubtypeKey(subtype);
    },
    getSubtypeKey: function(subtype) {
        return subtype.replace(/[^a-zA-Z0-9\-]/g, "").toLowerCase();
    },
    overwriteMainTypes: function(){
        for (var i = 0; i < this.types.length; i++) {
            var subtypes = [];
            var lowerType = this.types[i].toLowerCase();
            if (this.config.subTypes.hasOwnProperty(lowerType)) {
                subtypes = this.config.subTypes[lowerType];
            }
            if(subtypes.length === 0) {
                continue;
            }
            for (var j = 0; j < subtypes.length; j++) {
                var subtype = subtypes[j];
                var className = "type-" + this.getTypeSubtypeKey(lowerType, subtype.name);
                var inputs = document.getElementsByClassName(className);
                for (var k = 0; k < inputs.length;k++) {
                    var input = inputs[k];
                    this.handleSubtypeChange({ target: input }, lowerType, subtype.name, subtypes, true);
                }
            }
            this.grids[lowerType].runCounters();
        }
    }
});