Ext.define('B3p.planmonitor.Edit', {

    extends: 'Ext.util.Observable',
    drawTool: null,
    viewer: null,
    overzichtExtent: null,
    kaartExtent: null,
    formChanged: false,
    layer: null,
    newGeom: true,
    mapInitialized:null,
    variableInstantiator:null,
    
    totaalcapaciteit: 0,
    koophuurtotaal: 0,
    
    koophuurcounter:null,
    woningtypencounter:null,

    config: {
        mapserverUrl: '',
        kaartlagen: '',
        querylagen: '',
        httpRequestParams: '',
        editPlan: false,
        bbox: '',
        isNew: false,
        geavanceerd: '',
        readonly: true,
        wktGeom: '',
        bouwplanId:null,
        saveGeometryUrl: '',
        variables:null,
        variableValues:null,
        searchGemeenteUrl: '',
        isProvince: false,
        canEdit: true,
        showWoningtypes:true,
        showOwnership: true
    },

    constructor: function(config) {
        var me = this;
        this.initConfig(config);
        this.mapInitialized = false;
        this.viewer = Ext.create('B3p.planmonitor.Viewer', {
            mapDiv: "edit_map"
        });
        $('#bewerk-plan').on("dialogopened", function(){
            me.startEditting();
        });
        $('#cancelGeometry').on("click", this.closeGeometryDialog.bind(this));
        $('#saveGeometry').on("click",$.proxy(this.saveGeometry,this));
        $('[name = "closebtn"]').on("click",function(){
            window.open("Search.action?close=true","_self");
        });
        $('#editBouwplanForm').submit($.proxy(this.saveBouwplan,this));
        $('[name="deleteButton"]').on("click",function(){
            if(confirm("Weet u zeker dat het plan verwijderd moet worden?")){
                window.open("Edit.action?deletePlan=true&bouwplan="+me.config.bouwplanId,"_self");
            }
        });
        $('[name="printButton"]').on("click",function(){
            window.open("Print.action?bouwplans="+me.config.bouwplanId,"_blank");
        });
        var variables = this.config.variables !== '' ? Ext.JSON.decode(this.config.variables) : [];
        var variableValues = this.config.variableValues !== '' ? Ext.JSON.decode(this.config.variableValues) : [];
        this.variableInstantiator = Ext.create("B3p.planmonitor.VariableInstantiator",{
            variables : variables,
            variableValues: variableValues,
            isProvince: this.config.isProvince
        });
        if(this.config.isProvince || !this.config.canEdit) {
            var inputs = document.querySelectorAll(".gemeentefield");
            for (var i = 0; i < inputs.length; i++){
                inputs[i].setAttribute('readonly', true);
            }
            Ext.ComponentQuery.query('combobox[cls~=nice-select][cls~=gemeentefield]').forEach(function(combobox) {
                combobox.setDisabled(true);
            });
        }
        // init autosuggest for gemeente field
        var searchGemeenteURL = this.config.searchGemeenteUrl;
        $("#gemeente").autocomplete({
            source: function( request, response ) {
                $.ajax({
                    url: searchGemeenteURL,
                    dataType: "json",
                    data: {
                        gemeente: request.term
                    },
                    success: function( data ) {
                        response( data );
                    }
                });
            },
            minLength: 2
        });

        if (this.config.showOwnership!== "") {
            // Init totals counter huur/koop
            this.koophuurcounter = Ext.create('B3p.planmonitor.TotalCounter', {
                parent: '.huurkoop-counter',
                fields: [
                    'koop', 'huur', 'onbekend'
                ],
                total: '.koop-huur-total',
                totalChanged: (function(field, totals, total) {
                    this.koophuurtotaal = total;
                }).bind(this)
            });
            this.koophuurtotaal = this.koophuurcounter.getTotal();
        }else{
            this.koophuurtotaal = 0;
        }
        if (this.config.showWoningtypes !== "") {
            this.woningtypencounter = Ext.create('B3p.planmonitor.TotalCounter', {
                parent: '.woningtype-counter',
                fields: [
                    'woningtype'
                ],
                total: '.woningtype-total'
            });
        }
        // Init some checks
        this.initChecks();
        // init totaalcapaciteit / bijzondere woningen checks
        this.initTotaalcapaciteit();
        // Make all blocks even height
        this.evenBlockHeight();
        // Init formMonitor
        this.initFormmonitor();

        $('#detailType').on('change',this.checkPlannerLinks.bind(this));
        $('#detailTypesloop').on('change',this.checkSloopLink.bind(this));
        
        
        $('#totaalsloop').on('keyup change',this.sloopChanged.bind(this));
        $('#gerealiseerdesloop').on('keyup',this.sloopChanged.bind(this));
        
        $('#totaalcapaciteit').on('keyup change',this.capaciteitChanged.bind(this));
        $('#gerealiseerdecapaciteit').on('keyup',this.capaciteitChanged.bind(this));
        this.checkPlannerLinks();
        this.checkSloopLink();
    },
    checkSloopLink : function(){
        var plannerType = $('#detailTypesloop').val();
        if(plannerType === "normaal"){
            $("#detailPopupLinksloop").css('display','block');
            $('#totaalsloop')[0].readOnly=true;
            $('#gerealiseerdesloop')[0].readOnly=true;
        }else{
            $('#totaalsloop')[0].readOnly=false || this.config.isProvince || !this.config.canEdit;
            $('#gerealiseerdesloop')[0].readOnly=false || this.config.isProvince || !this.config.canEdit;
            $("#detailPopupLinksloop").css("display", "none");
        }
    },
    
    checkPlannerLinks : function(a,b,c){
        var plannerType = $('#detailType').val();
        if(plannerType === "normaal"){
            $("#detailUitgebreidPopupLink").css("display", "none");
            $("#detailPopupLink").css('display','block');
            $('#totaalcapaciteit')[0].readOnly=true;
            $('#gerealiseerdecapaciteit')[0].readOnly=true;
            this.toggleFieldForDetailplanning(false || this.config.isProvince || !this.config.canEdit);
        }else if( plannerType === "uitgebreid"){
            $("#detailPopupLink").css("display", "none");
            $("#detailUitgebreidPopupLink").css('display','block');
            $('#totaalcapaciteit')[0].readOnly=true;
            $('#gerealiseerdecapaciteit')[0].readOnly=true;
            this.toggleFieldForDetailplanning(true);
        }else{
            $('#totaalcapaciteit')[0].readOnly=false || this.config.isProvince || !this.config.canEdit;
            $('#gerealiseerdecapaciteit')[0].readOnly=false || this.config.isProvince || !this.config.canEdit;
            $("#detailPopupLink").css("display", "none");
            $("#detailUitgebreidPopupLink").css("display", "none");
            this.toggleFieldForDetailplanning(false || this.config.isProvince || !this.config.canEdit);
        }
    },
    
    toggleFieldForDetailplanning :function(readonly){
        var fields = ['type-meergezins','type-eengezins','type-onbekend','koop1','koop2','koop3','koop4', 'kooponb','huur1','huur2','huur3','huur4', 'huuronb', 'onbekend'];
        for (var i = 0 ; i < fields.length ;i++ ){
            var field = fields[i];
            var input = document.getElementById(field);
            input.readOnly = readonly;
        }
    },

    initTotaalcapaciteit: function() {
        var totaalcapaciteit = document.getElementById('totaalcapaciteit');
        var bijzonderewoningen = document.getElementById('bijzonderewoningen').querySelectorAll('input');
        totaalcapaciteit.addEventListener('input', (function() {
            this.totaalcapaciteit = +(totaalcapaciteit.value);
            for(var i = 0; i < bijzonderewoningen.length; i++) {
                this.checkBijzonderewoningen({ target: bijzonderewoningen[i] });
            }
        }).bind(this));
        this.totaalcapaciteit = +(totaalcapaciteit.value);
        for(var i = 0; i < bijzonderewoningen.length; i++) {
            bijzonderewoningen[i].addEventListener('input', this.checkBijzonderewoningen.bind(this));
        }
    },

    capaciteitChanged : function(){
        this.totaalcapaciteit = document.getElementById('totaalcapaciteit').value;
        var gerealiseerdTotaal = document.getElementById('gerealiseerdecapaciteit').value;
        var resterendecapaciteit = this.totaalcapaciteit - gerealiseerdTotaal;

        document.getElementById('restcapaciteit').value = resterendecapaciteit;
        document.getElementById('restcapaciteit').readonly = true;
        
        if(this.koophuurcounter && this.koophuurcounter.getTotal() !== this.totaalcapaciteit){
            this.koophuurcounter.checkTotal();
        }
        
        if( this.woningtypencounter &&  this.woningtypencounter.getTotal() !== this.totaalcapaciteit){
            this.woningtypencounter.checkTotal();
        }
        
    },
    
    sloopChanged : function(){
        var totaalsloop = document.getElementById('totaalsloop').value;
        var gerealiseerdesloop = document.getElementById('gerealiseerdesloop').value;
        var resterendesloop = totaalsloop - gerealiseerdesloop;

        document.getElementById('resterendesloop').value = resterendesloop;
    },

    checkBijzonderewoningen: function(e) {
        var val = +(e.target.value);
        var row = $(e.target).closest('.row');
        row.removeClass('error').find('.error-message').remove();
        if(val > this.totaalcapaciteit) {
            row.addClass('error').append('<span class="error-message">Waarde mag niet hoger dan plancapaciteit totaal (' + this.totaalcapaciteit + ') zijn</span>');
        }
    },
    
    initChecks: function() {
        var eerste_oplevering = document.getElementById('jaar_eerste_oplevering');
        var laatste_oplevering = document.getElementById('jaar_laatste_oplevering');
        var laatste_oplevering_row = laatste_oplevering.parentNode.parentNode;
        var error = document.createElement('span');
        error.innerHTML = 'Laatste oplevering mag niet voor Eerste oplevering liggen';
        error.className = 'error-message';
        function checkYears() {
            var yearStart = parseInt(eerste_oplevering.value, 10);
            var yearEnd = parseInt(laatste_oplevering.value, 10);
            if(yearStart > yearEnd) {
                if(laatste_oplevering_row.className.indexOf('error') === -1) {
                    laatste_oplevering_row.className += ' error';
                    laatste_oplevering_row.appendChild(error);
                }
            } else {
                if(laatste_oplevering_row.className.indexOf('error') !== -1) {
                    laatste_oplevering_row.className = laatste_oplevering_row.className.replace(' error', '');
                    laatste_oplevering_row.removeChild(error);
                }
            }
        }
        eerste_oplevering.addEventListener('change', checkYears);
        laatste_oplevering.addEventListener('change', checkYears);
    },

    evenBlockHeight: function() {
        var sections = document.querySelectorAll('#editBouwplanForm section');
        for(var i = 0; i < sections.length; i++) {
            var maxHeight = 0;
            var blocks = sections[i].querySelectorAll('.blocks .block');
            for(var j = 0; j < blocks.length; j++) {
                if(blocks[j].offsetHeight > maxHeight) {
                    maxHeight = blocks[j].offsetHeight;
                }
            }
            for(j = 0; j < blocks.length; j++) {
                blocks[j].style.height = maxHeight + 'px';
            }
        }
    },

    startEditting: function(){
        var me = this;
        this.viewer.viewerController.layoutManager.resizeLayout();
        // Figure out better way for settimeout
        setTimeout(function () {
            if (me.viewer.getViewerController().layersInitialized) {
                me.initViewer();
            } else {
                me.viewer.getViewerController().addListener(viewer.viewercontroller.controller.Event.ON_LAYERS_INITIALIZED, me.initViewer, me);
            }
        }, 250);
    },

    initViewer: function(){
        if(!this.mapInitialized){
            this.drawTool = new DrawTool({ canEdit: this.config.canEdit, isProvince: this.config.isProvince }, this.viewer.getViewerController(), this);
            this.viewer.voegGrenzenToe(this.config.mapserverUrl);
            loadBackgroundLayers(this.viewer.getViewerController(), this.viewer.getLegend());
            this.voegLayersToeEdit(this.config.querylagen, this.config.kaartlagen, this.config.httpRequestParams,false);
            var panTool=this.viewer.getViewerController().mapComponent.getToolsByType(viewer.viewercontroller.controller.Tool.PAN)[0];
            panTool.activate();
            var identifyTool=this.viewer.getViewerController().mapComponent.getToolsByType(viewer.viewercontroller.controller.Tool.GET_FEATURE_INFO)[0];
            identifyTool.setVisible(false);
            this.drawTool.setVisible(true);
            this.viewer.naarBbox(this.config.bbox);
            this.mapInitialized = true;
            this.drawTool.editButtonDown();
        }
    },

    initFormmonitor: function() {
        document.body.addEventListener('change', this.formChange.bind(this));
        document.body.addEventListener('input', this.formChange.bind(this));
    },

    formChange: function(e) {
        var tagName = e.target.tagName.toLowerCase();
        if(['input', 'select', 'textarea','geometry'].indexOf(tagName) === -1) {
            return;
        }
        if(!this.formChanged) {
            document.querySelector(".header-plannaam").innerHTML += ' *';
            window.onbeforeunload = function() {
                return 'U heeft uw wijzigingen nog niet opgeslagen, weet u zeker dat u deze pagina wilt verlaten?';
            };
        }
        this.formChanged = true;
    },

    voegLayersToeEdit: function(querylayers, layers, httpRequestParams,visible){
        var url = this.config.mapserverUrl;
        url += (url.indexOf("?") === -1 ? "?" : "&");
        url += httpRequestParams + "&";
        this.viewer.voegLayerToe(url, layers, querylayers, null, visible);
    },

    saveGeometry : function(){
        var wkt = this.drawTool.getWKT();
        Ext.get("bewerk-plan").mask("Opslaan geometrie...");
        if(wkt){
            if(this.config.bouwplanId !== ""){
                var me = this;
                Ext.Ajax.request({
                    url: this.config.saveGeometryUrl,
                    scope:me,
                    params: {
                        bouwplan: this.config.bouwplanId,
                        geometry: wkt
                    },
                    success: function (result) {
                        var response = Ext.JSON.decode(result.responseText);
                        if (response.success) {
                            var layers = this.viewer.layers;
                            for( var i = 0 ; i < layers.length; i++){
                                var layer = layers[i].layer;
                                layer.reload();
                            }
                        } else {
                            console.log("Error", response);
                        }

                        document.getElementById("geometry").value = wkt;
                        this.closeGeometryDialog();
                        this.reloadImage(document.querySelector('#map_thumb img'));
                        Ext.get("bewerk-plan").unmask();
                    },
                    failure: function (error) {
                        console.log("Error", error);
                        Ext.get("bewerk-plan").unmask();
                        this.closeGeometryDialog();
                    }
                });
            }else{
                document.getElementById("geometry").value = wkt;
                Ext.get("bewerk-plan").unmask();
                this.closeGeometryDialog();
            }
        }
    },
    
    reloadImage: function(img) {
        var src = img.src;
        var cache = 'cache=' + Date.now();
        if(src.indexOf('cache=') !== -1) {
            src = src.replace(/cache=[0-9]*/ig, cache);
        } else {
            var separator = '?';
            if(src.indexOf('?') !== -1) {
                separator = '&';
            }
            src += separator + cache;
        }
        img.src = src;
    },

    closeGeometryDialog : function(){
        $("#bewerk-plan").dialog('close');
    },

    saveBouwplan: function () {
        var detailplanningType = $("#detailType").val();
        
        var normalTotal = detailplanner.getTotal();        
        var expandedTotal =  detailplannerUitgebreid.getTotal();
        
        var totalMainScreen = $("#totaalcapaciteit").val();
        var realisedTotalMainScreen = $("#gerealiseerdecapaciteit").val();
        var restcapaciteitMainScreen = $("#restcapaciteit").val();
        
        var mainScreenFilled = (totalMainScreen != 0 ||realisedTotalMainScreen != 0 || restcapaciteitMainScreen != 0);

        
        if(detailplanningType === "normaal" && (normalTotal === 0  || detailplanner.capacityDividedButNotSaved === true )&& mainScreenFilled){
            if (confirm("De geselecteerde 'Standaard detailplanning' is leeg of nog niet opgeslagen. Als u doorgaat zal de planning in het hoofdscherm worden overschreven met de gegevens uit de 'Standaard detailplanning'. Wilt u doorgaan?")) {
                detailplanner.updateMainScreen();
            } else {
                return false;
            }
            
        } else if (detailplanningType === "uitgebreid" && expandedTotal === 0 && mainScreenFilled) {
            if (confirm("De geselecteerde 'Uitgebreide detailplanning' is leeg of nog niet opgeslagen. Als u doorgaat zal de planning in het hoofdscherm (inclusief woningtypen en koop/huur) worden overschreven met de gegevens uit de 'Uitgebreide detailplanning'. Wilt u doorgaan?")) {
                detailplannerUitgebreid.updateMainscreen();
            } else {
                return false;
            }
        }
        
        var sloopType = $("#detailTypesloop").val();
        var sloopMainScreen = $("#resterendesloop").val();
        var realisedSloopMainScreen = $("#gerealiseerdesloop").val();
        if(sloopType === "normaal" && detailplannersloop.getTotal() === 0 && (sloopMainScreen != 0 || realisedSloopMainScreen != 0) ){
            if (confirm("De geselecteerde 'Detailplanning sloop' is leeg. Als u doorgaat zal de planning in het hoofdscherm worden overschreven met de gegevens uit de 'Detailplanning sloop'? . Wilt u doorgaan?")) {
                detailplannersloop.updateMainScreen();
            } else {
                return false;
            }
        }
        
        var additionalVariables = this.variableInstantiator.getValues();
        document.getElementById("additionalVariables").value = Ext.JSON.encode(additionalVariables);
        
        window.onbeforeunload = null;
        return true;
    },

    editGeometry: function(){
        if (this.config.wktGeom !== ''){
            var feature = new viewer.viewercontroller.controller.Feature({
                id: 1,
                wktgeom: this.config.wktGeom
            });
            this.drawTool.setFeature(feature);
        }
    }

});

Ext.define ("DrawTool", {
    viewerController: null,
    editTool: null,
    pointButton: null,
    polygonButton: null,
    editButton: null,
    removeButton: null,
    pointImage: "images/edit_point.png",
    polygonImage: "images/edit_poly.png",
    editImage: "images/edit.png",
    removeImage: "images/remove_geom.png",
    
    config: {
        canEdit: true,
        isProvince: false
    },

    constructor: function (config, viewerController, editTool) {
        this.initConfig(config);
        this.viewerController=viewerController;
        this.editTool = editTool;
        this.createVectorLayer();
        this.createButtons();
    },
    
    isEditable: function(vis) {
        return this.config.canEdit && !this.config.isProvince && (typeof vis === 'undefined' || vis);
    },
    
    createVectorLayer : function (){
        this.vectorLayer=this.viewerController.mapComponent.createVectorLayer({
            name:'drawingVectorLayer',
            geometrytypes:["Polygon","Point"],
            showmeasures:false,
            viewerController: this.viewerController,
            style: {
                'fillcolor': this.color || 'FF0000',
                'fillopacity': 50,
                'strokecolor': "FF0000",
                'strokeopacity': 50
            }
        });
        this.viewerController.mapComponent.getMap().addLayer(this.vectorLayer);

        this.vectorLayer.addListener (viewer.viewercontroller.controller.Event.ON_ACTIVE_FEATURE_CHANGED,this.activeFeatureChanged,this);
        this.vectorLayer.addListener (viewer.viewercontroller.controller.Event.ON_FEATURE_ADDED,this.activeFeatureFinished,this);
    },
    createButtons: function(){
        this.pointButton= this.viewerController.mapComponent.createTool({
            type: viewer.viewercontroller.controller.Tool.BUTTON,
            id: "drawPoint",
            iconUrl_up: this.pointImage,
            iconUrl_over: this.pointImage,
            iconUrl_sel: this.pointImage,
            iconUrl_dis: this.pointImage,
            tooltip: "Teken plan als punt",
            viewerController: this.viewerController,
            visible: false
        });
        this.viewerController.mapComponent.addTool(this.pointButton);
        this.pointButton.addListener(viewer.viewercontroller.controller.Event.ON_EVENT_DOWN,this.pointButtonDown, this);

        this.polygonButton= this.viewerController.mapComponent.createTool({
            type: viewer.viewercontroller.controller.Tool.BUTTON,
            id: "drawPolygon",
            iconUrl_up: this.polygonImage,
            iconUrl_over: this.polygonImage,
            iconUrl_sel: this.polygonImage,
            iconUrl_dis: this.polygonImage,
            tooltip: "Teken plan als vlak",
            viewerController: this.viewerController,
            visible: false
        });
        this.viewerController.mapComponent.addTool(this.polygonButton);
        this.polygonButton.addListener(viewer.viewercontroller.controller.Event.ON_EVENT_DOWN,this.polygonButtonDown, this);

        this.editButton= this.viewerController.mapComponent.createTool({
            type: viewer.viewercontroller.controller.Tool.BUTTON,
            id: "editGeometry",
            iconUrl_up: this.editImage,
            iconUrl_over: this.editImage,
            iconUrl_sel: this.editImage,
            iconUrl_dis: this.editImage,
            tooltip: "Bewerk opgeslagen geometrie",
            viewerController: this.viewerController,
            visible: false
        });
        this.viewerController.mapComponent.addTool(this.editButton);
        this.editButton.addListener(viewer.viewercontroller.controller.Event.ON_EVENT_DOWN,this.editButtonDown, this);

        this.removeButton= this.viewerController.mapComponent.createTool({
            type: viewer.viewercontroller.controller.Tool.BUTTON,
            id: "removeGeometry",
            iconUrl_up: this.removeImage,
            iconUrl_over: this.removeImage,
            iconUrl_sel: this.removeImage,
            iconUrl_dis: this.removeImage,
            tooltip: "Verwijder getekende geometry",
            viewerController: this.viewerController,
            visible: false
        });
        this.viewerController.mapComponent.addTool(this.removeButton);
        this.removeButton.addListener(viewer.viewercontroller.controller.Event.ON_EVENT_DOWN,this.removeButtonDown, this);
    },

    checkForFeatures: function(func){
        var features=this.vectorLayer.getAllFeatures();
        if (features==undefined || features ==null || features.length ==0){
            func.call();
        }else{
            var returnValue;
            Ext.Msg.confirm("Nieuwe Feature", "Een plan kan maximaal uit 1 geometry bestaan, \n\
                wilt u de reeds getekende geometry verwijderen?",
                function(btn,txt){
                    if (btn=='yes'){
                        func.call();
                    }
                }
            );
        }
    },
    removeAllFeatures: function(){
        this.getVectorLayer().removeAllFeatures();
        this.startNewGeom();
    },
    startNewGeom: function(){
        if(this.config.wktGeom){
            this.getEditButton().setVisible(true);
        }
        this.getRemoveButton().setVisible(false);
        this.getPointButton().setVisible(true);
        this.getPolygonButton().setVisible(true);
    },
    editExistingGeom: function(){
        if(this.config.wktGeom){
            this.getEditButton().setVisible(this.isEditable());
        }
        this.getRemoveButton().setVisible(this.isEditable());
        this.getPointButton().setVisible(false);
        this.getPolygonButton().setVisible(false);
    },
    pointButtonDown: function(){
        this.disableZoomInControls();
        var vl= this.vectorLayer;
        this.checkForFeatures(function(){
            vl.removeAllFeatures();
            vl.drawFeature("Point");
        });
    },
    polygonButtonDown: function(){
        this.disableZoomInControls();
        var vl= this.vectorLayer;
        this.checkForFeatures(function(){
            vl.removeAllFeatures();
            vl.drawFeature("Polygon");
        });
    },
    editButtonDown: function(){
        this.editTool.formChange({target:{tagName: "geometry"}});
        var vl= this.vectorLayer;
        var me = this;
        this.checkForFeatures(function(){
            vl.removeAllFeatures();
            me.editTool.editGeometry();
        });
    },
    editButtonUp: function(){
        //console.log("need to be implemented");
        confirmPopup('Geometrie wijzigen', 'geomMessage');
    },

    removeButtonDown: function(){
        var me = this;
        Ext.Msg.confirm("Verwijder Feature", "Weet u zeker dat u de getekende geometrie wilt verwijderen? \n\
                Het is vereist om een geometry op te slaan, \n\
                zolang u geen nieuwe geometry heeft getekend blijft de oude geometry bestaan.",
                function(btn,txt){
                    if (btn=='yes'){
                        me.removeAllFeatures();
                    }
                }
            );
    },
    setFeature: function(feature){
        this.vectorLayer.removeAllFeatures();
        this.vectorLayer.addFeature(feature);
        this.getRemoveButton().setVisible(this.isEditable());
    },

    setVisible: function(vis){
        this.pointButton.setVisible(vis);
        this.polygonButton.setVisible(vis);
        this.editButton.setVisible(this.isEditable(vis));
        this.removeButton.setVisible(this.isEditable(vis));
        this.vectorLayer.setVisible(vis);
    },
    activeFeatureChanged: function(){

    },
    activeFeatureFinished: function(){
        this.editExistingGeom();
    },
    getPointButton: function(){
        return this.pointButton;
    },
    getPolygonButton: function(){
        return this.polygonButton;
    },
    getEditButton: function(){
        return this.editButton;
    },
    getVectorLayer: function(){
        return this.vectorLayer;
    },
    getRemoveButton: function(){
        return this.removeButton;
    },
    disableZoomInControls: function(){
        var comps = this.viewerController.getComponentsByClassName("viewer.components.tools.ZoomIn");
        for(var i = 0 ; i < comps.length ; i++){
            var component = comps[i];
            var tool = component.tool;
            tool.deactivate();
        }
    },
    getWKT : function(){

        var features=this.vectorLayer.getAllFeatures();
        if(features && features.length > 0){
            var feature = features[0];
            return feature.getWktgeom();
        }else{
            return null;
        }
    }
});