<%@include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@page contentType="text/html" session="false" pageEncoding="UTF-8"%>

<stripes:layout-render name="/WEB-INF/jsp/templates/siteTemplate.jsp" pageTitle="Inloggen">
    <stripes:layout-component name="content">
        <div class="login">
            <h1>Planmonitor Wonen</h1>
            <c:if test="${not empty param.loginmessage}">
                <p><c:out value="${param.loginmessage}" escapeXml="false" /></p>
            </c:if>
            <h2>Login om gegevens in te voeren in de planmonitor</h2>
            <form action="j_security_check" method="POST" class="formblock">
                <div class="form-group">
                    <label for="j_username">Gebruikersnaam:</label>
                    <div class="form-input">
                        <input type="text" id="j_username" name="j_username">
                    </div>
                </div>
                <div class="form-group">
                    <label for="j_password">Wachtwoord:</label>
                    <div class="form-input">
                        <input type="password" id="j_password" name="j_password">
                    </div>
                </div>
                <div class="form-group form-buttons">
                    <input type="Submit" value="Login" class="inputbutton">
                </div>
            </form>
            <h3 class="extra_whitespace">Update december 2016</h3>
            <p>
                In de laatste update van de planmonitor is een aantal onderdelen verbeterd/aangepast. De belangrijkste zijn:
                <ul>
                    <li>Indien een standaard of uitgebreide detailplanning wordt ingevuld en opgeslagen, dan worden de totalen in het hoofdscherm automatisch bijgewerkt.</li>
                    <li>Er is een apart blok (en detailplanning) toegevoegd voor sloop.</li>
                    <li>Er komen nu waarschuwingen bij het opslaan van plannen indien detailplanning(en) en hoofdscherm onderling verschillen.</li>
                    <li>De export is herzien (ontbrekende velden toegevoegd en veldnamen aangepast).</li>
                    <li>De handleiding wordt in januari 2017 aangepast aan de nieuwe functionaliteiten. </li>
                </ul>
            </p>

            <h2 class="extra_whitespace">Selecteer een provincie om plannen te bekijken, zonder in te loggen (alleen openbare plannen)</h2>
            <form method="POST">
                <div class="form-input">
                    <select data-emptytext="Selecteer een provincie" data-showemptytext="true" onchange="provincieChanged(this)">
                        <option value="Fryslân">Provincie Friesland</option>
                        <option value="Overijssel">Provincie Overijssel</option>
                        <option value="Zuid-Holland">Provincie Zuid-Holland</option>
                        <option value="Utrecht">Provincie Utrecht</option>
                        <option value="Zeeland">Provincie Zeeland</option>
                        <option value="Gelderland">Provincie Gelderland</option>
                    </select>
                </div>
            </form>
            
            <h3 class="extra_whitespace">Planmonitor Wonen</h3>
            <p>
                De Planmonitor Wonen is een instrument om gegevens over woningbouwplannen te beheren voor het rijk, provincies, regio’s en gemeenten.
                Deze gegevens worden gebruikt in voortgangsrapportages, woningmarktverkenningen en bevolkingsprognoses.
                Iedere instantie bepaalt zelf in hoeverre de verzamelde gegevens openbaar gemaakt worden.
            </p>
            <p>
                Voor informatie over het gebruik van de planmonitor kunt u mailen naar <a href="mailto: info@planmonitorwonen.nl">info@planmonitorwonen.nl</a>
            </p>
            <h3>Deelnemers</h3>
            De volgende instanties nemen deel aan de Planmonitor Wonen:
            <ul class="simple-list">
                <li><a href="#">Provincie Friesland</a></li>
                <li><a href="#">Provincie Overijssel</a></li>
                <li><a href="#">Provincie Zuid-Holland</a></li>
                <li><a href="#">Provincie Utrecht</a></li>
                <li><a href="#">Provincie Zeeland</a></li>
                <li><a href="#">Provincie Gelderland</a></li>
            </ul>
        </div>
        <script>
            function provincieChanged(form){
                var url = "<stripes:url beanclass="nl.b3p.pzh.rwbp.stripes.SearchActionBean"/>";
                var provincie = form.getSelectedRecord().data.field1;
                url += "?provincie=" + provincie;
                document.location = url;
            }
        </script>
    </stripes:layout-component>
</stripes:layout-render>